/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.automaticclient;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.SystemProperties;
import de.aristaflow.adept2.core.client.implementation.xml.ClientPersistenceXMLConstants;
import de.aristaflow.adept2.core.client.implementation.xml.ClientPersistenceXMLExport;
import de.aristaflow.adept2.core.client.implementation.xml.ClientPersistenceXMLImport;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.validation.Schema;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class IWLISPersistence {
    private Logger logger = LoggerTools.getLogger(this);
    private final String filename = "automatic_resume.persistence";
    private File clientDir;
    private Map<EBPInstanceReference, Long> automaticResumeTime = Collections.synchronizedMap(new HashMap());

    public IWLISPersistence() throws ConfigurationException {
        String datadir = SystemProperties.getDataDir();
        this.clientDir = new File(datadir, "ClientPersistence");
        try {
            if (!this.clientDir.exists()) {
                boolean success = this.clientDir.mkdir();
                if (!success) {
                    String msg = "The client persistence directory could not be created and does not exist yet either!";
                    throw new ConfigurationException(msg);
                }
            } else {
                File f = new File(this.clientDir, "automatic_resume.persistence");
                if (f.exists()) {
                    try {
                        Schema schema = ClientPersistenceXMLConstants.getAutomaticResumePersistenceSchema();
                        Document doc = XMLHelperTools.getDocumentFromFile(f, schema, null);
                        this.automaticResumeTime.putAll(ClientPersistenceXMLImport.getAutomaticResumePersistenceFromDocument(doc));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        String msg = String.format("The file '%s/%s' could not be accessed!", this.clientDir, "automatic_resume.persistence");
                        this.logger.fine(msg);
                    }
                    catch (XMLFormatException e) {
                        String msg = String.format("A XMLFormatException occurred while trying to get a XML document from the file '%s/%s'!", this.clientDir, "automatic_resume.persistence");
                        this.logger.log(Level.WARNING, msg, e);
                    }
                    catch (IOException e) {
                        String msg = String.format("An IOException occurred while trying to get a XML document from the file '%s/%s'!", this.clientDir, "automatic_resume.persistence");
                        this.logger.log(Level.WARNING, msg, e);
                    }
                    catch (SAXException e) {
                        String msg = String.format("A SAXException occurred while trying to get a XML document from the file '%s/%s'!", this.clientDir, "automatic_resume.persistence");
                        this.logger.log(Level.WARNING, msg, e);
                    }
                } else {
                    String msg = "There is no automatic resume persistence file we could read from. Ignore the initialisation from XML.";
                    this.logger.fine(msg);
                }
            }
        }
        catch (SecurityException se) {
            String msg = "The client persistence directory could not be accessed!";
            throw new ConfigurationException(msg, se);
        }
    }

    void storeResumeTime(EBPInstanceReference ebpIR, long resumeTime) {
        this.automaticResumeTime.put(ebpIR, resumeTime);
        this.updatePersistence();
        String msg = String.format("Stored the automatic resume time of activity '%s' to the persistence file.", ebpIR);
        this.logger.info(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Long getResumeTime(EBPInstanceReference ebpIR) {
        Long resumeTime = null;
        Map<EBPInstanceReference, Long> map = this.automaticResumeTime;
        synchronized (map) {
            if (this.automaticResumeTime.containsKey(ebpIR)) {
                resumeTime = this.automaticResumeTime.get(ebpIR);
            }
        }
        return resumeTime;
    }

    void deleteResumeTime(EBPInstanceReference ebpIR) {
        if (this.automaticResumeTime.remove(ebpIR) != null) {
            this.updatePersistence();
            String msg = String.format("Removed the automatic resume time of activity '%s' from the persistence file.", ebpIR);
            this.logger.info(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePersistence() {
        Map<EBPInstanceReference, Long> map = this.automaticResumeTime;
        synchronized (map) {
            Document doc = ClientPersistenceXMLExport.getDocumentForAutomaticResumePersistence(this.automaticResumeTime);
            try {
                Schema schema = ClientPersistenceXMLConstants.getAutomaticResumePersistenceSchema();
                XMLHelperTools.writeDocumentToFile(doc, new File(this.clientDir, "automatic_resume.persistence"), schema);
            }
            catch (IOException e) {
                String msg = String.format("An IOException occurred while trying to write a XML document to the file '%s/%s'!", this.clientDir, "automatic_resume.persistence");
                this.logger.log(Level.SEVERE, msg, e);
            }
            catch (XMLFormatException e) {
                String msg = String.format("A XMLFormatException occurred while trying to write a XML document to the file '%s/%s'!", this.clientDir, "automatic_resume.persistence");
                this.logger.log(Level.SEVERE, msg, e);
            }
            catch (SAXException e) {
                String msg = String.format("A SAXException occurred while trying to write a XML document to the file '%s/%s'!", this.clientDir, "automatic_resume.persistence");
                this.logger.log(Level.SEVERE, msg, e);
            }
        }
    }
}

