/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.automaticclient;

import de.aristaflow.adept2.core.automaticclient.ItemExecutor;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.Serializable;
import java.util.Comparator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ItemExecutorService
extends ThreadPoolExecutor {
    public ItemExecutorService(int minPoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int threadPriority, long stackSize, Comparator<WorklistItem> worklistItemComparator) {
        super(minPoolSize, maximumPoolSize, keepAliveTime, unit, ItemExecutorService.getQueue(minPoolSize, worklistItemComparator), new Adept2ThreadFactory("AutomaticClientWorklistExecutorPool", stackSize, threadPriority, LoggerTools.getLogger(ItemExecutorService.class)), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    protected static BlockingQueue<Runnable> getQueue(int minQueueSize, Comparator<WorklistItem> worklistItemComparator) {
        PriorityBlockingQueue<Runnable> ret = new PriorityBlockingQueue<Runnable>(minQueueSize, new ItemExecutorComparator(worklistItemComparator));
        return ret;
    }

    protected static class ItemExecutorComparator
    implements Comparator<Runnable>,
    Serializable {
        private static final long serialVersionUID = -4309951924866379370L;
        private final Comparator<WorklistItem> worklistItemComparator;

        protected ItemExecutorComparator(Comparator<WorklistItem> worklistItemComparator) {
            this.worklistItemComparator = worklistItemComparator;
        }

        @Override
        public int compare(Runnable executor1, Runnable executor2) {
            WorklistItem item1 = ((ItemExecutor)executor1).getWorklistItem();
            WorklistItem item2 = ((ItemExecutor)executor2).getWorklistItem();
            return this.worklistItemComparator.compare(item1, item2);
        }
    }
}

