/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.automaticclient;

import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Collection;
import java.util.logging.Logger;

public abstract class ItemHandler
implements Runnable {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected WorklistItem worklistItem;
    protected final Collection<? extends ItemHandler> pendingItems;
    protected volatile boolean invalidated;
    protected volatile boolean abortable;

    protected ItemHandler(WorklistItem worklistItem, Collection<? extends ItemHandler> pendingItems) {
        this.worklistItem = worklistItem;
        this.pendingItems = pendingItems;
        this.invalidated = false;
        this.abortable = true;
    }

    protected WorklistItem getWorklistItem() {
        return this.worklistItem;
    }

    public synchronized boolean invalidate() {
        this.invalidated = true;
        String msg = this.abortable ? "Invalidated item '%1$s'. It will not be handled." : "Invalidated item '%1$s'. However it is currently being handled.";
        this.logger.fine(String.format(msg, this.worklistItem.getActivityReference()));
        return this.abortable;
    }

    public boolean equals(Object other) {
        boolean ret = false;
        if (other instanceof ItemHandler) {
            ret = this.worklistItem.equals(((ItemHandler)other).worklistItem);
        }
        return ret;
    }

    public int hashCode() {
        return this.worklistItem.hashCode();
    }
}

