/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.automaticclient;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.automaticclient.ItemExecutor;
import de.aristaflow.adept2.core.automaticclient.LimitedCollection;
import de.aristaflow.adept2.core.automaticclient.WorklistHandler;
import de.aristaflow.adept2.core.executionmanager.ActivityStarting;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.model.execution.AgentUnknownException;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2EBPReference;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;

public class ItemResumer
extends ItemExecutor {
    public ItemResumer(SessionToken session, WorklistItem worklistItem, URI[] runtimeManagerURIs, WorklistHandler worklist, Collection<ItemExecutor> pendingItems, LimitedCollection<WorklistItem> runningItems, Registry registry) {
        super(session, worklistItem, runtimeManagerURIs, worklist, pendingItems, runningItems, registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block19: {
            try {
                try {
                    String msg = String.format("Trying to resume item '%1$s' on runtime manager '%2$s'.", this.worklistItem.getActivityReference(), Arrays.toString(this.runtimeManagerURIs));
                    this.logger.fine(msg);
                    String activityReferenceType = this.worklistItem.getActivityReference().getActivityReferenceType();
                    if (!activityReferenceType.equals("de.aristaflow.ADEPT2ActivityReference") && !activityReferenceType.equals("de.aristaflow.LWPActivityReference")) break block19;
                    ADEPT2EBPReference reference = (ADEPT2EBPReference)this.worklistItem.getActivityReference();
                    ActivityStarting executionManager = this.registry.getService(this.session, reference.getExecutionManagerURIs(), ExecutionManager.class).getActivityStarting();
                    ClientWorklistItem newWorklistItem = this.worklist.getWorklistItem(reference);
                    if (newWorklistItem != null && newWorklistItem.getState() == WorklistConstants.WorklistItemState.SUSPENDED && !this.invalidated) {
                        ItemResumer itemResumer = this;
                        synchronized (itemResumer) {
                            this.abortable = this.invalidated;
                        }
                        if (!this.abortable) {
                            msg = String.format("Resuming item '%1$s' on runtime manager '%2$s'.", reference, Arrays.toString(this.runtimeManagerURIs));
                        }
                        this.logger.info(msg);
                        boolean resumed = false;
                        try {
                            reference.setRuntimeManagerURIs(this.runtimeManagerURIs);
                            this.runningItems.add(newWorklistItem);
                            executionManager.resumeActivity(this.session, reference);
                            resumed = true;
                            this.worklist.getPersistence().deleteResumeTime(reference);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            msg = String.format("Unable to resume item '%1$s' since the server-side iteration has already been increased.  Obviously the item has already been executed. Ignoring it.", reference);
                            this.logger.info(msg);
                        }
                        catch (InvalidActivityStateException iase) {
                            msg = "Unable to resume item '%1$s' since the server-side state is now %2$s, I expected %3$s. Obviously another agent has already resumed it. This can happen if the resuming agent has started and initially executed it (which is quite critical). Or due to some rare synchronisation issue where this agent retrieves the item twice due to a late worklist update (which is no problem at all). Ignoring item.";
                            msg = String.format(msg, new Object[]{reference, iase.getActivityState(), newWorklistItem.getState()});
                            this.logger.info(msg);
                        }
                        catch (InvalidInstanceStateException iise) {
                            msg = String.format("Unable to resume item '%1$s' since its instanceis in state %2$s. Obviously someone has changed the instance state. Ignoring item.", reference, iise.getPreventingState());
                            this.logger.info(msg);
                        }
                        catch (AgentUnknownException aue) {
                            msg = String.format("Unable to resume item '%s' since the runtime manager '%s' does not know the performing agent '%s' (this automatic client). Ignoring item, it may need to be start manually.", reference, Arrays.toString(aue.getRuntimeManagerURIs()), aue.getAgent());
                            this.logger.info(msg);
                        }
                        if (!resumed) {
                            this.runningItems.remove(newWorklistItem);
                        }
                        break block19;
                    }
                    if (this.invalidated) {
                        msg = String.format("Aborted resruming of item '%s' since it has been invalidated. This may happen due to a complete worklist update.", reference);
                        this.logger.fine(msg);
                    }
                }
                catch (ServiceNotKnownException snke) {
                    String msg = String.format("Could not resume item '%s' since the corresponding execution manager is not known by the registry.", this.worklistItem.getActivityReference());
                    this.logger.log(Level.WARNING, msg, snke);
                    this.pendingItems.remove(this);
                }
                catch (RuntimeException re) {
                    String msg = String.format("An unexpected exception occured while resuming item '%1$s'. Log is just for information purpose.", this.worklistItem.getActivityReference());
                    this.logger.log(Level.INFO, msg, re);
                    this.pendingItems.remove(this);
                }
            }
            finally {
                this.pendingItems.remove(this);
            }
        }
    }
}

