/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.automaticclient;

import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LimitedCollection<T> {
    protected final int limit;
    protected final Collection<T> collection;
    protected final Lock lock;
    protected final Condition notFull;
    protected volatile boolean closed;

    public LimitedCollection(int limit) {
        this.limit = limit;
        this.collection = new HashSet<T>();
        this.lock = new ReentrantLock(true);
        this.notFull = this.lock.newCondition();
        this.closed = false;
    }

    protected long timeLeft(long startInNanos, long duration, TimeUnit unit) {
        long elapsed = System.nanoTime() - startInNanos;
        return duration - unit.convert(elapsed, TimeUnit.MILLISECONDS);
    }

    public boolean offer(T element) throws InterruptedException {
        boolean ret;
        this.lock.lockInterruptibly();
        try {
            while (this.collection.size() > this.limit && !this.closed) {
                this.notFull.await();
            }
            if (this.closed) {
                String msg = "The limited collection is closed while waiting to offer an element.";
                throw new InterruptedException(msg);
            }
            ret = this.collection.add(element);
        }
        finally {
            this.lock.unlock();
        }
        return ret;
    }

    public boolean offer(T element, long timeout, TimeUnit unit) throws InterruptedException {
        long started = System.nanoTime();
        boolean ret = false;
        boolean locked = this.lock.tryLock(timeout, unit);
        try {
            long timeLeft = this.timeLeft(started, timeout, unit);
            if (timeLeft > 0L) {
                while (this.collection.size() >= this.limit && timeLeft > 0L && !this.closed) {
                    this.notFull.await(timeLeft, unit);
                    timeLeft = this.timeLeft(started, timeout, unit);
                }
                if (this.closed) {
                    String msg = "The limited collection is closed while waiting to offer an element.";
                    throw new InterruptedException(msg);
                }
                if (this.collection.size() < this.limit) {
                    ret = this.collection.add(element);
                }
            }
        }
        finally {
            if (locked) {
                this.lock.unlock();
            }
        }
        return ret;
    }

    public boolean add(T element) {
        boolean ret;
        this.lock.lock();
        try {
            ret = this.collection.add(element);
        }
        finally {
            this.lock.unlock();
        }
        return ret;
    }

    public boolean remove(T element) {
        boolean ret;
        this.lock.lock();
        try {
            ret = this.collection.remove(element);
            if (this.collection.size() < this.limit) {
                this.notFull.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
        return ret;
    }

    public void clear() {
        this.lock.lock();
        try {
            this.collection.clear();
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void closeAndInterruptWaiters() {
        this.lock.lock();
        try {
            this.closed = true;
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

