/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.automaticclient;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.automaticclient.AbstractWorklistHandler;
import de.aristaflow.adept2.core.automaticclient.IWLISPersistence;
import de.aristaflow.adept2.core.automaticclient.LimitedCollection;
import de.aristaflow.adept2.core.automaticclient.WorklistItemComparator;
import de.aristaflow.adept2.core.automaticclient.WorklistItemExecutorService;
import de.aristaflow.adept2.core.runtimemanager.ResumingRuntimeManager;
import de.aristaflow.adept2.core.worklistmanager.WorklistManager;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2EBPReference;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.UUID;

public class WorklistHandler
extends AbstractWorklistHandler
implements ResumingRuntimeManager.AutomaticResumer {
    protected final ClientSessionFactory sessionFactory;
    protected final WorklistItemExecutorService<ClientWorklistItem> itemExecutor;
    protected final Collection<WorklistItem> resumePending;
    protected final LimitedCollection<WorklistItem> runningItems;
    private IWLISPersistence persistence;
    protected boolean active;
    protected boolean wlLogoff;

    public WorklistHandler(ClientSessionFactory sessionFactory, WorklistManager wlm, WorklistUpdateConfiguration updateConfiguration, WorklistItemExecutorService<ClientWorklistItem> itemExecutor, LimitedCollection<WorklistItem> runningItems, long recheckTime, int threadPriority) throws ConfigurationException {
        super(wlm, updateConfiguration, recheckTime, threadPriority);
        this.sessionFactory = sessionFactory;
        this.itemExecutor = itemExecutor;
        this.runningItems = runningItems;
        this.resumePending = new HashSet<WorklistItem>();
        this.persistence = new IWLISPersistence();
        this.active = false;
        this.wlLogoff = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.active = true;
            super.run();
        }
        catch (Throwable throwable) {
            WorklistHandler worklistHandler = this;
            synchronized (worklistHandler) {
                this.active = false;
                if (this.wlLogoff) {
                    this.wlm.logoff(this.createSession(), false);
                }
            }
            throw throwable;
        }
        WorklistHandler worklistHandler = this;
        synchronized (worklistHandler) {
            this.active = false;
            if (this.wlLogoff) {
                this.wlm.logoff(this.createSession(), false);
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        this.stopWLHandling(true);
    }

    public synchronized void stopWLHandling(boolean logoff) {
        this.wlLogoff = logoff;
        super.shutdown();
    }

    public synchronized void logoff() {
        this.wlLogoff = true;
        if (!this.active) {
            this.wlm.logoff(this.createSession(), false);
        }
    }

    @Override
    protected void processCompleteUpdate(Collection<ClientWorklistItem> items, UUID worklistID) {
        this.runningItems.clear();
        TreeSet<WorklistItem> sortedItems = new TreeSet<WorklistItem>(new WorklistItemComparator());
        sortedItems.addAll(items);
        super.processCompleteUpdate(sortedItems, worklistID);
    }

    @Override
    protected boolean itemProcessable(ClientWorklistItem item) {
        String activityReferenceType = item.getActivityReference().getActivityReferenceType();
        if (activityReferenceType.equals("de.aristaflow.LWPActivityReference")) {
            return true;
        }
        boolean ret = super.itemProcessable(item);
        if (ret) {
            ADEPT2EBPReference ebpRef = (ADEPT2EBPReference)item.getActivityReference();
            ret = ebpRef.getExecutableComponentName() == null || !"de.aristaflow.events".equals(ebpRef.getExecutableComponentName());
        }
        return ret;
    }

    protected IWLISPersistence getPersistence() {
        return this.persistence;
    }

    private Long checkAndGetResumeTime(ClientWorklistItem item) {
        Long resumeTime = null;
        String referenceType = item.getActivityReference().getActivityReferenceType();
        if (referenceType.equals("de.aristaflow.ADEPT2ActivityReference") || referenceType.equals("de.aristaflow.LWPActivityReference")) {
            EBPInstanceReference ebpIR = (EBPInstanceReference)((Object)item.getActivityReference());
            String resumeDateString = item.getUserAttributeValue("AutomaticResumeDate");
            Long persistedResumeTime = this.persistence.getResumeTime(ebpIR);
            if (resumeDateString != null && resumeDateString.length() > 0) {
                if (persistedResumeTime != null && !Long.valueOf(resumeDateString).equals(persistedResumeTime)) {
                    String msg = String.format("The automatic resume time of activity '%s' has different values in the worklist item settings (%s) and the local persistence (%s)!", ebpIR, resumeDateString, persistedResumeTime);
                    this.logger.warning(msg);
                }
                resumeTime = Long.valueOf(resumeDateString);
            } else if (persistedResumeTime != null) {
                this.storeResumeTime(item, persistedResumeTime);
                String msg = String.format("Stored the automatic resume time of activity '%s' to the worklist item settings.", ebpIR);
                this.logger.info(msg);
                resumeTime = persistedResumeTime;
            }
        }
        return resumeTime;
    }

    private void storeResumeTime(ClientWorklistItem item, long resumeTime) {
        item.setUserAttributeValue("AutomaticResumeDate", Long.toString(resumeTime));
        this.wlm.getWorklistUpdateManager().updateIndividualSettings(this.sessionFactory.getSessionToken(), item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeActivity(EBPInstanceReference ebpInstanceReference, long delay) {
        ClientWorklistItem item = this.getWorklistItem(ebpInstanceReference);
        if (item != null) {
            long resumeTime = System.currentTimeMillis() + delay;
            this.persistence.storeResumeTime(ebpInstanceReference, resumeTime);
            this.storeResumeTime(item, resumeTime);
            String msg = String.format("Set automatic resume for activity '%s' in %d ms (at %s).", ebpInstanceReference, delay, new SimpleDateFormat().format(new Date(resumeTime)));
            this.logger.finer(msg);
            if (this.itemProcessable(item)) {
                Collection<WorklistItem> collection = this.resumePending;
                synchronized (collection) {
                    item = this.getWorklistItem(ebpInstanceReference);
                    if (item.getState() == WorklistConstants.WorklistItemState.SUSPENDED) {
                        msg = String.format("The update has already arrived, submitting activity '%s' directly for resuming in %d ms (at %s).", ebpInstanceReference, delay, new SimpleDateFormat().format(new Date(resumeTime)));
                        this.logger.finer(msg);
                        this.itemExecutor.submit(item, delay);
                    } else {
                        msg = String.format("The worklist does not have the right state for activity '%s'. Remembering it until the update has arrived which will then submit it.", ebpInstanceReference);
                        this.logger.finer(msg);
                        this.resumePending.add(item);
                    }
                }
            }
        }
    }

    @Override
    protected SessionToken createSession() {
        return this.sessionFactory.getSessionToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processCompleteUpdate(ClientWorklistItem item) {
        switch (item.getState()) {
            case AVAILABLE: 
            case ASSIGNED: {
                String msg = String.format("Submitting item '%s' for execution.", item.getActivityReference());
                this.logger.finer(msg);
                this.itemExecutor.submit(item);
                break;
            }
            case SUSPENDED: {
                Long resumeTime = this.checkAndGetResumeTime(item);
                if (resumeTime == null) break;
                try {
                    long fromNow = resumeTime - System.currentTimeMillis();
                    Collection<WorklistItem> collection = this.resumePending;
                    synchronized (collection) {
                        if (this.resumePending.contains(item)) {
                            this.resumePending.remove(item);
                        }
                    }
                    String msg = String.format("Found item '%s' for resuming in %d ms. Submitting it.", item.getActivityReference(), fromNow);
                    this.logger.finer(msg);
                    this.itemExecutor.submit(item, fromNow);
                }
                catch (NumberFormatException numberFormatException) {
                    String msg = String.format("Found item '%s' does have a resume time of '%s' but this is no valid time. Ignoring item.", item.getActivityReference(), resumeTime);
                    this.logger.warning(msg);
                }
                break;
            }
        }
    }

    @Override
    protected void prepareCompleteUpdate() {
        this.itemExecutor.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processUpdatedItem(ClientWorklistItem updatedItem, WorklistConstants.WorklistItemUpdateType updateType) {
        block5 : switch (updateType) {
            case CHANGED: 
            case ADDED: {
                switch (updatedItem.getState()) {
                    case SUSPENDED: {
                        boolean pending;
                        boolean resumeItem = false;
                        Long resumeTime = this.checkAndGetResumeTime(updatedItem);
                        Collection<WorklistItem> collection = this.resumePending;
                        synchronized (collection) {
                            pending = this.resumePending.contains(updatedItem);
                            if (pending && resumeTime != null) {
                                this.resumePending.remove(updatedItem);
                                resumeItem = true;
                            }
                        }
                        if (resumeItem) {
                            try {
                                assert (resumeTime != null);
                                long fromNow = resumeTime - System.currentTimeMillis();
                                String msg = String.format("Retrieved item '%s' ('%s', state: %s) for resuming in %d ms. Submitting it.", new Object[]{updatedItem.getActivityReference(), updatedItem.getID(), updatedItem.getState(), fromNow});
                                this.logger.finer(msg);
                                this.itemExecutor.submit(updatedItem, fromNow);
                            }
                            catch (NumberFormatException numberFormatException) {
                                String msg = String.format("Retrieved item '%s' ('%s', state: %s) does have a resume time of '%s' but this is no valid time. Ignoring item.", new Object[]{updatedItem.getActivityReference(), updatedItem.getID(), updatedItem.getState(), resumeTime});
                                this.logger.warning(msg);
                            }
                            break block5;
                        }
                        String msg = pending ? String.format("Worklist item '%s' (%s) is pending for resume but the resume date has not been set yet. Waiting for the corresponding worklist update.", updatedItem.getActivityReference(), updatedItem.getID()) : String.format("Worklist item '%s' (%s) is not pending for resume and has therefore not signalled automatic resume. Ignoring it.", updatedItem.getActivityReference(), updatedItem.getID());
                        this.logger.finest(msg);
                        break block5;
                    }
                    case AVAILABLE: 
                    case ASSIGNED: {
                        boolean pending;
                        Collection<WorklistItem> collection = this.resumePending;
                        synchronized (collection) {
                            pending = this.resumePending.contains(updatedItem);
                        }
                        if (pending) {
                            String msg = String.format("Retrieved item '%s' ('%s') which is pending for resume but the current update declares its state as %s. Another worklist update should follow assigning the state SUSPENDED.", new Object[]{updatedItem.getActivityReference(), updatedItem.getID(), updatedItem.getState()});
                            this.logger.fine(msg);
                            break block5;
                        }
                        String msg = String.format("Submitting retrieved item '%s' ('%s') for execution.", updatedItem.getActivityReference(), updatedItem.getID());
                        this.logger.finer(msg);
                        this.itemExecutor.submit(updatedItem);
                        break block5;
                    }
                }
                String msg = String.format("Ignore WorklistItemState %s.", new Object[]{updatedItem.getState()});
                this.logger.finest(msg);
                break;
            }
            case REMOVED: {
                this.runningItems.remove(updatedItem);
                break;
            }
            default: {
                assert (false) : updatedItem;
                break;
            }
        }
    }
}

