/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.UpdateNode;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.systemdata.SystemDataConsumer;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AddNodeSystemParameter {
    private static final String MY_INSTANCE_NAME = "AddNodeSystemParameter";
    protected static final Logger logger = LoggerTools.getLogger(AddNodeSystemParameter.class);
    private static final String CHECK_ID = "Add Node System Parameter";

    public static boolean isPossible(Template template, int nodeID, ActivityConstants.AccessType type, ProcessModelParameter parameter) {
        return AddNodeSystemParameter.isPossible(template, nodeID, type, parameter, null);
    }

    public static boolean isPossible(Template template, int nodeID, ActivityConstants.AccessType type, ProcessModelParameter parameter, CheckReport checkReport) {
        Node node;
        boolean possible = true;
        if (!AddNodeSystemParameter.enoughParameter(template, type, nodeID, parameter, checkReport)) {
            possible = false;
        }
        if ((node = template.getNode(nodeID)).getSystemParameter(parameter.getName(), type) != null) {
            return false;
        }
        Method[] methods = Node.class.getMethods();
        boolean found = false;
        String parameterName = parameter.getName();
        found = AddNodeSystemParameter.parameterReferenceExists(node, methods, parameterName);
        if (!found) {
            if (checkReport != null) {
                String message = "Parameter '%s' cannot be added because it is not referenced in any system data consumer!";
                message = String.format(message, parameter.getName());
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return possible;
    }

    public static boolean parameterReferenceExists(Object object, Method[] methods, String parameterName) {
        boolean found = false;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        block2: while (n2 < n) {
            block9: {
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(SystemDataConsumer.class) && method.getParameterTypes().length <= 0) {
                    try {
                        Object res = method.invoke(object, new Object[0]);
                        if (res instanceof String) {
                            String value = (String)res;
                            ParameterRef[] refs = SystemDataTools.findParameterReferences(value);
                            if (AddNodeSystemParameter.parameterExists(parameterName, refs)) {
                                found = true;
                                break;
                            }
                            break block9;
                        }
                        if (res instanceof Map) {
                            Map pluginDataMap = (Map)res;
                            for (PluginData entry : pluginDataMap.values()) {
                                for (String paramString : entry.getPluginData().values()) {
                                    ParameterRef[] refs;
                                    if (paramString == null || !AddNodeSystemParameter.parameterExists(parameterName, refs = SystemDataTools.findParameterReferences(paramString))) continue;
                                    found = true;
                                    break block2;
                                }
                            }
                            break block9;
                        }
                        throw new AssertionError((Object)("Unknown return type for a SystemDataConsumer: " + res.getClass()));
                    }
                    catch (Exception e) {
                        String msg = "Could not retrieve value of consumer '%s'!";
                        msg = String.format(msg, method.toString());
                        logger.log(Level.SEVERE, msg, e);
                    }
                }
            }
            ++n2;
        }
        return found;
    }

    private static boolean parameterExists(String parameterName, ParameterRef[] refs) {
        boolean found = false;
        ParameterRef[] parameterRefArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterRef ref = parameterRefArray[n2];
            if (ref.getName().equals(parameterName)) {
                found = true;
                break;
            }
            ++n2;
        }
        return found;
    }

    public static boolean isPossible(Instance instance, int nodeID, ActivityConstants.AccessType type, ProcessModelParameter parameter) {
        return AddNodeSystemParameter.isPossible(instance, nodeID, type, parameter, null);
    }

    public static boolean isPossible(Instance instance, int nodeID, ActivityConstants.AccessType type, ProcessModelParameter parameter, CheckReport checkReport) {
        if (!(instance instanceof ChangeableInstance)) {
            if (checkReport != null) {
                String message = "The given instance is of type: " + instance.getClass().getName() + " but it must be of type ChangeableInstance.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, checkReport.getBase());
            }
            return false;
        }
        Template template = instance.getTemplate();
        if (!AddNodeSystemParameter.enoughParameter(template, type, nodeID, parameter, checkReport)) {
            return false;
        }
        if (instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(template.getNode(nodeID)) + "' where the system parameter should be added must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(nodeID).toString() + ".";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID), "NodeState")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return AddNodeSystemParameter.isPossible(template, nodeID, type, parameter, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, int nodeID, ActivityConstants.AccessType type, ProcessModelParameter parameter) {
        AddNodeSystemParameter.performOperation(session, template, nodeID, type, parameter, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, int nodeID, ActivityConstants.AccessType type, ProcessModelParameter parameter, UpdateManager updateManager) {
        AddNodeSystemParameter.performOperation(session, (ChangePrimitives)template, nodeID, type, parameter, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, int nodeID, ActivityConstants.AccessType type, ProcessModelParameter parameter) {
        AddNodeSystemParameter.performOperation(session, instance, nodeID, type, parameter, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, int nodeID, ActivityConstants.AccessType type, ProcessModelParameter parameter, UpdateManager updateManager) {
        AddNodeSystemParameter.performOperation(session, (ChangePrimitives)instance, nodeID, type, parameter, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, int nodeID, ActivityConstants.AccessType type, ProcessModelParameter parameter, UpdateManager updateManager) {
        ProcessModelFactory pmf;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        if (template.getNode(nodeID).getSystemParameter(parameter.getName(), type) != null) {
            String msg = "The system parameter '%s' of type '%s' already exists at node #%d.";
            msg = String.format(msg, new Object[]{parameter.getName(), type, nodeID});
            logger.warning(msg);
        }
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>> systemParams = new HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>>();
        HashSet<ProcessModelParameter> params = new HashSet<ProcessModelParameter>(template.getNode(nodeID).getSystemParameters(type));
        params.add(parameter);
        systemParams.put(type, params);
        Node dummyNode = pmf.createNode(nodeID, "", "", "", null, false, null, null, systemParams, null, null, null);
        ProcessConstants.NodeProperty property = type == ActivityConstants.AccessType.SYSTEM_READ ? ProcessConstants.NodeProperty.SYSTEM_READ_PARAMS : ProcessConstants.NodeProperty.SYSTEM_WRITE_PARAMS;
        UpdateNode.performOperation(processGraph, dummyNode, updateManager, property);
    }

    private static boolean enoughParameter(Template template, ActivityConstants.AccessType type, int nodeID, ProcessModelParameter parameter, CheckReport checkReport) {
        if (template.getNode(nodeID) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain the given node: " + nodeID;
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (type != ActivityConstants.AccessType.SYSTEM_READ && type != ActivityConstants.AccessType.SYSTEM_WRITE) {
            if (checkReport != null) {
                String message = "The access type of a System Parameter must be SYSTEM_READ or SYSTEM.WRITE";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(nodeID).getSystemParameters(type) != null && template.getNode(nodeID).getSystemParameters(type).contains(parameter)) {
            if (checkReport != null) {
                String message = "The given node already contains the given system parameter for the given AccessType";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

