/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.AddNodeSystemParameter;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.InsertDataEdge;
import de.aristaflow.adept2.core.changeoperations.InsertDataElement;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.systemdata.SystemDataProducer;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class AddSystemDataFlow {
    private static final String MY_INSTANCE_NAME = "AddSystemDataFlow";
    protected static final Logger logger = LoggerTools.getLogger(AddSystemDataFlow.class);
    private static final String CHECK_ID = "Add System Data Flow";

    public static boolean isPossible(Template template, int producerNodeID, SystemDataProducer systemDataType, int consumerNodeID, String inputParameterName) {
        return AddSystemDataFlow.isPossible(template, producerNodeID, systemDataType, consumerNodeID, inputParameterName, null);
    }

    public static boolean isPossible(Template template, int producerNodeID, SystemDataProducer systemDataType, int consumerNodeID, String inputParameterName, CheckReport checkReport) {
        if (!AddSystemDataFlow.parameterExists(template, consumerNodeID, inputParameterName, checkReport)) {
            return false;
        }
        return AddSystemDataFlow.isPossible(template, producerNodeID, systemDataType, consumerNodeID, checkReport);
    }

    protected static boolean isPossible(Template template, int producerNodeID, SystemDataProducer systemDataType, int consumerNodeID, CheckReport checkReport) {
        URI[] affectedElements;
        String message;
        boolean possible = true;
        if (!AddSystemDataFlow.enoughParameter(template, producerNodeID, systemDataType, consumerNodeID, checkReport)) {
            possible = false;
        }
        Node producerNode = template.getNode(producerNodeID);
        Node consumerNode = template.getNode(consumerNodeID);
        if (producerNodeID == consumerNodeID && checkReport != null) {
            message = "The producer node '" + ChangeOperationTools.getHumanReadableNodeName(producerNode) + "' and the consumer node '" + ChangeOperationTools.getHumanReadableNodeName(consumerNode) + "' must be different, but this is not the case here.";
            affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), producerNode), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), consumerNode)};
            checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
        }
        if (!template.isTransPredOf(consumerNodeID, producerNodeID, ProcessConstants.EdgeType.ET_CONTROL)) {
            if (checkReport != null) {
                message = "The selected producer node '" + ChangeOperationTools.getHumanReadableNodeName(producerNode) + "' must be a predecessor of the selected consumer node '" + ChangeOperationTools.getHumanReadableNodeName(consumerNode) + "', but this is not the case here.";
                affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), producerNode), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), consumerNode)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return possible;
    }

    public static boolean isPossible(Instance instance, int producerNodeID, SystemDataProducer systemDataType, int consumerNodeID, String inputParameterName) {
        return AddSystemDataFlow.isPossible(instance, producerNodeID, systemDataType, consumerNodeID, inputParameterName, null);
    }

    public static boolean isPossible(Instance instance, int producerNodeID, SystemDataProducer systemDataType, int consumerNodeID, String inputParameterName, CheckReport checkReport) {
        if (!AddSystemDataFlow.checkStateBasedConditions(instance, producerNodeID, systemDataType, consumerNodeID, checkReport)) {
            return false;
        }
        return AddSystemDataFlow.isPossible(instance.getTemplate(), producerNodeID, systemDataType, consumerNodeID, inputParameterName, checkReport);
    }

    protected static boolean isPossible(Instance instance, int producerNodeID, SystemDataProducer systemDataType, int consumerNodeID, CheckReport checkReport) {
        if (!AddSystemDataFlow.checkStateBasedConditions(instance, producerNodeID, systemDataType, consumerNodeID, checkReport)) {
            return false;
        }
        return AddSystemDataFlow.isPossible(instance.getTemplate(), producerNodeID, systemDataType, consumerNodeID, checkReport);
    }

    private static boolean checkStateBasedConditions(Instance instance, int producerNodeID, SystemDataProducer systemDataType, int consumerNodeID, CheckReport checkReport) {
        if (!(instance instanceof ChangeableInstance)) {
            if (checkReport != null) {
                String message = "The given instance is of type: " + instance.getClass().getName() + " but it must be of type ChangeableInstance.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, checkReport.getBase());
            }
            return false;
        }
        Template template = instance.getTemplate();
        if (!AddSystemDataFlow.enoughParameter(template, producerNodeID, systemDataType, consumerNodeID, checkReport)) {
            return false;
        }
        if (template.getNode(producerNodeID).getSystemParameter(systemDataType.getParameterProperties().getName(), ActivityConstants.AccessType.SYSTEM_WRITE) == null) {
            if (instance.getNodeState(producerNodeID) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(producerNodeID) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
                if (checkReport != null) {
                    String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(template.getNode(producerNodeID)) + "' where the system parameter should be produced does not " + "contain a parameter which matches the given system data producer, " + "therefore the node must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(producerNodeID).toString() + ".";
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(producerNodeID), "NodeState")};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                return false;
            }
        } else if (instance.getNodeState(consumerNodeID) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(consumerNodeID) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(template.getNode(consumerNodeID)) + "' where the system parameter should be added must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(consumerNodeID).toString() + ".";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(consumerNodeID), "NodeState")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return true;
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, int producerNodeID, SystemDataProducer systemDataType, int consumerNodeID, String inputParameterName) {
        AddSystemDataFlow.performOperation(session, template, producerNodeID, systemDataType, consumerNodeID, inputParameterName, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, int producerNodeID, SystemDataProducer systemDataType, int consumerNodeID, String inputParameterName, UpdateManager updateManager) {
        AddSystemDataFlow.performOperation(session, (ChangePrimitives)template, producerNodeID, systemDataType, consumerNodeID, inputParameterName, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, int producerNodeID, SystemDataProducer systemDataType, int consumerNodeID, String inputParameterName) {
        AddSystemDataFlow.performOperation(session, instance, producerNodeID, systemDataType, consumerNodeID, inputParameterName, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, int producerNodeID, SystemDataProducer systemDataType, int consumerNodeID, String inputParameterName, UpdateManager updateManager) {
        AddSystemDataFlow.performOperation(session, (ChangePrimitives)instance, producerNodeID, systemDataType, consumerNodeID, inputParameterName, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, int producerNodeID, SystemDataProducer systemDataType, int consumerNodeID, String inputParameterName, UpdateManager updateManager) {
        ProcessModelFactory pmf;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        DataElement systemDataElement = null;
        ProcessModelParameter producerParameter = template.getNode(producerNodeID).getSystemParameter(systemDataType.getParameterProperties().getName(), ActivityConstants.AccessType.SYSTEM_WRITE);
        if (producerParameter == null) {
            ProcessModelParameter tempParam = systemDataType.getParameterProperties();
            producerParameter = pmf.createProcessModelParameter(tempParam.getName(), tempParam.getDescription(), tempParam.getDataType(), tempParam.getUDTName(), tempParam.getIdentifierID(), tempParam.isOptional(), tempParam.isVirtual(), tempParam.isFailure(), tempParam.getDefaultValue(), tempParam.getConfiguration(), tempParam, tempParam.getUserAttributes());
            logger.info("call change operation add node system parameter");
            AddNodeSystemParameter.performOperation(session, processGraph, producerNodeID, ActivityConstants.AccessType.SYSTEM_WRITE, producerParameter, updateManager);
        } else {
            int connectorID = template.getNode(producerNodeID).getConnector(producerParameter.getName(), ActivityConstants.AccessType.SYSTEM_WRITE);
            systemDataElement = template.getDataElement(producerNodeID, connectorID);
        }
        if (systemDataElement == null) {
            systemDataElement = ChangeOperationTools.createSimpleDataElementObject(session, producerParameter.getName(), producerParameter.getDataType());
            logger.info("call change operation insert data element");
            systemDataElement = InsertDataElement.performOperation(session, processGraph, systemDataElement, updateManager);
            logger.info("call change operation insert data edge");
            InsertDataEdge.performOperation(session, processGraph, template.getNode(producerNodeID), systemDataElement, producerParameter, ActivityConstants.AccessType.SYSTEM_WRITE, updateManager);
        }
        ProcessModelParameter consumerParameter = template.getNode(consumerNodeID).getSystemParameter(inputParameterName, ActivityConstants.AccessType.SYSTEM_READ);
        if (template.getDataEdge(consumerNodeID, systemDataElement.getID(), ActivityConstants.AccessType.SYSTEM_READ) == null) {
            logger.info("call change operation insert data edge");
            InsertDataEdge.performOperation(session, processGraph, template.getNode(consumerNodeID), systemDataElement, consumerParameter, ActivityConstants.AccessType.SYSTEM_READ, updateManager);
        }
    }

    private static boolean enoughParameter(Template template, int producerNodeID, SystemDataProducer systemDataType, int consumerNodeID, CheckReport checkReport) {
        if (template.getNode(producerNodeID) == null || template.getNode(consumerNodeID) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain one or both of the nodes with the given IDs: " + producerNodeID + ", " + consumerNodeID;
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (systemDataType == null) {
            if (checkReport != null) {
                String message = "The system data type must not be null";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }

    private static boolean parameterExists(Template template, int consumerNodeID, String inputParameterName, CheckReport checkReport) {
        if (template.getNode(consumerNodeID).getSystemParameter(inputParameterName, ActivityConstants.AccessType.SYSTEM_READ) == null) {
            if (checkReport != null) {
                String message = "The consumer node must have a parameter with the given name: '" + inputParameterName + "', but this is not the case.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

