/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.DeleteDataEdge;
import de.aristaflow.adept2.core.changeoperations.InsertDataEdge;
import de.aristaflow.adept2.core.changeoperations.InsertDataElement;
import de.aristaflow.adept2.core.changeoperations.UpdateDataEdge;
import de.aristaflow.adept2.core.changeoperations.UpdateDataElement;
import de.aristaflow.adept2.core.changeoperations.UpdateNode;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class AssignExecutableBusinessProcess {
    private static final String MY_INSTANCE_NAME = "AssignExecutableBusinessProcess";
    private static final String CHECK_ID = "Assign Executable Business Process";

    public static boolean isPossible(Template template, Node node, ExecutableBusinessProcess ebp, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, DataElement>> paramsWithExistingDataElements) {
        return AssignExecutableBusinessProcess.isPossible(template, node, ebp, paramsWithoutExistingDataElements, paramsWithExistingDataElements, null);
    }

    public static boolean isPossible(Template template, Node node, ExecutableBusinessProcess ebp, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, DataElement>> paramsWithExistingDataElements, CheckReport checkReport) {
        String message;
        boolean possible = true;
        if (!AssignExecutableBusinessProcess.enoughParameter(node, ebp, template, checkReport)) {
            return false;
        }
        for (Map.Entry<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> entry : paramsWithoutExistingDataElements.entrySet()) {
            ActivityConstants.AccessType accessType = entry.getKey();
            if (!ActivityConstants.AccessType.isActivityRelatedValue(accessType)) {
                if (checkReport != null) {
                    String message2 = String.format("The access type %s is not suitable for activities.", new Object[]{accessType});
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message2, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node));
                }
                return false;
            }
            if (accessType != ActivityConstants.AccessType.WRITE) {
                Map<ProcessModelParameter, ProcessConstants.DataMappingType> paramMap = entry.getValue();
                for (Map.Entry<ProcessModelParameter, ProcessConstants.DataMappingType> entry2 : paramMap.entrySet()) {
                    if (entry2.getValue() != ProcessConstants.DataMappingType.DISABLE) continue;
                    if (entry2.getKey().isOptional()) break;
                    possible = false;
                    if (checkReport == null) break;
                    message = String.format("The parameter '%s' from EBP '%s' which should be assigned to node '%s' is not optional, so it's not allowed to mark it as disabled", entry2.getKey().getName(), ebp, ChangeOperationTools.getHumanReadableNodeName(node));
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getParameterIdentifier(checkReport.getBase(), node, ebp, entry2.getKey()));
                    break;
                }
            }
            if (!possible) break;
        }
        if (possible) {
            for (Map.Entry<ActivityConstants.AccessType, Map<ProcessModelParameter, Object>> entry : paramsWithExistingDataElements.entrySet()) {
                if (!ActivityConstants.AccessType.isActivityRelatedValue(entry.getKey())) {
                    if (checkReport != null) {
                        String message3 = String.format("The access type %s is not suitable for activities.", new Object[]{entry.getKey()});
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message3, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node));
                    }
                    return false;
                }
                Map<ProcessModelParameter, Object> paramMap = entry.getValue();
                block3: for (Map.Entry<ProcessModelParameter, Object> entry1 : paramMap.entrySet()) {
                    URI[] affectedElements;
                    DataElement data = (DataElement)entry1.getValue();
                    if (entry1.getKey().getDataType() != data.getDataType() || entry1.getKey().isVirtual() != data.isVirtual() || !entry1.getKey().getIdentifierID().equals(data.getIdentifierID()) && !data.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) && !data.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET)) {
                        possible = false;
                        if (checkReport != null) {
                            message = String.format("The parameter '%s' from EBP '%s' which should be assigned to node '%s' is not compatible to the data element '%s' to which it should be mapped to.", entry1.getKey().getName(), ebp, ChangeOperationTools.getHumanReadableNodeName(node), data.getName());
                            affectedElements = new URI[]{ProcessElementIdentifierTools.getParameterIdentifier(checkReport.getBase(), node, ebp, entry1.getKey()), ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), data)};
                            checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                        }
                    } else if (entry1.getKey().getDataType() == ProcessConstants.AdeptDataType.USERDEFINED && !entry1.getKey().getUDTName().equals(data.getUDTName())) {
                        possible = false;
                        if (checkReport != null) {
                            message = String.format("The parameter '%s' from EBP '%s' which should be assigned to node '%s' is not compatible to the data element '%s' to which it should be mapped to. Parameter and data elements are both of type USERDEFINED but the user defined types are different.", entry1.getKey().getName(), ebp, ChangeOperationTools.getHumanReadableNodeName(node), data.getName());
                            affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node, "userDefinedType"), ProcessElementIdentifierTools.getEBPIdentifier(checkReport.getBase(), node, ebp), ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), data, "userDefinedType")};
                            checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                        }
                    }
                    for (Map.Entry<ProcessModelParameter, Object> entry2 : paramMap.entrySet()) {
                        DataElement data2;
                        if (entry2.getKey().getIdentifierID().equals(entry1.getKey().getIdentifierID()) || (data2 = (DataElement)entry2.getValue()).getID() != data.getID()) continue;
                        possible = false;
                        if (checkReport == null) continue block3;
                        String message4 = String.format("The Mapping for the parameter '%s' from EBP '%s' which should be assigned to node '%s' is not valid. The data element '%s' to which the parameter should be mapped to is already used by parameter '%s'.", entry1.getKey().getName(), ebp, ChangeOperationTools.getHumanReadableNodeName(node), data.getName(), entry2.getKey().getName());
                        URI[] affectedElements2 = new URI[]{ProcessElementIdentifierTools.getParameterIdentifier(checkReport.getBase(), node, ebp, entry1.getKey()), ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), data), ProcessElementIdentifierTools.getParameterIdentifier(checkReport.getBase(), node, ebp, entry2.getKey())};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message4, affectedElements2);
                        continue block3;
                    }
                }
                if (!possible) break;
            }
        }
        return possible;
    }

    public static boolean isPossible(ChangeableInstance instance, Node node, ExecutableBusinessProcess ebp, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, DataElement>> paramsWithExistingDataElements) {
        return AssignExecutableBusinessProcess.isPossible(instance, node, ebp, paramsWithoutExistingDataElements, paramsWithExistingDataElements, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node node, ExecutableBusinessProcess ebp, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, DataElement>> paramsWithExistingDataElements, CheckReport checkReport) {
        if (!AssignExecutableBusinessProcess.enoughParameter(node, ebp, instance.getTemplate(), checkReport)) {
            return false;
        }
        if (instance.getNodeState(node.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(node.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = String.format("The node '%s' given as target for the EBP assignment must be ACTIVATED or NOT_ACTIVATED, but it is in state: %s.", ChangeOperationTools.getHumanReadableNodeName(node), instance.getNodeState(node.getID()).toString());
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        Template template = instance.getTemplate();
        return AssignExecutableBusinessProcess.isPossible(template, node, ebp, paramsWithoutExistingDataElements, paramsWithExistingDataElements, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node node, ExecutableBusinessProcess ebp, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>> paramsWithExistingDataElements) {
        AssignExecutableBusinessProcess.performOperation(session, template, node, ebp, paramsWithoutExistingDataElements, paramsWithExistingDataElements, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node node, ExecutableBusinessProcess ebp, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>> paramsWithExistingDataElements, UpdateManager updateManager) {
        AssignExecutableBusinessProcess.performOperation(session, (ChangePrimitives)template, node, ebp, paramsWithoutExistingDataElements, paramsWithExistingDataElements, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node node, ExecutableBusinessProcess ebp, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>> paramsWithExistingDataElements) {
        AssignExecutableBusinessProcess.performOperation(session, instance, node, ebp, paramsWithoutExistingDataElements, paramsWithExistingDataElements, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node node, ExecutableBusinessProcess ebp, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>> paramsWithExistingDataElements, UpdateManager updateManager) {
        AssignExecutableBusinessProcess.performOperation(session, (ChangePrimitives)instance, node, ebp, paramsWithoutExistingDataElements, paramsWithExistingDataElements, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, Node node, ExecutableBusinessProcess ebp, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>> paramsWithExistingDataElements, UpdateManager updateManager) {
        ProcessModelFactory processModelFactory;
        ActivityConstants.AccessType[] readMap;
        Object object;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        boolean ebpExists = false;
        boolean dataExists = false;
        int lowestFreeConnectorID = 0;
        HashMap<ActivityConstants.AccessType, Map<String, Integer>> parameterConnectorMap = new HashMap<ActivityConstants.AccessType, Map<String, Integer>>();
        HashMap<String, Integer> inConnectorMap = new HashMap<String, Integer>();
        HashMap<String, Integer> outConnectorMap = new HashMap<String, Integer>();
        HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>> nodeParameters = new HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>>();
        HashSet<Integer> usedConnectorIDs = new HashSet<Integer>();
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.systemRelatedValues();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.AccessType type = accessTypeArray[n2];
            usedConnectorIDs.addAll(node.getConnectorMapping(type).values());
            ++n2;
        }
        if (node.getExecutableBusinessProcess() != null) {
            ebpExists = true;
        }
        HashMap<Integer, Integer> inDataElementMap = new HashMap<Integer, Integer>();
        int[] readDataElementIDs = template.getAccessedDataElementIDsForNode(node.getID(), ActivityConstants.AccessType.READ);
        if (readDataElementIDs.length != 0) {
            object = readDataElementIDs;
            int n3 = readDataElementIDs.length;
            int n4 = 0;
            while (n4 < n3) {
                int readDataElementID = object[n4];
                inDataElementMap.put(readDataElementID, template.getConnector(node.getID(), readDataElementID, ActivityConstants.AccessType.READ));
                ++n4;
            }
            dataExists = true;
        }
        HashMap<Integer, Integer> outDataElementMap = new HashMap<Integer, Integer>();
        int[] writtenDataElementIDs = template.getAccessedDataElementIDsForNode(node.getID(), ActivityConstants.AccessType.WRITE);
        if (writtenDataElementIDs.length != 0) {
            int[] nArray = writtenDataElementIDs;
            int n3 = writtenDataElementIDs.length;
            int n6 = 0;
            while (n6 < n3) {
                int n4 = nArray[n6];
                outDataElementMap.put(n4, template.getConnector(node.getID(), n4, ActivityConstants.AccessType.WRITE));
                ++n6;
            }
            dataExists = true;
        }
        if (ebpExists) {
            object = paramsWithoutExistingDataElements.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                switch ((ActivityConstants.AccessType)((Object)entry.getKey())) {
                    case READ: {
                        AssignExecutableBusinessProcess.recycleDisabledConnectors(processGraph, node, (Map)entry.getValue(), inConnectorMap, usedConnectorIDs, (ActivityConstants.AccessType)((Object)entry.getKey()));
                        break;
                    }
                    case WRITE: {
                        AssignExecutableBusinessProcess.recycleDisabledConnectors(processGraph, node, (Map)entry.getValue(), outConnectorMap, usedConnectorIDs, (ActivityConstants.AccessType)((Object)entry.getKey()));
                        break;
                    }
                    case SYSTEM_READ: 
                    case SYSTEM_WRITE: {
                        throw new AssertionError((Object)("isPossible should have failed, illegal access type " + entry.getKey()));
                    }
                    default: {
                        throw new AssertionError((Object)"An unknown access type was found!");
                    }
                }
            }
        }
        if (dataExists) {
            object = paramsWithExistingDataElements.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                switch ((ActivityConstants.AccessType)((Object)entry.getKey())) {
                    case READ: {
                        AssignExecutableBusinessProcess.deleteUnusedDataEdges(session, processGraph, node, (Map)entry.getValue(), inDataElementMap, (ActivityConstants.AccessType)((Object)entry.getKey()), updateManager);
                        break;
                    }
                    case WRITE: {
                        AssignExecutableBusinessProcess.deleteUnusedDataEdges(session, processGraph, node, (Map)entry.getValue(), outDataElementMap, (ActivityConstants.AccessType)((Object)entry.getKey()), updateManager);
                        break;
                    }
                    case SYSTEM_READ: 
                    case SYSTEM_WRITE: {
                        throw new AssertionError((Object)("isPossible should have failed, illegal access type " + entry.getKey()));
                    }
                    default: {
                        throw new AssertionError((Object)"An unknown access type was found!");
                    }
                }
            }
            for (Map.Entry entry : paramsWithExistingDataElements.entrySet()) {
                switch ((ActivityConstants.AccessType)((Object)entry.getKey())) {
                    case READ: {
                        AssignExecutableBusinessProcess.mapStillUsedDataElements(session, processGraph, (Map)entry.getValue(), inConnectorMap, usedConnectorIDs, inDataElementMap, node.getID(), (ActivityConstants.AccessType)((Object)entry.getKey()), updateManager);
                        break;
                    }
                    case WRITE: {
                        AssignExecutableBusinessProcess.mapStillUsedDataElements(session, processGraph, (Map)entry.getValue(), outConnectorMap, usedConnectorIDs, outDataElementMap, node.getID(), (ActivityConstants.AccessType)((Object)entry.getKey()), updateManager);
                        break;
                    }
                    case SYSTEM_READ: 
                    case SYSTEM_WRITE: {
                        throw new AssertionError((Object)("isPossible should have failed, illegal access type " + entry.getKey()));
                    }
                    default: {
                        throw new AssertionError((Object)"An unknown access type was found!");
                    }
                }
            }
        }
        object = paramsWithoutExistingDataElements.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            switch ((ActivityConstants.AccessType)((Object)entry.getKey())) {
                case READ: {
                    Map<ProcessModelParameter, ProcessConstants.DataMappingType> writeMap = paramsWithoutExistingDataElements.get((Object)ActivityConstants.AccessType.WRITE);
                    lowestFreeConnectorID = AssignExecutableBusinessProcess.mapRemainingParamsWithoutExistingDataElements(session, processGraph, node, (Map)entry.getValue(), inConnectorMap, usedConnectorIDs, (ActivityConstants.AccessType)((Object)entry.getKey()), lowestFreeConnectorID, outConnectorMap, writeMap, updateManager);
                    break;
                }
                case WRITE: {
                    readMap = paramsWithoutExistingDataElements.get((Object)ActivityConstants.AccessType.READ);
                    lowestFreeConnectorID = AssignExecutableBusinessProcess.mapRemainingParamsWithoutExistingDataElements(session, processGraph, node, (Map)entry.getValue(), outConnectorMap, usedConnectorIDs, (ActivityConstants.AccessType)((Object)entry.getKey()), lowestFreeConnectorID, inConnectorMap, (Map<ProcessModelParameter, ProcessConstants.DataMappingType>)readMap, updateManager);
                    break;
                }
                case SYSTEM_READ: 
                case SYSTEM_WRITE: {
                    throw new AssertionError((Object)("isPossible should have failed, illegal access type " + entry.getKey()));
                }
                default: {
                    throw new AssertionError((Object)"An unknown access type was found!");
                }
            }
        }
        for (Map.Entry entry : paramsWithExistingDataElements.entrySet()) {
            switch ((ActivityConstants.AccessType)((Object)entry.getKey())) {
                case READ: {
                    lowestFreeConnectorID = AssignExecutableBusinessProcess.mapRemainingParamsWithExistingDataElements(session, processGraph, node, (Map)entry.getValue(), inConnectorMap, usedConnectorIDs, (ActivityConstants.AccessType)((Object)entry.getKey()), lowestFreeConnectorID, updateManager);
                    break;
                }
                case WRITE: {
                    lowestFreeConnectorID = AssignExecutableBusinessProcess.mapRemainingParamsWithExistingDataElements(session, processGraph, node, (Map)entry.getValue(), outConnectorMap, usedConnectorIDs, (ActivityConstants.AccessType)((Object)entry.getKey()), lowestFreeConnectorID, updateManager);
                    break;
                }
                case SYSTEM_READ: 
                case SYSTEM_WRITE: {
                    throw new AssertionError((Object)("isPossible should have failed, illegal access type " + entry.getKey()));
                }
                default: {
                    throw new AssertionError((Object)"An unknown access type was found!");
                }
            }
        }
        parameterConnectorMap.put(ActivityConstants.AccessType.READ, inConnectorMap);
        parameterConnectorMap.put(ActivityConstants.AccessType.WRITE, outConnectorMap);
        readMap = ActivityConstants.AccessType.systemRelatedValues();
        int writeMap = readMap.length;
        int n7 = 0;
        while (n7 < writeMap) {
            ActivityConstants.AccessType accessType = readMap[n7];
            nodeParameters.put(accessType, node.getSystemParameters(accessType));
            ++n7;
        }
        try {
            processModelFactory = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        Node temporaryNode = processModelFactory.createNode(node.getID(), node.getName(), node.getDescription(), node.getStaffAssignmentRule(), ebp, node.isAutoStartEnabled(), node.getIconID(), parameterConnectorMap, nodeParameters, node.getSupportedPlugins(), node.getPluginDatas(), node.getUserAttributes());
        UpdateNode.performOperation(processGraph, temporaryNode, updateManager, ProcessConstants.NodeProperty.EXECUTABLE_BUSINESS_PROCESS);
        if (updateManager != null && ebp instanceof DecisionActivity) {
            int[] nodeIDs;
            int[] nArray = nodeIDs = template.getSuccByEdgeType(node.getID(), ProcessConstants.EdgeType.ET_CONTROL, ProcessConstants.EdgeType.ET_LOOP);
            int n5 = nodeIDs.length;
            int n6 = 0;
            while (n6 < n5) {
                int nodeID = nArray[n6];
                Edge edge = template.getEdge(node.getID(), nodeID, ProcessConstants.EdgeType.ET_CONTROL);
                if (edge == null) {
                    edge = template.getEdge(node.getID(), nodeID, ProcessConstants.EdgeType.ET_LOOP);
                }
                updateManager.firePropertyChange(edge, (Object)UpdateManager.EdgeProperties.EDGE_LABEL);
                ++n6;
            }
        }
    }

    private static void recycleDisabledConnectors(ChangePrimitives processGraph, Node node, Map<ProcessModelParameter, ProcessConstants.DataMappingType> mapping, Map<String, Integer> connectorMap, Set<Integer> usedConnectorIDs, ActivityConstants.AccessType type) {
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        int[] formerDisabledConnectorIDs = template.getDisabledConnectors(node.getID(), type);
        LinkedList<ProcessModelParameter> disabledParameter = new LinkedList<ProcessModelParameter>();
        for (Map.Entry<ProcessModelParameter, ProcessConstants.DataMappingType> entry : mapping.entrySet()) {
            if (entry.getValue() != ProcessConstants.DataMappingType.DISABLE) continue;
            disabledParameter.add(entry.getKey());
        }
        int[] nArray = formerDisabledConnectorIDs;
        int n = formerDisabledConnectorIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int connectorID = nArray[n2];
            if (disabledParameter.size() > 0) {
                ProcessModelParameter param = (ProcessModelParameter)disabledParameter.get(0);
                usedConnectorIDs.add(connectorID);
                connectorMap.put(param.getName(), connectorID);
                disabledParameter.remove(param);
                mapping.remove(param);
            } else {
                processGraph.removeDisabledConnector(node.getID(), connectorID);
            }
            ++n2;
        }
    }

    private static void deleteUnusedDataEdges(SessionToken session, ChangePrimitives processGraph, Node node, Map<ProcessModelParameter, Integer> mapping, Map<Integer, Integer> dataElementMap, ActivityConstants.AccessType type, UpdateManager updateManager) {
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        Iterator<Integer> dataElementIDIter = dataElementMap.keySet().iterator();
        while (dataElementIDIter.hasNext()) {
            int dataElementID = dataElementIDIter.next();
            if (mapping.containsValue(dataElementID)) continue;
            dataElementIDIter.remove();
            DeleteDataEdge.performOperation(session, processGraph, node, template.getDataElement(dataElementID), type, updateManager);
        }
    }

    private static void mapStillUsedDataElements(SessionToken session, ChangePrimitives processGraph, Map<ProcessModelParameter, Integer> mapping, Map<String, Integer> connectorMap, Set<Integer> usedConnectorIDs, Map<Integer, Integer> dataElementMap, int nodeID, ActivityConstants.AccessType type, UpdateManager updateManager) {
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        for (int dataElementID : dataElementMap.keySet()) {
            int connectorID = dataElementMap.get(dataElementID);
            usedConnectorIDs.add(connectorID);
            Iterator<ProcessModelParameter> paramIter = mapping.keySet().iterator();
            while (paramIter.hasNext()) {
                ProcessModelParameter param = paramIter.next();
                if (mapping.get(param) != dataElementID) continue;
                connectorMap.put(param.getName(), connectorID);
                DataElement data = template.getDataElement(dataElementID);
                if (data.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET)) {
                    ProcessModelFactory pmf;
                    UUID paramIdentifierID = param.getIdentifierID();
                    try {
                        pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
                    }
                    catch (ServiceNotKnownException snke) {
                        throw new RTServiceNotKnownException(snke);
                    }
                    DataElement tempDataElement = pmf.createDataElement(data.getID(), data.getName(), data.getDataType(), data.getDescription(), data.getUDTName(), data.getIconID(), paramIdentifierID, data.isPublic(), data.isVirtual(), data.getSupportedPlugins(), data.getPluginDatas(), data.getUserAttributes());
                    UpdateDataElement.performOperation(session, processGraph, tempDataElement, updateManager, ProcessConstants.DataElementProperty.IDENTIFIER);
                }
                AssignExecutableBusinessProcess.updateDataEdgeOptionalAttribute(session, processGraph, nodeID, type, updateManager, data.getID(), param);
                paramIter.remove();
            }
        }
    }

    private static int mapRemainingParamsWithoutExistingDataElements(SessionToken session, ChangePrimitives processGraph, Node node, Map<ProcessModelParameter, ProcessConstants.DataMappingType> mapping, Map<String, Integer> connectorMap, Set<Integer> usedConnectorIDs, ActivityConstants.AccessType type, int lowestFreeConnectorID, Map<String, Integer> otherConnectorMap, Map<ProcessModelParameter, ProcessConstants.DataMappingType> otherMapping, UpdateManager updateManager) {
        int connectorID = lowestFreeConnectorID;
        for (Map.Entry<ProcessModelParameter, ProcessConstants.DataMappingType> entry : mapping.entrySet()) {
            ProcessModelParameter parameter = entry.getKey();
            while (usedConnectorIDs.contains(connectorID)) {
                ++connectorID;
            }
            connectorMap.put(parameter.getName(), connectorID);
            switch (entry.getValue()) {
                case CONNECT_LATER: {
                    ++connectorID;
                    break;
                }
                case DISABLE: {
                    processGraph.addDisabledConnector(node.getID(), connectorID);
                    ++connectorID;
                    break;
                }
                case NEW_DATAELEMENT: {
                    DataElement dataWithID = null;
                    if (otherConnectorMap.containsKey(parameter.getName())) {
                        Parameter otherParam = null;
                        for (ProcessModelParameter tempParam : otherMapping.keySet()) {
                            if (!tempParam.getName().equals(parameter.getName())) continue;
                            otherParam = tempParam;
                        }
                        if (otherParam != null && parameter.getDataType().equals((Object)otherParam.getDataType()) && parameter.getIdentifierID().equals(otherParam.getIdentifierID())) {
                            int otherConnectorID = otherConnectorMap.get(otherParam.getName());
                            Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
                            dataWithID = template.getDataElement(node.getID(), otherConnectorID);
                        }
                    }
                    if (dataWithID == null) {
                        ProcessModelFactory pmf;
                        try {
                            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
                        }
                        catch (ServiceNotKnownException snke) {
                            throw new RTServiceNotKnownException(snke);
                        }
                        DataElement newData = pmf.createDataElement(Integer.MIN_VALUE, parameter.getName(), parameter.getDataType(), parameter.getDescription(), parameter.getUDTName(), null, parameter.getIdentifierID(), false, parameter.isVirtual(), new HashMap<String, Set<String>>(), new HashMap<String, PluginData>(), new HashMap<String, String>());
                        dataWithID = InsertDataElement.performOperation(session, processGraph, newData, updateManager);
                    }
                    InsertDataEdge.performOperation(session, processGraph, node, dataWithID, parameter, connectorID, type, updateManager);
                    ++connectorID;
                    break;
                }
                default: {
                    throw new RuntimeException("DataMappingType not supported");
                }
            }
        }
        return connectorID;
    }

    private static int mapRemainingParamsWithExistingDataElements(SessionToken session, ChangePrimitives processGraph, Node node, Map<ProcessModelParameter, Integer> mapping, Map<String, Integer> connectorMap, Set<Integer> usedConnectorIDs, ActivityConstants.AccessType type, int lowestFreeConnectorID, UpdateManager updateManager) {
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        int connectorID = lowestFreeConnectorID;
        for (Map.Entry<ProcessModelParameter, Integer> entry : mapping.entrySet()) {
            DataElement data = template.getDataElement(entry.getValue());
            while (usedConnectorIDs.contains(connectorID)) {
                ++connectorID;
            }
            connectorMap.put(entry.getKey().getName(), connectorID);
            InsertDataEdge.performOperation(session, processGraph, node, data, entry.getKey(), connectorID, type, updateManager);
            ++connectorID;
        }
        return connectorID;
    }

    private static void updateDataEdgeOptionalAttribute(SessionToken session, ChangePrimitives processGraph, int nodeID, ActivityConstants.AccessType type, UpdateManager updateManager, int dataElementID, ProcessModelParameter parameter) {
        ProcessModelFactory pmf;
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        DataEdge dummyDataEdge = parameter.isOptional() ? pmf.createDataEdge(type, true, new HashMap<String, String>()) : pmf.createDataEdge(type, false, new HashMap<String, String>());
        UpdateDataEdge.performOperation(session, processGraph, nodeID, dataElementID, type, dummyDataEdge, updateManager, ProcessConstants.DataEdgeProperty.OPTIONAL);
    }

    private static boolean enoughParameter(Node node, ExecutableBusinessProcess ebp, Template template, CheckReport checkReport) {
        if (node == null || ebp == null) {
            if (checkReport != null) {
                String message = "Not enough selected elements for this operation. A node as target and an EBP which should be assigned to that node are needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(node.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain the given node and/or the given EBP does not exist: " + ChangeOperationTools.getHumanReadableNodeName(node);
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (ebp instanceof EmbeddedProcess && !(((EmbeddedProcess)ebp).getTemplate() instanceof ChangeableTemplate)) {
            if (checkReport != null) {
                String message = "The given EBP is an embedded template but the template to be embedded is not a ChangeableTemplate.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

