/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class ChangeOperationTools {
    private static final String MY_INSTANCE_NAME = "ChangeOperationTools";

    public static Node createSimpleNodeObject(SessionToken session) {
        ProcessModelFactory pmf;
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        return pmf.createNode(Integer.MIN_VALUE, "", "", "", null, false, null, null, null, null, null, null);
    }

    public static Edge createSimpleEdgeObject(SessionToken session, ProcessConstants.EdgeType type) {
        ProcessModelFactory pmf;
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        return pmf.createEdge(type, Integer.MIN_VALUE, null);
    }

    public static ConstraintEdge createConstraintEdgeObject(SessionToken session) {
        ProcessModelFactory pmf;
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        return pmf.createConstraintEdge(null, null, null);
    }

    public static DataElement createSimpleDataElementObject(SessionToken session, String name, ProcessConstants.AdeptDataType type) {
        ProcessModelFactory pmf;
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        return pmf.createDataElement(Integer.MIN_VALUE, name, type, "", null, null, ProcessConstants.IDENTIFIER_NOT_SET, false, false, null, null, null);
    }

    public static DataEdge createSimpleDataEdgeObject(SessionToken session, ActivityConstants.AccessType type) {
        ProcessModelFactory pmf;
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        return pmf.createDataEdge(type, false, null);
    }

    public static ProcessModelParameter createSimpleProcessParameterObject(SessionToken session, String name, ProcessConstants.AdeptDataType type, String userDefinedType, boolean isVirtual, UUID identifierID, boolean isInputParameter) {
        ProcessModelFactory pmf;
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        String description = isInputParameter ? "Process input parameter to supply data element '" : "Process output parameter to supply data element '";
        description = String.valueOf(description) + name;
        description = String.valueOf(description) + "'";
        return pmf.createProcessModelParameter(name, description, type, userDefinedType, identifierID, false, isVirtual, false, null, null, null, null);
    }

    public static UpdateManager.NodeProperties[] getCorrespondingNodeProperties(ProcessConstants.NodeProperty ... nodeProperties) {
        LinkedList<UpdateManager.NodeProperties> ret = new LinkedList<UpdateManager.NodeProperties>();
        ProcessConstants.NodeProperty[] nodePropertyArray = nodeProperties;
        int n = nodeProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.NodeProperty np = nodePropertyArray[n2];
            switch (np) {
                case NAME: {
                    ret.add(UpdateManager.NodeProperties.NODE_NAME);
                    break;
                }
                case DESCRIPTION: {
                    ret.add(UpdateManager.NodeProperties.NODE_DESCRIPTION);
                    break;
                }
                case EXECUTABLE_BUSINESS_PROCESS: {
                    ret.add(UpdateManager.NodeProperties.NODE_EXECUTABLE_BUSINES_PROCESS);
                    break;
                }
                case AUTO_START: {
                    ret.add(UpdateManager.NodeProperties.NODE_AUTO_START);
                    break;
                }
                case STAFF_ASSIGNMENT_RULE: {
                    ret.add(UpdateManager.NodeProperties.NODE_STAFF_ASSIGNMENT_RULE);
                    break;
                }
                case SYSTEM_READ_PARAMS: {
                    ret.add(UpdateManager.NodeProperties.NODE_SYSTEM_READ_PARAMS);
                    break;
                }
                case SYSTEM_WRITE_PARAMS: {
                    ret.add(UpdateManager.NodeProperties.NODE_SYSTEM_WRITE_PARAMS);
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("No corresponding NodeProperties defined for %s - please update this method.", np.name()));
                }
            }
            ++n2;
        }
        return ret.toArray(new UpdateManager.NodeProperties[ret.size()]);
    }

    public static UpdateManager.DataElementProperties[] getCorrespondingDataElementProperties(ProcessConstants.DataElementProperty ... dataElementProperties) {
        LinkedList<UpdateManager.DataElementProperties> ret = new LinkedList<UpdateManager.DataElementProperties>();
        ProcessConstants.DataElementProperty[] dataElementPropertyArray = dataElementProperties;
        int n = dataElementProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.DataElementProperty dp = dataElementPropertyArray[n2];
            switch (dp) {
                case NAME: {
                    ret.add(UpdateManager.DataElementProperties.DE_NAME);
                    break;
                }
                case DESCRIPTION: {
                    ret.add(UpdateManager.DataElementProperties.DE_DESCRIPTION);
                    break;
                }
                case VIRTUAL: {
                    ret.add(UpdateManager.DataElementProperties.DE_VIRTUAL);
                    break;
                }
                case USER_ATTRIBUTE: {
                    ret.add(UpdateManager.DataElementProperties.DE_USER_ATTRIB);
                    break;
                }
                case TYPE: {
                    ret.add(UpdateManager.DataElementProperties.DE_TYPE);
                    break;
                }
                case USER_DEFINED_TYPE: {
                    ret.add(UpdateManager.DataElementProperties.DE_USER_TYPE);
                    break;
                }
                case IDENTIFIER: {
                    ret.add(UpdateManager.DataElementProperties.DE_IDENTIFIER);
                    break;
                }
                case PUBLIC: {
                    ret.add(UpdateManager.DataElementProperties.DE_PUBLIC);
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("No corresponding NodeProperties defined for %s - please update this method.", dp.name()));
                }
            }
            ++n2;
        }
        return ret.toArray(new UpdateManager.DataElementProperties[ret.size()]);
    }

    public static UpdateManager.ActivityProperties[] getCorrespondingActivityProperties(ProcessConstants.ExecutableBusinessProcessProperty ... ebpProperties) {
        LinkedList<UpdateManager.ActivityProperties> ret = new LinkedList<UpdateManager.ActivityProperties>();
        ProcessConstants.ExecutableBusinessProcessProperty[] executableBusinessProcessPropertyArray = ebpProperties;
        int n = ebpProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.ExecutableBusinessProcessProperty ebpp = executableBusinessProcessPropertyArray[n2];
            switch (ebpp) {
                case EXECUTABLE_COMPONENT_NAME: {
                    ret.add(UpdateManager.ActivityProperties.ACTIVITY_EXECUTABLE_COMPONENT);
                    break;
                }
                case CONFIGURATION: {
                    ret.add(UpdateManager.ActivityProperties.ACTIVITY_META_DATA);
                    break;
                }
                case CONFIGURATION_NAME: {
                    ret.add(UpdateManager.ActivityProperties.ACTIVITY_CONFIGURATION_NAME);
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("No corresponding ActivityProperties defined for %s - please update this method.", ebpp.name()));
                }
            }
            ++n2;
        }
        return ret.toArray(new UpdateManager.ActivityProperties[ret.size()]);
    }

    public static String getHumanReadableNodeName(Node node) {
        if (node.getName().equals("")) {
            return Integer.toString(node.getID());
        }
        return node.getName();
    }

    public static Map<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>> getParameterDataElementMappingForAlreadyAssignedEBP(Template template, int nodeID) {
        HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>> result = new HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>>();
        Node node = template.getNode(nodeID);
        Map<ProcessModelParameter, Integer> read = ChangeOperationTools.getParameterDataElementMappingForDirection(template, node, ActivityConstants.AccessType.READ);
        Map<ProcessModelParameter, Integer> write = ChangeOperationTools.getParameterDataElementMappingForDirection(template, node, ActivityConstants.AccessType.WRITE);
        result.put(ActivityConstants.AccessType.READ, read);
        result.put(ActivityConstants.AccessType.WRITE, write);
        return result;
    }

    private static Map<ProcessModelParameter, Integer> getParameterDataElementMappingForDirection(Template template, Node node, ActivityConstants.AccessType type) {
        LinkedList<ProcessModelParameter> parameter = new LinkedList<ProcessModelParameter>();
        parameter.addAll(node.getExecutableBusinessProcess().getParameters(type));
        HashMap<ProcessModelParameter, Integer> mappedParameters = new HashMap<ProcessModelParameter, Integer>();
        for (ProcessModelParameter param : parameter) {
            int connectorID = node.getConnector(param.getName(), type);
            DataElement dataElement = template.getDataElement(node.getID(), connectorID);
            if (dataElement == null) continue;
            mappedParameters.put(param, dataElement.getID());
        }
        return mappedParameters;
    }

    public static Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> getParameterSystemValueMappingForAlreadyAssignedEBP(Template template, int nodeID) {
        HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> result = new HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>>();
        Node node = template.getNode(nodeID);
        Map<ProcessModelParameter, ProcessConstants.DataMappingType> read = ChangeOperationTools.getParameterSystemValueMappingForDirection(template, node, ActivityConstants.AccessType.READ);
        Map<ProcessModelParameter, ProcessConstants.DataMappingType> write = ChangeOperationTools.getParameterSystemValueMappingForDirection(template, node, ActivityConstants.AccessType.WRITE);
        result.put(ActivityConstants.AccessType.READ, read);
        result.put(ActivityConstants.AccessType.WRITE, write);
        return result;
    }

    private static Map<ProcessModelParameter, ProcessConstants.DataMappingType> getParameterSystemValueMappingForDirection(Template template, Node node, ActivityConstants.AccessType type) {
        LinkedList<ProcessModelParameter> parameter = new LinkedList<ProcessModelParameter>();
        parameter.addAll(node.getExecutableBusinessProcess().getParameters(type));
        HashMap<ProcessModelParameter, ProcessConstants.DataMappingType> mappedParameters = new HashMap<ProcessModelParameter, ProcessConstants.DataMappingType>();
        for (ProcessModelParameter param : parameter) {
            int connectorID = node.getConnector(param.getName(), type);
            DataElement dataElement = template.getDataElement(node.getID(), connectorID);
            if (dataElement != null) continue;
            ProcessConstants.DataMappingType mappingType = ProcessConstants.DataMappingType.CONNECT_LATER;
            int[] nArray = template.getDisabledConnectors(node.getID(), type);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int disabledCon = nArray[n2];
                if (disabledCon == connectorID) {
                    mappingType = ProcessConstants.DataMappingType.DISABLE;
                    break;
                }
                ++n2;
            }
            mappedParameters.put(param, mappingType);
        }
        return mappedParameters;
    }

    public static Map<ActivityConstants.AccessType, Map<ProcessModelParameter, DataElement>> createRandomisedParameterDataElementMappingForNewEBP(Template template, int nodeID, ExecutableBusinessProcess ebp) {
        HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, DataElement>> result = new HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, DataElement>>();
        Set<ProcessModelParameter> inputParameter = ebp.getParameters(ActivityConstants.AccessType.READ);
        Set<ProcessModelParameter> outputParameter = ebp.getParameters(ActivityConstants.AccessType.WRITE);
        int[] connectedReadDataElementIDs = template.getAccessedDataElementIDsForNode(nodeID, ActivityConstants.AccessType.READ);
        HashSet<DataElement> connectedReadDataElements = new HashSet<DataElement>();
        int[] nArray = connectedReadDataElementIDs;
        int n = connectedReadDataElementIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            connectedReadDataElements.add(template.getDataElement(id));
            ++n2;
        }
        int[] connectedWrittenDataElementsIDs = template.getAccessedDataElementIDsForNode(nodeID, ActivityConstants.AccessType.WRITE);
        HashSet<DataElement> connectedWrittenDataElements = new HashSet<DataElement>();
        int[] nArray2 = connectedWrittenDataElementsIDs;
        int n3 = connectedWrittenDataElementsIDs.length;
        int n4 = 0;
        while (n4 < n3) {
            int id = nArray2[n4];
            connectedWrittenDataElements.add(template.getDataElement(id));
            ++n4;
        }
        HashSet<DataElement> unConnectedDataElements = new HashSet<DataElement>();
        for (DataElement data : template.getDataElements()) {
            if (connectedReadDataElements.contains(data) || connectedWrittenDataElements.contains(data)) continue;
            unConnectedDataElements.add(data);
        }
        LinkedList<ProcessModelParameter> inputParamList = new LinkedList<ProcessModelParameter>(inputParameter);
        Collections.shuffle(inputParamList);
        Map<ProcessModelParameter, DataElement> mappedReadConnectedDataElements = ChangeOperationTools.mapDataElements(connectedReadDataElements, inputParamList);
        LinkedList<ProcessModelParameter> outputParamList = new LinkedList<ProcessModelParameter>(outputParameter);
        Collections.shuffle(new LinkedList<ProcessModelParameter>(outputParameter));
        Map<ProcessModelParameter, DataElement> mappedWrittenConnectedDataElements = ChangeOperationTools.mapDataElements(connectedWrittenDataElements, outputParamList);
        unConnectedDataElements.addAll(connectedReadDataElements);
        unConnectedDataElements.addAll(connectedWrittenDataElements);
        Map<ProcessModelParameter, DataElement> mappedReadUnConnectedDataElements = ChangeOperationTools.mapDataElements(unConnectedDataElements, inputParamList);
        Map<ProcessModelParameter, DataElement> mappedWrittenUnConnectedDataElements = ChangeOperationTools.mapDataElements(unConnectedDataElements, outputParamList);
        mappedReadConnectedDataElements.putAll(mappedReadUnConnectedDataElements);
        mappedWrittenConnectedDataElements.putAll(mappedWrittenUnConnectedDataElements);
        result.put(ActivityConstants.AccessType.READ, mappedReadConnectedDataElements);
        result.put(ActivityConstants.AccessType.WRITE, mappedWrittenConnectedDataElements);
        return result;
    }

    private static Map<ProcessModelParameter, DataElement> mapDataElements(Set<DataElement> dataElements, Collection<ProcessModelParameter> paramList) {
        HashMap<ProcessModelParameter, DataElement> mappedDataElements = new HashMap<ProcessModelParameter, DataElement>();
        Iterator<ProcessModelParameter> paramListIterator = paramList.iterator();
        while (paramListIterator.hasNext()) {
            ProcessModelParameter parameter = paramListIterator.next();
            Iterator<DataElement> dataElementIterator = dataElements.iterator();
            boolean mapped = false;
            while (dataElementIterator.hasNext()) {
                DataElement data = dataElementIterator.next();
                if (parameter.getDataType() != data.getDataType() || parameter.isVirtual() != data.isVirtual() || !parameter.getIdentifierID().equals(data.getIdentifierID()) && !data.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) && !data.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET) || parameter.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED && !parameter.getUDTName().equals(data.getUDTName())) continue;
                mappedDataElements.put(parameter, data);
                dataElementIterator.remove();
                mapped = true;
                break;
            }
            if (!mapped) continue;
            paramListIterator.remove();
        }
        return mappedDataElements;
    }

    public static Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> createParameterSystemValueMappingForNewEBP(ExecutableBusinessProcess ebp, Map<ActivityConstants.AccessType, List<ProcessModelParameter>> alreadyMappedParameters, ProcessConstants.DataMappingType initType) {
        HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> result = new HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>>();
        List<ProcessModelParameter> alreadyMappedInputParams = alreadyMappedParameters.get((Object)ActivityConstants.AccessType.READ);
        Map<ProcessModelParameter, ProcessConstants.DataMappingType> read = ChangeOperationTools.createParameterSystemValueMappingForDirection(ebp, ActivityConstants.AccessType.READ, alreadyMappedInputParams, initType);
        List<ProcessModelParameter> alreadyMappedOutputParams = alreadyMappedParameters.get((Object)ActivityConstants.AccessType.WRITE);
        Map<ProcessModelParameter, ProcessConstants.DataMappingType> write = ChangeOperationTools.createParameterSystemValueMappingForDirection(ebp, ActivityConstants.AccessType.WRITE, alreadyMappedOutputParams, initType);
        result.put(ActivityConstants.AccessType.READ, read);
        result.put(ActivityConstants.AccessType.WRITE, write);
        return result;
    }

    private static Map<ProcessModelParameter, ProcessConstants.DataMappingType> createParameterSystemValueMappingForDirection(ExecutableBusinessProcess ebp, ActivityConstants.AccessType type, List<ProcessModelParameter> alreadyMappedParameter, ProcessConstants.DataMappingType initType) {
        LinkedList<ProcessModelParameter> parameter = new LinkedList<ProcessModelParameter>();
        parameter.addAll(ebp.getParameters(type));
        parameter.removeAll(alreadyMappedParameter);
        HashMap<ProcessModelParameter, ProcessConstants.DataMappingType> mappedParameters = new HashMap<ProcessModelParameter, ProcessConstants.DataMappingType>();
        for (ProcessModelParameter param : parameter) {
            mappedParameters.put(param, initType);
        }
        return mappedParameters;
    }

    public static Set<DataElement> getCompliantConnectedDataElementsForParameter(ProcessModelParameter parameter, Template template, int nodeID, ActivityConstants.AccessType type) {
        int[] connectedDataElementIDs;
        HashSet<DataElement> compliantConnectedDataElements = new HashSet<DataElement>();
        int[] nArray = connectedDataElementIDs = template.getAccessedDataElementIDsForNode(nodeID, type);
        int n = connectedDataElementIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            DataElement data = template.getDataElement(id);
            if (parameter.getDataType() == data.getDataType() && parameter.isVirtual() == data.isVirtual() && (parameter.getIdentifierID().equals(data.getIdentifierID()) || data.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) || data.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET)) && (parameter.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED || parameter.getUDTName().equals(data.getUDTName()))) {
                compliantConnectedDataElements.add(data);
            }
            ++n2;
        }
        return Collections.unmodifiableSet(compliantConnectedDataElements);
    }

    public static Set<DataElement> getCompliantUnConnectedDataElementsForParameter(ProcessModelParameter parameter, Template template, int nodeID, ActivityConstants.AccessType type) {
        Set<DataElement> dataElements = template.getDataElements();
        HashSet<DataElement> compliantUnConnectedDataElements = new HashSet<DataElement>();
        for (DataElement data : dataElements) {
            if (template.getDataEdge(nodeID, data.getID(), type) != null || parameter.getDataType() != data.getDataType() || parameter.isVirtual() != data.isVirtual() || !parameter.getIdentifierID().equals(data.getIdentifierID()) && !data.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) && !data.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET) || parameter.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED && !parameter.getUDTName().equals(data.getUDTName())) continue;
            compliantUnConnectedDataElements.add(data);
        }
        return Collections.unmodifiableSet(compliantUnConnectedDataElements);
    }

    public static boolean ebpEqualsAssignedEbp(Node node, ExecutableBusinessProcess ebp) {
        boolean ebpEquals = false;
        ExecutableBusinessProcess nodeEBP = node.getExecutableBusinessProcess();
        if (nodeEBP != null) {
            if (nodeEBP instanceof Activity && ebp instanceof Activity) {
                if (((Activity)nodeEBP).getID().equals(((Activity)ebp).getID())) {
                    ebpEquals = true;
                }
            } else if (nodeEBP instanceof ReferencedProcess && ebp instanceof ReferencedProcess) {
                if (((ReferencedProcess)nodeEBP).getTemplateID().equals(((ReferencedProcess)ebp).getTemplateID())) {
                    ebpEquals = true;
                }
            } else if (nodeEBP instanceof EmbeddedProcess && ebp instanceof EmbeddedProcess && ((EmbeddedProcess)nodeEBP).getTemplateID().equals(((EmbeddedProcess)ebp).getTemplateID())) {
                ebpEquals = true;
            }
        }
        return ebpEquals;
    }

    public static void fireNodeStateChangedEvent(UpdateManager updateManager, Instance instance, Node node) {
        int[] writtenDataElements;
        int succ;
        int pred;
        updateManager.firePropertyChange(node, (Object)UpdateManager.NodeProperties.NODE_STATE);
        int nodeID = node.getID();
        Template template = instance.getTemplate();
        int[] nArray = template.getPredByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            pred = nArray[n2];
            updateManager.firePropertyChange(template.getEdge(pred, nodeID, ProcessConstants.EdgeType.ET_CONTROL), (Object)UpdateManager.EdgeProperties.EDGE_STATE);
            ++n2;
        }
        nArray = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_CONTROL);
        n = nArray.length;
        n2 = 0;
        while (n2 < n) {
            succ = nArray[n2];
            updateManager.firePropertyChange(template.getEdge(nodeID, succ, ProcessConstants.EdgeType.ET_CONTROL), (Object)UpdateManager.EdgeProperties.EDGE_STATE);
            ++n2;
        }
        nArray = template.getPredByEdgeType(nodeID, ProcessConstants.EdgeType.ET_SYNC);
        n = nArray.length;
        n2 = 0;
        while (n2 < n) {
            pred = nArray[n2];
            updateManager.firePropertyChange(template.getEdge(pred, nodeID, ProcessConstants.EdgeType.ET_SYNC), (Object)UpdateManager.EdgeProperties.EDGE_STATE);
            ++n2;
        }
        nArray = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_SYNC);
        n = nArray.length;
        n2 = 0;
        while (n2 < n) {
            succ = nArray[n2];
            updateManager.firePropertyChange(template.getEdge(nodeID, succ, ProcessConstants.EdgeType.ET_SYNC), (Object)UpdateManager.EdgeProperties.EDGE_STATE);
            ++n2;
        }
        int[] nArray2 = writtenDataElements = template.getAccessedDataElementIDsForNode(nodeID, ActivityConstants.AccessType.WRITE);
        int n3 = writtenDataElements.length;
        n = 0;
        while (n < n3) {
            int dataElementID = nArray2[n];
            updateManager.firePropertyChange(template.getDataElement(dataElementID), (Object)UpdateManager.DataElementProperties.DE_NAME);
            ++n;
        }
    }

    public static Set<DataElement> getCompliantDataElements(Template template, ProcessConstants.AdeptDataType type, UUID identifierID, boolean includingSystemDataElements) {
        HashSet<DataElement> elements = new HashSet<DataElement>();
        for (DataElement dataElement : template.getDataElements()) {
            if (type != dataElement.getDataType() || identifierID != null && !identifierID.equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) && !dataElement.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET) && !identifierID.equals(dataElement.getIdentifierID()) || !includingSystemDataElements && (template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.SYSTEM_READ).length != 0 || template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.SYSTEM_WRITE).length != 0) && template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.READ).length == 0 && template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.WRITE).length == 0) continue;
            elements.add(dataElement);
        }
        return elements;
    }

    public static Set<Node> getSavePredecessors(Template template, int nodeID) {
        NodeRelations relations = new NodeRelations(template);
        HashSet<Node> elements = new HashSet<Node>();
        for (Node node : template.getNodes()) {
            NodeRelations.NodeRelation relation;
            if (node.getID() == nodeID || (relation = relations.getNodeRelation(node.getID(), nodeID)) != NodeRelations.NodeRelation.ONE_BEFORE_TWO && relation != NodeRelations.NodeRelation.ONE_BEFORE_TWO_OPTIONAL || ProcessModelTools.isNullNode(template.getNodeType(node.getID()))) continue;
            elements.add(node);
        }
        return elements;
    }
}

