/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.activitymodel.ATParameter;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplate;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.DecisionStatement;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Logger;

public class ConvertActivityTemplateToActivity {
    protected static final Logger logger = LoggerTools.getLogger(ConvertActivityTemplateToActivity.class);

    public static Activity performConversion(ProcessModelFactory pmf, SessionToken session, ActivityTemplate at, String instanceName) {
        boolean decision = Boolean.parseBoolean(at.getUserAttributeValue("decision"));
        HashSet<ProcessModelParameter> inputParams = new HashSet<ProcessModelParameter>();
        HashSet<ProcessModelParameter> outputParams = new HashSet<ProcessModelParameter>();
        ConvertActivityTemplateToActivity.convertTemplateParameters(pmf, at, inputParams, outputParams);
        Activity activity = pmf.createActivity(at.getID(), at.getExecutableComponentName(), at.getOperationName(), at.getConfigurationName(), at.getActivityName(), at.getDescription(), at.getImplementationClass(), at.getSeparatedClassPaths(), at.isSingleton(), at.getSystemComponent(), at.getGUIContextID(), at.getExecutionControlProperties(), at.supportsViewOnly(), at.supportsTestExecution(), at.getIconID(), at.getAttributeOrigins(), at.getConfiguration(), at.getTestConfiguration(), at.getParameterChangePolicy(), inputParams, outputParams, at, at.getUserAttributes());
        if (decision) {
            if (outputParams.size() != 1) {
                String message = "Decision activity templates must have exactly one output parameter of type integer.";
                logger.severe(message);
                throw new RuntimeException(message);
            }
            ProcessModelParameter decisionParameter = (ProcessModelParameter)outputParams.iterator().next();
            HashMap<Long, Collection<DecisionStatement>> decisionMapping = new HashMap<Long, Collection<DecisionStatement>>();
            activity = pmf.createDecisionActivity(activity, decisionParameter, decisionMapping);
        }
        return activity;
    }

    public static void convertTemplateParameters(ProcessModelFactory pmf, ActivityTemplate activityTemplate, Collection<ProcessModelParameter> inParameters, Collection<ProcessModelParameter> outParameters) {
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.activityRelatedValues();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.AccessType accessType = accessTypeArray[n2];
            for (ATParameter param : activityTemplate.getParameters(accessType)) {
                HashMap<String, String> userAttributes = new HashMap<String, String>(param.getUserAttributes());
                userAttributes.put("fromParameter", param.getName());
                ProcessModelParameter parameter = pmf.createProcessModelParameter(param.getName(), param.getDescription(), param.getDataType(), param.getUDTName(), param.getIdentifierID(), param.isOptional(), param.isVirtual(), param.isFailure(), param.getDefaultValue(), param.getConfiguration(), param, userAttributes);
                switch (accessType) {
                    case READ: {
                        inParameters.add(parameter);
                        break;
                    }
                    case WRITE: {
                        outParameters.add(parameter);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"An unknown access type was found!");
                    }
                }
            }
            ++n2;
        }
    }
}

