/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.InsertNode;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.LinkedList;
import java.util.logging.Logger;

public class CreateSurroundingBlock {
    protected static final Logger logger = LoggerTools.getLogger(CreateSurroundingBlock.class);
    private static final String MY_INSTANCE_NAME = "CreateSurroundingBlock";
    private static final String CHECK_ID = "Create Surrounding Block. Type: ";

    public static boolean isPossible(Template template, Node first, Node last, ProcessConstants.BlockType type) {
        return CreateSurroundingBlock.isPossible(template, first, last, type, null);
    }

    public static boolean isPossible(Template template, Node first, Node last, ProcessConstants.BlockType type, CheckReport checkReport) {
        int[] nodesWithSyncEdges;
        String check_ID = CHECK_ID + type.toString();
        if (!CreateSurroundingBlock.enoughParameter(first, last, template, checkReport)) {
            return false;
        }
        if (template.getNodeType(first.getID()).equals((Object)ProcessConstants.NodeType.NT_STARTFLOW) || template.getNodeType(last.getID()).equals((Object)ProcessConstants.NodeType.NT_ENDFLOW) || template.getNodeType(first.getID()).equals((Object)ProcessConstants.NodeType.NT_ENDFLOW) || template.getNodeType(last.getID()).equals((Object)ProcessConstants.NodeType.NT_STARTFLOW)) {
            if (checkReport != null) {
                String message = "One (or both) of the selected nodes '" + ChangeOperationTools.getHumanReadableNodeName(first) + "', '" + ChangeOperationTools.getHumanReadableNodeName(last) + "' do have a type which are not allowed to be surrounded by a block (start node, end node).";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first, "NodeType"), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), last, "NodeType")};
                checkReport.addReportEntry(check_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        if (first.getID() != last.getID()) {
            if (!template.isTransPredOf(last.getID(), first.getID(), ProcessConstants.EdgeType.ET_CONTROL)) {
                if (checkReport != null) {
                    String message = "The selected start element '" + ChangeOperationTools.getHumanReadableNodeName(first) + "' must be a predecessor of the selected end element '" + ChangeOperationTools.getHumanReadableNodeName(last) + "', but this is not the case here.";
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), last)};
                    checkReport.addReportEntry(check_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                return false;
            }
            if (template.getNodeBranchID(first.getID()) != template.getNodeBranchID(last.getID())) {
                if (checkReport != null) {
                    String message = "The selected nodes '" + ChangeOperationTools.getHumanReadableNodeName(first) + "', '" + ChangeOperationTools.getHumanReadableNodeName(last) + "' have to be on the same branch, but they aren't.";
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first, "branchID"), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), last, "branchID")};
                    checkReport.addReportEntry(check_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                return false;
            }
        }
        if (template.getNodeType(first.getID()).equals((Object)ProcessConstants.NodeType.NT_AND_JOIN) || template.getNodeType(first.getID()).equals((Object)ProcessConstants.NodeType.NT_XOR_JOIN) || template.getNodeType(first.getID()).equals((Object)ProcessConstants.NodeType.NT_ENDLOOP) || template.getNodeType(last.getID()).equals((Object)ProcessConstants.NodeType.NT_AND_SPLIT) || template.getNodeType(last.getID()).equals((Object)ProcessConstants.NodeType.NT_XOR_SPLIT) || template.getNodeType(last.getID()).equals((Object)ProcessConstants.NodeType.NT_STARTLOOP)) {
            if (checkReport != null) {
                String message = "One (or both) of the selected nodes '" + ChangeOperationTools.getHumanReadableNodeName(first) + "', '" + ChangeOperationTools.getHumanReadableNodeName(last) + "' do have a type which are not allowed to be surrounded by a block; Surrounding the given nodes would lead to a violation of the block structure";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first, "NodeType"), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), last, "NodeType")};
                checkReport.addReportEntry(check_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        if (type.equals((Object)ProcessConstants.BlockType.LOOP_BLOCK) && (nodesWithSyncEdges = ProcessModelTools.nodesWithSyncEdgesInArea(template, first.getID(), last.getID(), false)).length != 0) {
            if (checkReport != null) {
                String message = "Surrounding the given nodes '" + ChangeOperationTools.getHumanReadableNodeName(first) + "', '" + ChangeOperationTools.getHumanReadableNodeName(last) + " would lead to a violation of the ADEPT meta model. The new block would have sync edges which are crossing the boundaries of the block.";
                LinkedList<URI> affectedElements = new LinkedList<URI>();
                affectedElements.add(ProcessElementIdentifierTools.getBlockIdentifier(checkReport.getBase(), first, last));
                int[] nArray = nodesWithSyncEdges;
                int n = nodesWithSyncEdges.length;
                int n2 = 0;
                while (n2 < n) {
                    int nodeID = nArray[n2];
                    int[] nArray2 = template.getSuccByEdgeType(nodeID, ProcessConstants.EdgeType.ET_SYNC);
                    int n3 = nArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int succID = nArray2[n4];
                        affectedElements.add(ProcessElementIdentifierTools.getEdgeIdentifier(checkReport.getBase(), template.getNode(nodeID), template.getNode(succID), ProcessConstants.EdgeType.ET_SYNC));
                        ++n4;
                    }
                    ++n2;
                }
                checkReport.addReportEntry(check_ID, CheckReport.ResultType.FAILURE, message, affectedElements.toArray(new URI[affectedElements.size()]));
            }
            return false;
        }
        return true;
    }

    public static boolean isPossible(ChangeableInstance instance, Node first, Node last, ProcessConstants.BlockType type) {
        return CreateSurroundingBlock.isPossible(instance, first, last, type, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node first, Node last, ProcessConstants.BlockType type, CheckReport checkReport) {
        Template template;
        if (!CreateSurroundingBlock.enoughParameter(first, last, instance.getTemplate(), checkReport)) {
            return false;
        }
        if (type == ProcessConstants.BlockType.AND_BLOCK || type == ProcessConstants.BlockType.LOOP_BLOCK) {
            int[] succs;
            template = instance.getTemplate();
            int[] nArray = succs = template.getSuccByEdgeType(last.getID(), ProcessConstants.EdgeType.ET_CONTROL);
            int n = succs.length;
            int n2 = 0;
            while (n2 < n) {
                int succ = nArray[n2];
                if (instance.getNodeState(succ) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(succ) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
                    if (checkReport != null) {
                        Node succNode = template.getNode(succ);
                        String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(succNode) + "' which is the successor of the last node of the block which should be surrounded must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(succ).toString() + ".";
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succNode, "NodeState"));
                    }
                    return false;
                }
                ++n2;
            }
        } else if (instance.getNodeState(first.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(first.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(first) + "' given as first node of the block which should be surrounded must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(first.getID()).toString() + ".";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first, "NodeState"));
            }
            return false;
        }
        template = instance.getTemplate();
        return CreateSurroundingBlock.isPossible(template, first, last, type, checkReport);
    }

    public static Node[] performOperation(SessionToken session, ChangeableTemplate template, Node first, Node last, ProcessConstants.BlockType type) {
        return CreateSurroundingBlock.performOperation(session, template, first, last, type, null);
    }

    public static Node[] performOperation(SessionToken session, ChangeableTemplate template, Node first, Node last, ProcessConstants.BlockType type, UpdateManager updateManager) {
        return CreateSurroundingBlock.performOperation(session, (ChangePrimitives)template, first, last, type, updateManager);
    }

    public static Node[] performOperation(SessionToken session, ChangeableInstance instance, Node first, Node last, ProcessConstants.BlockType type) {
        return CreateSurroundingBlock.performOperation(session, instance, first, last, type, null);
    }

    public static Node[] performOperation(SessionToken session, ChangeableInstance instance, Node first, Node last, ProcessConstants.BlockType type, UpdateManager updateManager) {
        Node[] newNodes = CreateSurroundingBlock.performOperation(session, (ChangePrimitives)instance, first, last, type, updateManager);
        if (instance.getNodeState(first.getID()) == ProcessConstants.NodeState.NS_ACTIVATED) {
            instance.setNodeState(first.getID(), ProcessConstants.NodeState.NS_NOT_ACTIVATED);
            if (updateManager != null) {
                ChangeOperationTools.fireNodeStateChangedEvent(updateManager, instance, first);
            }
        }
        if ((type == ProcessConstants.BlockType.AND_BLOCK || type == ProcessConstants.BlockType.LOOP_BLOCK) && instance.getNodeState(first.getID()) == ProcessConstants.NodeState.NS_COMPLETED) {
            instance.setNodeState(newNodes[0].getID(), ProcessConstants.NodeState.NS_COMPLETED);
            if (updateManager != null) {
                ChangeOperationTools.fireNodeStateChangedEvent(updateManager, instance, newNodes[0]);
            }
        }
        return newNodes;
    }

    protected static Node[] performOperation(SessionToken session, ChangePrimitives processGraph, Node first, Node last, ProcessConstants.BlockType type, UpdateManager updateManager) {
        Node newNode2;
        Node newNode1;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        int[] preds = template.getPredByEdgeType(first.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        int[] succs = template.getSuccByEdgeType(last.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        assert (preds.length == 1);
        assert (succs.length == 1);
        logger.info("calling protected ChangeOperation insertNode 2x");
        switch (type) {
            case AND_BLOCK: {
                newNode1 = InsertNode.performOperation(session, processGraph, template.getNode(preds[0]), first, ProcessConstants.NodeType.NT_AND_SPLIT, null);
                newNode2 = InsertNode.performOperation(session, processGraph, last, template.getNode(succs[0]), ProcessConstants.NodeType.NT_AND_JOIN, null);
                break;
            }
            case OR_BLOCK: {
                newNode1 = InsertNode.performOperation(session, processGraph, template.getNode(preds[0]), first, ProcessConstants.NodeType.NT_XOR_SPLIT, null);
                newNode2 = InsertNode.performOperation(session, processGraph, last, template.getNode(succs[0]), ProcessConstants.NodeType.NT_XOR_JOIN, null);
                break;
            }
            case LOOP_BLOCK: {
                ProcessModelFactory pmf;
                newNode1 = InsertNode.performOperation(session, processGraph, template.getNode(preds[0]), first, ProcessConstants.NodeType.NT_STARTLOOP, null);
                newNode2 = InsertNode.performOperation(session, processGraph, last, template.getNode(succs[0]), ProcessConstants.NodeType.NT_ENDLOOP, null);
                try {
                    pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
                }
                catch (ServiceNotKnownException snke) {
                    throw new RTServiceNotKnownException(snke);
                }
                Edge loopEdge = pmf.createEdge(ProcessConstants.EdgeType.ET_LOOP, 1L, null);
                logger.info("Calling add Edge");
                processGraph.addEdge(newNode2.getID(), newNode1.getID(), loopEdge);
                break;
            }
            default: {
                throw new RuntimeException("Programming error (Invalid block type)");
            }
        }
        logger.info("Calling set corresponding block node");
        processGraph.setCorrespondingBlockNode(newNode1.getID(), newNode2.getID());
        processGraph.setSplitNodeID(newNode2.getID(), newNode2.getID(), template.getNodeSplitNodeID(newNode1.getID()));
        processGraph.setBranchID(newNode2.getID(), newNode2.getID(), false, template.getNodeBranchID(newNode1.getID()));
        processGraph.setSplitNodeID(first.getID(), last.getID(), newNode1.getID());
        processGraph.setBranchID(first.getID(), last.getID(), true, Integer.MIN_VALUE);
        if (updateManager != null) {
            updateManager.firePropertyChange(template.getNode(preds[0]), (Object)UpdateManager.NodeProperties.NODE_OUT_EDGES);
            updateManager.firePropertyChange(first, (Object)UpdateManager.NodeProperties.NODE_IN_EDGES);
            updateManager.firePropertyChange(template.getNode(succs[0]), (Object)UpdateManager.NodeProperties.NODE_IN_EDGES);
            updateManager.firePropertyChange(last, (Object)UpdateManager.NodeProperties.NODE_OUT_EDGES);
        }
        return new Node[]{newNode1, newNode2};
    }

    private static boolean enoughParameter(Node first, Node last, Template template, CheckReport checkReport) {
        if (first == null || last == null) {
            if (checkReport != null) {
                String message = "Not enough selected nodes for this operation. A node before which the split node and a node after which the corresponding join node should be inserted are necessary.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(first.getID()) == null || template.getNode(last.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain one or both of the given nodes: " + ChangeOperationTools.getHumanReadableNodeName(first) + "," + ChangeOperationTools.getHumanReadableNodeName(last);
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

