/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.DeleteNode;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Logger;

public class DeleteBorderNodes {
    protected static final Logger logger = LoggerTools.getLogger(DeleteBorderNodes.class);
    private static final String CHECK_ID = "Delete Border Nodes";
    private static /* synthetic */ int[] $SWITCH_TABLE$de$aristaflow$adept2$model$globals$ActivityConstants$AccessType;

    public static boolean isPossible(Template template, Node split, Node join) {
        return DeleteBorderNodes.isPossible(template, split, join, null);
    }

    public static boolean isPossible(Template template, Node split, Node join, CheckReport checkReport) {
        if (!DeleteBorderNodes.enoughParameter(split, join, template, checkReport)) {
            return false;
        }
        if (!(template.getNodeType(split.getID()).equals((Object)ProcessConstants.NodeType.NT_AND_SPLIT) || template.getNodeType(split.getID()).equals((Object)ProcessConstants.NodeType.NT_XOR_SPLIT) || template.getNodeType(split.getID()).equals((Object)ProcessConstants.NodeType.NT_STARTLOOP))) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(split) + "' given as split/loop start is not of type split/loop start.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), split, "NodeType"));
            }
            return false;
        }
        if (!(template.getNodeType(join.getID()).equals((Object)ProcessConstants.NodeType.NT_AND_JOIN) || template.getNodeType(join.getID()).equals((Object)ProcessConstants.NodeType.NT_XOR_JOIN) || template.getNodeType(join.getID()).equals((Object)ProcessConstants.NodeType.NT_ENDLOOP))) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(join) + "' given as join/loop end is not of type join/loop end.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), join, "NodeType"));
            }
            return false;
        }
        if (template.getNodeCorrespondingBlockNodeID(split.getID()) != join.getID()) {
            if (checkReport != null) {
                String message = "The given split node: '" + ChangeOperationTools.getHumanReadableNodeName(split) + "' and the given join node: '" + ChangeOperationTools.getHumanReadableNodeName(join) + "' are not corresponding to each other.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), split), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), join)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        if (template.getSuccByEdgeType(split.getID(), ProcessConstants.EdgeType.ET_CONTROL).length != 1) {
            if (checkReport != null) {
                String message = "There are more than one branch between the split node: '" + ChangeOperationTools.getHumanReadableNodeName(split) + "' and join node: '" + ChangeOperationTools.getHumanReadableNodeName(join) + "'. A deletion is not possible.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getBranchIdentifier(checkReport.getBase(), split, join));
            }
            return false;
        }
        return true;
    }

    public static boolean isPossible(ChangeableInstance instance, Node split, Node join) {
        return DeleteBorderNodes.isPossible(instance, split, join, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node split, Node join, CheckReport checkReport) {
        if (!DeleteBorderNodes.enoughParameter(split, join, instance.getTemplate(), checkReport)) {
            return false;
        }
        if (instance.getNodeState(join.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(join.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The join node '" + ChangeOperationTools.getHumanReadableNodeName(join) + "' must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(join.getID()).toString() + ".";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), join, "NodeState"));
            }
            return false;
        }
        Template template = instance.getTemplate();
        return DeleteBorderNodes.isPossible(template, split, join, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node split, Node join) {
        DeleteBorderNodes.performOperation(session, template, split, join, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node split, Node join, UpdateManager updateManager) {
        DeleteBorderNodes.performOperation(session, (ChangePrimitives)template, split, join, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node split, Node join) {
        DeleteBorderNodes.performOperation(session, instance, split, join, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node split, Node join, UpdateManager updateManager) {
        DeleteBorderNodes.performOperation(session, (ChangePrimitives)instance, split, join, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, Node split, Node join, UpdateManager updateManager) {
        int n;
        int n2;
        Object[] objectArray;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        int branchID = template.getNodeBranchID(split.getID());
        int splitNodeID = template.getNodeSplitNodeID(split.getID());
        int[] splitSucc = template.getSuccByEdgeType(split.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        int[] joinPred = template.getPredByEdgeType(join.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        boolean nodesExist = false;
        if (template.getEdge(split.getID(), join.getID(), ProcessConstants.EdgeType.ET_CONTROL) == null) {
            nodesExist = true;
        }
        int[] allPred1 = new int[]{};
        int[] allSucc1 = new int[]{};
        ArrayList<DataElementUpdate> dataElementChanges = new ArrayList<DataElementUpdate>();
        int[] allPred2 = new int[]{};
        int[] allSucc2 = new int[]{};
        if (updateManager != null) {
            allPred1 = template.getPredByEdgeType(split.getID(), ProcessConstants.EdgeType.ET_CONTROL, ProcessConstants.EdgeType.ET_SYNC);
            allSucc1 = template.getSuccByEdgeType(join.getID(), ProcessConstants.EdgeType.ET_CONTROL, ProcessConstants.EdgeType.ET_SYNC);
            ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
            objectArray = (Object[])accessTypeArray;
            n2 = accessTypeArray.length;
            n = 0;
            while (n < n2) {
                int accessedDataElement;
                UpdateManager.DataElementProperties prop;
                int accessType = objectArray[n];
                switch (DeleteBorderNodes.$SWITCH_TABLE$de$aristaflow$adept2$model$globals$ActivityConstants$AccessType()[accessType.ordinal()]) {
                    case 1: {
                        prop = UpdateManager.DataElementProperties.DE_READERS;
                        break;
                    }
                    case 2: {
                        prop = UpdateManager.DataElementProperties.DE_WRITERS;
                        break;
                    }
                    case 3: {
                        prop = UpdateManager.DataElementProperties.DE_SYSTEM_READERS;
                        break;
                    }
                    case 4: {
                        prop = UpdateManager.DataElementProperties.DE_SYSTEM_WRITERS;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"An unknown access type was found!");
                    }
                }
                int[] nArray = template.getAccessedDataElementIDsForNode(split.getID(), (ActivityConstants.AccessType)accessType);
                int n3 = nArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    accessedDataElement = nArray[n4];
                    dataElementChanges.add(new DataElementUpdate(template.getDataElement(accessedDataElement), prop));
                    ++n4;
                }
                nArray = template.getAccessedDataElementIDsForNode(join.getID(), (ActivityConstants.AccessType)accessType);
                n3 = nArray.length;
                n4 = 0;
                while (n4 < n3) {
                    accessedDataElement = nArray[n4];
                    dataElementChanges.add(new DataElementUpdate(template.getDataElement(accessedDataElement), prop));
                    ++n4;
                }
                ++n;
            }
            if (nodesExist) {
                allPred2 = template.getPredByEdgeType(join.getID(), ProcessConstants.EdgeType.ET_CONTROL, ProcessConstants.EdgeType.ET_SYNC);
                allSucc2 = template.getSuccByEdgeType(split.getID(), ProcessConstants.EdgeType.ET_CONTROL, ProcessConstants.EdgeType.ET_SYNC);
            }
        }
        logger.info("calling ChangeOperation DeleteNode");
        DeleteNode.performOperation(session, processGraph, split, template.getNodeType(split.getID()), null);
        logger.info("calling ChangeOperation DeleteNode");
        DeleteNode.performOperation(session, processGraph, join, template.getNodeType(join.getID()), null);
        if (nodesExist) {
            logger.info("calling set branch id");
            processGraph.setBranchID(splitSucc[0], joinPred[0], false, branchID);
            logger.info("calling set split node id");
            processGraph.setSplitNodeID(splitSucc[0], joinPred[0], splitNodeID);
        }
        if (updateManager != null) {
            objectArray = allPred1;
            n2 = allPred1.length;
            n = 0;
            while (n < n2) {
                int pred1 = objectArray[n];
                updateManager.firePropertyChange(template.getNode(pred1), (Object)UpdateManager.NodeProperties.NODE_OUT_EDGES);
                ++n;
            }
            objectArray = allSucc1;
            n2 = allSucc1.length;
            n = 0;
            while (n < n2) {
                int succ1 = objectArray[n];
                updateManager.firePropertyChange(template.getNode(succ1), (Object)UpdateManager.NodeProperties.NODE_IN_EDGES);
                ++n;
            }
            for (DataElementUpdate update : dataElementChanges) {
                updateManager.firePropertyChange(update.dataElement, (Object)update.property);
            }
            if (nodesExist) {
                objectArray = allSucc2;
                n2 = allSucc2.length;
                int n5 = 0;
                while (n5 < n2) {
                    int succ2 = objectArray[n5];
                    updateManager.firePropertyChange(template.getNode(succ2), (Object)UpdateManager.NodeProperties.NODE_IN_EDGES);
                    ++n5;
                }
                objectArray = allPred2;
                n2 = allPred2.length;
                n5 = 0;
                while (n5 < n2) {
                    int pred2 = objectArray[n5];
                    updateManager.firePropertyChange(template.getNode(pred2), (Object)UpdateManager.NodeProperties.NODE_OUT_EDGES);
                    ++n5;
                }
            }
        }
    }

    private static boolean enoughParameter(Node split, Node join, Template template, CheckReport checkReport) {
        if (split == null || join == null) {
            if (checkReport != null) {
                String message = "Not enough selected nodes for this operation. A split/start loop and its corresponding join/end loop are needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(split.getID()) == null || template.getNode(join.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain one or both of the necessary border nodes.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$de$aristaflow$adept2$model$globals$ActivityConstants$AccessType() {
        if ($SWITCH_TABLE$de$aristaflow$adept2$model$globals$ActivityConstants$AccessType != null) {
            return $SWITCH_TABLE$de$aristaflow$adept2$model$globals$ActivityConstants$AccessType;
        }
        int[] nArray = new int[ActivityConstants.AccessType.values().length];
        try {
            nArray[ActivityConstants.AccessType.READ.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ActivityConstants.AccessType.SYSTEM_READ.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ActivityConstants.AccessType.SYSTEM_WRITE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ActivityConstants.AccessType.WRITE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$aristaflow$adept2$model$globals$ActivityConstants$AccessType = nArray;
        return nArray;
    }

    private static class DataElementUpdate {
        final DataElement dataElement;
        final UpdateManager.DataElementProperties property;

        public DataElementUpdate(DataElement dataElement, UpdateManager.DataElementProperties property) {
            this.dataElement = dataElement;
            this.property = property;
        }
    }
}

