/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class DeleteConstraintEdge {
    protected static final Logger logger = LoggerTools.getLogger(DeleteConstraintEdge.class);
    private static final String CHECK_ID = "Delete constraint Edge";

    public static boolean isPossible(Template template, Node pred, Node succ) {
        return DeleteConstraintEdge.isPossible(template, pred, succ, null);
    }

    public static boolean isPossible(Template template, Node pred, Node succ, CheckReport checkReport) {
        if (!DeleteConstraintEdge.enoughParameter(pred, succ, template, checkReport)) {
            return false;
        }
        return template.getConstraintEdge(pred.getID(), succ.getID()) != null;
    }

    public static boolean isPossible(ChangeableInstance model, ConstraintEdge constraintEdge, CheckReport checkReport) {
        return false;
    }

    public static boolean isPossible(ChangeableTemplate model, ConstraintEdge constraintEdge, CheckReport checkReport) {
        return true;
    }

    public static boolean isPossible(ChangeableInstance instance, Node pred, Node succ) {
        return DeleteConstraintEdge.isPossible(instance, pred, succ, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node pred, Node succ, CheckReport checkReport) {
        if (!DeleteConstraintEdge.enoughParameter(pred, succ, instance.getTemplate(), checkReport)) {
            return false;
        }
        Template template = instance.getTemplate();
        if (instance.getNodeState(succ.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(succ.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = String.format("The node '%1$s' given as target for the constraint-edge must be ACTIVATED or NOT_ACTIVATED, but it is in state: %2$s.", ChangeOperationTools.getHumanReadableNodeName(succ), instance.getNodeState(succ.getID()).toString());
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ, "NodeState")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return DeleteConstraintEdge.isPossible(template, pred, succ, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node pred, Node succ) {
        DeleteConstraintEdge.performOperation(session, template, pred, succ, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node pred, Node succ, UpdateManager updateManager) {
        DeleteConstraintEdge.performOperation(session, (ChangePrimitives)template, pred, succ, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node pred, Node succ) {
        DeleteConstraintEdge.performOperation(session, instance, pred, succ, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node pred, Node succ, UpdateManager updateManager) {
        DeleteConstraintEdge.performOperation(session, (ChangePrimitives)instance, pred, succ, updateManager);
        instance.setNodeState(succ.getID(), ProcessConstants.NodeState.NS_NOT_ACTIVATED);
        if (updateManager != null) {
            ChangeOperationTools.fireNodeStateChangedEvent(updateManager, instance, succ);
        }
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, Node pred, Node succ, UpdateManager updateManager) {
        processGraph.removeConstraintEdge(pred.getID(), succ.getID());
        if (updateManager != null) {
            updateManager.firePropertyChange(pred, (Object)UpdateManager.NodeProperties.NODE_OUT_EDGES);
            updateManager.firePropertyChange(succ, (Object)UpdateManager.NodeProperties.NODE_IN_EDGES);
        }
    }

    private static boolean enoughParameter(Node pred, Node succ, Template template, CheckReport checkReport) {
        if (pred == null || succ == null) {
            if (checkReport != null) {
                String message = "Not enough selected nodes for this operation. A node as constraint-edge-start and a node as constraint-edge-end are needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(pred.getID()) == null || template.getNode(succ.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain one or both of the source/target nodes.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

