/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.UpdateInstance;
import de.aristaflow.adept2.core.changeoperations.UpdateTemplate;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class DeleteDataEdge {
    private static final String MY_INSTANCE_NAME = "DeleteDataEdge";
    protected static final Logger logger = LoggerTools.getLogger(DeleteDataEdge.class);
    private static final String CHECK_ID = "Delete Data Edge. Type: ";

    public static boolean isPossible(Template template, Node node, DataElement dataElement, ActivityConstants.AccessType type) {
        return DeleteDataEdge.isPossible(template, node, dataElement, type, null);
    }

    public static boolean isPossible(Template template, Node node, DataElement dataElement, ActivityConstants.AccessType type, CheckReport checkReport) {
        String check_ID = CHECK_ID + type.toString();
        if (!DeleteDataEdge.enoughParameter(node, dataElement, type, template, checkReport)) {
            return false;
        }
        int[] nArray = template.getAccessedDataElementIDsForNode(node.getID(), type);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int dataElementID = nArray[n2];
            if (dataElementID == dataElement.getID()) {
                if (template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_ENDFLOW)) {
                    return UpdateTemplate.isPossible(template.getID(), checkReport, ProcessConstants.TemplateProperty.OUTPUT_PARAMETER);
                }
                return true;
            }
            ++n2;
        }
        if (checkReport != null) {
            String message;
            switch (type) {
                case SYSTEM_READ: {
                    message = "There is no reading system data edge between node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' and data element '" + dataElement.getName() + "'. Therefore a deletion is not possible.";
                    break;
                }
                case READ: {
                    message = "There is no reading data edge between node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' and data element '" + dataElement.getName() + "'. Therefore a deletion is not possible.";
                    break;
                }
                case SYSTEM_WRITE: {
                    message = "There is no writing system data edge between node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' and data element '" + dataElement.getName() + "'. Therefore a deletion is not possible.";
                    break;
                }
                case WRITE: {
                    message = "There is no writing data edge between node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' and data element '" + dataElement.getName() + "'. Therefore a deletion is not possible.";
                    break;
                }
                default: {
                    message = "An unknown access type was found!";
                }
            }
            URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node), ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), dataElement)};
            checkReport.addReportEntry(check_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
        }
        return false;
    }

    public static boolean isPossible(ChangeableInstance instance, Node node, DataElement dataElement, ActivityConstants.AccessType type) {
        return DeleteDataEdge.isPossible(instance, node, dataElement, type, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node node, DataElement dataElement, ActivityConstants.AccessType type, CheckReport checkReport) {
        if (!DeleteDataEdge.enoughParameter(node, dataElement, type, instance.getTemplate(), checkReport)) {
            return false;
        }
        if (instance.getNodeState(node.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(node.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' which is connected to the data edge must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(node.getID()).toString() + ".";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node, "NodeState"));
            }
            return false;
        }
        Template template = instance.getTemplate();
        return DeleteDataEdge.isPossible(template, node, dataElement, type, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node node, DataElement dataElement, ActivityConstants.AccessType type) {
        DeleteDataEdge.performOperation(session, template, node, dataElement, type, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node node, DataElement dataElement, ActivityConstants.AccessType type, UpdateManager updateManager) {
        DeleteDataEdge.performOperation(session, (ChangePrimitives)template, node, dataElement, type, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node node, DataElement dataElement, ActivityConstants.AccessType type) {
        DeleteDataEdge.performOperation(session, instance, node, dataElement, type, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node node, DataElement dataElement, ActivityConstants.AccessType type, UpdateManager updateManager) {
        DeleteDataEdge.performOperation(session, (ChangePrimitives)instance, node, dataElement, type, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, Node node, DataElement dataElement, ActivityConstants.AccessType type, UpdateManager updateManager) {
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        logger.info("calling ChangePrimitive deleteDataEdge");
        processGraph.removeDataEdge(node.getID(), dataElement.getID(), type);
        if (node.getExecutableBusinessProcess() != null && !dataElement.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID)) {
            boolean resetIdentifier = true;
            ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
            int n = accessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityConstants.AccessType accessType = accessTypeArray[n2];
                if (resetIdentifier) {
                    int[] nArray = template.getAccessingNodeIDsForDataElement(dataElement.getID(), accessType);
                    int n3 = nArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int accessingNodeID = nArray[n4];
                        Node accessingNode = template.getNode(accessingNodeID);
                        if (accessingNode.getExecutableBusinessProcess() != null) {
                            resetIdentifier = false;
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            if (resetIdentifier) {
                ProcessModelFactory pmf;
                try {
                    pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
                }
                catch (ServiceNotKnownException snke) {
                    throw new RTServiceNotKnownException(snke);
                }
                DataElement tempDataElement = pmf.createDataElement(dataElement.getID(), dataElement.getName(), dataElement.getDataType(), dataElement.getDescription(), dataElement.getUDTName(), dataElement.getIconID(), ProcessConstants.IDENTIFIER_NOT_SET, dataElement.isPublic(), dataElement.isVirtual(), dataElement.getSupportedPlugins(), dataElement.getPluginDatas(), dataElement.getUserAttributes());
                processGraph.updateDataElement(tempDataElement, ProcessConstants.DataElementProperty.IDENTIFIER);
            }
        }
        if (updateManager != null) {
            switch (type) {
                case READ: {
                    updateManager.firePropertyChange(node, (Object)UpdateManager.NodeProperties.NODE_IN_DATA);
                    updateManager.firePropertyChange(dataElement, (Object)UpdateManager.DataElementProperties.DE_READERS);
                    break;
                }
                case WRITE: {
                    updateManager.firePropertyChange(node, (Object)UpdateManager.NodeProperties.NODE_OUT_DATA);
                    updateManager.firePropertyChange(dataElement, (Object)UpdateManager.DataElementProperties.DE_WRITERS);
                    break;
                }
                case SYSTEM_READ: {
                    updateManager.firePropertyChange(node, (Object)UpdateManager.NodeProperties.NODE_IN_DATA);
                    updateManager.firePropertyChange(dataElement, (Object)UpdateManager.DataElementProperties.DE_SYSTEM_READERS);
                    break;
                }
                case SYSTEM_WRITE: {
                    updateManager.firePropertyChange(node, (Object)UpdateManager.NodeProperties.NODE_OUT_DATA);
                    updateManager.firePropertyChange(dataElement, (Object)UpdateManager.DataElementProperties.DE_SYSTEM_WRITERS);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"An unknown access type was found!");
                }
            }
            if (template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_STARTFLOW)) {
                DeleteDataEdge.removeProcessInputParameter(processGraph, dataElement.getName(), updateManager);
            } else if (template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_ENDFLOW)) {
                DeleteDataEdge.removeProcessOutputParameter(processGraph, dataElement.getName(), updateManager);
            }
        }
    }

    private static boolean enoughParameter(Node node, DataElement dataElement, ActivityConstants.AccessType type, Template template, CheckReport checkReport) {
        if (node == null || dataElement == null || type == null) {
            if (checkReport != null) {
                String message = "Not enough selected elements for this operation. A single node and a single data element is needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(node.getID()) == null || template.getDataElement(dataElement.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain the data element: " + dataElement + " and/or the node: " + node;
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }

    private static void removeProcessInputParameter(ChangePrimitives processGraph, String inputParameterName, UpdateManager updateManager) {
        boolean isInstance;
        Template template;
        if (processGraph instanceof ChangeableInstance) {
            template = ((ChangeableInstance)processGraph).getTemplate();
            isInstance = true;
        } else {
            template = (ChangeableTemplate)processGraph;
            isInstance = false;
        }
        Set<ProcessModelParameter> processInputParameters = template.getParameters(ActivityConstants.AccessType.READ);
        HashSet<ProcessModelParameter> newProcessInputParameters = new HashSet<ProcessModelParameter>();
        for (ProcessModelParameter processInputParameter : processInputParameters) {
            if (processInputParameter.getName().equals(inputParameterName)) continue;
            newProcessInputParameters.add(processInputParameter);
        }
        if (isInstance) {
            UpdateInstance.performOperation((ChangeableInstance)((Object)template), null, null, newProcessInputParameters, null, updateManager, ProcessConstants.InstanceProperty.INPUT_PARAMETER);
        } else {
            UpdateTemplate.performOperation((ChangeableTemplate)template, null, null, null, newProcessInputParameters, null, updateManager, ProcessConstants.TemplateProperty.INPUT_PARAMETER);
        }
    }

    private static void removeProcessOutputParameter(ChangePrimitives processGraph, String outputParameterName, UpdateManager updateManager) {
        boolean isInstance;
        Template template;
        if (processGraph instanceof ChangeableInstance) {
            template = ((ChangeableInstance)processGraph).getTemplate();
            isInstance = true;
        } else {
            template = (ChangeableTemplate)processGraph;
            isInstance = false;
        }
        Set<ProcessModelParameter> processOutputParameters = template.getParameters(ActivityConstants.AccessType.WRITE);
        HashSet<ProcessModelParameter> newProcessOutputParameters = new HashSet<ProcessModelParameter>();
        for (ProcessModelParameter processOutputParameter : processOutputParameters) {
            if (processOutputParameter.getName().equals(outputParameterName)) continue;
            newProcessOutputParameters.add(processOutputParameter);
        }
        if (isInstance) {
            UpdateInstance.performOperation((ChangeableInstance)((Object)template), null, null, null, newProcessOutputParameters, updateManager, ProcessConstants.InstanceProperty.OUTPUT_PARAMETER);
        } else {
            UpdateTemplate.performOperation((ChangeableTemplate)template, null, null, null, null, newProcessOutputParameters, updateManager, ProcessConstants.TemplateProperty.OUTPUT_PARAMETER);
        }
    }
}

