/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.DeleteDataEdge;
import de.aristaflow.adept2.core.changeoperations.RemoveNodeSystemParameter;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.systemdata.SystemDataProducer;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.UUID;
import java.util.logging.Logger;

public class DeleteDataElement {
    protected static final Logger logger = LoggerTools.getLogger(DeleteDataElement.class);
    private static final String CHECK_ID = "Delete Data Element";

    public static boolean isPossible(Template template, DataElement dataElement) {
        return DeleteDataElement.isPossible(template, dataElement, null);
    }

    public static boolean isPossible(Template template, DataElement dataElement, CheckReport checkReport) {
        if (dataElement == null) {
            if (checkReport != null) {
                String message = "The data element is null.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }

    public static boolean isPossible(ChangeableInstance instance, DataElement dataElement) {
        return DeleteDataElement.isPossible(instance, dataElement, null);
    }

    public static boolean isPossible(ChangeableInstance instance, DataElement dataElement, CheckReport checkReport) {
        int[] writingNodes;
        if (!DeleteDataElement.enoughParameter(dataElement, instance.getTemplate(), checkReport)) {
            return false;
        }
        Template template = instance.getTemplate();
        int[] nArray = writingNodes = template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.WRITE);
        int n = writingNodes.length;
        int n2 = 0;
        while (n2 < n) {
            int writerID = nArray[n2];
            if (instance.getNodeState(writerID) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(writerID) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
                if (checkReport != null) {
                    String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(template.getNode(writerID)) + "' who writes the data element " + dataElement + " must be in one of the states ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(writerID).toString() + ".";
                    Node writer = template.getNode(writerID);
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), dataElement), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), writer, "NodeState")};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                return false;
            }
            ++n2;
        }
        return DeleteDataElement.isPossible(template, dataElement, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, DataElement dataElement) {
        DeleteDataElement.performOperation(session, template, dataElement, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, DataElement dataElement, UpdateManager updateManager) {
        DeleteDataElement.performOperation(session, (ChangePrimitives)template, dataElement, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, DataElement dataElement) {
        DeleteDataElement.performOperation(session, instance, dataElement, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, DataElement dataElement, UpdateManager updateManager) {
        DeleteDataElement.performOperation(session, (ChangePrimitives)instance, dataElement, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, DataElement dataElement, UpdateManager updateManager) {
        int nodeID;
        int n;
        int n2;
        int[] nArray;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        UUID identifierID = dataElement.getIdentifierID();
        Enum[] enumArray = SystemDataProducer.values();
        int n3 = enumArray.length;
        int n4 = 0;
        while (n4 < n3) {
            SystemDataProducer prod = enumArray[n4];
            if (identifierID.equals(prod.getParameterProperties().getIdentifierID())) {
                nArray = template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.SYSTEM_WRITE);
                n2 = nArray.length;
                n = 0;
                while (n < n2) {
                    nodeID = nArray[n];
                    int connectorID = template.getConnector(nodeID, dataElement.getID(), ActivityConstants.AccessType.SYSTEM_WRITE);
                    Node node = template.getNode(nodeID);
                    String parameterName = node.getParameterName(connectorID);
                    RemoveNodeSystemParameter.performOperation(session, processGraph, nodeID, ActivityConstants.AccessType.SYSTEM_WRITE, parameterName, updateManager);
                    ++n;
                }
                break;
            }
            ++n4;
        }
        enumArray = ActivityConstants.AccessType.values();
        n3 = enumArray.length;
        n4 = 0;
        while (n4 < n3) {
            Enum accessType = enumArray[n4];
            nArray = template.getAccessingNodeIDsForDataElement(dataElement.getID(), (ActivityConstants.AccessType)accessType);
            n2 = nArray.length;
            n = 0;
            while (n < n2) {
                nodeID = nArray[n];
                logger.info("Calling delete data edge (" + accessType + ")");
                DeleteDataEdge.performOperation(session, processGraph, template.getNode(nodeID), dataElement, (ActivityConstants.AccessType)accessType, updateManager);
                ++n;
            }
            ++n4;
        }
        logger.info("Calling delete data element");
        processGraph.removeDataElement(dataElement.getID());
        if (updateManager != null) {
            updateManager.firePropertyChange(template, (Object)UpdateManager.ProcessProperties.PROCESS_DATA_ELEMENT);
        }
    }

    private static boolean enoughParameter(DataElement dataElement, Template template, CheckReport checkReport) {
        if (dataElement == null) {
            if (checkReport != null) {
                String message = "Not enough selected data elements for this operation. A single data element is needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getDataElement(dataElement.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain the data element: " + dataElement;
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

