/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class DeleteEmptyBranch {
    protected static final Logger logger = LoggerTools.getLogger(DeleteEmptyBranch.class);
    private static final String CHECK_ID = "Delete Empty Branch";

    public static boolean isPossible(Template template, Node split, Node join) {
        return DeleteEmptyBranch.isPossible(template, split, join, null);
    }

    public static boolean isPossible(Template template, Node split, Node join, CheckReport checkReport) {
        if (!DeleteEmptyBranch.enoughParameter(split, join, template, checkReport)) {
            return false;
        }
        if (!(template.getNodeType(split.getID()).equals((Object)ProcessConstants.NodeType.NT_AND_SPLIT) || template.getNodeType(split.getID()).equals((Object)ProcessConstants.NodeType.NT_XOR_SPLIT) || template.getNodeType(split.getID()).equals((Object)ProcessConstants.NodeType.NT_STARTLOOP))) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(split) + "' given as split is not of type split.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), split, "NodeType"));
            }
            return false;
        }
        if (!(template.getNodeType(join.getID()).equals((Object)ProcessConstants.NodeType.NT_AND_JOIN) || template.getNodeType(join.getID()).equals((Object)ProcessConstants.NodeType.NT_XOR_JOIN) || template.getNodeType(join.getID()).equals((Object)ProcessConstants.NodeType.NT_ENDLOOP))) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(join) + "' given as join/loop end is not of type join/loop end.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), join, "NodeType"));
            }
            return false;
        }
        if (template.getNodeCorrespondingBlockNodeID(split.getID()) != join.getID()) {
            if (checkReport != null) {
                String message = "The given split node: '" + ChangeOperationTools.getHumanReadableNodeName(split) + "' and the given join node: '" + ChangeOperationTools.getHumanReadableNodeName(join) + "' are not corresponding to each other.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), split), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(template.getNodeCorrespondingBlockNodeID(split.getID()))), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), join)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        int[] succ = template.getSuccByEdgeType(split.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        if (succ.length < 2) {
            if (checkReport != null) {
                if (template.getNodeType(split.getID()) == ProcessConstants.NodeType.NT_STARTLOOP) {
                    String message = "An edge between a loop start and a loop end node (loop edge) can not be deleted. Use DeleteBorderNodes to remove the whole block.";
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getEdgeIdentifier(checkReport.getBase(), split, join, ProcessConstants.EdgeType.ET_CONTROL));
                } else {
                    String message = "The edge between the given split node: '" + ChangeOperationTools.getHumanReadableNodeName(split) + "' and the given join node: '" + ChangeOperationTools.getHumanReadableNodeName(join) + "' is the last edge. Use DeleteBorderNodes to remove the whole block.";
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getEdgeIdentifier(checkReport.getBase(), split, join, ProcessConstants.EdgeType.ET_CONTROL));
                }
            }
            return false;
        }
        boolean directPred = false;
        int[] nArray = succ;
        int n = succ.length;
        int n2 = 0;
        while (n2 < n) {
            int succID = nArray[n2];
            if (succID == join.getID()) {
                directPred = true;
                break;
            }
            ++n2;
        }
        if (!directPred) {
            if (checkReport != null) {
                String message = "The given split node: '" + ChangeOperationTools.getHumanReadableNodeName(split) + "' and the given join node: '" + ChangeOperationTools.getHumanReadableNodeName(join) + "' are not directly connected. Therefore there is no empty branch to delete.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), split), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), join)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return true;
    }

    public static boolean isPossible(ChangeableInstance instance, Node split, Node join) {
        return DeleteEmptyBranch.isPossible(instance, split, join, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node split, Node join, CheckReport checkReport) {
        if (!DeleteEmptyBranch.enoughParameter(split, join, instance.getTemplate(), checkReport)) {
            return false;
        }
        if (instance.getNodeState(join.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(join.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(join) + "' given as target of the branch to delete must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(split.getID()).toString() + ".";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), join, "NodeState"));
            }
            return false;
        }
        Template template = instance.getTemplate();
        return DeleteEmptyBranch.isPossible(template, split, join, checkReport);
    }

    public static void performOperation(ChangeableTemplate template, Node split, Node join) {
        DeleteEmptyBranch.performOperation(template, split, join, null);
    }

    public static void performOperation(ChangeableTemplate template, Node split, Node join, UpdateManager updateManager) {
        DeleteEmptyBranch.performOperation((ChangePrimitives)template, split, join, updateManager);
    }

    public static void performOperation(ChangeableInstance instance, Node split, Node join) {
        DeleteEmptyBranch.performOperation(instance, split, join, null);
    }

    public static void performOperation(ChangeableInstance instance, Node split, Node join, UpdateManager updateManager) {
        DeleteEmptyBranch.performOperation((ChangePrimitives)instance, split, join, updateManager);
    }

    protected static void performOperation(ChangePrimitives processGraph, Node split, Node join, UpdateManager updateManager) {
        logger.info("calling ChangePrimitive \"removeEdge\"");
        processGraph.removeEdge(split.getID(), join.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        if (updateManager != null) {
            updateManager.firePropertyChange(split, (Object)UpdateManager.NodeProperties.NODE_OUT_EDGES);
            updateManager.firePropertyChange(join, (Object)UpdateManager.NodeProperties.NODE_IN_EDGES);
        }
    }

    private static boolean enoughParameter(Node split, Node join, Template template, CheckReport checkReport) {
        if (split == null || join == null) {
            if (checkReport != null) {
                String message = "Not enough selected nodes for this operation. A split and its corresponding join are needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(split.getID()) == null || template.getNode(join.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain one or both of the given nodes: " + ChangeOperationTools.getHumanReadableNodeName(split) + "," + ChangeOperationTools.getHumanReadableNodeName(join);
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, checkReport.getBase());
            }
            return false;
        }
        return true;
    }
}

