/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.AssignExecutableBusinessProcess;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.RemoveExecutableBusinessProcess;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.DecisionStatement;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;

public class DeleteNode {
    protected static final Logger logger = LoggerTools.getLogger(DeleteNode.class);
    private static final String CHECK_ID = "Delete Node";
    private static final String MY_INSTANCE_NAME = "DeleteNode";
    private static /* synthetic */ int[] $SWITCH_TABLE$de$aristaflow$adept2$model$globals$ActivityConstants$AccessType;

    public static boolean isPossible(Template template, Node node) {
        return DeleteNode.isPossible(template, node, null);
    }

    public static boolean isPossible(Template template, Node node, CheckReport checkReport) {
        if (!DeleteNode.enoughParameter(node, template, checkReport)) {
            return false;
        }
        if (template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_NORMAL)) {
            return true;
        }
        if (checkReport != null) {
            String message = "The given node: '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' is of type '" + template.getNodeType(node.getID()).toString() + "' but it has to be of type NT_NORMAL.";
            URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node, "NodeType")};
            checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
        }
        return false;
    }

    public static boolean isPossible(ChangeableInstance instance, Node node) {
        return DeleteNode.isPossible(instance, node, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node node, CheckReport checkReport) {
        if (!DeleteNode.enoughParameter(node, instance.getTemplate(), checkReport)) {
            return false;
        }
        if (instance.getNodeState(node.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(node.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' to delete must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(node.getID()).toString() + ".";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node, "NodeState")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        Template template = instance.getTemplate();
        return DeleteNode.isPossible(template, node, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node node) {
        DeleteNode.performOperation(session, template, node, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node node, UpdateManager updateManager) {
        DeleteNode.performOperation(session, template, node, ProcessConstants.NodeType.NT_NORMAL, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangeableTemplate template, Node node, ProcessConstants.NodeType type, UpdateManager updateManager) {
        DeleteNode.performOperation(session, (ChangePrimitives)template, node, type, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node node) {
        DeleteNode.performOperation(session, instance, node, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node node, UpdateManager updateManager) {
        DeleteNode.performOperation(session, instance, node, ProcessConstants.NodeType.NT_NORMAL, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangeableInstance instance, Node node, ProcessConstants.NodeType type, UpdateManager updateManager) {
        DeleteNode.performOperation(session, (ChangePrimitives)instance, node, type, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, Node node, ProcessConstants.NodeType type, UpdateManager updateManager) {
        Object[] objectArray;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        HashMap<Node, UpdateManager.NodeProperties> nodeChanges = new HashMap<Node, UpdateManager.NodeProperties>();
        ArrayList<DataElementUpdate> dataElementChanges = new ArrayList<DataElementUpdate>();
        int[] predByControl = template.getPredByEdgeType(node.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        int[] succByControl = template.getSuccByEdgeType(node.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        assert (predByControl.length == 1 || succByControl.length == 1) : "we can only delete a node if there is only one pred and succ by CONTROL edges";
        Edge oldEdge = template.getEdge(predByControl[0], node.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        logger.info("calling ChangePrimitive removeEdge");
        processGraph.removeEdge(predByControl[0], node.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        nodeChanges.put(template.getNode(predByControl[0]), UpdateManager.NodeProperties.NODE_OUT_EDGES);
        logger.info("calling ChangePrimitive removeEdge");
        processGraph.removeEdge(node.getID(), succByControl[0], ProcessConstants.EdgeType.ET_CONTROL);
        nodeChanges.put(template.getNode(succByControl[0]), UpdateManager.NodeProperties.NODE_IN_EDGES);
        Edge emptyEdge = null;
        ProcessConstants.NodeType predByControlType = template.getNodeType(predByControl[0]);
        if ((predByControlType == ProcessConstants.NodeType.NT_AND_SPLIT || predByControlType == ProcessConstants.NodeType.NT_XOR_SPLIT) && template.getNodeCorrespondingBlockNodeID(predByControl[0]) == succByControl[0]) {
            int[] succsOfPred;
            int[] nArray = succsOfPred = template.getSuccByEdgeType(predByControl[0], ProcessConstants.EdgeType.ET_CONTROL);
            int n = succsOfPred.length;
            int n2 = 0;
            while (n2 < n) {
                int succID = nArray[n2];
                ProcessConstants.NodeType nodeType = template.getNodeType(succID);
                if (nodeType.equals((Object)ProcessConstants.NodeType.NT_AND_JOIN) || nodeType.equals((Object)ProcessConstants.NodeType.NT_XOR_JOIN)) {
                    emptyEdge = template.getEdge(predByControl[0], succID, ProcessConstants.EdgeType.ET_CONTROL);
                    break;
                }
                ++n2;
            }
        }
        if (emptyEdge != null) {
            if (predByControlType == ProcessConstants.NodeType.NT_XOR_SPLIT && processGraph instanceof ChangeableInstance && ((ChangeableInstance)processGraph).getNodeState(predByControl[0]) == ProcessConstants.NodeState.NS_COMPLETED) {
                ProcessModelFactory pmf;
                int[] succsOfPred;
                HashMap<Long, Collection<DecisionStatement>> decisionMapping = new HashMap<Long, Collection<DecisionStatement>>();
                ExecutableBusinessProcess ebp = template.getNode(predByControl[0]).getExecutableBusinessProcess();
                DecisionActivity decisionActivity = (DecisionActivity)ebp;
                objectArray = succsOfPred = template.getSuccByEdgeType(predByControl[0], ProcessConstants.EdgeType.ET_CONTROL);
                int n = succsOfPred.length;
                int nodeType = 0;
                while (nodeType < n) {
                    int n3;
                    Edge edge;
                    long[] decisionIDs;
                    int succID = objectArray[nodeType];
                    ProcessConstants.NodeType nodeType2 = template.getNodeType(succID);
                    LinkedList<DecisionStatement> decisionStatements = new LinkedList<DecisionStatement>();
                    if (nodeType2.equals((Object)ProcessConstants.NodeType.NT_XOR_JOIN)) {
                        long decisionID;
                        decisionIDs = decisionActivity.getDecisionID(emptyEdge.getEdgeCode());
                        edge = emptyEdge;
                        long[] deletedEdgeDecisionIDs = decisionActivity.getDecisionID(oldEdge.getEdgeCode());
                        long[] lArray = decisionIDs;
                        int n4 = decisionIDs.length;
                        n3 = 0;
                        while (n3 < n4) {
                            decisionID = lArray[n3];
                            decisionStatements.add(decisionActivity.getDecisionStatement(decisionID));
                            ++n3;
                        }
                        lArray = deletedEdgeDecisionIDs;
                        n4 = deletedEdgeDecisionIDs.length;
                        n3 = 0;
                        while (n3 < n4) {
                            decisionID = lArray[n3];
                            decisionStatements.add(decisionActivity.getDecisionStatement(decisionID));
                            ++n3;
                        }
                    } else {
                        edge = template.getEdge(predByControl[0], succID, ProcessConstants.EdgeType.ET_CONTROL);
                        long[] lArray = decisionIDs = decisionActivity.getDecisionID(edge.getEdgeCode());
                        n3 = decisionIDs.length;
                        int n5 = 0;
                        while (n5 < n3) {
                            long decisionID = lArray[n5];
                            decisionStatements.add(decisionActivity.getDecisionStatement(decisionID));
                            ++n5;
                        }
                    }
                    decisionMapping.put(edge.getEdgeCode(), decisionStatements);
                    ++nodeType;
                }
                try {
                    pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
                }
                catch (ServiceNotKnownException snke) {
                    throw new RTServiceNotKnownException(snke);
                }
                DecisionActivity newDecisionActivity = pmf.createDecisionActivity(decisionActivity, decisionActivity.getDecisionParameter(), decisionMapping);
                Node xorSplitNode = template.getNode(predByControl[0]);
                Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements = ChangeOperationTools.getParameterSystemValueMappingForAlreadyAssignedEBP(template, predByControl[0]);
                Map<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>> paramsWithExistingDataElements = ChangeOperationTools.getParameterDataElementMappingForAlreadyAssignedEBP(template, predByControl[0]);
                RemoveExecutableBusinessProcess.performOperation(session, processGraph, xorSplitNode, updateManager);
                AssignExecutableBusinessProcess.performOperation(session, processGraph, xorSplitNode, (ExecutableBusinessProcess)newDecisionActivity, paramsWithoutExistingDataElements, paramsWithExistingDataElements, updateManager);
            }
        } else {
            logger.info("calling ChangePrimitive addEdge");
            processGraph.addEdge(predByControl[0], succByControl[0], oldEdge);
        }
        int[] predBySync = template.getPredByEdgeType(node.getID(), ProcessConstants.EdgeType.ET_SYNC);
        int[] succBySync = template.getSuccByEdgeType(node.getID(), ProcessConstants.EdgeType.ET_SYNC);
        int[] nArray = predBySync;
        int pmf = predBySync.length;
        int succsOfPred = 0;
        while (succsOfPred < pmf) {
            int sPred = nArray[succsOfPred];
            logger.info("calling ChangePrimitive removeEdge (pred-Sync)");
            processGraph.removeEdge(sPred, node.getID(), ProcessConstants.EdgeType.ET_SYNC);
            nodeChanges.put(template.getNode(sPred), UpdateManager.NodeProperties.NODE_OUT_EDGES);
            ++succsOfPred;
        }
        nArray = succBySync;
        pmf = succBySync.length;
        succsOfPred = 0;
        while (succsOfPred < pmf) {
            int sSucc = nArray[succsOfPred];
            logger.info("calling ChangePrimitive removeEdge (succ-Sync)");
            processGraph.removeEdge(node.getID(), sSucc, ProcessConstants.EdgeType.ET_SYNC);
            nodeChanges.put(template.getNode(sSucc), UpdateManager.NodeProperties.NODE_IN_EDGES);
            ++succsOfPred;
        }
        int[] predByConst = template.getPredByEdgeType(node.getID(), ProcessConstants.EdgeType.ET_CONSTRAINT);
        int[] succByConst = template.getSuccByEdgeType(node.getID(), ProcessConstants.EdgeType.ET_CONSTRAINT);
        objectArray = predByConst;
        int n = predByConst.length;
        int n6 = 0;
        while (n6 < n) {
            int sPred = objectArray[n6];
            logger.info("calling ChangePrimitive removeEdge (pred-Const)");
            processGraph.removeConstraintEdge(sPred, node.getID());
            nodeChanges.put(template.getNode(sPred), UpdateManager.NodeProperties.NODE_OUT_EDGES);
            ++n6;
        }
        objectArray = succByConst;
        n = succByConst.length;
        n6 = 0;
        while (n6 < n) {
            int sSucc = objectArray[n6];
            logger.info("calling ChangePrimitive removeEdge (succ-Const)");
            processGraph.removeConstraintEdge(node.getID(), sSucc);
            nodeChanges.put(template.getNode(sSucc), UpdateManager.NodeProperties.NODE_IN_EDGES);
            ++n6;
        }
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
        objectArray = (Object[])accessTypeArray;
        n = accessTypeArray.length;
        n6 = 0;
        while (n6 < n) {
            UpdateManager.DataElementProperties prop;
            int accessType = objectArray[n6];
            switch (DeleteNode.$SWITCH_TABLE$de$aristaflow$adept2$model$globals$ActivityConstants$AccessType()[accessType.ordinal()]) {
                case 1: {
                    prop = UpdateManager.DataElementProperties.DE_READERS;
                    break;
                }
                case 2: {
                    prop = UpdateManager.DataElementProperties.DE_WRITERS;
                    break;
                }
                case 3: {
                    prop = UpdateManager.DataElementProperties.DE_SYSTEM_READERS;
                    break;
                }
                case 4: {
                    prop = UpdateManager.DataElementProperties.DE_SYSTEM_WRITERS;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"An unknown access type was found!");
                }
            }
            int[] nArray2 = template.getAccessedDataElementIDsForNode(node.getID(), (ActivityConstants.AccessType)accessType);
            int n7 = nArray2.length;
            int n8 = 0;
            while (n8 < n7) {
                int accessedDataElement = nArray2[n8];
                logger.info("calling ChangePrimitive removeDataEdge (" + accessType + ")");
                processGraph.removeDataEdge(node.getID(), accessedDataElement, (ActivityConstants.AccessType)accessType);
                dataElementChanges.add(new DataElementUpdate(template.getDataElement(accessedDataElement), prop));
                ++n8;
            }
            ++n6;
        }
        if (type.equals((Object)ProcessConstants.NodeType.NT_STARTLOOP)) {
            int[] predByLoop = template.getPredByEdgeType(node.getID(), ProcessConstants.EdgeType.ET_LOOP);
            logger.info("calling ChangePrimitive removeEdge (LOOP)");
            processGraph.removeEdge(predByLoop[0], node.getID(), ProcessConstants.EdgeType.ET_LOOP);
        }
        logger.info("calling ChangePrimitive removeNode");
        processGraph.removeNode(node.getID());
        if (updateManager != null) {
            for (Map.Entry entry : nodeChanges.entrySet()) {
                updateManager.firePropertyChange(entry.getKey(), entry.getValue());
            }
            for (DataElementUpdate update : dataElementChanges) {
                updateManager.firePropertyChange(update.dataElement, (Object)update.property);
            }
        }
    }

    private static boolean enoughParameter(Node node, Template template, CheckReport checkReport) {
        if (node == null) {
            if (checkReport != null) {
                String message = "Not enough selected nodes for this operation. A single node is needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(node.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain the node to delete.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$de$aristaflow$adept2$model$globals$ActivityConstants$AccessType() {
        if ($SWITCH_TABLE$de$aristaflow$adept2$model$globals$ActivityConstants$AccessType != null) {
            return $SWITCH_TABLE$de$aristaflow$adept2$model$globals$ActivityConstants$AccessType;
        }
        int[] nArray = new int[ActivityConstants.AccessType.values().length];
        try {
            nArray[ActivityConstants.AccessType.READ.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ActivityConstants.AccessType.SYSTEM_READ.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ActivityConstants.AccessType.SYSTEM_WRITE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ActivityConstants.AccessType.WRITE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$aristaflow$adept2$model$globals$ActivityConstants$AccessType = nArray;
        return nArray;
    }

    private static class DataElementUpdate {
        final DataElement dataElement;
        final UpdateManager.DataElementProperties property;

        public DataElementUpdate(DataElement dataElement, UpdateManager.DataElementProperties property) {
            this.dataElement = dataElement;
            this.property = property;
        }
    }
}

