/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.AssignExecutableBusinessProcess;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.DeleteBorderNodes;
import de.aristaflow.adept2.core.changeoperations.DeleteDataElement;
import de.aristaflow.adept2.core.changeoperations.DeleteEmptyBranch;
import de.aristaflow.adept2.core.changeoperations.DeleteNode;
import de.aristaflow.adept2.core.changeoperations.InsertConstraintEdge;
import de.aristaflow.adept2.core.changeoperations.InsertDataEdge;
import de.aristaflow.adept2.core.changeoperations.InsertDataElement;
import de.aristaflow.adept2.core.changeoperations.InsertEmptyBlock;
import de.aristaflow.adept2.core.changeoperations.InsertEmptyBranch;
import de.aristaflow.adept2.core.changeoperations.InsertNode;
import de.aristaflow.adept2.core.changeoperations.ToggleSyncEdge;
import de.aristaflow.adept2.core.changeoperations.UpdateDataEdge;
import de.aristaflow.adept2.core.changeoperations.UpdateNode;
import de.aristaflow.adept2.core.changeoperations.UpdatePluginDataContainer;
import de.aristaflow.adept2.core.changeoperations.UpdateUserAttribute;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.UserAttributeContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.DecisionStatement;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.StructuredConstraintEdge;
import de.aristaflow.adept2.model.processmodel.StructuredDataEdge;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ExtractSubprocess {
    private static final String MY_INSTANCE_NAME = "ExtractSubprocess";
    private static final String CHECK_ID1 = "Extract Sub Process Branch";
    private static final String CHECK_ID2 = "Valid Extract Block";
    protected static final Logger logger = LoggerTools.getLogger(ExtractSubprocess.class);

    public static boolean isPossible(ChangeableTemplate template, Node first, Node last) {
        return ExtractSubprocess.isPossible(template, first, last, null);
    }

    public static boolean isPossible(Template template, Node first, Node last, CheckReport checkReport) {
        int n;
        int[] nArray;
        int n2;
        if (!ExtractSubprocess.enoughParameter(first, last, template, checkReport)) {
            return false;
        }
        if (first.getID() == template.getStartNode().getID() || last.getID() == template.getEndNode().getID()) {
            if (checkReport != null) {
                String message = "The first extract block node must not be of type NT_STARTFLOW and the last move block node must not be of type NT_ENDFLOW";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first, "NodeType"), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), last, "NodeType")};
                checkReport.addReportEntry(CHECK_ID1, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        if (first.getID() != last.getID()) {
            if (!template.isTransPredOf(last.getID(), first.getID(), ProcessConstants.EdgeType.ET_CONTROL)) {
                if (checkReport != null) {
                    String message = String.format("The first node of the extract block '%s' must be a predecessor of the last node '%s' of the extract block, but this is not the case.", ChangeOperationTools.getHumanReadableNodeName(first), ChangeOperationTools.getHumanReadableNodeName(last));
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), last)};
                    checkReport.addReportEntry(CHECK_ID1, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                return false;
            }
            if (template.getNodeBranchID(first.getID()) != template.getNodeBranchID(last.getID())) {
                if (checkReport != null) {
                    String message = String.format("The first node of the extract block '%s' must be on the same block level as the last node '%s' of the extract block, but this is not the case.", ChangeOperationTools.getHumanReadableNodeName(first), ChangeOperationTools.getHumanReadableNodeName(last));
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first, "branchID"), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), last, "branchID")};
                    checkReport.addReportEntry(CHECK_ID1, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                return false;
            }
        }
        ProcessConstants.NodeType firstType = template.getNodeType(first.getID());
        ProcessConstants.NodeType lastType = template.getNodeType(last.getID());
        if (firstType.equals((Object)ProcessConstants.NodeType.NT_AND_JOIN) || firstType.equals((Object)ProcessConstants.NodeType.NT_XOR_JOIN) || firstType.equals((Object)ProcessConstants.NodeType.NT_ENDLOOP) || lastType.equals((Object)ProcessConstants.NodeType.NT_AND_SPLIT) || lastType.equals((Object)ProcessConstants.NodeType.NT_XOR_SPLIT) || lastType.equals((Object)ProcessConstants.NodeType.NT_STARTLOOP)) {
            if (checkReport != null) {
                String message = String.format("Neither the first node of the extract block '%s' must be a join/loop start node nor the last node of the extract block '%s' must be a split/loop end node.", ChangeOperationTools.getHumanReadableNodeName(first), ChangeOperationTools.getHumanReadableNodeName(last));
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first, "NodeType"), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), last, "NodeType")};
                checkReport.addReportEntry(CHECK_ID1, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        int[] syncNodes = ProcessModelTools.nodesWithSyncEdgesInArea(template, first.getID(), last.getID(), false);
        int[] nodesInArea = template.getNodeIDsInArea(first.getID(), last.getID(), true);
        Arrays.sort(nodesInArea);
        int[] nArray2 = syncNodes;
        int n3 = syncNodes.length;
        int n4 = 0;
        while (n4 < n3) {
            int[] syncPreds;
            int syncNode = nArray2[n4];
            int[] nArray3 = syncPreds = template.getPredByEdgeType(syncNode, ProcessConstants.EdgeType.ET_SYNC);
            n2 = syncPreds.length;
            int n5 = 0;
            while (n5 < n2) {
                int syncPred = nArray3[n5];
                if (Arrays.binarySearch(nodesInArea, syncPred) < 0) {
                    return false;
                }
                ++n5;
            }
            int[] syncSuccs = template.getSuccByEdgeType(syncNode, ProcessConstants.EdgeType.ET_SYNC);
            nArray = syncSuccs;
            n = syncSuccs.length;
            n2 = 0;
            while (n2 < n) {
                int syncSucc = nArray[n2];
                if (Arrays.binarySearch(nodesInArea, syncSucc) < 0) {
                    return false;
                }
                ++n2;
            }
            ++n4;
        }
        int[] constraintNodes = ExtractSubprocess.nodesWithConstraintEdgesInArea(template, first.getID(), last.getID(), false);
        Arrays.sort(constraintNodes);
        int[] nArray4 = syncNodes;
        int n6 = syncNodes.length;
        n3 = 0;
        while (n3 < n6) {
            int[] syncSuccs;
            int[] syncPreds;
            int syncNode = nArray4[n3];
            nArray = syncPreds = template.getPredByEdgeType(syncNode, ProcessConstants.EdgeType.ET_CONSTRAINT);
            n = syncPreds.length;
            n2 = 0;
            while (n2 < n) {
                int syncPred = nArray[n2];
                if (Arrays.binarySearch(constraintNodes, syncPred) < 0) {
                    return false;
                }
                ++n2;
            }
            int[] nArray5 = syncSuccs = template.getSuccByEdgeType(syncNode, ProcessConstants.EdgeType.ET_CONSTRAINT);
            int n7 = syncSuccs.length;
            n = 0;
            while (n < n7) {
                int syncSucc = nArray5[n];
                if (Arrays.binarySearch(constraintNodes, syncSucc) < 0) {
                    return false;
                }
                ++n;
            }
            ++n3;
        }
        return true;
    }

    public static int[] nodesWithConstraintEdgesInArea(Template template, int firstID, int lastID, boolean includingInnerSyncEdges) {
        Set<StructuredConstraintEdge> syncEdges = template.getConstraintEdgeStructure();
        HashSet<Node> resultSet = new HashSet<Node>();
        int firstTopID = template.getNodeTopologicalID(firstID);
        int lastTopID = template.getNodeTopologicalID(lastID);
        for (StructuredEdge structuredEdge : syncEdges) {
            int srcTopID = template.getNodeTopologicalID(structuredEdge.getSourceNodeID());
            int destTopID = template.getNodeTopologicalID(structuredEdge.getDestinationNodeID());
            if (srcTopID >= firstTopID && srcTopID <= lastTopID) {
                if (!includingInnerSyncEdges && destTopID >= firstTopID && destTopID <= lastTopID) continue;
                resultSet.add(template.getNode(structuredEdge.getSourceNodeID()));
                continue;
            }
            if (destTopID < firstTopID || destTopID > lastTopID) continue;
            resultSet.add(template.getNode(structuredEdge.getDestinationNodeID()));
        }
        return ProcessModelTools.intArrayNode(resultSet);
    }

    public static boolean isPossible(ChangeableInstance instance, Node first, Node last) {
        return ExtractSubprocess.isPossible(instance, first, last, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node first, Node last, CheckReport checkReport) {
        if (instance.getNodeState(first.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(first.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = String.format("One the nodes '%' which marks the beginning of the extract blockmust be ACTIVATED or NOT_ACTIVATED, but it isin state: %s.", ChangeOperationTools.getHumanReadableNodeName(first), instance.getNodeState(first.getID()).toString());
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first, "NodeState")};
                checkReport.addReportEntry(CHECK_ID2, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        Template template = instance.getTemplate();
        if (!ExtractSubprocess.enoughParameter(first, last, template, checkReport)) {
            return false;
        }
        return ExtractSubprocess.isPossible(template, first, last, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node first, Node last) {
        ExtractSubprocess.performOperation(session, template, first, last, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node first, Node last, UpdateManager updateManager) {
        ExtractSubprocess.performOperation(session, (ChangePrimitives)template, first, last, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node first, Node last) {
        ExtractSubprocess.performOperation(session, instance, first, last, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node first, Node last, UpdateManager updateManager) {
        int firstPred = instance.getTemplate().getPredByEdgeType(first.getID(), ProcessConstants.EdgeType.ET_CONTROL)[0];
        ProcessConstants.NodeState firstPredState = instance.getNodeState(firstPred);
        ExtractSubprocess.performOperation(session, (ChangePrimitives)instance, first, last, updateManager);
        boolean predCompleted = false;
        if (!(firstPredState != ProcessConstants.NodeState.NS_COMPLETED && firstPredState != ProcessConstants.NodeState.NS_ENQUIRED || predCompleted)) {
            instance.setNodeState(first.getID(), ProcessConstants.NodeState.NS_NOT_ACTIVATED);
            if (updateManager != null) {
                ChangeOperationTools.fireNodeStateChangedEvent(updateManager, instance, first);
            }
        }
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, Node first, Node last, UpdateManager updateManager) {
        ProcessModelFactory pmf;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        int[] predsOfFirst = template.getPredByEdgeType(first.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        int[] succsOfLast = template.getSuccByEdgeType(last.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        if (predsOfFirst.length != 1) {
            throw new RuntimeException("Error: first must/can only have one predecessor");
        }
        if (succsOfLast.length != 1) {
            throw new RuntimeException("Error: last must/can only have one successor");
        }
        Node pred = template.getNode(predsOfFirst[0]);
        Node succ = template.getNode(succsOfLast[0]);
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        pmf.setCreateChangeable(true);
        SubprocessMapping subprocessMapping = ExtractSubprocess.extractSubProcess(session, pmf, processGraph, template, first, last);
        ChangeableTemplate extractedProcess = subprocessMapping.targetTemplate;
        Node abstractedNode = InsertNode.performOperation(session, processGraph, pred, first, ProcessConstants.NodeType.NT_NORMAL, null);
        ArrayList<Node> removedNodes = new ArrayList<Node>();
        ExtractSubprocess.removeFragment(session, processGraph, template, first, last, removedNodes);
        ArrayList<DataElement> removedDataElements = new ArrayList<DataElement>();
        ExtractSubprocess.removeDataElements(session, processGraph, subprocessMapping.dataElementsToMove, removedDataElements);
        EmbeddedProcess ebp = ExtractSubprocess.createLWP(pmf, template, extractedProcess);
        HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements = new HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>>();
        HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, DataElement>> paramsWithExistingDataElementsIP = new HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, DataElement>>();
        Map<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>> paramsWithExistingDataElements = subprocessMapping.dataEdgesToBeReconnected;
        if (AssignExecutableBusinessProcess.isPossible(template, abstractedNode, (ExecutableBusinessProcess)ebp, paramsWithoutExistingDataElements, paramsWithExistingDataElementsIP)) {
            AssignExecutableBusinessProcess.performOperation(session, (ChangeableTemplate)template, abstractedNode, (ExecutableBusinessProcess)ebp, paramsWithoutExistingDataElements, paramsWithExistingDataElements, null);
        }
        if (updateManager != null) {
            updateManager.firePropertyChange(pred, (Object)UpdateManager.NodeProperties.NODE_OUT_EDGES);
            updateManager.firePropertyChange(succ, (Object)UpdateManager.NodeProperties.NODE_IN_EDGES);
            updateManager.firePropertyChange(abstractedNode, (Object)UpdateManager.NodeProperties.NODE_OUT_EDGES);
            updateManager.firePropertyChange(abstractedNode, (Object)UpdateManager.NodeProperties.NODE_IN_EDGES);
        }
    }

    private static SubprocessMapping extractSubProcess(SessionToken session, ProcessModelFactory pmf, ChangePrimitives processGraph, Template template, Node first, Node last) {
        ChangeableTemplate subprocess = (ChangeableTemplate)pmf.createNullTemplate(ExtractSubprocess.getQualifiedAgent(session, template));
        SubprocessMapping subprocessMapping = new SubprocessMapping(template, processGraph, subprocess);
        subprocess.startTransaction();
        ExtractSubprocess.copyProcessFragment(session, pmf, subprocessMapping, first, last);
        ExtractSubprocess.copyDataFlow(session, pmf, subprocessMapping, first, last);
        ExtractSubprocess.processEBPs(session, pmf, subprocessMapping);
        subprocess.endTransaction();
        return subprocessMapping;
    }

    protected static void copyProcessFragment(SessionToken session, ProcessModelFactory pmf, SubprocessMapping mapping, Node first, Node last) {
        ExtractSubprocess.recursivelyCopyBasicProcessStructure(session, pmf, mapping, first, last, mapping.targetTemplate.getStartNode(), mapping.targetTemplate.getEndNode());
        ExtractSubprocess.copySyncEdges(session, pmf, mapping, first, last);
        ExtractSubprocess.copyConstraintEdges(session, pmf, mapping, first, last);
    }

    protected static EmbeddedProcess createLWP(ProcessModelFactory pmf, Template parentProcess, Template subProcess) {
        Configuration conf = null;
        Configuration testConf = null;
        ExecutionControlProperties executionControlProperties = new ExecutionControlProperties(true, false, false);
        Template pluginData = subProcess;
        Map<String, String> userAttributes = subProcess.getUserAttributes();
        EmbeddedProcess ebp = null;
        ebp = pmf.createEmbeddedProcess(subProcess, parentProcess.getID(), null, conf, testConf, executionControlProperties, pluginData, userAttributes);
        return ebp;
    }

    protected static void copyConstraintEdges(SessionToken session, ProcessModelFactory pmf, SubprocessMapping processMapping, Node first, Node last) {
        Template template = processMapping.sourceTemplate;
        ChangeableTemplate subprocess = processMapping.targetTemplate;
        Map<Node, Node> mapping = processMapping.nodeMapping;
        Set<StructuredConstraintEdge> edgeStructure = template.getConstraintEdgeStructure();
        int[] nodes = ProcessModelTools.intArrayNode(mapping.keySet());
        Arrays.sort(nodes);
        for (StructuredConstraintEdge constraintEdge : edgeStructure) {
            if (Arrays.binarySearch(nodes, constraintEdge.getSourceNodeID()) < 0) continue;
            Node source = template.getNode(constraintEdge.getSourceNodeID());
            Node target = template.getNode(constraintEdge.getDestinationNodeID());
            Node sourceMap = mapping.get(source);
            Node targetMap = mapping.get(target);
            assert (sourceMap != null);
            assert (targetMap != null);
            ConstraintEdge newConstraintEdge = InsertConstraintEdge.performOperation(session, subprocess, sourceMap, targetMap, null);
            ExtractSubprocess.copyPluginData(subprocess, (ConstraintEdge)constraintEdge.getEdge(), newConstraintEdge);
        }
    }

    private static void copyPluginData(ChangeableTemplate subprocess, PluginDataContainer from, PluginDataContainer to) {
        for (Map.Entry<String, Set<String>> extensionPoints : from.getSupportedPlugins().entrySet()) {
            for (String pluginID : extensionPoints.getValue()) {
                PluginData pluginData = from.getPluginData(pluginID);
                UpdatePluginDataContainer.performOperation(subprocess, to, extensionPoints.getKey(), pluginID, pluginData, null);
            }
        }
    }

    private static void copyUserAttributes(ChangeableTemplate targetTemplate, UserAttributeContainer from, UserAttributeContainer toUpdate) {
        for (Map.Entry<String, String> entry : from.getUserAttributes().entrySet()) {
            UpdateUserAttribute.performOperation(targetTemplate, toUpdate, entry.getKey(), entry.getValue(), null);
        }
    }

    private static void removeDataElements(SessionToken session, ChangePrimitives processGraph, Set<DataElement> dataElementToBeRemoved, Collection<DataElement> removedDataElements) {
        for (DataElement dataElement : dataElementToBeRemoved) {
            DeleteDataElement.performOperation(session, processGraph, dataElement, null);
        }
    }

    private static void processEBPs(SessionToken session, ProcessModelFactory pmf, SubprocessMapping processMapping) {
        Template template = processMapping.sourceTemplate;
        ChangeableTemplate subprocess = processMapping.targetTemplate;
        Map<Node, Node> mapping = processMapping.nodeMapping;
        for (Node sourceNode : mapping.keySet()) {
            ExecutableBusinessProcess sourceEBP = sourceNode.getExecutableBusinessProcess();
            if (sourceEBP == null) continue;
            ExecutableBusinessProcess targetEBP = ExtractSubprocess.cloneEBP(pmf, sourceEBP);
            HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements = new HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>>();
            HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>> paramsWithExistingDataElements = new HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>>();
            paramsWithExistingDataElements.put(ActivityConstants.AccessType.READ, new HashMap());
            paramsWithExistingDataElements.put(ActivityConstants.AccessType.WRITE, new HashMap());
            ExtractSubprocess.matchParameterMapping(template, processMapping, sourceNode, sourceEBP, targetEBP, (Map)paramsWithExistingDataElements.get((Object)ActivityConstants.AccessType.READ), ActivityConstants.AccessType.READ);
            ExtractSubprocess.matchParameterMapping(template, processMapping, sourceNode, sourceEBP, targetEBP, (Map)paramsWithExistingDataElements.get((Object)ActivityConstants.AccessType.WRITE), ActivityConstants.AccessType.WRITE);
            Node targetNode = mapping.get(sourceNode);
            AssignExecutableBusinessProcess.performOperation(session, subprocess, targetNode, targetEBP, paramsWithoutExistingDataElements, paramsWithExistingDataElements, null);
        }
    }

    private static void matchParameterMapping(Template sourceTemplate, SubprocessMapping processMapping, Node sourceNode, ExecutableBusinessProcess sourceEBP, ExecutableBusinessProcess targetEBP, Map<ProcessModelParameter, Integer> targetParameters, ActivityConstants.AccessType accessType) {
        Set<ProcessModelParameter> sourceReadParameters = sourceEBP.getParameters(accessType);
        Map<String, Integer> sourceConnectorMapping = sourceNode.getConnectorMapping(accessType);
        for (ProcessModelParameter param : sourceReadParameters) {
            int sourceConnectorID = sourceConnectorMapping.get(param.getName());
            DataElement sourceDataElement = sourceTemplate.getDataElement(sourceNode.getID(), sourceConnectorID);
            Integer targetDataElementID = processMapping.dataElementIDMapping.get(sourceDataElement.getID());
            targetParameters.put(targetEBP.getParameter(param.getName(), accessType), targetDataElementID);
        }
    }

    private static ExecutableBusinessProcess cloneEBP(ProcessModelFactory pmf, ExecutableBusinessProcess ebp) {
        switch (ebp.getType()) {
            case ACTIVITY: {
                Activity oldActivity = (Activity)ebp;
                return pmf.createActivity(oldActivity.getID(), oldActivity.getExecutableComponentName(), oldActivity.getOperationName(), oldActivity.getConfigurationName(), oldActivity.getActivityName(), oldActivity.getDescription(), oldActivity.getImplementationClass(), oldActivity.getSeparatedClassPaths(), oldActivity.isSingleton(), oldActivity.getSystemComponent(), oldActivity.getGUIContextID(), oldActivity.getExecutionControlProperties(), oldActivity.supportsViewOnly(), oldActivity.supportsTestExecution(), oldActivity.getIconID(), oldActivity.getAttributeOrigins(), oldActivity.getConfiguration(), oldActivity.getTestConfiguration(), oldActivity.getParameterChangePolicy(), oldActivity.getParameters(ActivityConstants.AccessType.READ), oldActivity.getParameters(ActivityConstants.AccessType.WRITE), oldActivity, oldActivity.getUserAttributes());
            }
            case DECISION_ACTIVITY: {
                DecisionActivity oldActivity = (DecisionActivity)ebp;
                HashMap<Long, Collection<DecisionStatement>> decisionMapping = new HashMap<Long, Collection<DecisionStatement>>();
                long[] lArray = oldActivity.getDecisionIDs();
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    long decisionID = lArray[n2];
                    Long edgeCode = oldActivity.getEdgeCode(decisionID);
                    ArrayList<DecisionStatement> coll = (ArrayList<DecisionStatement>)decisionMapping.get(edgeCode);
                    if (coll == null) {
                        coll = new ArrayList<DecisionStatement>();
                        decisionMapping.put(edgeCode, coll);
                    }
                    coll.add(oldActivity.getDecisionStatement(decisionID));
                    ++n2;
                }
                return pmf.createDecisionActivity(oldActivity.getID(), oldActivity.getExecutableComponentName(), oldActivity.getOperationName(), oldActivity.getConfigurationName(), oldActivity.getActivityName(), oldActivity.getDescription(), oldActivity.getImplementationClass(), oldActivity.getSeparatedClassPaths(), oldActivity.isSingleton(), oldActivity.getSystemComponent(), oldActivity.getGUIContextID(), oldActivity.getExecutionControlProperties(), oldActivity.supportsViewOnly(), oldActivity.supportsTestExecution(), oldActivity.getIconID(), oldActivity.getAttributeOrigins(), oldActivity.getConfiguration(), oldActivity.getTestConfiguration(), oldActivity.getParameterChangePolicy(), oldActivity.getParameters(ActivityConstants.AccessType.READ), oldActivity.getParameters(ActivityConstants.AccessType.WRITE), oldActivity, oldActivity.getUserAttributes(), oldActivity.getDecisionParameter(), decisionMapping);
            }
            case LWP: {
                if (ebp instanceof EmbeddedProcess) {
                    EmbeddedProcess oldEP = (EmbeddedProcess)ebp;
                    return pmf.createEmbeddedProcess(oldEP.getTemplate(), oldEP.getTemplate().getID(), oldEP.getTemplateID(), oldEP.getConfiguration(), oldEP.getTestConfiguration(), oldEP.getExecutionControlProperties(), oldEP, oldEP.getUserAttributes());
                }
                if (ebp instanceof ReferencedProcess) {
                    ReferencedProcess oldRP = (ReferencedProcess)ebp;
                    return pmf.createReferencedProcess(oldRP.getTemplateID(), oldRP.fork(), oldRP.getConfiguration(), oldRP.getTestConfiguration(), oldRP.getExecutionControlProperties(), oldRP.getParameters(ActivityConstants.AccessType.READ), oldRP.getParameters(ActivityConstants.AccessType.WRITE), oldRP, oldRP.getUserAttributes());
                }
                throw new RuntimeException();
            }
        }
        throw new RuntimeException();
    }

    private static void copyDataFlow(SessionToken session, ProcessModelFactory pmf, SubprocessMapping processMapping, Node first, Node last) {
        Template sourceProcess = processMapping.sourceTemplate;
        ChangeableTemplate targetProcess = processMapping.targetTemplate;
        Map<Node, Node> mapping = processMapping.nodeMapping;
        Set<DataElement> dataElementsToMove = processMapping.dataElementsToMove;
        Set<DataElement> dataElementsToCopy = processMapping.dataElementsToCopy;
        int[] nodes = ProcessModelTools.intArrayNode(mapping.keySet());
        Arrays.sort(nodes);
        Set<StructuredDataEdge> dataEdges = sourceProcess.getDataEdgeStructure();
        for (StructuredDataEdge dataEdge : dataEdges) {
            if (Arrays.binarySearch(nodes, dataEdge.getNodeID()) < 0) continue;
            dataElementsToMove.add(sourceProcess.getDataElement(dataEdge.getDataElementID()));
        }
        for (StructuredDataEdge dataEdge : dataEdges) {
            DataElement dataElement;
            if (Arrays.binarySearch(nodes, dataEdge.getNodeID()) >= 0 || !dataElementsToMove.remove(dataElement = sourceProcess.getDataElement(dataEdge.getDataElementID()))) continue;
            dataElementsToCopy.add(dataElement);
        }
        assert (!dataElementsToCopy.removeAll(dataElementsToMove));
        Map<Integer, Integer> dataElementMapping = processMapping.dataElementIDMapping;
        for (DataElement dataElement : dataElementsToCopy) {
            String description = dataElement.getDescription();
            DataElement tempDataElement = pmf.createDataElement(Integer.MIN_VALUE, dataElement.getName(), dataElement.getDataType(), description, dataElement.getUDTName(), dataElement.getIconID(), dataElement.getIdentifierID(), dataElement.isPublic(), dataElement.isVirtual(), dataElement.getSupportedPlugins(), dataElement.getPluginDatas(), dataElement.getUserAttributes());
            DataElement newDataElement = InsertDataElement.performOperation(session, targetProcess, tempDataElement, null);
            dataElementMapping.put(dataElement.getID(), newDataElement.getID());
        }
        for (DataElement dataElement : dataElementsToMove) {
            DataElement tempDataElement = pmf.createDataElement(Integer.MIN_VALUE, dataElement.getName(), dataElement.getDataType(), dataElement.getDescription(), dataElement.getUDTName(), dataElement.getIconID(), dataElement.getIdentifierID(), dataElement.isPublic(), dataElement.isVirtual(), dataElement.getSupportedPlugins(), dataElement.getPluginDatas(), dataElement.getUserAttributes());
            DataElement newDataElement = InsertDataElement.performOperation(session, targetProcess, tempDataElement, null);
            dataElementMapping.put(dataElement.getID(), newDataElement.getID());
        }
        processMapping.dataEdgesToBeReconnected.put(ActivityConstants.AccessType.READ, new HashMap());
        processMapping.dataEdgesToBeReconnected.put(ActivityConstants.AccessType.WRITE, new HashMap());
        block12: for (StructuredDataEdge dataEdge : dataEdges) {
            DataEdge tempDataEdge;
            DataEdge newDataEdge;
            if (Arrays.binarySearch(nodes, dataEdge.getNodeID()) < 0) continue;
            Node sourceNode = sourceProcess.getNode(dataEdge.getNodeID());
            Node targetNode = mapping.get(sourceNode);
            int sourceDataElementID = dataEdge.getDataElementID();
            DataElement sourceDataElement = sourceProcess.getDataElement(sourceDataElementID);
            int targetDataElementID = dataElementMapping.get(sourceDataElementID);
            DataElement newDataElement = targetProcess.getDataElement(targetDataElementID);
            switch (dataEdge.getDataEdgeType()) {
                case READ: 
                case WRITE: {
                    InsertDataEdge.performOperation(session, targetProcess, targetNode, newDataElement, dataEdge.getDataEdgeType(), null);
                    if (!dataEdge.getDataEdge().isOptional()) break;
                    newDataEdge = targetProcess.getDataEdge(targetNode.getID(), newDataElement.getID(), dataEdge.getDataEdgeType());
                    tempDataEdge = pmf.createDataEdge(newDataEdge.getType(), true, newDataEdge.getUserAttributes());
                    UpdateDataEdge.performOperation(session, targetProcess, targetNode.getID(), newDataElement.getID(), newDataEdge.getType(), tempDataEdge, ProcessConstants.DataEdgeProperty.OPTIONAL);
                    break;
                }
                case SYSTEM_READ: 
                case SYSTEM_WRITE: {
                    String parameterName = sourceNode.getParameterName(dataEdge.getConnectorID());
                    ProcessModelParameter systemParameter = sourceNode.getSystemParameter(parameterName, dataEdge.getDataEdgeType());
                    InsertDataEdge.performOperation(session, targetProcess, targetNode, newDataElement, systemParameter, dataEdge.getConnectorID(), dataEdge.getDataEdgeType(), null);
                    if (!dataEdge.getDataEdge().isOptional()) break;
                    DataEdge newDataEdge2 = targetProcess.getDataEdge(targetNode.getID(), newDataElement.getID(), dataEdge.getDataEdgeType());
                    DataEdge tempDataEdge2 = pmf.createDataEdge(newDataEdge2.getType(), true, newDataEdge2.getUserAttributes());
                    UpdateDataEdge.performOperation(session, targetProcess, targetNode.getID(), newDataElement.getID(), newDataEdge2.getType(), tempDataEdge2, ProcessConstants.DataEdgeProperty.OPTIONAL);
                }
            }
            if (!dataElementsToCopy.contains(sourceDataElement)) continue;
            switch (dataEdge.getDataEdgeType()) {
                case READ: 
                case SYSTEM_READ: {
                    Map<ProcessModelParameter, Integer> map;
                    if (targetProcess.getDataEdge(targetProcess.getStartNode().getID(), newDataElement.getID(), ActivityConstants.AccessType.WRITE) != null) break;
                    InsertDataEdge.performOperation(session, targetProcess, targetProcess.getStartNode(), newDataElement, ActivityConstants.AccessType.WRITE, null);
                    if (dataEdge.getDataEdge().isOptional()) {
                        newDataEdge = targetProcess.getDataEdge(targetProcess.getStartNode().getID(), newDataElement.getID(), dataEdge.getDataEdgeType());
                        tempDataEdge = pmf.createDataEdge(newDataEdge.getType(), true, newDataEdge.getUserAttributes());
                        UpdateDataEdge.performOperation(session, targetProcess, targetProcess.getStartNode().getID(), newDataElement.getID(), newDataEdge.getType(), tempDataEdge, ProcessConstants.DataEdgeProperty.OPTIONAL);
                    }
                    Set<ProcessModelParameter> processInputParameters = targetProcess.getParameters(ActivityConstants.AccessType.READ);
                    for (ProcessModelParameter param : processInputParameters) {
                        if (newDataElement.getName() != param.getName() || newDataElement.getDataType() != param.getDataType()) continue;
                        map = processMapping.dataEdgesToBeReconnected.get((Object)ActivityConstants.AccessType.READ);
                        map.put(param, sourceDataElementID);
                    }
                    continue block12;
                }
                case WRITE: 
                case SYSTEM_WRITE: {
                    Map<ProcessModelParameter, Integer> map;
                    if (targetProcess.getDataEdge(targetProcess.getStartNode().getID(), newDataElement.getID(), ActivityConstants.AccessType.READ) != null) break;
                    InsertDataEdge.performOperation(session, targetProcess, targetProcess.getEndNode(), newDataElement, ActivityConstants.AccessType.READ, null);
                    if (dataEdge.getDataEdge().isOptional()) {
                        newDataEdge = targetProcess.getDataEdge(targetProcess.getEndNode().getID(), newDataElement.getID(), dataEdge.getDataEdgeType());
                        tempDataEdge = pmf.createDataEdge(newDataEdge.getType(), true, newDataEdge.getUserAttributes());
                        UpdateDataEdge.performOperation(session, targetProcess, targetProcess.getEndNode().getID(), newDataElement.getID(), newDataEdge.getType(), tempDataEdge, ProcessConstants.DataEdgeProperty.OPTIONAL);
                    }
                    Set<ProcessModelParameter> processInputParameters = targetProcess.getParameters(ActivityConstants.AccessType.WRITE);
                    for (ProcessModelParameter param : processInputParameters) {
                        if (newDataElement.getName() != param.getName() || newDataElement.getDataType() != param.getDataType()) continue;
                        map = processMapping.dataEdgesToBeReconnected.get((Object)ActivityConstants.AccessType.WRITE);
                        map.put(param, sourceDataElementID);
                    }
                    continue block12;
                }
            }
        }
    }

    protected static void copySyncEdges(SessionToken session, ProcessModelFactory pmf, SubprocessMapping processMapping, Node first, Node last) {
        Template template = processMapping.sourceTemplate;
        ChangeableTemplate subprocess = processMapping.targetTemplate;
        Map<Node, Node> nodeMapping = processMapping.nodeMapping;
        Set<StructuredEdge> edgeStructure = template.getEdgeStructure(ProcessConstants.EdgeType.ET_SYNC);
        int[] nodes = ProcessModelTools.intArrayNode(nodeMapping.keySet());
        Arrays.sort(nodes);
        for (StructuredEdge syncEdge : edgeStructure) {
            if (Arrays.binarySearch(nodes, syncEdge.getSourceNodeID()) < 0) continue;
            Node source = template.getNode(syncEdge.getSourceNodeID());
            Node target = template.getNode(syncEdge.getDestinationNodeID());
            Node sourceMap = nodeMapping.get(source);
            Node targetMap = nodeMapping.get(target);
            ToggleSyncEdge.performOperation(session, subprocess, sourceMap, targetMap, null);
        }
    }

    protected static void removeFragment(SessionToken session, ChangePrimitives processGraph, Template template, Node first, Node last, Collection<Node> removedNodes) {
        if (first.getID() == last.getID()) {
            DeleteNode.performOperation(session, processGraph, first, template.getNodeType(first.getID()), null);
        } else {
            int[] nodeIDsInArea = ProcessModelTools.getNodesInArea(first.getID(), last.getID(), false, template, true);
            nodeIDsInArea = Arrays.copyOf(nodeIDsInArea, nodeIDsInArea.length + 2);
            nodeIDsInArea[nodeIDsInArea.length - 2] = first.getID();
            nodeIDsInArea[nodeIDsInArea.length - 1] = last.getID();
            int[] nArray = nodeIDsInArea;
            int n = nodeIDsInArea.length;
            int n2 = 0;
            while (n2 < n) {
                int nodeID = nArray[n2];
                Node node = template.getNode(nodeID);
                if (node != null) {
                    switch (template.getNodeType(nodeID)) {
                        case NT_NORMAL: {
                            DeleteNode.performOperation(session, processGraph, node, template.getNodeType(node.getID()), null);
                            removedNodes.add(node);
                            break;
                        }
                        case NT_AND_SPLIT: 
                        case NT_XOR_SPLIT: {
                            int[] branchStartNodeIDs = template.getSuccByEdgeType(node.getID(), ProcessConstants.EdgeType.ET_CONTROL);
                            int blockEndNodeID = template.getNodeCorrespondingBlockNodeID(node.getID());
                            Node blockEndNode = template.getNode(blockEndNodeID);
                            int[] nArray2 = branchStartNodeIDs;
                            int n3 = branchStartNodeIDs.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                int branchStartNodeID = nArray2[n4];
                                if (branchStartNodeID != blockEndNodeID) {
                                    int branchEndNodeID = ProcessModelTools.getBranchEndNode(template, node.getID(), template.getNodeBranchID(branchStartNodeID));
                                    Node branchStartNode = template.getNode(branchStartNodeID);
                                    Node branchEndNode = template.getNode(branchEndNodeID);
                                    ExtractSubprocess.removeFragment(session, processGraph, template, branchStartNode, branchEndNode, removedNodes);
                                }
                                if (DeleteEmptyBranch.isPossible(template, node, blockEndNode)) {
                                    DeleteEmptyBranch.performOperation(processGraph, node, blockEndNode, null);
                                }
                                ++n4;
                            }
                            DeleteBorderNodes.performOperation(session, processGraph, node, blockEndNode, null);
                            removedNodes.add(node);
                            removedNodes.add(blockEndNode);
                            break;
                        }
                        case NT_STARTLOOP: {
                            int[] branchStartNodeIDs = template.getSuccByEdgeType(node.getID(), ProcessConstants.EdgeType.ET_CONTROL);
                            int blockEndNodeID = template.getNodeCorrespondingBlockNodeID(node.getID());
                            Node blockEndNode = template.getNode(blockEndNodeID);
                            int[] branchEndNodeIDs = template.getPredByEdgeType(blockEndNodeID, ProcessConstants.EdgeType.ET_CONTROL);
                            Node branchStartNode = template.getNode(branchStartNodeIDs[0]);
                            Node branchEndNode = template.getNode(branchEndNodeIDs[0]);
                            ExtractSubprocess.removeFragment(session, processGraph, template, branchStartNode, branchEndNode, removedNodes);
                            DeleteBorderNodes.performOperation(session, processGraph, node, blockEndNode, null);
                            removedNodes.add(node);
                            removedNodes.add(blockEndNode);
                            break;
                        }
                        case NT_AND_JOIN: 
                        case NT_XOR_JOIN: 
                        case NT_ENDLOOP: {
                            break;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private static void recursivelyCopyBasicProcessStructure(SessionToken session, ProcessModelFactory pmf, SubprocessMapping processMapping, Node fragmentStart, Node fragmentEnd, Node predecessorNode, Node successorNode) {
        Template sourceTemplate = processMapping.sourceTemplate;
        ChangeableTemplate targetTemplate = processMapping.targetTemplate;
        Map<Node, Node> mapping = processMapping.nodeMapping;
        Node lastProcessed = null;
        Node toBeProcessed = fragmentStart;
        Node currentTargetPredecessor = predecessorNode;
        while (lastProcessed != fragmentEnd) {
            ProcessConstants.NodeType nodeType = sourceTemplate.getNodeType(toBeProcessed.getID());
            switch (nodeType) {
                case NT_NORMAL: {
                    Node newNode = InsertNode.performOperation(session, targetTemplate, currentTargetPredecessor, successorNode);
                    ExtractSubprocess.updateNodeFromNode(session, pmf, targetTemplate, toBeProcessed, newNode);
                    int[] succs = sourceTemplate.getSuccByEdgeType(toBeProcessed.getID(), ProcessConstants.EdgeType.ET_CONTROL);
                    if (succs.length != 1) {
                        throw new RuntimeException();
                    }
                    mapping.put(toBeProcessed, newNode);
                    lastProcessed = toBeProcessed;
                    toBeProcessed = sourceTemplate.getNode(succs[0]);
                    currentTargetPredecessor = newNode;
                    break;
                }
                case NT_AND_SPLIT: 
                case NT_XOR_SPLIT: 
                case NT_STARTLOOP: {
                    int[] succs;
                    ProcessConstants.BlockType blockType;
                    int currentJoinNodeID = sourceTemplate.getNodeCorrespondingBlockNodeID(toBeProcessed.getID());
                    Node currentJoinNode = sourceTemplate.getNode(currentJoinNodeID);
                    if (ProcessConstants.NodeType.NT_AND_SPLIT.equals((Object)nodeType)) {
                        blockType = ProcessConstants.BlockType.AND_BLOCK;
                    } else if (ProcessConstants.NodeType.NT_XOR_SPLIT.equals((Object)nodeType)) {
                        blockType = ProcessConstants.BlockType.OR_BLOCK;
                    } else if (ProcessConstants.NodeType.NT_STARTLOOP.equals((Object)nodeType)) {
                        blockType = ProcessConstants.BlockType.LOOP_BLOCK;
                    } else {
                        throw new IllegalArgumentException();
                    }
                    Node[] blockNodes = InsertEmptyBlock.performOperation(session, targetTemplate, currentTargetPredecessor, successorNode, blockType);
                    Node newSplitNode = blockNodes[0];
                    Node newJoinNode = blockNodes[1];
                    ExtractSubprocess.updateNodeFromNode(session, pmf, targetTemplate, toBeProcessed, newSplitNode);
                    ExtractSubprocess.updateNodeFromNode(session, pmf, targetTemplate, currentJoinNode, newJoinNode);
                    mapping.put(toBeProcessed, newSplitNode);
                    mapping.put(currentJoinNode, newJoinNode);
                    int[] branchStartNodeIDs = sourceTemplate.getSuccByEdgeType(toBeProcessed.getID(), ProcessConstants.EdgeType.ET_CONTROL);
                    boolean first = true;
                    boolean emptyEdge = false;
                    int[] nArray = branchStartNodeIDs;
                    int n = branchStartNodeIDs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int branchStartNodeID = nArray[n2];
                        if (branchStartNodeID != currentJoinNodeID) {
                            if (!first) {
                                InsertEmptyBranch.performOperation(session, targetTemplate, newSplitNode, newJoinNode);
                            }
                            int branchEndNodeID = ProcessModelTools.getBranchEndNode(sourceTemplate, toBeProcessed.getID(), sourceTemplate.getNodeBranchID(branchStartNodeID));
                            Node branchStartNode = sourceTemplate.getNode(branchStartNodeID);
                            Node branchEndNode = sourceTemplate.getNode(branchEndNodeID);
                            ExtractSubprocess.recursivelyCopyBasicProcessStructure(session, pmf, processMapping, branchStartNode, branchEndNode, newSplitNode, newJoinNode);
                            first = false;
                        } else {
                            emptyEdge = true;
                        }
                        ++n2;
                    }
                    if (emptyEdge && !first) {
                        InsertEmptyBranch.performOperation(session, targetTemplate, newSplitNode, newJoinNode);
                    }
                    if ((succs = sourceTemplate.getSuccByEdgeType(currentJoinNode.getID(), ProcessConstants.EdgeType.ET_CONTROL)).length != 1) {
                        throw new RuntimeException();
                    }
                    lastProcessed = currentJoinNode;
                    toBeProcessed = sourceTemplate.getNode(succs[0]);
                    currentTargetPredecessor = newJoinNode;
                    break;
                }
                case NT_AND_JOIN: 
                case NT_XOR_JOIN: 
                case NT_ENDLOOP: {
                    throw new RuntimeException();
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    private static void updateNodeFromNode(SessionToken session, ProcessModelFactory pmf, ChangeableTemplate targetTemplate, Node nodeToUpdateFrom, Node nodeToUpdate) {
        Node splitCloneNode = ExtractSubprocess.cloneNode(pmf, nodeToUpdateFrom, nodeToUpdate.getID());
        UpdateNode.performOperation(targetTemplate, splitCloneNode, ProcessConstants.NodeProperty.NAME, ProcessConstants.NodeProperty.AUTO_START, ProcessConstants.NodeProperty.DESCRIPTION, ProcessConstants.NodeProperty.STAFF_ASSIGNMENT_RULE);
        ExtractSubprocess.copyPluginData(targetTemplate, nodeToUpdateFrom, nodeToUpdate);
        ExtractSubprocess.copyUserAttributes(targetTemplate, nodeToUpdateFrom, nodeToUpdate);
    }

    private static Node cloneNode(ProcessModelFactory pmf, Node node, int newID) {
        HashMap<ActivityConstants.AccessType, Map<String, Integer>> parameterConnectorMapping = new HashMap<ActivityConstants.AccessType, Map<String, Integer>>();
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.AccessType accessType = accessTypeArray[n2];
            parameterConnectorMapping.put(accessType, new HashMap<String, Integer>(node.getConnectorMapping(accessType)));
            ++n2;
        }
        HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>> nodeParameters = new HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>>();
        ActivityConstants.AccessType[] accessTypeArray2 = ActivityConstants.AccessType.systemRelatedValues();
        int n3 = accessTypeArray2.length;
        n = 0;
        while (n < n3) {
            ActivityConstants.AccessType accessType = accessTypeArray2[n];
            nodeParameters.put(accessType, node.getSystemParameters(accessType));
            ++n;
        }
        return pmf.createNode(newID, node.getName(), node.getDescription(), node.getStaffAssignmentRule(), node.getExecutableBusinessProcess(), node.isAutoStartEnabled(), node.getIconID(), parameterConnectorMapping, nodeParameters, node.getSupportedPlugins(), node.getPluginDatas(), node.getUserAttributes());
    }

    private static QualifiedAgent getQualifiedAgent(SessionToken session, Template template) {
        return template.getSupervisorAgent();
    }

    private static boolean enoughParameter(Node first, Node last, Template template, CheckReport checkReport) {
        if (first == null || last == null) {
            if (checkReport != null) {
                String message = "Not enough selected nodes for this operation. The block to extract specified by first is needed.";
                checkReport.addReportEntry(CHECK_ID1, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(first.getID()) == null || template.getNode(last.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain one or more of the necessary nodes for a move operation.";
                checkReport.addReportEntry(CHECK_ID1, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }

    private static final class SubprocessMapping {
        public Template sourceTemplate;
        public ChangeableTemplate targetTemplate;
        public Map<Node, Node> nodeMapping = new HashMap<Node, Node>();
        public Map<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>> dataEdgesToBeReconnected = new HashMap<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>>(4);
        public Map<Integer, Integer> dataElementIDMapping = new HashMap<Integer, Integer>();
        public Set<DataElement> dataElementsToMove = new HashSet<DataElement>();
        public Set<DataElement> dataElementsToCopy = new HashSet<DataElement>();

        public SubprocessMapping(Template template, ChangePrimitives processGraph, ChangeableTemplate subprocess) {
            this.sourceTemplate = template;
            this.targetTemplate = subprocess;
        }
    }
}

