/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashSet;
import java.util.logging.Logger;

public class InsertConstraintEdge {
    protected static final Logger logger = LoggerTools.getLogger(InsertConstraintEdge.class);
    private static final String CHECK_ID = "Insert Constraint Edge";

    public static boolean isPossible(Template template, Node pred, Node succ) {
        return InsertConstraintEdge.isPossible(template, pred, succ, null);
    }

    public static boolean isPossible(Template template, Node pred, Node succ, CheckReport checkReport) {
        if (!InsertConstraintEdge.enoughParameter(pred, succ, template, checkReport)) {
            return false;
        }
        if (pred.getID() == succ.getID()) {
            if (checkReport != null) {
                String message = String.format("The given nodes '%1$s', '%2$s' are equal.", ChangeOperationTools.getHumanReadableNodeName(pred), ChangeOperationTools.getHumanReadableNodeName(succ));
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), pred), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        if (template.getConstraintEdge(pred.getID(), succ.getID()) != null) {
            if (checkReport != null) {
                String message = String.format("There is already a constraint edge between the node '%1$s' and the node '%2$s'.", ChangeOperationTools.getHumanReadableNodeName(pred), ChangeOperationTools.getHumanReadableNodeName(succ));
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), pred), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        NodeRelations relations = new NodeRelations(template);
        NodeRelations.NodeRelation nodeRelation = relations.getNodeRelation(pred.getID(), succ.getID());
        if (NodeRelations.NodeRelation.EXCLUSIVE.equals((Object)nodeRelation)) {
            if (checkReport != null) {
                URI affectedElements = ProcessElementIdentifierTools.getConstraintEdgeIdentifier(checkReport.getBase(), pred, succ);
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, "Constraint edge cannot connect two elements which are executed exclusive!", affectedElements);
            }
            return false;
        }
        if (NodeRelations.NodeRelation.AFTER.equals((Object)nodeRelation)) {
            HashSet<Node> nodes = new HashSet<Node>();
            nodes.add(pred);
            nodes.add(succ);
            int[] minBlock = template.getMinBlock(nodes);
            int splitNode = minBlock[0];
            ProcessConstants.NodeType split = template.getNodeType(splitNode);
            while (!ProcessConstants.NodeType.NT_STARTLOOP.equals((Object)split) && !ProcessConstants.NodeType.NT_STARTFLOW.equals((Object)split)) {
                splitNode = template.getNodeSplitNodeID(splitNode);
                split = template.getNodeType(splitNode);
            }
            if (ProcessConstants.NodeType.NT_STARTFLOW.equals((Object)split)) {
                if (checkReport != null) {
                    URI affectedElements = ProcessElementIdentifierTools.getConstraintEdgeIdentifier(checkReport.getBase(), pred, succ);
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, "Constraint edge contradicts control flow!", affectedElements);
                }
                return false;
            }
        }
        return true;
    }

    private boolean nodesAreInALoop(ChangeableTemplate model, Node pred, Node succ) {
        HashSet<Node> nodes = new HashSet<Node>();
        nodes.add(pred);
        nodes.add(succ);
        int minStartNodeId = model.getMinBlock(nodes)[0];
        while (!model.getNodeType(minStartNodeId).equals((Object)ProcessConstants.NodeType.NT_STARTLOOP)) {
            minStartNodeId = this.getDirectPredOfNode(model, succ).getID();
            if (model.getStartNode().getID() == minStartNodeId) {
                return false;
            }
            succ = this.getDirectPredOfNode(model, succ);
        }
        return model.getNodeTopologicalID(pred.getID()) < model.getNodeTopologicalID(model.getNodeCorrespondingBlockNodeID(minStartNodeId));
    }

    private Node getDirectPredOfNode(ChangeableTemplate model, Node node) {
        int[] preds = model.getPredByEdgeType(node.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        return model.getNode(preds[0]);
    }

    public static boolean isPossible(ChangeableInstance instance, Node pred, Node succ) {
        return InsertConstraintEdge.isPossible(instance, pred, succ, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node pred, Node succ, CheckReport checkReport) {
        if (!InsertConstraintEdge.enoughParameter(pred, succ, instance.getTemplate(), checkReport)) {
            return false;
        }
        Template template = instance.getTemplate();
        if (instance.getNodeState(succ.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(succ.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = String.format("The node '%1$s' given as target for the constraint-edge must be ACTIVATED or NOT_ACTIVATED, but it is in state: %2$s.", ChangeOperationTools.getHumanReadableNodeName(succ), instance.getNodeState(succ.getID()).toString());
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ, "NodeState")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return InsertConstraintEdge.isPossible(template, pred, succ, checkReport);
    }

    public static ConstraintEdge performOperation(SessionToken session, ChangeableTemplate template, Node pred, Node succ) {
        return InsertConstraintEdge.performOperation(session, template, pred, succ, null);
    }

    public static ConstraintEdge performOperation(SessionToken session, ChangeableTemplate template, Node pred, Node succ, UpdateManager updateManager) {
        return InsertConstraintEdge.performOperation(session, (ChangePrimitives)template, pred, succ, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node pred, Node succ) {
        InsertConstraintEdge.performOperation(session, instance, pred, succ, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node pred, Node succ, UpdateManager updateManager) {
        InsertConstraintEdge.performOperation(session, (ChangePrimitives)instance, pred, succ, updateManager);
        instance.setNodeState(succ.getID(), ProcessConstants.NodeState.NS_NOT_ACTIVATED);
        if (updateManager != null) {
            ChangeOperationTools.fireNodeStateChangedEvent(updateManager, instance, succ);
        }
    }

    protected static ConstraintEdge performOperation(SessionToken session, ChangePrimitives processGraph, Node pred, Node succ, UpdateManager updateManager) {
        ConstraintEdge newConstraintEdge = ChangeOperationTools.createConstraintEdgeObject(session);
        logger.info("calling ChangePrimitive addConstraintEdge");
        ConstraintEdge constraintEdge = processGraph.addConstraintEdge(pred.getID(), succ.getID(), newConstraintEdge);
        if (updateManager != null) {
            updateManager.firePropertyChange(pred, (Object)UpdateManager.NodeProperties.NODE_OUT_EDGES);
            updateManager.firePropertyChange(succ, (Object)UpdateManager.NodeProperties.NODE_IN_EDGES);
        }
        return constraintEdge;
    }

    private static boolean enoughParameter(Node pred, Node succ, Template template, CheckReport checkReport) {
        if (pred == null || succ == null) {
            if (checkReport != null) {
                String message = "Not enough selected nodes for this operation. A node as constraint-edge-start and a node as constraint-edge-end are needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(pred.getID()) == null || template.getNode(succ.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain one or both of the source/target nodes.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

