/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.UpdateDataEdge;
import de.aristaflow.adept2.core.changeoperations.UpdateDataElement;
import de.aristaflow.adept2.core.changeoperations.UpdateInstance;
import de.aristaflow.adept2.core.changeoperations.UpdateTemplate;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

public class InsertDataEdge {
    private static final String MY_INSTANCE_NAME = "InsertDataEdge";
    protected static final Logger logger = LoggerTools.getLogger(InsertDataEdge.class);
    private static final String CHECK_ID = "Insert Data Edge";

    public static boolean isPossible(Template template, Node node, DataElement dataElement, ActivityConstants.AccessType type) {
        return InsertDataEdge.isPossible(template, node, dataElement, type, null);
    }

    public static boolean isPossible(Template template, Node node, DataElement dataElement, ActivityConstants.AccessType type, CheckReport checkReport) {
        ProcessConstants.TemplateProperty property;
        ProcessConstants.NodeType nodeType2;
        ProcessConstants.NodeType nodeType1;
        String message2;
        String message1;
        if (!InsertDataEdge.enoughParameter(node, dataElement, type, template, checkReport)) {
            return false;
        }
        ProcessConstants.NodeType nodeType = template.getNodeType(node.getID());
        if (nodeType == ProcessConstants.NodeType.NT_AND_SPLIT || nodeType == ProcessConstants.NodeType.NT_AND_JOIN || nodeType == ProcessConstants.NodeType.NT_XOR_JOIN || nodeType == ProcessConstants.NodeType.NT_STARTLOOP) {
            if (checkReport != null) {
                String message = "A node of type '" + nodeType.toString() + "' can't have in- or outgoing data edges.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        switch (type) {
            case READ: 
            case SYSTEM_READ: {
                message1 = "There is a data edge of type '" + type.toString() + "' between the data element '" + dataElement.getName() + "' and the node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' already.";
                message2 = "The node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' is the start node of the process. It can not read data elements.";
                nodeType1 = ProcessConstants.NodeType.NT_STARTFLOW;
                nodeType2 = ProcessConstants.NodeType.NT_ENDFLOW;
                property = ProcessConstants.TemplateProperty.OUTPUT_PARAMETER;
                break;
            }
            case WRITE: 
            case SYSTEM_WRITE: {
                message1 = "There is a data edge of type '" + type.toString() + "' between the node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' and the data element '" + dataElement.getName() + "' already.";
                message2 = "The node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' is the end node of the process. It can not write data elements.";
                nodeType1 = ProcessConstants.NodeType.NT_ENDFLOW;
                nodeType2 = ProcessConstants.NodeType.NT_STARTFLOW;
                property = ProcessConstants.TemplateProperty.INPUT_PARAMETER;
                break;
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
        int[] nArray = template.getAccessedDataElementIDsForNode(node.getID(), type);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int dataElementID = nArray[n2];
            if (dataElementID == dataElement.getID()) {
                if (checkReport != null) {
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getDataEdgeIdentifier(checkReport.getBase(), node, dataElement, type)};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message1, affectedElements);
                }
                return false;
            }
            ++n2;
        }
        if (template.getNodeType(node.getID()) == nodeType1) {
            if (checkReport != null) {
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message2, affectedElements);
            }
            return false;
        }
        if (template.getNodeType(node.getID()) == nodeType2 && !UpdateTemplate.isPossible(template.getID(), checkReport, property)) {
            return false;
        }
        switch (type) {
            case READ: 
            case WRITE: {
                if (node.getExecutableBusinessProcess() == null) break;
                Set<ProcessModelParameter> freeParams = InsertDataEdge.getFreeCompliantParameters(template, node, dataElement, type);
                if (freeParams.size() == 1) {
                    return true;
                }
                if (checkReport != null) {
                    String message = null;
                    message = freeParams.size() == 0 ? "The node does have an assigned EBP already, but the EBP does not have any free input-/output parameters which are compatible to the data element which should be connected to the node" : "The EBP has more than a single free input-/output parameter which are compatible to the data element which should be connected to the node. Mapping is ambiguous.";
                    ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getEBPIdentifier(checkReport.getBase(), node, ebp)};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                return false;
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                if (InsertDataEdge.getFreeCompliantParameters(template, node, dataElement, type).size() > 0) {
                    return true;
                }
                if (checkReport != null) {
                    String message = "The node does not have a compatible system parameter for the given data element or the compatible parameter is already connected to another data element";
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                return false;
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
        return true;
    }

    public static boolean isPossible(Template template, Node node, DataElement[] dataElements, ActivityConstants.AccessType type) {
        return InsertDataEdge.isPossible(template, node, dataElements, type, null);
    }

    public static boolean isPossible(Template template, Node node, DataElement[] dataElements, ActivityConstants.AccessType type, CheckReport checkReport) {
        DataElement[] dataElementArray = dataElements;
        int n = dataElements.length;
        int n2 = 0;
        while (n2 < n) {
            DataElement dataElement = dataElementArray[n2];
            if (!InsertDataEdge.isPossible(template, node, dataElement, type, checkReport)) {
                return false;
            }
            ++n2;
        }
        if (node.getExecutableBusinessProcess() != null) {
            int[] unconnectedCons = template.getUnconnectedConnectors(node.getID(), type);
            if (unconnectedCons.length != dataElements.length) {
                if (checkReport != null) {
                    String message = "No valid elements selected for this operation. There are more data elements selected than free unconnected parameters are available.";
                    checkReport.addReportEntry("ChangeOperationAction", CheckReport.ResultType.FAILURE, message, new URI[0]);
                }
                return false;
            }
            HashSet<ProcessModelParameter> usedParams = new HashSet<ProcessModelParameter>();
            DataElement[] dataElementArray2 = dataElements;
            int n3 = dataElements.length;
            int n4 = 0;
            while (n4 < n3) {
                DataElement dataElement = dataElementArray2[n4];
                ProcessModelParameter param = InsertDataEdge.getFreeCompliantParameters(template, node, dataElement, type).iterator().next();
                if (usedParams.contains(param)) {
                    if (checkReport != null) {
                        String message = "No valid elements selected for this operation. There are not enough compliant unconnected parameters for the selected data elements.";
                        checkReport.addReportEntry("ChangeOperationAction", CheckReport.ResultType.FAILURE, message, new URI[0]);
                    }
                    return false;
                }
                usedParams.add(param);
                ++n4;
            }
        }
        return true;
    }

    public static boolean isPossible(Template template, Node node, DataElement dataElement, String paramName, ActivityConstants.AccessType type) {
        return InsertDataEdge.isPossible(template, node, dataElement, paramName, type, null);
    }

    public static boolean isPossible(Template template, Node node, DataElement dataElement, String paramName, ActivityConstants.AccessType type, CheckReport checkReport) {
        ProcessModelParameter tempParameter = null;
        switch (type) {
            case READ: 
            case WRITE: {
                if (node.getExecutableBusinessProcess() == null) {
                    if (checkReport != null) {
                        String message = "The node does not even have an assigned EBP. Therefore the given parameter with the name '" + paramName + "' does not exist";
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                    }
                    return false;
                }
                if (node.getExecutableBusinessProcess().getParameter(paramName, type) == null) {
                    if (checkReport != null) {
                        String message = "The EBP on the given node does not have a parameter with the name '" + paramName + "'";
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                    }
                    return false;
                }
                tempParameter = node.getExecutableBusinessProcess().getParameter(paramName, type);
                break;
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                if (node.getSystemParameter(paramName, type) == null) {
                    if (checkReport != null) {
                        String message = "The node does not contain a system parameter with the name '" + paramName + "'";
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                    }
                    return false;
                }
                tempParameter = node.getSystemParameter(paramName, type);
                break;
            }
            default: {
                String msg = String.format("An unexpected access type '%s' occurred!", new Object[]{type});
                logger.warning(msg);
            }
        }
        int connectorID = node.getConnector(paramName, type);
        int[] freeCons = template.getUnconnectedConnectors(node.getID(), type);
        boolean unconnected = false;
        int[] nArray = freeCons;
        int n = freeCons.length;
        int n2 = 0;
        while (n2 < n) {
            int tempFreeCon = nArray[n2];
            if (connectorID == tempFreeCon) {
                unconnected = true;
                break;
            }
            ++n2;
        }
        if (!unconnected) {
            if (checkReport != null) {
                String message = "The parameter with the name '" + paramName + "' is already connected.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        if (!InsertDataEdge.checkMappingCompliance(dataElement, tempParameter)) {
            if (checkReport != null) {
                String message = "The parameter with the name '" + paramName + "' is not compatible with the given data element '" + dataElement + "'";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node), ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), dataElement)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return InsertDataEdge.isPossible(template, node, dataElement, type, checkReport);
    }

    public static boolean isPossible(ChangeableInstance instance, Node node, DataElement dataElement, ActivityConstants.AccessType type) {
        return InsertDataEdge.isPossible(instance, node, dataElement, type, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node node, DataElement dataElement, ActivityConstants.AccessType type, CheckReport checkReport) {
        if (!InsertDataEdge.enoughParameter(node, dataElement, type, instance.getTemplate(), checkReport)) {
            return false;
        }
        if (!InsertDataEdge.stateBasedConditions(instance, node, checkReport)) {
            return false;
        }
        if (!InsertDataEdge.checkProcessParameter(instance, node, checkReport)) {
            return false;
        }
        return InsertDataEdge.isPossible(instance.getTemplate(), node, dataElement, type, checkReport);
    }

    public static boolean isPossible(ChangeableInstance instance, Node node, DataElement[] dataElements, ActivityConstants.AccessType type) {
        return InsertDataEdge.isPossible(instance, node, dataElements, type, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node node, DataElement[] dataElements, ActivityConstants.AccessType type, CheckReport checkReport) {
        DataElement[] dataElementArray = dataElements;
        int n = dataElements.length;
        int n2 = 0;
        while (n2 < n) {
            DataElement dataElement = dataElementArray[n2];
            if (!InsertDataEdge.enoughParameter(node, dataElement, type, instance.getTemplate(), checkReport)) {
                return false;
            }
            ++n2;
        }
        if (!InsertDataEdge.stateBasedConditions(instance, node, checkReport)) {
            return false;
        }
        if (!InsertDataEdge.checkProcessParameter(instance, node, checkReport)) {
            return false;
        }
        return InsertDataEdge.isPossible(instance.getTemplate(), node, dataElements, type, checkReport);
    }

    public static boolean isPossible(ChangeableInstance instance, Node node, DataElement dataElement, String paramName, ActivityConstants.AccessType type) {
        return InsertDataEdge.isPossible(instance, node, dataElement, paramName, type, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node node, DataElement dataElement, String paramName, ActivityConstants.AccessType type, CheckReport checkReport) {
        if (!InsertDataEdge.stateBasedConditions(instance, node, checkReport)) {
            return false;
        }
        if (!InsertDataEdge.checkProcessParameter(instance, node, checkReport)) {
            return false;
        }
        return InsertDataEdge.isPossible(instance.getTemplate(), node, dataElement, paramName, type, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node node, DataElement dataElement, ProcessModelParameter parameter, ActivityConstants.AccessType type) {
        InsertDataEdge.performOperation(session, template, node, dataElement, parameter, type, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node node, DataElement dataElement, ProcessModelParameter parameter, ActivityConstants.AccessType type, UpdateManager updateManager) {
        InsertDataEdge.performOperation(session, (ChangePrimitives)template, node, dataElement, parameter, type, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node node, DataElement dataElement, ActivityConstants.AccessType type) {
        InsertDataEdge.performOperation(session, template, node, dataElement, type, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node node, DataElement dataElement, ActivityConstants.AccessType type, UpdateManager updateManager) {
        InsertDataEdge.performOperation(session, (ChangePrimitives)template, node, dataElement, type, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangeableTemplate template, Node node, DataElement dataElement, ProcessModelParameter param, int connectorID, ActivityConstants.AccessType type, UpdateManager updateManager) {
        InsertDataEdge.performOperation(session, (ChangePrimitives)template, node, dataElement, param, connectorID, type, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node node, DataElement dataElement, ProcessModelParameter parameter, ActivityConstants.AccessType type) {
        InsertDataEdge.performOperation(session, instance, node, dataElement, parameter, type, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node node, DataElement dataElement, ProcessModelParameter parameter, ActivityConstants.AccessType type, UpdateManager updateManager) {
        InsertDataEdge.performOperation(session, (ChangePrimitives)instance, node, dataElement, parameter, type, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node node, DataElement dataElement, ActivityConstants.AccessType type) {
        InsertDataEdge.performOperation(session, instance, node, dataElement, type, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node node, DataElement dataElement, ActivityConstants.AccessType type, UpdateManager updateManager) {
        InsertDataEdge.performOperation(session, (ChangePrimitives)instance, node, dataElement, type, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangeableInstance instance, Node node, DataElement dataElement, ProcessModelParameter param, int connectorID, ActivityConstants.AccessType type, UpdateManager updateManager) {
        InsertDataEdge.performOperation(session, (ChangePrimitives)instance, node, dataElement, param, connectorID, type, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, Node node, DataElement dataElement, ActivityConstants.AccessType type, UpdateManager updateManager) {
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        logger.info("calling ChangePrimitive addDataEdge");
        DataEdge dataEdge = ChangeOperationTools.createSimpleDataEdgeObject(session, type);
        switch (type) {
            case READ: 
            case WRITE: {
                if (node.getExecutableBusinessProcess() == null) {
                    processGraph.addDataEdge(node.getID(), dataElement.getID(), dataEdge);
                    if (updateManager != null) {
                        InsertDataEdge.callUpdateManager(node, dataElement, type, updateManager);
                    }
                    if (template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_STARTFLOW)) {
                        InsertDataEdge.addProcessInputParameter(session, processGraph, dataElement, updateManager);
                        break;
                    }
                    if (!template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_ENDFLOW)) break;
                    InsertDataEdge.addProcessOutputParameter(session, processGraph, dataElement, updateManager);
                    break;
                }
                Set<ProcessModelParameter> freeParams = InsertDataEdge.getFreeCompliantParameters(template, node, dataElement, type);
                assert (freeParams.size() != 0);
                ProcessModelParameter param = freeParams.iterator().next();
                InsertDataEdge.performOperation(session, processGraph, node, dataElement, param, type, updateManager);
                break;
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                Set<ProcessModelParameter> freeParams = InsertDataEdge.getFreeCompliantParameters(template, node, dataElement, type);
                assert (freeParams.size() != 0);
                ProcessModelParameter param = freeParams.iterator().next();
                InsertDataEdge.performOperation(session, processGraph, node, dataElement, param, type, updateManager);
                break;
            }
            default: {
                String msg = String.format("An unexpected access type '%s' occurred!", new Object[]{type});
                logger.warning(msg);
            }
        }
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, Node node, DataElement dataElement, ProcessModelParameter parameter, ActivityConstants.AccessType type, UpdateManager updateManager) {
        int connectorID = node.getConnector(parameter.getName(), type);
        InsertDataEdge.performOperation(session, processGraph, node, dataElement, parameter, connectorID, type, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, Node node, DataElement dataElement, ProcessModelParameter param, int connectorID, ActivityConstants.AccessType type, UpdateManager updateManager) {
        int[] disabledConnectors;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        DataEdge dataEdge = ChangeOperationTools.createSimpleDataEdgeObject(session, type);
        int[] nArray = disabledConnectors = template.getDisabledConnectors(node.getID(), type);
        int n = disabledConnectors.length;
        int n2 = 0;
        while (n2 < n) {
            int disabledConnectorID = nArray[n2];
            if (disabledConnectorID == connectorID) {
                processGraph.removeDisabledConnector(node.getID(), connectorID);
                break;
            }
            ++n2;
        }
        logger.info("calling ChangePrimitive addDataEdge");
        processGraph.addDataEdge(node.getID(), connectorID, dataElement.getID(), dataEdge);
        if (dataElement.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET)) {
            ProcessModelFactory pmf;
            UUID paramIdentifierID = param.getIdentifierID();
            try {
                pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
            }
            catch (ServiceNotKnownException snke) {
                throw new RTServiceNotKnownException(snke);
            }
            DataElement tempDataElement = pmf.createDataElement(dataElement.getID(), dataElement.getName(), dataElement.getDataType(), dataElement.getDescription(), dataElement.getUDTName(), dataElement.getIconID(), paramIdentifierID, dataElement.isPublic(), dataElement.isVirtual(), dataElement.getSupportedPlugins(), dataElement.getPluginDatas(), dataElement.getUserAttributes());
            UpdateDataElement.performOperation(session, processGraph, tempDataElement, updateManager, ProcessConstants.DataElementProperty.IDENTIFIER);
        }
        InsertDataEdge.updateDataEdgeOptionalAttribute(session, processGraph, node.getID(), type, updateManager, dataElement.getID(), param);
        if (updateManager != null) {
            InsertDataEdge.callUpdateManager(node, dataElement, type, updateManager);
        }
        if (type.equals((Object)ActivityConstants.AccessType.READ) || type.equals((Object)ActivityConstants.AccessType.WRITE)) {
            if (template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_STARTFLOW)) {
                InsertDataEdge.addProcessInputParameter(session, processGraph, dataElement, updateManager);
            } else if (template.getNodeType(node.getID()).equals((Object)ProcessConstants.NodeType.NT_ENDFLOW)) {
                InsertDataEdge.addProcessOutputParameter(session, processGraph, dataElement, updateManager);
            }
        }
    }

    private static void callUpdateManager(Node node, DataElement dataElement, ActivityConstants.AccessType type, UpdateManager updateManager) {
        switch (type) {
            case READ: {
                updateManager.firePropertyChange(node, (Object)UpdateManager.NodeProperties.NODE_IN_DATA);
                updateManager.firePropertyChange(dataElement, (Object)UpdateManager.DataElementProperties.DE_READERS);
                break;
            }
            case WRITE: {
                updateManager.firePropertyChange(node, (Object)UpdateManager.NodeProperties.NODE_OUT_DATA);
                updateManager.firePropertyChange(dataElement, (Object)UpdateManager.DataElementProperties.DE_WRITERS);
                break;
            }
            case SYSTEM_READ: {
                updateManager.firePropertyChange(node, (Object)UpdateManager.NodeProperties.NODE_IN_DATA);
                updateManager.firePropertyChange(dataElement, (Object)UpdateManager.DataElementProperties.DE_SYSTEM_READERS);
                break;
            }
            case SYSTEM_WRITE: {
                updateManager.firePropertyChange(node, (Object)UpdateManager.NodeProperties.NODE_OUT_DATA);
                updateManager.firePropertyChange(dataElement, (Object)UpdateManager.DataElementProperties.DE_SYSTEM_WRITERS);
                break;
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
    }

    private static Set<ProcessModelParameter> getFreeCompliantParameters(Template template, Node node, DataElement dataElement, ActivityConstants.AccessType type) {
        HashSet<ProcessModelParameter> freeParams = new HashSet<ProcessModelParameter>();
        int[] unconIDs = template.getUnconnectedConnectors(node.getID(), type);
        switch (type) {
            case READ: 
            case WRITE: {
                int[] nArray = unconIDs;
                int n = unconIDs.length;
                int n2 = 0;
                while (n2 < n) {
                    int unconID = nArray[n2];
                    ProcessModelParameter param = node.getExecutableBusinessProcess().getParameter(node.getParameterName(unconID), type);
                    if (InsertDataEdge.checkMappingCompliance(dataElement, param)) {
                        freeParams.add(param);
                    }
                    ++n2;
                }
                break;
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                int[] nArray = unconIDs;
                int n = unconIDs.length;
                int n3 = 0;
                while (n3 < n) {
                    int unconID = nArray[n3];
                    ProcessModelParameter param = node.getSystemParameter(node.getParameterName(unconID), type);
                    if (InsertDataEdge.checkMappingCompliance(dataElement, param)) {
                        freeParams.add(param);
                    }
                    ++n3;
                }
                break;
            }
        }
        return freeParams;
    }

    private static boolean checkMappingCompliance(DataElement dataElement, ProcessModelParameter param) {
        if (param.getDataType() == dataElement.getDataType() && param.isVirtual() == dataElement.isVirtual() && (param.getIdentifierID().equals(dataElement.getIdentifierID()) || dataElement.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) || dataElement.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET))) {
            return param.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED || param.getUDTName().equals(dataElement.getUDTName());
        }
        return false;
    }

    private static void updateDataEdgeOptionalAttribute(SessionToken session, ChangePrimitives processGraph, int nodeID, ActivityConstants.AccessType type, UpdateManager updateManager, int dataElementID, ProcessModelParameter parameter) {
        ProcessModelFactory pmf;
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        DataEdge dummyDataEdge = parameter.isOptional() ? pmf.createDataEdge(type, true, new HashMap<String, String>()) : pmf.createDataEdge(type, false, new HashMap<String, String>());
        UpdateDataEdge.performOperation(session, processGraph, nodeID, dataElementID, type, dummyDataEdge, updateManager, ProcessConstants.DataEdgeProperty.OPTIONAL);
    }

    private static boolean enoughParameter(Node node, DataElement dataElement, ActivityConstants.AccessType type, Template template, CheckReport checkReport) {
        if (node == null || dataElement == null || type == null) {
            if (checkReport != null) {
                String message = "Not enough selected elements for this operation. A single node and a single data element is needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, checkReport.getBase());
            }
            return false;
        }
        if (template.getNode(node.getID()) == null || template.getDataElement(dataElement.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain the data element: " + dataElement + " and/or the node: " + node;
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, checkReport.getBase());
            }
            return false;
        }
        return true;
    }

    private static void addProcessInputParameter(SessionToken session, ChangePrimitives processGraph, DataElement dataElement, UpdateManager updateManager) {
        boolean isInstance;
        String processInfo;
        Template template;
        if (processGraph instanceof ChangeableInstance) {
            template = ((ChangeableInstance)processGraph).getTemplate();
            processInfo = String.format("Instance '%s (ID = %s)'", ((ChangeableInstance)processGraph).getName(), ((ChangeableInstance)processGraph).getID());
            isInstance = true;
        } else {
            template = (ChangeableTemplate)processGraph;
            processInfo = String.format("Template '%s (ID = %s)'", template.getName(), template.getID());
            isInstance = false;
        }
        String infoMessage = String.format("Adding the new process input parameter '%s' of type '%s' to the '%s' and assign the identifier with ID = %s to it!", new Object[]{dataElement.getName(), dataElement.getDataType(), processInfo, dataElement.getIdentifierID()});
        logger.info(infoMessage);
        Set<ProcessModelParameter> processInputParameters = template.getParameters(ActivityConstants.AccessType.READ);
        HashSet<ProcessModelParameter> newProcessInputParameters = new HashSet<ProcessModelParameter>(processInputParameters);
        ProcessModelParameter newProcessInputParameter = ChangeOperationTools.createSimpleProcessParameterObject(session, dataElement.getName(), dataElement.getDataType(), dataElement.getUDTName(), dataElement.isVirtual(), dataElement.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET) ? ProcessConstants.UNIVERSAL_IDENTIFIER_ID : dataElement.getIdentifierID(), true);
        newProcessInputParameters.add(newProcessInputParameter);
        if (isInstance) {
            UpdateInstance.performOperation((ChangeableInstance)processGraph, null, null, newProcessInputParameters, null, updateManager, ProcessConstants.InstanceProperty.INPUT_PARAMETER);
        } else {
            UpdateTemplate.performOperation((ChangeableTemplate)template, null, null, null, newProcessInputParameters, null, updateManager, ProcessConstants.TemplateProperty.INPUT_PARAMETER);
        }
    }

    private static void addProcessOutputParameter(SessionToken session, ChangePrimitives processGraph, DataElement dataElement, UpdateManager updateManager) {
        boolean isInstance;
        String processInfo;
        Template template;
        if (processGraph instanceof ChangeableInstance) {
            template = ((ChangeableInstance)processGraph).getTemplate();
            processInfo = String.format("Instance '%s (ID = %s)'", ((ChangeableInstance)processGraph).getName(), ((ChangeableInstance)processGraph).getID());
            isInstance = true;
        } else {
            template = (ChangeableTemplate)processGraph;
            processInfo = String.format("Template '%s (ID = %s)'", template.getName(), template.getID());
            isInstance = false;
        }
        String infoMessage = String.format("Adding the new process output parameter '%s' of type '%s' to the %s and assign the identifier with ID = %s to it!", new Object[]{dataElement.getName(), dataElement.getDataType(), processInfo, dataElement.getIdentifierID().toString()});
        logger.info(infoMessage);
        Set<ProcessModelParameter> processOutputParameters = template.getParameters(ActivityConstants.AccessType.WRITE);
        HashSet<ProcessModelParameter> newProcessOutputParameters = new HashSet<ProcessModelParameter>(processOutputParameters);
        ProcessModelParameter newProcessOutputParameter = ChangeOperationTools.createSimpleProcessParameterObject(session, dataElement.getName(), dataElement.getDataType(), dataElement.getUDTName(), dataElement.isVirtual(), dataElement.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET) ? ProcessConstants.UNIVERSAL_IDENTIFIER_ID : dataElement.getIdentifierID(), false);
        newProcessOutputParameters.add(newProcessOutputParameter);
        if (isInstance) {
            UpdateInstance.performOperation((ChangeableInstance)processGraph, null, null, null, newProcessOutputParameters, updateManager, ProcessConstants.InstanceProperty.OUTPUT_PARAMETER);
        } else {
            UpdateTemplate.performOperation((ChangeableTemplate)template, null, null, null, null, newProcessOutputParameters, updateManager, ProcessConstants.TemplateProperty.OUTPUT_PARAMETER);
        }
    }

    private static boolean stateBasedConditions(ChangeableInstance instance, Node node, CheckReport checkReport) {
        if (instance.getNodeState(node.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(node.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' which is to be connected to the data edge must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(node.getID()).toString() + ".";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node, "NodeState")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return true;
    }

    private static boolean checkProcessParameter(ChangeableInstance instance, Node node, CheckReport checkReport) {
        Template template = instance.getTemplate();
        return !(node.getID() == template.getStartNode().getID() ? !UpdateInstance.isPossible((Instance)instance, checkReport, ProcessConstants.InstanceProperty.INPUT_PARAMETER) : node.getID() == template.getEndNode().getID() && !UpdateInstance.isPossible((Instance)instance, checkReport, ProcessConstants.InstanceProperty.OUTPUT_PARAMETER));
    }
}

