/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;

public class InsertDataElement {
    private static final String MY_INSTANCE_NAME = "InsertDataElement";
    protected static final Logger logger = LoggerTools.getLogger(InsertDataElement.class);

    public static boolean isPossible(Template template) {
        return InsertDataElement.isPossible(template, null);
    }

    public static boolean isPossible(Template template, CheckReport checkReport) {
        return true;
    }

    public static boolean isPossible(Template template, DataElement dataElement) {
        return InsertDataElement.isPossible(template, dataElement, null);
    }

    public static boolean isPossible(Template template, DataElement dataElement, CheckReport checkReport) {
        return true;
    }

    public static boolean isPossible(ChangeableInstance instance) {
        return InsertDataElement.isPossible(instance, null);
    }

    public static boolean isPossible(ChangeableInstance instance, CheckReport checkReport) {
        return true;
    }

    public static boolean isPossible(ChangeableInstance instance, DataElement dataElement) {
        return InsertDataElement.isPossible(instance, dataElement, null);
    }

    public static boolean isPossible(ChangeableInstance instance, DataElement dataElement, CheckReport checkReport) {
        return true;
    }

    public static DataElement performOperation(SessionToken session, ChangeableTemplate template) {
        return InsertDataElement.performOperation(session, template, null);
    }

    public static DataElement performOperation(SessionToken session, ChangeableTemplate template, UpdateManager updateManager) {
        return InsertDataElement.performOperation(session, (ChangePrimitives)template, updateManager);
    }

    public static DataElement performOperation(SessionToken session, ChangeableTemplate template, DataElement dataElement) {
        return InsertDataElement.performOperation(session, template, dataElement, null);
    }

    public static DataElement performOperation(SessionToken session, ChangeableTemplate template, DataElement dataElement, UpdateManager updateManager) {
        return InsertDataElement.performOperation(session, (ChangePrimitives)template, dataElement, updateManager);
    }

    public static DataElement performOperation(SessionToken session, ChangeableInstance instance) {
        return InsertDataElement.performOperation(session, instance, null);
    }

    public static DataElement performOperation(SessionToken session, ChangeableInstance instance, UpdateManager updateManager) {
        return InsertDataElement.performOperation(session, (ChangePrimitives)instance, updateManager);
    }

    public static DataElement performOperation(SessionToken session, ChangeableInstance instance, DataElement dataElement) {
        return InsertDataElement.performOperation(session, instance, dataElement, null);
    }

    public static DataElement performOperation(SessionToken session, ChangeableInstance instance, DataElement dataElement, UpdateManager updateManager) {
        DataElement newDataElement = InsertDataElement.performOperation(session, (ChangePrimitives)instance, dataElement, updateManager);
        return newDataElement;
    }

    protected static DataElement performOperation(SessionToken session, ChangePrimitives processGraph, DataElement dataElement, UpdateManager updateManager) {
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        boolean changeName = false;
        for (DataElement existentDataElement : template.getDataElements()) {
            if (!existentDataElement.getName().equals(dataElement.getName())) continue;
            changeName = true;
            break;
        }
        logger.info("calling ChangePrimitive addDataElement");
        DataElement newDataElement = processGraph.addDataElement(dataElement);
        if (changeName) {
            ProcessModelFactory pmf;
            try {
                pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
            }
            catch (ServiceNotKnownException snke) {
                throw new RTServiceNotKnownException(snke);
            }
            newDataElement = pmf.createDataElement(newDataElement.getID(), String.valueOf(newDataElement.getName()) + newDataElement.getID(), newDataElement.getDataType(), "", null, newDataElement.getIconID(), newDataElement.getIdentifierID(), newDataElement.isPublic(), newDataElement.isVirtual(), newDataElement.getSupportedPlugins(), newDataElement.getPluginDatas(), newDataElement.getUserAttributes());
            newDataElement = processGraph.updateDataElement(newDataElement, ProcessConstants.DataElementProperty.NAME);
        }
        if (updateManager != null) {
            updateManager.firePropertyChange(template, (Object)UpdateManager.ProcessProperties.PROCESS_DATA_ELEMENT);
        }
        return newDataElement;
    }

    protected static DataElement performOperation(SessionToken session, ChangePrimitives processGraph, UpdateManager updateManager) {
        ProcessModelFactory pmf;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        DataElement dataElement = ChangeOperationTools.createSimpleDataElementObject(session, "name", ProcessConstants.AdeptDataType.STRING);
        logger.info("calling ChangePrimitive addDataElement");
        DataElement newDataElement = processGraph.addDataElement(dataElement);
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        newDataElement = pmf.createDataElement(newDataElement.getID(), String.valueOf(newDataElement.getName()) + newDataElement.getID(), newDataElement.getDataType(), "", null, newDataElement.getIconID(), newDataElement.getIdentifierID(), newDataElement.isPublic(), newDataElement.isVirtual(), newDataElement.getSupportedPlugins(), newDataElement.getPluginDatas(), newDataElement.getUserAttributes());
        newDataElement = processGraph.updateDataElement(newDataElement, ProcessConstants.DataElementProperty.NAME);
        if (updateManager != null) {
            updateManager.firePropertyChange(template, (Object)UpdateManager.ProcessProperties.PROCESS_DATA_ELEMENT);
        }
        return newDataElement;
    }
}

