/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.InsertNode;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class InsertEmptyBlock {
    protected static final Logger logger = LoggerTools.getLogger(InsertEmptyBlock.class);
    private static final String MY_INSTANCE_NAME = "InsertEmptyBlock";
    private static final String CHECK_ID = "Insert Empty Block";

    public static boolean isPossible(Template template, Node pred, Node succ) {
        return InsertEmptyBlock.isPossible(template, pred, succ, null);
    }

    public static boolean isPossible(Template template, Node pred, Node succ, CheckReport checkReport) {
        if (!InsertEmptyBlock.enoughParameter(pred, succ, template, checkReport)) {
            return false;
        }
        if (template.getEdge(pred.getID(), succ.getID(), ProcessConstants.EdgeType.ET_CONTROL) == null) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "' given as successor is not following the node '" + ChangeOperationTools.getHumanReadableNodeName(pred) + "' given as predecessor directly (concerning control edges). An Insertion between the given nodes is not allowed.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), pred), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return true;
    }

    public static boolean isPossible(ChangeableInstance instance, Node pred, Node succ) {
        return InsertEmptyBlock.isPossible(instance, pred, succ, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node pred, Node succ, CheckReport checkReport) {
        if (!InsertEmptyBlock.enoughParameter(pred, succ, instance.getTemplate(), checkReport)) {
            return false;
        }
        if (instance.getNodeState(succ.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(succ.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "' given as successor of the new empty block must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(succ.getID()).toString() + ".";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ, "NodeState")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        Template template = instance.getTemplate();
        return InsertEmptyBlock.isPossible(template, pred, succ, checkReport);
    }

    public static Node[] performOperation(SessionToken session, ChangeableTemplate template, Node pred, Node succ, ProcessConstants.BlockType type) {
        return InsertEmptyBlock.performOperation(session, template, pred, succ, type, null);
    }

    public static Node[] performOperation(SessionToken session, ChangeableTemplate template, Node pred, Node succ, ProcessConstants.BlockType type, UpdateManager updateManager) {
        return InsertEmptyBlock.performOperation(session, (ChangePrimitives)template, pred, succ, type, updateManager);
    }

    public static Node[] performOperation(SessionToken session, ChangeableInstance instance, Node pred, Node succ, ProcessConstants.BlockType type) {
        return InsertEmptyBlock.performOperation(session, instance, pred, succ, type, null);
    }

    public static Node[] performOperation(SessionToken session, ChangeableInstance instance, Node pred, Node succ, ProcessConstants.BlockType type, UpdateManager updateManager) {
        Node[] newNodes = InsertEmptyBlock.performOperation(session, (ChangePrimitives)instance, pred, succ, type, updateManager);
        if (instance.getNodeState(succ.getID()) == ProcessConstants.NodeState.NS_ACTIVATED) {
            instance.setNodeState(succ.getID(), ProcessConstants.NodeState.NS_NOT_ACTIVATED);
            if (updateManager != null) {
                ChangeOperationTools.fireNodeStateChangedEvent(updateManager, instance, succ);
            }
        }
        return newNodes;
    }

    protected static Node[] performOperation(SessionToken session, ChangePrimitives processGraph, Node pred, Node succ, ProcessConstants.BlockType type, UpdateManager updateManager) {
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        assert (type != null);
        ProcessConstants.NodeType typeSplitNode = ProcessConstants.NodeType.NT_NORMAL;
        ProcessConstants.NodeType typeJoinNode = ProcessConstants.NodeType.NT_NORMAL;
        switch (type) {
            case AND_BLOCK: {
                typeSplitNode = ProcessConstants.NodeType.NT_AND_SPLIT;
                typeJoinNode = ProcessConstants.NodeType.NT_AND_JOIN;
                break;
            }
            case OR_BLOCK: {
                typeSplitNode = ProcessConstants.NodeType.NT_XOR_SPLIT;
                typeJoinNode = ProcessConstants.NodeType.NT_XOR_JOIN;
                break;
            }
            case LOOP_BLOCK: {
                typeSplitNode = ProcessConstants.NodeType.NT_STARTLOOP;
                typeJoinNode = ProcessConstants.NodeType.NT_ENDLOOP;
                break;
            }
            default: {
                assert (false) : "type not supported!";
                break;
            }
        }
        logger.info("Calling insert Node");
        Node newNode1 = InsertNode.performOperation(session, processGraph, pred, succ, typeSplitNode, null);
        logger.info("Calling insert Node");
        Node newNode2 = InsertNode.performOperation(session, processGraph, newNode1, succ, typeJoinNode, null);
        if (type == ProcessConstants.BlockType.LOOP_BLOCK) {
            ProcessModelFactory pmf;
            try {
                pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
            }
            catch (ServiceNotKnownException snke) {
                throw new RTServiceNotKnownException(snke);
            }
            Edge loopEdge = pmf.createEdge(ProcessConstants.EdgeType.ET_LOOP, 1L, null);
            logger.info("Calling add Edge");
            processGraph.addEdge(newNode2.getID(), newNode1.getID(), loopEdge);
        }
        logger.info("Calling set corresponding block node");
        processGraph.setCorrespondingBlockNode(newNode1.getID(), newNode2.getID());
        processGraph.setSplitNodeID(newNode2.getID(), newNode2.getID(), template.getNodeSplitNodeID(newNode1.getID()));
        processGraph.setBranchID(newNode2.getID(), newNode2.getID(), false, template.getNodeBranchID(newNode1.getID()));
        if (updateManager != null) {
            updateManager.firePropertyChange(pred, (Object)UpdateManager.NodeProperties.NODE_OUT_EDGES);
            updateManager.firePropertyChange(succ, (Object)UpdateManager.NodeProperties.NODE_IN_EDGES);
        }
        return new Node[]{newNode1, newNode2};
    }

    private static boolean enoughParameter(Node pred, Node succ, Template template, CheckReport checkReport) {
        if (pred == null || succ == null) {
            if (checkReport != null) {
                String message = "Not enough selected nodes for this operation. A node as predecessor and a node as successor of the empty block is needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(pred.getID()) == null || template.getNode(succ.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain one or both of the given nodes: " + ChangeOperationTools.getHumanReadableNodeName(pred) + "," + ChangeOperationTools.getHumanReadableNodeName(succ);
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

