/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashSet;
import java.util.logging.Logger;

public class InsertEmptyBranch {
    private static final String MY_INSTANCE_NAME = "InsertEmptyBranch";
    protected static final Logger logger = LoggerTools.getLogger(InsertEmptyBranch.class);
    private static final String CHECK_ID = "Insert Empty Branch";

    public static boolean isPossible(Template template, Node split, Node join) {
        return InsertEmptyBranch.isPossible(template, split, join, null);
    }

    public static boolean isPossible(Template template, Node split, Node join, CheckReport checkReport) {
        if (!InsertEmptyBranch.enoughParameter(split, join, template, checkReport)) {
            return false;
        }
        if (!template.getNodeType(split.getID()).equals((Object)ProcessConstants.NodeType.NT_AND_SPLIT) && !template.getNodeType(split.getID()).equals((Object)ProcessConstants.NodeType.NT_XOR_SPLIT)) {
            if (checkReport != null) {
                String message = "The node given as split: '" + ChangeOperationTools.getHumanReadableNodeName(split) + "' is not of type split.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), split, "NodeType"));
            }
            return false;
        }
        if (!template.getNodeType(join.getID()).equals((Object)ProcessConstants.NodeType.NT_AND_JOIN) && !template.getNodeType(join.getID()).equals((Object)ProcessConstants.NodeType.NT_XOR_JOIN)) {
            if (checkReport != null) {
                String message = "The node given as join: '" + ChangeOperationTools.getHumanReadableNodeName(join) + "' is not of type join.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), join, "NodeType"));
            }
            return false;
        }
        if (template.getNodeCorrespondingBlockNodeID(split.getID()) != join.getID()) {
            if (checkReport != null) {
                String message = "The given split node: '" + ChangeOperationTools.getHumanReadableNodeName(split) + "' and the given join node: '" + ChangeOperationTools.getHumanReadableNodeName(join) + "' are not corresponding to each other.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), split), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(template.getNodeCorrespondingBlockNodeID(split.getID()))), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), join)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        if (template.getEdge(split.getID(), join.getID(), ProcessConstants.EdgeType.ET_CONTROL) != null) {
            if (checkReport != null) {
                String message = "There is an empty branch between the given split node: '" + ChangeOperationTools.getHumanReadableNodeName(split) + "' and the given join node: '" + ChangeOperationTools.getHumanReadableNodeName(join) + "' already. An insertion of another empty branch is not allowed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getBranchIdentifier(checkReport.getBase(), split, join));
            }
            return false;
        }
        return true;
    }

    public static boolean isPossible(ChangeableInstance instance, Node split, Node join) {
        return InsertEmptyBranch.isPossible(instance, split, join, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node split, Node join, CheckReport checkReport) {
        if (!InsertEmptyBranch.enoughParameter(split, join, instance.getTemplate(), checkReport)) {
            return false;
        }
        Template template = instance.getTemplate();
        if (instance.getNodeState(split.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(split.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (template.getNodeType(split.getID()) == ProcessConstants.NodeType.NT_XOR_SPLIT || template.getNodeType(split.getID()) != ProcessConstants.NodeType.NT_XOR_SPLIT && instance.getNodeState(split.getID()) != ProcessConstants.NodeState.NS_COMPLETED) {
                if (checkReport != null) {
                    String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(split) + "' given as source of the new branch must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(split.getID()).toString() + ".";
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), split, "NodeState"));
                }
                return false;
            }
            if (instance.getNodeState(join.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(join.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
                if (checkReport != null) {
                    String message = "The join node '" + ChangeOperationTools.getHumanReadableNodeName(join) + "' given as target of the new branch must be ACTIVATED, NOT_ACTIVATED, but it is in state: " + instance.getNodeState(join.getID()).toString() + ".";
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), join, "NodeState"));
                }
                return false;
            }
        }
        return InsertEmptyBranch.isPossible(template, split, join, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node split, Node join) {
        InsertEmptyBranch.performOperation(session, template, split, join, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node split, Node join, UpdateManager updateManager) {
        InsertEmptyBranch.performOperation(session, (ChangePrimitives)template, split, join, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node split, Node join) {
        InsertEmptyBranch.performOperation(session, instance, split, join, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node split, Node join, UpdateManager updateManager) {
        InsertEmptyBranch.performOperation(session, (ChangePrimitives)instance, split, join, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, Node split, Node join, UpdateManager updateManager) {
        Edge newEdge;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        logger.info("calling ChangePrimitive addEdge");
        if (template.getNodeType(split.getID()) == ProcessConstants.NodeType.NT_XOR_SPLIT) {
            ProcessModelFactory pmf;
            int[] succs;
            long freeEdgeCode = 0L;
            HashSet<Long> usedEdgeCodes = new HashSet<Long>();
            int[] nArray = succs = template.getSuccByEdgeType(split.getID(), ProcessConstants.EdgeType.ET_CONTROL);
            int n = succs.length;
            int n2 = 0;
            while (n2 < n) {
                int succ = nArray[n2];
                Edge edge = template.getEdge(split.getID(), succ, ProcessConstants.EdgeType.ET_CONTROL);
                usedEdgeCodes.add(edge.getEdgeCode());
                ++n2;
            }
            while (freeEdgeCode <= (long)succs.length) {
                if (!usedEdgeCodes.contains(freeEdgeCode)) break;
                ++freeEdgeCode;
            }
            try {
                pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
            }
            catch (ServiceNotKnownException snke) {
                throw new RTServiceNotKnownException(snke);
            }
            newEdge = pmf.createEdge(ProcessConstants.EdgeType.ET_CONTROL, freeEdgeCode, null);
        } else {
            newEdge = ChangeOperationTools.createSimpleEdgeObject(session, ProcessConstants.EdgeType.ET_CONTROL);
        }
        processGraph.addEdge(split.getID(), join.getID(), newEdge);
        if (updateManager != null) {
            updateManager.firePropertyChange(split, (Object)UpdateManager.NodeProperties.NODE_OUT_EDGES);
            updateManager.firePropertyChange(join, (Object)UpdateManager.NodeProperties.NODE_IN_EDGES);
        }
    }

    private static boolean enoughParameter(Node split, Node join, Template template, CheckReport checkReport) {
        if (split == null || join == null) {
            if (checkReport != null) {
                String message = "Not enough selected nodes for this operation. A split and its corresponding join are needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(split.getID()) == null || template.getNode(join.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain one or both of the given nodes: " + ChangeOperationTools.getHumanReadableNodeName(split) + "," + ChangeOperationTools.getHumanReadableNodeName(join);
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

