/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class InsertNode {
    private static final String MY_INSTANCE_NAME = "InsertNode";
    protected static final Logger logger = LoggerTools.getLogger(InsertNode.class);
    private static final String CHECK_ID = "Insert Node";

    public static boolean isPossible(Template template, Node pred, Node succ) {
        return InsertNode.isPossible(template, pred, succ, null);
    }

    public static boolean isPossible(Template template, Node pred, Node succ, CheckReport checkReport) {
        boolean possible = false;
        if (!InsertNode.enoughParameter(pred, succ, template, checkReport)) {
            return false;
        }
        Edge predSucc = template.getEdge(pred.getID(), succ.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        if (predSucc != null) {
            possible = true;
        } else if (checkReport != null) {
            String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "' given as successor is not following the node '" + ChangeOperationTools.getHumanReadableNodeName(pred) + "' given as predecessor directly (concerning control edges). An Insertion between the given nodes is not allowed.";
            URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), pred), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ)};
            checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
        }
        return possible;
    }

    public static boolean isPossible(Instance instance, Node pred, Node succ) {
        return InsertNode.isPossible(instance, pred, succ, null);
    }

    public static boolean isPossible(Instance instance, Node pred, Node succ, CheckReport checkReport) {
        if (!(instance instanceof ChangeableInstance)) {
            if (checkReport != null) {
                String message = "The given instance is of type: " + instance.getClass().getName() + " but it must be of type ChangeableInstance.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, checkReport.getBase());
            }
            return false;
        }
        if (!InsertNode.enoughParameter(pred, succ, instance.getTemplate(), checkReport)) {
            return false;
        }
        if (instance.getNodeState(succ.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(succ.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "' given as successor must be in one of the states ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(succ.getID()).toString() + ".";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), pred), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        Template template = instance.getTemplate();
        return InsertNode.isPossible(template, pred, succ, checkReport);
    }

    public static Node performOperation(SessionToken session, ChangeableTemplate template, Node pred, Node succ) {
        return InsertNode.performOperation(session, template, pred, succ, null);
    }

    public static Node performOperation(SessionToken session, ChangeableTemplate template, Node pred, Node succ, UpdateManager updateManager) {
        return InsertNode.performOperation(session, template, pred, succ, ProcessConstants.NodeType.NT_NORMAL, updateManager);
    }

    protected static Node performOperation(SessionToken session, ChangeableTemplate template, Node pred, Node succ, ProcessConstants.NodeType type, UpdateManager updateManager) {
        return InsertNode.performOperation(session, (ChangePrimitives)template, pred, succ, type, updateManager);
    }

    public static Node performOperation(SessionToken session, ChangeableInstance instance, Node pred, Node succ) {
        return InsertNode.performOperation(session, instance, pred, succ, null);
    }

    public static Node performOperation(SessionToken session, ChangeableInstance instance, Node pred, Node succ, UpdateManager updateManager) {
        return InsertNode.performOperation(session, instance, pred, succ, ProcessConstants.NodeType.NT_NORMAL, updateManager);
    }

    protected static Node performOperation(SessionToken session, ChangeableInstance instance, Node pred, Node succ, ProcessConstants.NodeType type, UpdateManager updateManager) {
        Node newNode = InsertNode.performOperation(session, (ChangePrimitives)instance, pred, succ, type, updateManager);
        if (instance.getNodeState(pred.getID()) == ProcessConstants.NodeState.NS_COMPLETED || instance.getNodeState(pred.getID()) == ProcessConstants.NodeState.NS_ENQUIRED) {
            instance.setNodeState(succ.getID(), ProcessConstants.NodeState.NS_NOT_ACTIVATED);
            if (updateManager != null) {
                ChangeOperationTools.fireNodeStateChangedEvent(updateManager, instance, succ);
            }
        }
        return newNode;
    }

    protected static Node performOperation(SessionToken session, ChangePrimitives processGraph, Node pred, Node succ, ProcessConstants.NodeType type, UpdateManager updateManager) {
        ProcessModelFactory pmf;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        Node newNode = ChangeOperationTools.createSimpleNodeObject(session);
        logger.info("calling ChangePrimitive addNode");
        newNode = processGraph.addNode(newNode);
        processGraph.setNodeType(newNode.getID(), type);
        Edge oldEdge = template.getEdge(pred.getID(), succ.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        logger.info("calling ChangePrimitive removeEdge");
        processGraph.removeEdge(pred.getID(), succ.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        Edge predEdge = pmf.createEdge(oldEdge.getType(), oldEdge.getEdgeCode(), oldEdge.getUserAttributes());
        Edge succEdge = type == ProcessConstants.NodeType.NT_XOR_SPLIT || type == ProcessConstants.NodeType.NT_ENDLOOP ? pmf.createEdge(oldEdge.getType(), 0L, null) : pmf.createEdge(oldEdge.getType(), Integer.MIN_VALUE, null);
        logger.info("calling ChangePrimitive addEdge (2x)");
        processGraph.addEdge(pred.getID(), newNode.getID(), predEdge);
        processGraph.addEdge(newNode.getID(), succ.getID(), succEdge);
        boolean newIDNecessary = true;
        if (template.getNodeType(pred.getID()) == ProcessConstants.NodeType.NT_AND_SPLIT || template.getNodeType(pred.getID()) == ProcessConstants.NodeType.NT_XOR_SPLIT || template.getNodeType(pred.getID()) == ProcessConstants.NodeType.NT_STARTLOOP || template.getNodeType(pred.getID()) == ProcessConstants.NodeType.NT_STARTFLOW) {
            processGraph.setSplitNodeID(newNode.getID(), newNode.getID(), pred.getID());
            if (template.getNodeCorrespondingBlockNodeID(pred.getID()) == succ.getID()) {
                processGraph.setBranchID(newNode.getID(), newNode.getID(), newIDNecessary, Integer.MIN_VALUE);
            } else {
                newIDNecessary = false;
                processGraph.setBranchID(newNode.getID(), newNode.getID(), newIDNecessary, template.getNodeBranchID(succ.getID()));
            }
        } else {
            newIDNecessary = false;
            processGraph.setSplitNodeID(newNode.getID(), newNode.getID(), template.getNodeSplitNodeID(pred.getID()));
            processGraph.setBranchID(newNode.getID(), newNode.getID(), newIDNecessary, template.getNodeBranchID(pred.getID()));
        }
        if (updateManager != null) {
            updateManager.firePropertyChange(pred, (Object)UpdateManager.NodeProperties.NODE_OUT_EDGES);
            updateManager.firePropertyChange(succ, (Object)UpdateManager.NodeProperties.NODE_IN_EDGES);
        }
        return newNode;
    }

    private static boolean enoughParameter(Node pred, Node succ, Template template, CheckReport checkReport) {
        if (pred == null || succ == null) {
            if (checkReport != null) {
                String message = "Not enough selected nodes for this operation. A predecessor node and a successor node are needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(pred.getID()) == null || template.getNode(succ.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain one or both of the nodes: " + pred + ", " + succ;
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

