/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.ToggleSyncEdge;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class MoveNodes {
    private static final String MY_INSTANCE_NAME = "MoveNodes";
    protected static final Logger logger = LoggerTools.getLogger(MoveNodes.class);
    private static final String CHECK_ID1 = "Insert Empty Branch";
    private static final String CHECK_ID2 = "Valid Move Block";

    public static boolean isPossible(ChangeableTemplate template, Node first, Node last, Node pred, Node succ) {
        return MoveNodes.isPossible(template, first, last, pred, succ, null);
    }

    public static boolean isPossible(Template template, Node first, Node last, Node pred, Node succ, CheckReport checkReport) {
        int[] syncNodes;
        if (!MoveNodes.enoughParameter(first, last, pred, succ, template, checkReport)) {
            return false;
        }
        if (first.getID() == template.getStartNode().getID() || last.getID() == template.getEndNode().getID()) {
            if (checkReport != null) {
                String message = "The first move block node must not be of type NT_STARTFLOW and the last move block node must not be of type NT_ENDFLOW";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first, "NodeType"), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), last, "NodeType")};
                checkReport.addReportEntry(CHECK_ID1, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        if (template.getEdge(pred.getID(), succ.getID(), ProcessConstants.EdgeType.ET_CONTROL) == null) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "' given as target successor is not following the node '" + ChangeOperationTools.getHumanReadableNodeName(pred) + "' given as target predecessor directly (concerning control edges). An Movement between the given nodes is not allowed.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), pred), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ)};
                checkReport.addReportEntry(CHECK_ID1, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        if (first.getID() != last.getID()) {
            if (!template.isTransPredOf(last.getID(), first.getID(), ProcessConstants.EdgeType.ET_CONTROL)) {
                if (checkReport != null) {
                    String message = "The first node of the move block '" + ChangeOperationTools.getHumanReadableNodeName(first) + "' must be a predecessor of the last node '" + ChangeOperationTools.getHumanReadableNodeName(last) + "' of the move block, but this is not the case.";
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), last)};
                    checkReport.addReportEntry(CHECK_ID1, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                return false;
            }
            if (template.getNodeBranchID(first.getID()) != template.getNodeBranchID(last.getID())) {
                if (checkReport != null) {
                    String message = "The first node of the move block '" + ChangeOperationTools.getHumanReadableNodeName(first) + "' must be on the same block level as the last node '" + ChangeOperationTools.getHumanReadableNodeName(last) + "' of the move block, but this is not the case.";
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first, "branchID"), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), last, "branchID")};
                    checkReport.addReportEntry(CHECK_ID1, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                return false;
            }
        }
        if (template.getNodeTopologicalID(pred.getID()) >= template.getNodeTopologicalID(first.getID()) && template.getNodeTopologicalID(pred.getID()) <= template.getNodeTopologicalID(last.getID()) || template.getNodeTopologicalID(succ.getID()) >= template.getNodeTopologicalID(first.getID()) && template.getNodeTopologicalID(succ.getID()) <= template.getNodeTopologicalID(last.getID())) {
            if (checkReport != null) {
                String message = "The predecessor and the successor of the move target '" + ChangeOperationTools.getHumanReadableNodeName(pred) + "' and '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "' must not be included in the move block";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), pred), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ), ProcessElementIdentifierTools.getBlockIdentifier(checkReport.getBase(), first, last)};
                checkReport.addReportEntry(CHECK_ID1, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        ProcessConstants.NodeType firstType = template.getNodeType(first.getID());
        ProcessConstants.NodeType lastType = template.getNodeType(last.getID());
        if (firstType.equals((Object)ProcessConstants.NodeType.NT_AND_JOIN) || firstType.equals((Object)ProcessConstants.NodeType.NT_XOR_JOIN) || firstType.equals((Object)ProcessConstants.NodeType.NT_ENDLOOP) || lastType.equals((Object)ProcessConstants.NodeType.NT_AND_SPLIT) || lastType.equals((Object)ProcessConstants.NodeType.NT_XOR_SPLIT) || lastType.equals((Object)ProcessConstants.NodeType.NT_STARTLOOP)) {
            if (checkReport != null) {
                String message = "Neither the first node of the move block '" + ChangeOperationTools.getHumanReadableNodeName(first) + "' must be a join/loop start node nor the last node of the move block ' " + ChangeOperationTools.getHumanReadableNodeName(last) + "' must be a split/loop end node.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first, "NodeType"), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), last, "NodeType")};
                checkReport.addReportEntry(CHECK_ID1, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        int[] nArray = syncNodes = ProcessModelTools.nodesWithSyncEdgesInArea(template, first.getID(), last.getID(), false);
        int n = syncNodes.length;
        int n2 = 0;
        while (n2 < n) {
            int[] syncSuccs;
            int[] syncPreds;
            int syncNode = nArray[n2];
            int[] nArray2 = syncPreds = template.getPredByEdgeType(syncNode, ProcessConstants.EdgeType.ET_SYNC);
            int n3 = syncPreds.length;
            int n4 = 0;
            while (n4 < n3) {
                int syncPred = nArray2[n4];
                if (!ToggleSyncEdge.isPossible(template, template.getNode(syncPred), succ, checkReport)) {
                    return false;
                }
                ++n4;
            }
            int[] nArray3 = syncSuccs = template.getSuccByEdgeType(syncNode, ProcessConstants.EdgeType.ET_SYNC);
            int n5 = syncSuccs.length;
            n3 = 0;
            while (n3 < n5) {
                int syncSucc = nArray3[n3];
                if (!ToggleSyncEdge.isPossible(template, pred, template.getNode(syncSucc), checkReport)) {
                    return false;
                }
                ++n3;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isValidMoveBlock(Template template, Node first, Node last) {
        return MoveNodes.isValidMoveBlock(template, first, last, null);
    }

    public static boolean isValidMoveBlock(Template template, Node first, Node last, CheckReport checkReport) {
        boolean valid = false;
        if (!MoveNodes.enoughBlockNodes(first, last, template, checkReport)) {
            return valid;
        }
        if (template.getNodeType(first.getID()) == ProcessConstants.NodeType.NT_STARTFLOW || template.getNodeType(first.getID()) == ProcessConstants.NodeType.NT_ENDFLOW || template.getNodeType(last.getID()) == ProcessConstants.NodeType.NT_STARTFLOW || template.getNodeType(last.getID()) == ProcessConstants.NodeType.NT_ENDFLOW) {
            if (checkReport != null) {
                String message = "Start flow and end flow nodes can't be part of a valid move block";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first, "NodeType"), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), last, "NodeType")};
                checkReport.addReportEntry(CHECK_ID2, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return valid;
        }
        if (first.getID() == last.getID()) {
            valid = true;
        } else {
            if (template.getNodeBranchID(first.getID()) != template.getNodeBranchID(last.getID()) || !template.isTransPredOf(last.getID(), first.getID(), ProcessConstants.EdgeType.ET_CONTROL)) {
                if (checkReport != null) {
                    String message = "The first node of the move block '" + ChangeOperationTools.getHumanReadableNodeName(first) + "' must be on the same block level as the last node ' " + ChangeOperationTools.getHumanReadableNodeName(last) + "' and first must be a predecessor of last concerning control edges. At least one criterion is violated";
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first, "branchID"), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), last, "branchID")};
                    checkReport.addReportEntry(CHECK_ID2, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                return false;
            }
            valid = true;
            if (valid) {
                if (template.getNodeType(first.getID()) != ProcessConstants.NodeType.NT_ENDLOOP && template.getNodeType(first.getID()) != ProcessConstants.NodeType.NT_AND_JOIN && template.getNodeType(first.getID()) != ProcessConstants.NodeType.NT_XOR_JOIN && template.getNodeType(last.getID()) != ProcessConstants.NodeType.NT_STARTLOOP && template.getNodeType(last.getID()) != ProcessConstants.NodeType.NT_AND_SPLIT && template.getNodeType(last.getID()) != ProcessConstants.NodeType.NT_XOR_SPLIT) {
                    valid = true;
                } else {
                    if (checkReport != null) {
                        String message = "The given block is invalid. Block end nodes as start or block start nodes as end of a move block are invalid.";
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), last)};
                        checkReport.addReportEntry(CHECK_ID2, CheckReport.ResultType.FAILURE, message, affectedElements);
                    }
                    return false;
                }
            }
        }
        return valid;
    }

    public static boolean isPossible(ChangeableInstance instance, Node first, Node last, Node pred, Node succ) {
        return MoveNodes.isPossible(instance, first, last, pred, succ, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node first, Node last, Node pred, Node succ, CheckReport checkReport) {
        if (instance.getNodeState(first.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(first.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED || instance.getNodeState(succ.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(succ.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "One or both of the nodes '" + ChangeOperationTools.getHumanReadableNodeName(first) + "', '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "' which marks the beginning of the move block/the end of the target area must be ACTIVATED or NOT_ACTIVATED, but it is/they are in state: " + instance.getNodeState(first.getID()).toString() + ", " + instance.getNodeState(succ.getID()).toString() + ".";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first, "NodeState"), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ, "NodeState")};
                checkReport.addReportEntry(CHECK_ID2, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        Template template = instance.getTemplate();
        if (!MoveNodes.enoughParameter(first, last, pred, succ, template, checkReport)) {
            return false;
        }
        return MoveNodes.isPossible(template, first, last, pred, succ, checkReport);
    }

    public static boolean isValidMoveBlock(ChangeableInstance instance, Node first, Node last) {
        return MoveNodes.isValidMoveBlock(instance, first, last, null);
    }

    public static boolean isValidMoveBlock(ChangeableInstance instance, Node first, Node last, CheckReport checkReport) {
        Template template = instance.getTemplate();
        if (!MoveNodes.enoughBlockNodes(first, last, template, checkReport)) {
            return false;
        }
        if (instance.getNodeState(first.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(first.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(first) + "' which marks the beginning of the move block must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(first.getID()).toString() + ".";
                checkReport.addReportEntry(CHECK_ID2, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), first, "NodeState"));
            }
            return false;
        }
        return MoveNodes.isValidMoveBlock(template, first, last, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node first, Node last, Node pred, Node succ) {
        MoveNodes.performOperation(session, template, first, last, pred, succ, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node first, Node last, Node pred, Node succ, UpdateManager updateManager) {
        MoveNodes.performOperation(session, (ChangePrimitives)template, first, last, pred, succ, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node first, Node last, Node pred, Node succ) {
        MoveNodes.performOperation(session, instance, first, last, pred, succ, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node first, Node last, Node pred, Node succ, UpdateManager updateManager) {
        boolean predCompleted;
        int firstPred = instance.getTemplate().getPredByEdgeType(first.getID(), ProcessConstants.EdgeType.ET_CONTROL)[0];
        ProcessConstants.NodeState firstPredState = instance.getNodeState(firstPred);
        MoveNodes.performOperation(session, (ChangePrimitives)instance, first, last, pred, succ, updateManager);
        boolean bl = predCompleted = instance.getNodeState(pred.getID()) == ProcessConstants.NodeState.NS_COMPLETED || instance.getNodeState(pred.getID()) == ProcessConstants.NodeState.NS_ENQUIRED;
        if (predCompleted) {
            instance.setNodeState(succ.getID(), ProcessConstants.NodeState.NS_NOT_ACTIVATED);
            if (updateManager != null) {
                ChangeOperationTools.fireNodeStateChangedEvent(updateManager, instance, succ);
            }
        }
        if (!(firstPredState != ProcessConstants.NodeState.NS_COMPLETED && firstPredState != ProcessConstants.NodeState.NS_ENQUIRED || predCompleted)) {
            instance.setNodeState(first.getID(), ProcessConstants.NodeState.NS_NOT_ACTIVATED);
            if (updateManager != null) {
                ChangeOperationTools.fireNodeStateChangedEvent(updateManager, instance, first);
            }
        }
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, Node first, Node last, Node pred, Node succ, UpdateManager updateManager) {
        int n;
        int n2;
        int[] nArray;
        ProcessModelFactory pmf;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        logger.info("calling ChangePrimitive removeEdge 3x");
        int[] predsOfFirst = template.getPredByEdgeType(first.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        int[] succsOfLast = template.getSuccByEdgeType(last.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        if (predsOfFirst.length != 1) {
            throw new RuntimeException("Error: first must/can only have one predecessor");
        }
        if (succsOfLast.length != 1) {
            throw new RuntimeException("Error: last must/can only have one successor");
        }
        Edge oldEdge1 = template.getEdge(pred.getID(), succ.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        Edge oldEdge2 = template.getEdge(predsOfFirst[0], first.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        processGraph.removeEdge(predsOfFirst[0], first.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        processGraph.removeEdge(last.getID(), succsOfLast[0], ProcessConstants.EdgeType.ET_CONTROL);
        processGraph.removeEdge(pred.getID(), succ.getID(), ProcessConstants.EdgeType.ET_CONTROL);
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        Edge predEdge = pmf.createEdge(oldEdge1.getType(), oldEdge1.getEdgeCode(), oldEdge1.getUserAttributes());
        Edge succEdge = pmf.createEdge(oldEdge1.getType(), Integer.MIN_VALUE, null);
        Edge gapEdge = pmf.createEdge(oldEdge2.getType(), oldEdge2.getEdgeCode(), oldEdge2.getUserAttributes());
        processGraph.addEdge(pred.getID(), first.getID(), predEdge);
        processGraph.addEdge(last.getID(), succ.getID(), succEdge);
        boolean emptyEdgeExists = false;
        ProcessConstants.NodeType predByControlType = template.getNodeType(predsOfFirst[0]);
        if ((predByControlType == ProcessConstants.NodeType.NT_AND_SPLIT || predByControlType == ProcessConstants.NodeType.NT_XOR_SPLIT) && template.getNodeCorrespondingBlockNodeID(predsOfFirst[0]) == succsOfLast[0]) {
            int[] succsOfPred = template.getSuccByEdgeType(predsOfFirst[0], ProcessConstants.EdgeType.ET_CONTROL);
            nArray = succsOfPred;
            n2 = succsOfPred.length;
            n = 0;
            while (n < n2) {
                int succID = nArray[n];
                ProcessConstants.NodeType nodeType = template.getNodeType(succID);
                if (nodeType.equals((Object)ProcessConstants.NodeType.NT_AND_JOIN) || nodeType.equals((Object)ProcessConstants.NodeType.NT_XOR_JOIN)) {
                    emptyEdgeExists = true;
                    break;
                }
                ++n;
            }
        }
        if (!emptyEdgeExists) {
            processGraph.addEdge(predsOfFirst[0], succsOfLast[0], gapEdge);
        }
        if (first.getID() == last.getID()) {
            logger.info("calling ChangePrimitive addMovedNode for a single moved node");
            processGraph.addMovedNode(first.getID());
        } else {
            int[] movedNodes = template.getNodeIDsInArea(first.getID(), last.getID(), true);
            logger.info("calling ChangePrimitive addMovedNode for all moved nodes");
            nArray = movedNodes;
            n2 = movedNodes.length;
            n = 0;
            while (n < n2) {
                int movedNode = nArray[n];
                processGraph.addMovedNode(movedNode);
                ++n;
            }
            processGraph.addMovedNode(first.getID());
            processGraph.addMovedNode(last.getID());
        }
        boolean newIDNecessary = true;
        ProcessConstants.NodeType type = template.getNodeType(pred.getID());
        if (type == ProcessConstants.NodeType.NT_AND_SPLIT || type == ProcessConstants.NodeType.NT_XOR_SPLIT || type == ProcessConstants.NodeType.NT_STARTFLOW || type == ProcessConstants.NodeType.NT_STARTLOOP) {
            processGraph.setSplitNodeID(first.getID(), last.getID(), pred.getID());
            if (template.getNodeCorrespondingBlockNodeID(pred.getID()) == succ.getID()) {
                processGraph.setBranchID(first.getID(), last.getID(), newIDNecessary, Integer.MIN_VALUE);
            } else {
                newIDNecessary = false;
                processGraph.setBranchID(first.getID(), last.getID(), newIDNecessary, template.getNodeBranchID(succ.getID()));
            }
        } else {
            newIDNecessary = false;
            processGraph.setSplitNodeID(first.getID(), last.getID(), template.getNodeSplitNodeID(pred.getID()));
            processGraph.setBranchID(first.getID(), last.getID(), newIDNecessary, template.getNodeBranchID(pred.getID()));
        }
        if (updateManager != null) {
            updateManager.firePropertyChange(template.getNode(predsOfFirst[0]), (Object)UpdateManager.NodeProperties.NODE_OUT_EDGES);
            updateManager.firePropertyChange(template.getNode(succsOfLast[0]), (Object)UpdateManager.NodeProperties.NODE_IN_EDGES);
            updateManager.firePropertyChange(pred, (Object)UpdateManager.NodeProperties.NODE_OUT_EDGES);
            updateManager.firePropertyChange(succ, (Object)UpdateManager.NodeProperties.NODE_IN_EDGES);
            updateManager.firePropertyChange(first, (Object)UpdateManager.NodeProperties.NODE_IN_EDGES);
            updateManager.firePropertyChange(last, (Object)UpdateManager.NodeProperties.NODE_OUT_EDGES);
        }
    }

    private static boolean enoughParameter(Node first, Node last, Node pred, Node succ, Template template, CheckReport checkReport) {
        if (first == null || last == null || pred == null || succ == null) {
            if (checkReport != null) {
                String message = "Not enough selected nodes for this operation. The block to move specified by first and last and the target specified by pred and succ are needed.";
                checkReport.addReportEntry(CHECK_ID1, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(first.getID()) == null || template.getNode(last.getID()) == null || template.getNode(pred.getID()) == null || template.getNode(succ.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain one or more of the necessary nodes for a move operation.";
                checkReport.addReportEntry(CHECK_ID1, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }

    private static boolean enoughBlockNodes(Node first, Node last, Template template, CheckReport checkReport) {
        if (first == null || last == null) {
            if (checkReport != null) {
                String message = "Not enough selected nodes for this operation. The block to move specified by first and last node are needed.";
                checkReport.addReportEntry(CHECK_ID2, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(first.getID()) == null || template.getNode(last.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain one or more of the necessary nodes for a valid move block.";
                checkReport.addReportEntry(CHECK_ID2, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

