/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.systemdata.Dependency;
import de.aristaflow.adept2.model.common.systemdata.DependencyProvider;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.OrgModelConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.systemdata.SystemDataProducer;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class NodeDependencyProvider
implements DependencyProvider {
    protected Template template;
    protected Node node;
    protected Map<String, Dependency> injectedDependencies = new HashMap<String, Dependency>();

    public NodeDependencyProvider(Template template, int nodeID) {
        ArgChecks.checkForNull(template, "template");
        this.template = template;
        this.node = template.getNode(nodeID);
        if (this.node == null) {
            String msg = "The node #%d does not exist in the template %s!";
            msg = String.format(msg, nodeID, template.getID());
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public ParameterRef[] getParameters() {
        LinkedHashSet<ParameterRef> params = new LinkedHashSet<ParameterRef>();
        for (Parameter parameter : this.node.getSystemParameters(ActivityConstants.AccessType.SYSTEM_READ)) {
            if (parameter.getDataType() != ProcessConstants.AdeptDataType.INTEGER && parameter.getDataType() != ProcessConstants.AdeptDataType.FLOAT && parameter.getDataType() != ProcessConstants.AdeptDataType.STRING && parameter.getDataType() != ProcessConstants.AdeptDataType.DATE) {
                String msg = "Ignoring SYSTEM_READ parameter %s of node #%d in template %s. Data type %s is not supported.";
                msg = String.format(msg, new Object[]{parameter.getName(), this.node.getID(), this.template.getID(), parameter.getDataType()});
                LoggerTools.getLogger(this).severe(msg);
                continue;
            }
            params.add(new ParameterRef(parameter.getDataType(), parameter.getName()));
        }
        for (String string : this.injectedDependencies.keySet()) {
            ProcessConstants.AdeptDataType dataType = this.getDataTypeOf(string);
            if (dataType != ProcessConstants.AdeptDataType.INTEGER && dataType != ProcessConstants.AdeptDataType.FLOAT && dataType != ProcessConstants.AdeptDataType.STRING && dataType != ProcessConstants.AdeptDataType.DATE) {
                String msg = "Ignoring SYSTEM_READ parameter %s of node #%d in template %s. Data type %s is not supported.";
                msg = String.format(msg, new Object[]{string, this.node.getID(), this.template.getID(), dataType});
                LoggerTools.getLogger(this).severe(msg);
                continue;
            }
            params.add(new ParameterRef(dataType, string));
        }
        return params.toArray(new ParameterRef[params.size()]);
    }

    @Override
    public boolean parameterExists(String parameterName) {
        ArgChecks.checkForNull(parameterName, "parameterName");
        ParameterRef[] parameterRefArray = this.getParameters();
        int n = parameterRefArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterRef ref = parameterRefArray[n2];
            if (ref.getName().equals(parameterName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Dependency getDependencyOf(String parameterName) {
        ArgChecks.checkForNull(parameterName, "parameterName");
        if (this.injectedDependencies.containsKey(parameterName)) {
            return this.injectedDependencies.get(parameterName);
        }
        int connectorID = this.node.getConnector(parameterName, ActivityConstants.AccessType.SYSTEM_READ);
        if (connectorID == Integer.MIN_VALUE) {
            return null;
        }
        DataElement dataElement = this.template.getDataElement(this.node.getID(), connectorID);
        if (dataElement == null) {
            return null;
        }
        int[] nodeIDs = this.template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.SYSTEM_WRITE);
        if (nodeIDs.length != 1) {
            return new Dependency(Dependency.DEPENDENCY_TYPE_DATA_ELEMENT, dataElement);
        }
        Node prodNode = this.template.getNode(nodeIDs[0]);
        int prodConnectorID = this.template.getConnector(prodNode.getID(), dataElement.getID(), ActivityConstants.AccessType.SYSTEM_WRITE);
        ProcessModelParameter prodParam = prodNode.getSystemParameter(prodNode.getParameterName(prodConnectorID), ActivityConstants.AccessType.SYSTEM_WRITE);
        SystemDataProducer[] systemDataProducerArray = SystemDataProducer.values();
        int n = systemDataProducerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SystemDataProducer producer = systemDataProducerArray[n2];
            if (producer.getParameterProperties().getIdentifierID().equals(prodParam.getIdentifierID())) {
                return new Dependency((Object)producer, prodNode);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ProcessConstants.AdeptDataType getDataTypeOf(String parameterName) {
        Dependency dep = this.getDependencyOf(parameterName);
        if (dep == null) {
            return null;
        }
        if (dep.getType().equals(Dependency.DEPENDENCY_TYPE_DATA_ELEMENT)) {
            DataElement dataElement = (DataElement)dep.getArgument();
            return dataElement.getDataType();
        }
        if (dep.getType() instanceof SystemDataProducer) {
            SystemDataProducer prod = (SystemDataProducer)((Object)dep.getType());
            return prod.getParameterProperties().getDataType();
        }
        throw new IllegalArgumentException("unhandled dependency type: " + dep.getType());
    }

    @Override
    public Map<Object, String> getDependencyTypes(ProcessConstants.AdeptDataType dataType, UUID identifierID) {
        ArgChecks.checkForNull((Object)dataType, "dataType");
        LinkedHashMap<Object, String> types = new LinkedHashMap<Object, String>();
        types.put(Dependency.DEPENDENCY_TYPE_DATA_ELEMENT, this.getLabelForType(Dependency.DEPENDENCY_TYPE_DATA_ELEMENT));
        SystemDataProducer[] systemDataProducerArray = SystemDataProducer.values();
        int n = systemDataProducerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SystemDataProducer producer = systemDataProducerArray[n2];
            UUID entityTypeIdentifier = this.determineEntityTypeIdentifier(producer);
            if (producer.getParameterProperties().getDataType() == dataType && (identifierID == null || producer.getParameterProperties().getIdentifierID().equals(identifierID) || entityTypeIdentifier.equals(identifierID))) {
                types.put((Object)producer, this.getLabelForType((Object)producer));
            }
            ++n2;
        }
        return types;
    }

    @Override
    public Map<Object, String> getDependencyTypeArguments(Object dependencyType, ProcessConstants.AdeptDataType dataType, UUID identifierID) {
        ArgChecks.checkForNull((Object)dataType, "dataType");
        ArgChecks.checkForNull(dependencyType, "dependencyType");
        if (dependencyType.equals(Dependency.DEPENDENCY_TYPE_DATA_ELEMENT)) {
            LinkedHashMap<Object, String> args = new LinkedHashMap<Object, String>();
            Set<DataElement> dataElements = ChangeOperationTools.getCompliantDataElements(this.template, dataType, identifierID, false);
            if (identifierID != null) {
                HashSet<SystemDataProducer> alternativeSources = new HashSet<SystemDataProducer>();
                SystemDataProducer[] systemDataProducerArray = SystemDataProducer.values();
                int n = systemDataProducerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SystemDataProducer producer = systemDataProducerArray[n2];
                    if (this.determineEntityTypeIdentifier(producer).equals(identifierID)) {
                        alternativeSources.add(producer);
                    }
                    ++n2;
                }
                for (SystemDataProducer producer : alternativeSources) {
                    Set<DataElement> moreDataElements = ChangeOperationTools.getCompliantDataElements(this.template, dataType, producer.getParameterProperties().getIdentifierID(), true);
                    dataElements.addAll(moreDataElements);
                }
            }
            for (DataElement dataElement : dataElements) {
                args.put(dataElement, this.getLabelForArgument(dependencyType, dataElement));
            }
            return args;
        }
        if (dependencyType instanceof SystemDataProducer) {
            if (Arrays.asList(SystemDataProducer.nodeProduced()).contains(dependencyType)) {
                LinkedHashMap<Object, String> args = new LinkedHashMap<Object, String>();
                Set<Node> nodes = ChangeOperationTools.getSavePredecessors(this.template, this.node.getID());
                for (Node node : nodes) {
                    args.put(node, this.getLabelForArgument(dependencyType, node));
                }
                return args;
            }
            if (Arrays.asList(SystemDataProducer.startNodeProduced()).contains(dependencyType)) {
                LinkedHashMap<Object, String> args = new LinkedHashMap<Object, String>();
                Node startNode = this.template.getStartNode();
                args.put(startNode, this.getLabelForArgument(dependencyType, startNode));
                return args;
            }
            throw new AssertionError((Object)("unhandled SystmDataProducer: " + dependencyType));
        }
        throw new AssertionError((Object)("unhandled dependency type: " + dependencyType));
    }

    private UUID determineEntityTypeIdentifier(SystemDataProducer producer) {
        switch (producer) {
            case TEMPLATE_SUPERVISOR_AGENT_ID: 
            case INSTANCE_SUPERVISOR_AGENT_ID: 
            case INSTANCE_INITIATOR_AGENT_ID: 
            case NODE_PERFORMING_AGENT_ID: {
                return EntityType.AGENT.identifierID();
            }
            case TEMPLATE_SUPERVISOR_ORGPOSITION_ID: 
            case INSTANCE_SUPERVISOR_ORGPOSITION_ID: 
            case INSTANCE_INITIATOR_ORGPOSITION_ID: 
            case NODE_PERFORMING_ORGPOSITION_ID: {
                return EntityType.ORG_POSITION.identifierID();
            }
            case NODE_STAFF_ASSIGNMENT_RULE: {
                return OrgModelConstants.IDENTIFIER_ID_ENTITY_EXPRESSION;
            }
            case INSTANCE_CREATION_DATE: 
            case NODE_TERMINATION_DATE: {
                return producer.getParameterProperties().getIdentifierID();
            }
        }
        throw new AssertionError((Object)("unhandled SystemDataProducer: " + (Object)((Object)producer)));
    }

    @Override
    public String getLabelForType(Object dependencyType) {
        if (dependencyType == null) {
            return "<none>";
        }
        if (dependencyType.equals(Dependency.DEPENDENCY_TYPE_DATA_ELEMENT)) {
            return Dependency.DEPENDENCY_TYPE_DATA_ELEMENT.toString();
        }
        if (dependencyType instanceof SystemDataProducer) {
            SystemDataProducer producer = (SystemDataProducer)((Object)dependencyType);
            return producer.getParameterProperties().getName();
        }
        return dependencyType.toString();
    }

    @Override
    public String getLabelForArgument(Object dependencyType, Object argument) {
        if (argument != null) {
            ArgChecks.checkForNull(dependencyType, "dependencyType");
        }
        if (argument == null) {
            return "<none>";
        }
        if (dependencyType.equals(Dependency.DEPENDENCY_TYPE_DATA_ELEMENT)) {
            DataElement dataElement = (DataElement)argument;
            String name = dataElement.getName();
            if (name.equals("")) {
                name = "<unnamed data element>";
            }
            return String.valueOf(name) + " (#" + dataElement.getID() + ")";
        }
        if (dependencyType instanceof SystemDataProducer) {
            Node node = (Node)argument;
            String name = node.getName();
            if (name.equals("")) {
                name = "<unnamed node>";
            }
            return String.valueOf(name) + " (#" + node.getID() + ")";
        }
        return argument.toString();
    }

    @Override
    public String getLabelForTypeAndArgument(Dependency dependency) {
        if (dependency == null) {
            return "<none>";
        }
        if (dependency.getArgument() == null) {
            return this.getLabelForType(dependency.getType());
        }
        return String.valueOf(this.getLabelForType(dependency.getType())) + ": " + this.getLabelForArgument(dependency.getType(), dependency.getArgument());
    }

    @Override
    public ParameterRef getPreferredParameter(Dependency dependency) {
        UUID identifierID;
        ProcessConstants.AdeptDataType dataType;
        String name;
        ArgChecks.checkForNull(dependency, "dependency");
        Object depType = dependency.getType();
        Object arg = dependency.getArgument();
        if (depType.equals(Dependency.DEPENDENCY_TYPE_DATA_ELEMENT)) {
            DataElement dataElement = (DataElement)arg;
            if (dataElement == null) {
                throw new IllegalArgumentException("the dependency type argument is missing");
            }
            name = "dataElement-#" + dataElement.getID();
            dataType = dataElement.getDataType();
            identifierID = dataElement.getIdentifierID();
        } else if (depType instanceof SystemDataProducer) {
            Node node = (Node)arg;
            if (node == null) {
                throw new IllegalArgumentException("the dependency type argument is missing");
            }
            ProcessModelParameter paramProps = ((SystemDataProducer)((Object)depType)).getParameterProperties();
            name = paramProps.getName();
            if (Arrays.asList(SystemDataProducer.nodeProduced()).contains(depType)) {
                name = String.valueOf(name) + "-#" + ((Node)arg).getID();
            }
            dataType = paramProps.getDataType();
            identifierID = paramProps.getIdentifierID();
        } else {
            throw new IllegalArgumentException("unhandled dependency type: " + depType);
        }
        Parameter param;
        while (!((param = this.getSystemInputParameter(name)) == null || param.getDataType() == dataType && param.getIdentifierID().equals(identifierID) && this.getDependencyOf(param.getName()).equals(dependency))) {
            name = "_" + name;
        }
        return new ParameterRef(dataType, name);
    }

    Parameter getSystemInputParameter(String name) {
        return this.node.getSystemParameter(name, ActivityConstants.AccessType.SYSTEM_READ);
    }

    public void injectDependency(String parameterName, Dependency dependency) {
        ArgChecks.checkForEmpty(parameterName, "parameterName");
        ArgChecks.checkForNull(dependency, "dependency");
        this.injectedDependencies.put(parameterName, dependency);
    }

    public void removeInjectedDependency(String parameterName) {
        ArgChecks.checkForEmpty(parameterName, "parameterName");
        this.injectedDependencies.remove(parameterName);
    }
}

