/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.UpdateDataEdge;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import java.util.HashMap;

public class ReconnectDataEdge {
    private static final String CHECK_ID = "Reconnect Data Edge";
    private static final String MY_INSTANCE_NAME = "ReconnectDataEdge";

    public static boolean isPossible(Template template, int nodeID, int dataElementID, DataEdge dataEdge, ProcessModelParameter param) {
        return ReconnectDataEdge.isPossible(template, nodeID, dataElementID, dataEdge, param, null);
    }

    public static boolean isPossible(Template template, int nodeID, int dataElementID, DataEdge dataEdge, ProcessModelParameter param, CheckReport checkReport) {
        if (!ReconnectDataEdge.enoughParameter(nodeID, dataElementID, dataEdge, param, template, checkReport)) {
            return false;
        }
        Node node = template.getNode(nodeID);
        ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
        if (ebp == null) {
            if (checkReport != null) {
                String message = "The node: " + template.getNode(nodeID) + " does not have an EBP assigned to it.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID))};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        DataElement dataElement = template.getDataElement(dataElementID);
        if (dataElement.getDataType() != param.getDataType()) {
            if (checkReport != null) {
                String message = "The type attribute of the data element: " + dataElement.getName() + " is not compatible to the one from the parameter: " + param.getName();
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getParameterIdentifier(checkReport.getBase(), node, ebp, param, "dataElementType"));
            }
            return false;
        }
        if (dataElement.isVirtual() != param.isVirtual()) {
            if (checkReport != null) {
                String message = "The isVirtual attribute of the data element: " + dataElement.getName() + " is not compatible to the one from the parameter: " + param.getName();
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getParameterIdentifier(checkReport.getBase(), node, ebp, param, "isVirtual"));
            }
            return false;
        }
        if (!(dataElement.getIdentifierID().equals(param.getIdentifierID()) || dataElement.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) || dataElement.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET))) {
            if (checkReport != null) {
                String message = "The identifier id attribute of the data element: " + dataElement.getName() + " is not compatible to the one from the parameter: " + param.getName();
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getParameterIdentifier(checkReport.getBase(), node, ebp, param, "identifierID"));
            }
            return false;
        }
        return true;
    }

    public static boolean isPossible(ChangeableInstance instance, int nodeID, int dataElementID, DataEdge dataEdge, ProcessModelParameter param) {
        return ReconnectDataEdge.isPossible(instance, nodeID, dataElementID, dataEdge, param, null);
    }

    public static boolean isPossible(ChangeableInstance instance, int nodeID, int dataElementID, DataEdge dataEdge, ProcessModelParameter param, CheckReport checkReport) {
        Template template = instance.getTemplate();
        if (template.getNode(nodeID) == null) {
            return false;
        }
        if (instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(template.getNode(nodeID)) + "' who is involved in the change of the parameter-data-element mapping must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(nodeID).toString() + ".";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID), "NodeState"));
            }
            return false;
        }
        return ReconnectDataEdge.isPossible(template, nodeID, dataElementID, dataEdge, param, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, int nodeID, int dataElementID, DataEdge dataEdge, ProcessModelParameter param) {
        ReconnectDataEdge.performOperation(session, template, nodeID, dataElementID, dataEdge, param, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, int nodeID, int dataElementID, DataEdge dataEdge, ProcessModelParameter param, UpdateManager updateManager) {
        ReconnectDataEdge.performOperation(session, (ChangePrimitives)template, nodeID, dataElementID, dataEdge, param, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, int nodeID, int dataElementID, DataEdge dataEdge, ProcessModelParameter param) {
        ReconnectDataEdge.performOperation(session, instance, nodeID, dataElementID, dataEdge, param, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, int nodeID, int dataElementID, DataEdge dataEdge, ProcessModelParameter param, UpdateManager updateManager) {
        ReconnectDataEdge.performOperation(session, (ChangePrimitives)instance, nodeID, dataElementID, dataEdge, param, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, int nodeID, int dataElementID, DataEdge dataEdge, ProcessModelParameter param, UpdateManager updateManager) {
        int[] disabledConnectors;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        int connectorID = template.getNode(nodeID).getConnectorMapping(dataEdge.getType()).get(param.getName());
        int[] nArray = disabledConnectors = template.getDisabledConnectors(nodeID, dataEdge.getType());
        int n = disabledConnectors.length;
        int n2 = 0;
        while (n2 < n) {
            int disabledConnectorID = nArray[n2];
            if (disabledConnectorID == connectorID) {
                processGraph.removeDisabledConnector(nodeID, connectorID);
                break;
            }
            ++n2;
        }
        processGraph.reMapDataElement(dataElementID, nodeID, dataEdge.getType(), param.getName());
        ReconnectDataEdge.updateDataEdgeOptionalAttribute(session, processGraph, nodeID, dataEdge.getType(), updateManager, dataElementID, param);
    }

    private static void updateDataEdgeOptionalAttribute(SessionToken session, ChangePrimitives processGraph, int nodeID, ActivityConstants.AccessType type, UpdateManager updateManager, int dataElementID, ProcessModelParameter parameter) {
        ProcessModelFactory pmf;
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        DataEdge dummyDataEdge = parameter.isOptional() ? pmf.createDataEdge(type, true, new HashMap<String, String>()) : pmf.createDataEdge(type, false, new HashMap<String, String>());
        UpdateDataEdge.performOperation(session, processGraph, nodeID, dataElementID, type, dummyDataEdge, updateManager, ProcessConstants.DataEdgeProperty.OPTIONAL);
    }

    private static boolean enoughParameter(int nodeID, int dataElementID, DataEdge dataEdge, ProcessModelParameter param, Template template, CheckReport checkReport) {
        if (dataEdge == null || param == null) {
            if (checkReport != null) {
                String message = "Not enough elements for this operation. A data edge, a parameter, a node id and a data element id are needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(nodeID) == null || template.getDataElement(dataElementID) == null) {
            if (checkReport != null) {
                String message = "A node with the given id: " + template.getNode(nodeID) + " and/or a data element with the given id: " + template.getDataElement(dataElementID) + " does not exist in the graph.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

