/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.UpdateDataElement;
import de.aristaflow.adept2.core.changeoperations.UpdateNode;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;

public class RemoveExecutableBusinessProcess {
    private static final String MY_INSTANCE_NAME = "RemoveExecutableBusinessProcess";
    private static final String CHECK_ID = "Remove Executable Business Process";

    public static boolean isPossible(Template template, Node node) {
        return RemoveExecutableBusinessProcess.isPossible(template, node, null);
    }

    public static boolean isPossible(Template template, Node node, CheckReport checkReport) {
        if (template == null) {
            throw new IllegalArgumentException("Template is null");
        }
        if (!RemoveExecutableBusinessProcess.enoughParameter(node, template, checkReport)) {
            return false;
        }
        if (node.getExecutableBusinessProcess() == null) {
            if (checkReport != null) {
                String message = "The given node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' does not have an assigned EBP.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node));
            }
            return false;
        }
        return true;
    }

    public static boolean isPossible(ChangeableInstance instance, Node node) {
        return RemoveExecutableBusinessProcess.isPossible(instance, node, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node node, CheckReport checkReport) {
        if (!RemoveExecutableBusinessProcess.enoughParameter(node, instance.getTemplate(), checkReport)) {
            return false;
        }
        if (instance.getNodeState(node.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(node.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' whose EBP should be removed must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(node.getID()).toString() + ".";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node, "NodeState"));
            }
            return false;
        }
        Template template = instance.getTemplate();
        return RemoveExecutableBusinessProcess.isPossible(template, node, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node node) {
        RemoveExecutableBusinessProcess.performOperation(session, template, node, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node node, UpdateManager updateManager) {
        RemoveExecutableBusinessProcess.performOperation(session, (ChangePrimitives)template, node, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node node) {
        RemoveExecutableBusinessProcess.performOperation(session, instance, node, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node node, UpdateManager updateManager) {
        RemoveExecutableBusinessProcess.performOperation(session, (ChangePrimitives)instance, node, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, Node node, UpdateManager updateManager) {
        ProcessModelFactory pmf;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        Node tempNode = pmf.createNode(node.getID(), node.getName(), "", "", null, false, node.getIconID(), null, null, node.getSupportedPlugins(), node.getPluginDatas(), node.getUserAttributes());
        UpdateNode.performOperation(processGraph, tempNode, updateManager, ProcessConstants.NodeProperty.EXECUTABLE_BUSINESS_PROCESS);
        int[] readDataElements = template.getAccessedDataElementIDsForNode(node.getID(), ActivityConstants.AccessType.READ);
        RemoveExecutableBusinessProcess.updateDataElements(session, processGraph, readDataElements, updateManager);
        int[] writtenDataElements = template.getAccessedDataElementIDsForNode(node.getID(), ActivityConstants.AccessType.WRITE);
        RemoveExecutableBusinessProcess.updateDataElements(session, processGraph, writtenDataElements, updateManager);
        if (updateManager != null && ebp instanceof DecisionActivity) {
            int[] nodeIDs;
            int[] nArray = nodeIDs = template.getSuccByEdgeType(node.getID(), ProcessConstants.EdgeType.ET_CONTROL, ProcessConstants.EdgeType.ET_LOOP);
            int n = nodeIDs.length;
            int n2 = 0;
            while (n2 < n) {
                int nodeID = nArray[n2];
                Edge edge = template.getEdge(node.getID(), nodeID, ProcessConstants.EdgeType.ET_CONTROL);
                if (edge == null) {
                    edge = template.getEdge(node.getID(), nodeID, ProcessConstants.EdgeType.ET_LOOP);
                }
                updateManager.firePropertyChange(edge, (Object)UpdateManager.EdgeProperties.EDGE_LABEL);
                ++n2;
            }
        }
    }

    private static void updateDataElements(SessionToken session, ChangePrimitives processGraph, int[] dataElementIDs, UpdateManager updateManager) {
        ProcessModelFactory pmf;
        Template template;
        boolean isInstance = false;
        if (processGraph instanceof ChangeableInstance) {
            template = ((ChangeableInstance)processGraph).getTemplate();
            isInstance = true;
        } else {
            template = (ChangeableTemplate)processGraph;
        }
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        int[] nArray = dataElementIDs;
        int n = dataElementIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int dataID = nArray[n2];
            DataElement data = template.getDataElement(dataID);
            if (!(isInstance ? !UpdateDataElement.isPossible((ChangeableInstance)processGraph, data, ProcessConstants.DataElementProperty.IDENTIFIER) : !UpdateDataElement.isPossible((Template)((ChangeableTemplate)processGraph), data, ProcessConstants.DataElementProperty.IDENTIFIER))) {
                DataElement tempDataElement = pmf.createDataElement(data.getID(), data.getName(), data.getDataType(), data.getDescription(), data.getUDTName(), data.getIconID(), ProcessConstants.IDENTIFIER_NOT_SET, data.isPublic(), data.isVirtual(), data.getSupportedPlugins(), data.getPluginDatas(), data.getUserAttributes());
                UpdateDataElement.performOperation(session, processGraph, tempDataElement, updateManager, ProcessConstants.DataElementProperty.IDENTIFIER);
            }
            ++n2;
        }
    }

    private static boolean enoughParameter(Node node, Template template, CheckReport checkReport) {
        if (node == null) {
            if (checkReport != null) {
                String message = "Not enough elements for this operation. A single node is needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(node.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain the given node." + ChangeOperationTools.getHumanReadableNodeName(node);
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

