/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.AddNodeSystemParameter;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.UpdateNode;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class RemoveNodeSystemParameter {
    private static final String MY_INSTANCE_NAME = "RemoveNodeSystemParameter";
    protected static final Logger logger = LoggerTools.getLogger(RemoveNodeSystemParameter.class);
    private static final String CHECK_ID = "Remove Node System Parameter";

    public static boolean isPossible(Template template, int nodeID, ActivityConstants.AccessType type, String parameterName) {
        return RemoveNodeSystemParameter.isPossible(template, nodeID, type, parameterName, null);
    }

    public static boolean isPossible(Template template, int nodeID, ActivityConstants.AccessType type, String parameterName, CheckReport checkReport) {
        Method[] methods;
        Node node;
        boolean parameterReferenceExists;
        boolean possible = true;
        if (!RemoveNodeSystemParameter.enoughParameter(template, type, nodeID, parameterName, checkReport)) {
            possible = false;
        }
        if (parameterReferenceExists = AddNodeSystemParameter.parameterReferenceExists(node = template.getNode(nodeID), methods = Node.class.getMethods(), parameterName)) {
            if (checkReport != null) {
                String message = "Parameter '%s' cannot be removed because it is still references in a system data consumer (Staff Assignment Rule, Node name, etc.)!";
                message = String.format(message, parameterName);
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return possible;
    }

    public static boolean isPossible(Instance instance, int nodeID, ActivityConstants.AccessType type, String parameterName) {
        return RemoveNodeSystemParameter.isPossible(instance, nodeID, type, parameterName, null);
    }

    public static boolean isPossible(Instance instance, int nodeID, ActivityConstants.AccessType type, String parameterName, CheckReport checkReport) {
        if (!(instance instanceof ChangeableInstance)) {
            if (checkReport != null) {
                String message = "The given instance is of type: " + instance.getClass().getName() + " but it must be of type ChangeableInstance.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, checkReport.getBase());
            }
            return false;
        }
        Template template = instance.getTemplate();
        if (!RemoveNodeSystemParameter.enoughParameter(template, type, nodeID, parameterName, checkReport)) {
            return false;
        }
        if (instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(template.getNode(nodeID)) + "' where the system parameter should be removed must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(nodeID).toString() + ".";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID), "NodeState")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return RemoveNodeSystemParameter.isPossible(template, nodeID, type, parameterName, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, int nodeID, ActivityConstants.AccessType type, String parameterName) {
        RemoveNodeSystemParameter.performOperation(session, template, nodeID, type, parameterName, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, int nodeID, ActivityConstants.AccessType type, String parameterName, UpdateManager updateManager) {
        RemoveNodeSystemParameter.performOperation(session, (ChangePrimitives)template, nodeID, type, parameterName, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, int nodeID, ActivityConstants.AccessType type, String parameterName) {
        RemoveNodeSystemParameter.performOperation(session, instance, nodeID, type, parameterName, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, int nodeID, ActivityConstants.AccessType type, String parameterName, UpdateManager updateManager) {
        RemoveNodeSystemParameter.performOperation(session, (ChangePrimitives)instance, nodeID, type, parameterName, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, int nodeID, ActivityConstants.AccessType type, String parameterName, UpdateManager updateManager) {
        ProcessModelFactory pmf;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>> systemParams = new HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>>();
        Node node = template.getNode(nodeID);
        HashSet<ProcessModelParameter> params = new HashSet<ProcessModelParameter>(node.getSystemParameters(type));
        ProcessModelParameter parameter = node.getSystemParameter(parameterName, type);
        params.remove(parameter);
        systemParams.put(type, params);
        Node dummyNode = pmf.createNode(nodeID, "", "", "", null, false, null, null, systemParams, null, null, null);
        ProcessConstants.NodeProperty property = type == ActivityConstants.AccessType.SYSTEM_READ ? ProcessConstants.NodeProperty.SYSTEM_READ_PARAMS : ProcessConstants.NodeProperty.SYSTEM_WRITE_PARAMS;
        UpdateNode.performOperation(processGraph, dummyNode, updateManager, property);
        if (updateManager != null) {
            if (property == ProcessConstants.NodeProperty.SYSTEM_READ_PARAMS) {
                updateManager.firePropertyChange(node, (Object)UpdateManager.NodeProperties.NODE_SYSTEM_READ_PARAMS);
            } else {
                updateManager.firePropertyChange(node, (Object)UpdateManager.NodeProperties.NODE_SYSTEM_WRITE_PARAMS);
            }
        }
    }

    private static boolean enoughParameter(Template template, ActivityConstants.AccessType type, int nodeID, String parameterName, CheckReport checkReport) {
        if (template.getNode(nodeID) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain the node with the ID: " + nodeID;
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (type != ActivityConstants.AccessType.SYSTEM_READ && type != ActivityConstants.AccessType.SYSTEM_WRITE) {
            if (checkReport != null) {
                String message = "The access type of a System Parameter must be SYSTEM_READ or SYSTEM.WRITE";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(nodeID).getSystemParameter(parameterName, type) == null) {
            if (checkReport != null) {
                String message = "The given system parameter does not exist for the given access type in the given node";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

