/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.DeleteDataEdge;
import de.aristaflow.adept2.core.changeoperations.DeleteDataElement;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class RemoveSystemDataFlow {
    protected static final Logger logger = LoggerTools.getLogger(RemoveSystemDataFlow.class);
    private static final String CHECK_ID = "Remove System Data Flow";

    public static boolean isPossible(Template template, int nodeID, String inputParameterName) {
        return RemoveSystemDataFlow.isPossible(template, nodeID, inputParameterName, null);
    }

    public static boolean isPossible(Template template, int nodeID, String inputParameterName, CheckReport checkReport) {
        Node node;
        int connectorID;
        boolean possible = true;
        if (!RemoveSystemDataFlow.enoughParameter(template, nodeID, inputParameterName, checkReport)) {
            possible = false;
        }
        if (template.getDataElement(nodeID, connectorID = (node = template.getNode(nodeID)).getConnector(inputParameterName, ActivityConstants.AccessType.SYSTEM_READ)) == null) {
            if (checkReport != null) {
                String message = "The system data flow for the parameter of the node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' can't be removed, because it does not exist.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return possible;
    }

    public static boolean isPossible(Instance instance, int nodeID, String inputParameterName) {
        return RemoveSystemDataFlow.isPossible(instance, nodeID, inputParameterName, null);
    }

    public static boolean isPossible(Instance instance, int nodeID, String inputParameterName, CheckReport checkReport) {
        if (!(instance instanceof ChangeableInstance)) {
            if (checkReport != null) {
                String message = "The given instance is of type: " + instance.getClass().getName() + " but it must be of type ChangeableInstance.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, checkReport.getBase());
            }
            return false;
        }
        Template template = instance.getTemplate();
        if (!RemoveSystemDataFlow.enoughParameter(template, nodeID, inputParameterName, checkReport)) {
            return false;
        }
        if (instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(template.getNode(nodeID)) + "' which contains the parameter must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(nodeID).toString() + ".";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID), "NodeState")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return RemoveSystemDataFlow.isPossible(template, nodeID, inputParameterName, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, int nodeID, String inputParameterName) {
        RemoveSystemDataFlow.performOperation(session, template, nodeID, inputParameterName, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, int nodeID, String inputParameterName, UpdateManager updateManager) {
        RemoveSystemDataFlow.performOperation(session, (ChangePrimitives)template, nodeID, inputParameterName, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, int nodeID, String inputParameterName) {
        RemoveSystemDataFlow.performOperation(session, instance, nodeID, inputParameterName, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, int nodeID, String inputParameterName, UpdateManager updateManager) {
        RemoveSystemDataFlow.performOperation(session, (ChangePrimitives)instance, nodeID, inputParameterName, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, int nodeID, String inputParameterName, UpdateManager updateManager) {
        int[] systemReadNodeIDs;
        Template template;
        boolean isInstance = false;
        if (processGraph instanceof ChangeableInstance) {
            template = ((ChangeableInstance)processGraph).getTemplate();
            isInstance = true;
        } else {
            template = (ChangeableTemplate)processGraph;
        }
        Node node = template.getNode(nodeID);
        int connectorID = node.getConnector(inputParameterName, ActivityConstants.AccessType.SYSTEM_READ);
        DataElement dataElement = template.getDataElement(nodeID, connectorID);
        boolean deleteDataElement = true;
        int[] readNodeIDs = template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.READ);
        if (readNodeIDs.length != 0) {
            deleteDataElement = false;
        }
        if ((systemReadNodeIDs = template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.SYSTEM_READ)).length != 1) {
            deleteDataElement = false;
        }
        if (!ProcessModelTools.isSystemDataElement(template, dataElement.getID())) {
            deleteDataElement = false;
        }
        if (deleteDataElement && isInstance) {
            deleteDataElement = DeleteDataElement.isPossible((ChangeableInstance)processGraph, dataElement);
        }
        if (deleteDataElement) {
            int[] writeNodeIDs = template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.SYSTEM_WRITE);
            assert (writeNodeIDs.length == 1 || writeNodeIDs.length == 0);
            if (writeNodeIDs.length > 0) {
                template.getConnector(writeNodeIDs[0], dataElement.getID(), ActivityConstants.AccessType.SYSTEM_WRITE);
            }
            logger.info("Calling change operation Delete Data Element");
            DeleteDataElement.performOperation(session, processGraph, dataElement, updateManager);
        } else {
            logger.info("Calling change operation Delete Data Edge");
            DeleteDataEdge.performOperation(session, processGraph, node, dataElement, ActivityConstants.AccessType.SYSTEM_READ, updateManager);
        }
    }

    private static boolean enoughParameter(Template template, int nodeID, String inputParameterName, CheckReport checkReport) {
        if (template.getNode(nodeID) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain the node with the given ID: " + nodeID + "'";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(nodeID).getSystemParameter(inputParameterName, ActivityConstants.AccessType.SYSTEM_READ) == null) {
            if (checkReport != null) {
                String message = "The node must have a parameter with the given name: '" + inputParameterName + "', but this is not the case.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

