/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.UpdateDataEdge;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import java.util.HashMap;

public class SwapDataElementParameterConnections {
    private static final String CHECK_ID = "Swap Data Element Parameter Connections";
    private static final String MY_INSTANCE_NAME = "SwapDataElementParameterConnections";

    public static boolean isPossible(Template template, int nodeID, int dataElementID1, DataEdge dataEdge1, int dataElementID2, DataEdge dataEdge2) {
        return SwapDataElementParameterConnections.isPossible(template, nodeID, dataElementID1, dataEdge1, dataElementID2, dataEdge2, null);
    }

    public static boolean isPossible(Template template, int nodeID, int dataElementID1, DataEdge dataEdge1, int dataElementID2, DataEdge dataEdge2, CheckReport checkReport) {
        if (dataEdge1 == null || dataEdge2 == null) {
            if (checkReport != null) {
                String message = "Not enough data edges for this operation. Two data edges are needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (!SwapDataElementParameterConnections.enoughParameter(nodeID, template, checkReport)) {
            return false;
        }
        if (template.getDataElement(dataElementID1) == null || template.getDataElement(dataElementID2) == null) {
            if (checkReport != null) {
                String message = "The data elements with the given IDs: " + template.getDataElement(dataElementID1) + " and " + template.getDataElement(dataElementID1) + " are not in the given template.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(nodeID).getExecutableBusinessProcess() == null) {
            if (checkReport != null) {
                String message = "The node: " + template.getNode(nodeID) + " does not have an EBP assigned to it.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID))};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        if (dataEdge1.getType() != dataEdge2.getType()) {
            if (checkReport != null) {
                String message = "The given data edges must have the same access type (direction), but this is not the case.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getDataEdgeIdentifier(checkReport.getBase(), template.getNode(nodeID), template.getDataElement(dataElementID1), dataEdge1.getType()), ProcessElementIdentifierTools.getDataEdgeIdentifier(checkReport.getBase(), template.getNode(nodeID), template.getDataElement(dataElementID2), dataEdge2.getType())};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        int connectorID1 = template.getConnector(nodeID, dataElementID1, dataEdge1.getType());
        int connectorID2 = template.getConnector(nodeID, dataElementID2, dataEdge2.getType());
        String paramName1 = template.getNode(nodeID).getParameterName(connectorID1);
        String paramName2 = template.getNode(nodeID).getParameterName(connectorID2);
        ProcessModelParameter param1 = template.getNode(nodeID).getExecutableBusinessProcess().getParameter(paramName1, dataEdge1.getType());
        ProcessModelParameter param2 = template.getNode(nodeID).getExecutableBusinessProcess().getParameter(paramName2, dataEdge2.getType());
        DataElement dataElement1 = template.getDataElement(dataElementID1);
        DataElement dataElement2 = template.getDataElement(dataElementID1);
        if (dataElement1.getDataType() != param2.getDataType()) {
            if (checkReport != null) {
                String message = "The type attribute of the first data edge is not compatible to those from the second parameter";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), dataElement1, "dataElementType"));
            }
            return false;
        }
        if (dataElement1.isVirtual() != param2.isVirtual()) {
            if (checkReport != null) {
                String message = "The isVirtual attribute of the first data edge is not compatible to those from the second parameter";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), dataElement1, "isVirtual"));
            }
            return false;
        }
        if (!(dataElement1.getIdentifierID().equals(param2.getIdentifierID()) || dataElement1.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) || dataElement1.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET))) {
            if (checkReport != null) {
                String message = "The identifier id attribute of the first data edge is not compatible to those from the second parameter";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), dataElement1, "identifierID"));
            }
            return false;
        }
        if (dataElement2.getDataType() != param1.getDataType()) {
            if (checkReport != null) {
                String message = "The type attribute of the first data edge is not compatible to those from the first parameter";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), dataElement2, "dataElementType"));
            }
            return false;
        }
        if (dataElement2.isVirtual() != param1.isVirtual()) {
            if (checkReport != null) {
                String message = "The isVirtual attribute of the first data edge is not compatible to those from the first parameter";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), dataElement2, "isVirtual"));
            }
            return false;
        }
        if (!(dataElement2.getIdentifierID().equals(param1.getIdentifierID()) || dataElement2.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) || dataElement2.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET))) {
            if (checkReport != null) {
                String message = "The identifier id attribute of the first data edge is not compatible to those from the first parameter";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), dataElement2, "identifierID"));
            }
            return false;
        }
        return true;
    }

    public static boolean isPossible(ChangeableInstance instance, int nodeID, int dataElementID1, DataEdge dataEdge1, int dataElementID2, DataEdge dataEdge2) {
        return SwapDataElementParameterConnections.isPossible(instance, nodeID, dataElementID1, dataEdge1, dataElementID2, dataEdge2, null);
    }

    public static boolean isPossible(ChangeableInstance instance, int nodeID, int dataElementID1, DataEdge dataEdge1, int dataElementID2, DataEdge dataEdge2, CheckReport checkReport) {
        Template template = instance.getTemplate();
        if (!SwapDataElementParameterConnections.enoughParameter(nodeID, template, checkReport)) {
            return false;
        }
        if (instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(template.getNode(nodeID)) + "' whose data element mapping should be changed must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(nodeID).toString() + ".";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID), "NodeState"));
            }
            return false;
        }
        return SwapDataElementParameterConnections.isPossible(template, nodeID, dataElementID1, dataEdge1, dataElementID2, dataEdge2, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, int nodeID, int dataElementID1, DataEdge dataEdge1, int dataElementID2, DataEdge dataEdge2) {
        SwapDataElementParameterConnections.performOperation(session, template, nodeID, dataElementID1, dataEdge1, dataElementID2, dataEdge2, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, int nodeID, int dataElementID1, DataEdge dataEdge1, int dataElementID2, DataEdge dataEdge2, UpdateManager updateManager) {
        SwapDataElementParameterConnections.performOperation(session, (ChangePrimitives)template, nodeID, dataElementID1, dataEdge1, dataElementID2, dataEdge2, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, int nodeID, int dataElementID1, DataEdge dataEdge1, int dataElementID2, DataEdge dataEdge2) {
        SwapDataElementParameterConnections.performOperation(session, instance, nodeID, dataElementID1, dataEdge1, dataElementID2, dataEdge2, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, int nodeID, int dataElementID1, DataEdge dataEdge1, int dataElementID2, DataEdge dataEdge2, UpdateManager updateManager) {
        SwapDataElementParameterConnections.performOperation(session, (ChangePrimitives)instance, nodeID, dataElementID1, dataEdge1, dataElementID2, dataEdge2, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, int nodeID, int dataElementID1, DataEdge dataEdge1, int dataElementID2, DataEdge dataEdge2, UpdateManager updateManager) {
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        int connectorID1 = template.getConnector(nodeID, dataElementID1, dataEdge1.getType());
        int connectorID2 = template.getConnector(nodeID, dataElementID2, dataEdge2.getType());
        Node node = template.getNode(nodeID);
        String paramName1 = node.getParameterName(connectorID1);
        String paramName2 = node.getParameterName(connectorID2);
        processGraph.reMapDataElement(dataElementID1, nodeID, dataEdge1.getType(), paramName2);
        processGraph.reMapDataElement(dataElementID2, nodeID, dataEdge2.getType(), paramName1);
        if (node.getExecutableBusinessProcess() != null) {
            ProcessModelParameter param2 = node.getExecutableBusinessProcess().getParameter(paramName2, dataEdge1.getType());
            SwapDataElementParameterConnections.updateDataEdgeOptionalAttribute(session, processGraph, nodeID, dataEdge1.getType(), updateManager, dataElementID1, param2);
            ProcessModelParameter param1 = node.getExecutableBusinessProcess().getParameter(paramName1, dataEdge2.getType());
            SwapDataElementParameterConnections.updateDataEdgeOptionalAttribute(session, processGraph, nodeID, dataEdge2.getType(), updateManager, dataElementID2, param1);
        }
    }

    private static void updateDataEdgeOptionalAttribute(SessionToken session, ChangePrimitives processGraph, int nodeID, ActivityConstants.AccessType type, UpdateManager updateManager, int dataElementID, ProcessModelParameter parameter) {
        ProcessModelFactory pmf;
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        DataEdge dummyDataEdge = parameter.isOptional() ? pmf.createDataEdge(type, true, new HashMap<String, String>()) : pmf.createDataEdge(type, false, new HashMap<String, String>());
        UpdateDataEdge.performOperation(session, processGraph, nodeID, dataElementID, type, dummyDataEdge, updateManager, ProcessConstants.DataEdgeProperty.OPTIONAL);
    }

    private static boolean enoughParameter(int nodeID, Template template, CheckReport checkReport) {
        if (template.getNode(nodeID) == null) {
            if (checkReport != null) {
                String message = "A node with the given id: " + template.getNode(nodeID) + " does not exist in the given template/instance.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

