/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;

public class ToggleSyncEdge {
    protected static final Logger logger = LoggerTools.getLogger(ToggleSyncEdge.class);
    private static final String CHECK_ID = "Toggle Sync Edge";

    public static boolean isPossible(Template template, Node pred, Node succ) {
        return ToggleSyncEdge.isPossible(template, pred, succ, null);
    }

    public static boolean isPossible(Template template, Node pred, Node succ, CheckReport checkReport) {
        String message;
        if (!ToggleSyncEdge.enoughParameter(pred, succ, template, checkReport)) {
            return false;
        }
        if (template.getEdge(pred.getID(), succ.getID(), ProcessConstants.EdgeType.ET_SYNC) != null) {
            return true;
        }
        if (pred.getID() == succ.getID()) {
            if (checkReport != null) {
                String message2 = "The given nodes '" + ChangeOperationTools.getHumanReadableNodeName(pred) + "', '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "' are equal.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), pred), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message2, affectedElements);
            }
            return false;
        }
        if (template.getNodeBranchID(pred.getID()) == template.getNodeBranchID(succ.getID())) {
            if (checkReport != null) {
                String message3 = "The given nodes '" + ChangeOperationTools.getHumanReadableNodeName(pred) + "', '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "' are on the same branch. The insertion of a sync edge is senseless/not possible";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), pred, "branchID"), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ, "branchID")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message3, affectedElements);
            }
            return false;
        }
        if (template.getNodeType(pred.getID()) == ProcessConstants.NodeType.NT_STARTFLOW || template.getNodeType(pred.getID()) == ProcessConstants.NodeType.NT_ENDFLOW || template.getNodeType(succ.getID()) == ProcessConstants.NodeType.NT_STARTFLOW || template.getNodeType(succ.getID()) == ProcessConstants.NodeType.NT_ENDFLOW || template.getNodeType(pred.getID()) == ProcessConstants.NodeType.NT_STARTLOOP || template.getNodeType(pred.getID()) == ProcessConstants.NodeType.NT_ENDLOOP) {
            if (checkReport != null) {
                String message4 = "One/Both of the given nodes '" + ChangeOperationTools.getHumanReadableNodeName(pred) + "', '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "' has/have an illegal type ((loop)start node, (loop)end node).";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), pred, "NodeType"), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ, "NodeType")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message4, affectedElements);
            }
            return false;
        }
        if (template.getEdge(succ.getID(), pred.getID(), ProcessConstants.EdgeType.ET_SYNC) != null) {
            if (checkReport != null) {
                String message5 = "There is a sync edge between the given nodes '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "', '" + ChangeOperationTools.getHumanReadableNodeName(pred) + "' already. Inserting a sync edge in the other direction would lead to a cycle.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message5, ProcessElementIdentifierTools.getEdgeIdentifier(checkReport.getBase(), succ, pred, ProcessConstants.EdgeType.ET_SYNC));
            }
            return false;
        }
        HashMap<Integer, Integer> predSplitIDs = new HashMap<Integer, Integer>();
        int splitNode = pred.getID();
        do {
            predSplitIDs.put(template.getNodeBranchID(splitNode), splitNode);
        } while (template.getNodeType(splitNode = template.getNodeSplitNodeID(splitNode)) != ProcessConstants.NodeType.NT_STARTFLOW);
        Set<StructuredEdge> loopEdges = template.getEdgeStructure(ProcessConstants.EdgeType.ET_LOOP);
        for (StructuredEdge lEdge : loopEdges) {
            int loopEndTopID = template.getNodeTopologicalID(lEdge.getSourceNodeID());
            int loopStartTopID = template.getNodeTopologicalID(lEdge.getDestinationNodeID());
            int srcTopID = template.getNodeTopologicalID(pred.getID());
            int destTopID = template.getNodeTopologicalID(succ.getID());
            if (srcTopID > loopStartTopID && srcTopID < loopEndTopID) {
                if (destTopID >= loopStartTopID && destTopID <= loopEndTopID) continue;
                if (checkReport != null) {
                    String message6 = "A sync edge between the given nodes '" + ChangeOperationTools.getHumanReadableNodeName(pred) + "', '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "' would cross the boundaries of the loop block ('" + lEdge.getDestinationNodeID() + ", " + lEdge.getSourceNodeID() + "'). This violates the ADEPT block structure.";
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), pred), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ), ProcessElementIdentifierTools.getBlockIdentifier(checkReport.getBase(), template.getNode(lEdge.getSourceNodeID()), template.getNode(lEdge.getDestinationNodeID()))};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message6, affectedElements);
                }
                return false;
            }
            if (destTopID <= loopStartTopID || destTopID >= loopEndTopID) continue;
            if (checkReport != null) {
                String message7 = "A sync edge between the given nodes '" + ChangeOperationTools.getHumanReadableNodeName(pred) + "', '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "' would cross the boundaries of the loop block ('" + lEdge.getDestinationNodeID() + ", " + lEdge.getSourceNodeID() + "'). This violates the ADEPT block structure.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), pred), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ), ProcessElementIdentifierTools.getBlockIdentifier(checkReport.getBase(), template.getNode(lEdge.getSourceNodeID()), template.getNode(lEdge.getDestinationNodeID()))};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message7, affectedElements);
            }
            return false;
        }
        splitNode = succ.getID();
        boolean splitNodeFound = false;
        do {
            if (!predSplitIDs.containsKey(template.getNodeBranchID(splitNode))) continue;
            if (splitNode != (Integer)predSplitIDs.get(template.getNodeBranchID(splitNode))) {
                if (checkReport != null) {
                    message = template.isTransPredOf(pred.getID(), succ.getID(), ProcessConstants.EdgeType.ET_CONTROL) ? "'The node '" + ChangeOperationTools.getHumanReadableNodeName(pred) + "', is a predecessor of the node '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "'. Connecting them with a sync-edge is senseless/forbidden." : "'The node '" + ChangeOperationTools.getHumanReadableNodeName(pred) + "', is a successor of the node '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "'. Connecting them with a sync-edge is senseless/forbidden.";
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), pred), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ)};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                return false;
            }
            if (template.getNodeType(splitNode).equals((Object)ProcessConstants.NodeType.NT_AND_SPLIT) && splitNode != pred.getID()) {
                splitNodeFound = true;
                break;
            }
            if (checkReport != null) {
                message = "'The common split node '" + ChangeOperationTools.getHumanReadableNodeName(template.getNode(splitNode)) + "' of the given nodes '" + ChangeOperationTools.getHumanReadableNodeName(pred) + "', is of type '" + template.getNodeType(splitNode).toString() + "', but the common split node must be of type AND_SPLIT.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(splitNode), "NodeType"));
            }
            return false;
        } while (template.getNodeType(splitNode = template.getNodeSplitNodeID(splitNode)) != ProcessConstants.NodeType.NT_STARTFLOW);
        if (!splitNodeFound) {
            if (checkReport != null) {
                message = "'The given nodes '" + ChangeOperationTools.getHumanReadableNodeName(pred) + "', '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "', do not have a common AND_SPLIT node. An insertion of a sync-edge is forbidden.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), pred), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        if (template.isTransPredOf(pred.getID(), succ.getID(), ProcessConstants.EdgeType.ET_CONTROL, ProcessConstants.EdgeType.ET_SYNC)) {
            if (checkReport != null) {
                message = "Inserting a sync edge between the given nodes '" + ChangeOperationTools.getHumanReadableNodeName(pred) + "', '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "' would lead to a deadlock causing cycle.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), pred), ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return true;
    }

    public static boolean isPossible(ChangeableInstance instance, Node pred, Node succ) {
        return ToggleSyncEdge.isPossible(instance, pred, succ, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node pred, Node succ, CheckReport checkReport) {
        if (!ToggleSyncEdge.enoughParameter(pred, succ, instance.getTemplate(), checkReport)) {
            return false;
        }
        Template template = instance.getTemplate();
        if (instance.getNodeState(succ.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(succ.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(succ) + "' given as target for the sync-edge must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(succ.getID()).toString() + ".";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), succ, "NodeState")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return ToggleSyncEdge.isPossible(template, pred, succ, checkReport);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node pred, Node succ) {
        ToggleSyncEdge.performOperation(session, template, pred, succ, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node pred, Node succ, UpdateManager updateManager) {
        ToggleSyncEdge.performOperation(session, (ChangePrimitives)template, pred, succ, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node pred, Node succ) {
        ToggleSyncEdge.performOperation(session, instance, pred, succ, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node pred, Node succ, UpdateManager updateManager) {
        ToggleSyncEdge.performOperation(session, (ChangePrimitives)instance, pred, succ, updateManager);
        instance.setNodeState(succ.getID(), ProcessConstants.NodeState.NS_NOT_ACTIVATED);
        if (updateManager != null) {
            ChangeOperationTools.fireNodeStateChangedEvent(updateManager, instance, succ);
        }
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, Node pred, Node succ, UpdateManager updateManager) {
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        if (template.getEdge(pred.getID(), succ.getID(), ProcessConstants.EdgeType.ET_SYNC) != null) {
            processGraph.removeEdge(pred.getID(), succ.getID(), ProcessConstants.EdgeType.ET_SYNC);
        } else {
            Edge newSyncEdge = ChangeOperationTools.createSimpleEdgeObject(session, ProcessConstants.EdgeType.ET_SYNC);
            logger.info("calling ChangePrimitive addEdge");
            processGraph.addEdge(pred.getID(), succ.getID(), newSyncEdge);
        }
        if (updateManager != null) {
            updateManager.firePropertyChange(pred, (Object)UpdateManager.NodeProperties.NODE_OUT_EDGES);
            updateManager.firePropertyChange(succ, (Object)UpdateManager.NodeProperties.NODE_IN_EDGES);
        }
    }

    private static boolean enoughParameter(Node pred, Node succ, Template template, CheckReport checkReport) {
        if (pred == null || succ == null) {
            if (checkReport != null) {
                String message = "Not enough selected nodes for this operation. A node as sync-edge-start and a node as sync-edge-end are needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(pred.getID()) == null || template.getNode(succ.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain one or both of the source/target nodes.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

