/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.UpdateInstance;
import de.aristaflow.adept2.core.changeoperations.UpdateTemplate;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

public class UpdateDataEdge {
    protected static final Logger logger = LoggerTools.getLogger(UpdateDataEdge.class);
    private static final String CHECK_ID = "Update DataEdge";
    private static final String MY_INSTANCE_NAME = "UpdateDataEdge";

    public static boolean isPossible(Template template, int nodeID, int dataElementID, ActivityConstants.AccessType type, ProcessConstants.DataEdgeProperty ... dataEdgeProperties) {
        ProcessConstants.DataEdgeProperty[] dataEdgePropertyArray = dataEdgeProperties;
        int n = dataEdgeProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.DataEdgeProperty dataEdgeProperty = dataEdgePropertyArray[n2];
            if (dataEdgeProperty == ProcessConstants.DataEdgeProperty.TYPE || dataEdgeProperty == ProcessConstants.DataEdgeProperty.USER_ATTRIBUTE) {
                throw new IllegalArgumentException("The given property/properties can't be changed with this operation.");
            }
            ++n2;
        }
        return UpdateDataEdge.isPossible(template, nodeID, dataElementID, type, null, dataEdgeProperties);
    }

    public static boolean isPossible(Template template, int nodeID, int dataElementID, ActivityConstants.AccessType type, CheckReport checkReport, ProcessConstants.DataEdgeProperty ... dataEdgeProperties) {
        if (!UpdateDataEdge.enoughParameter(nodeID, dataElementID, type, template, checkReport)) {
            return false;
        }
        ProcessConstants.DataEdgeProperty[] dataEdgePropertyArray = dataEdgeProperties;
        int n = dataEdgeProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.DataEdgeProperty dataEdgeProperty = dataEdgePropertyArray[n2];
            if (dataEdgeProperty == ProcessConstants.DataEdgeProperty.TYPE) {
                if (checkReport != null) {
                    String message = "It is forbidden to change the type of a data edge.";
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID)), ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), template.getDataElement(dataElementID))};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                return false;
            }
            ++n2;
        }
        Node node = template.getNode(nodeID);
        if (node.getExecutableBusinessProcess() != null) {
            if (checkReport != null) {
                String message = "The node which is the source/target of the data edge has already an assigned activity/executableBusinessProcess. Therefore a change of the OPTIONAL Attribute is forbidden.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID)), ProcessElementIdentifierTools.getEBPIdentifier(checkReport.getBase(), template.getNode(nodeID), template.getNode(nodeID).getExecutableBusinessProcess())};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return true;
    }

    public static boolean isPossible(ChangeableInstance instance, int nodeID, int dataElementID, ActivityConstants.AccessType type, ProcessConstants.DataEdgeProperty ... dataEdgeProperties) {
        return UpdateDataEdge.isPossible(instance, nodeID, dataElementID, type, null, dataEdgeProperties);
    }

    public static boolean isPossible(ChangeableInstance instance, int nodeID, int dataElementID, ActivityConstants.AccessType type, CheckReport checkReport, ProcessConstants.DataEdgeProperty ... dataEdgeProperties) {
        Template template = instance.getTemplate();
        if (!UpdateDataEdge.enoughParameter(nodeID, dataElementID, type, template, checkReport)) {
            return false;
        }
        if (instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(template.getNode(nodeID)) + "' which is the source/target of the data edge whose properties should be updated must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(nodeID).toString() + ".";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nodeID), "NodeState")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return UpdateDataEdge.isPossible(template, nodeID, dataElementID, type, checkReport, dataEdgeProperties);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, int nodeID, int dataElementID, ActivityConstants.AccessType type, DataEdge dataEdge, ProcessConstants.DataEdgeProperty ... dataEdgeProperties) {
        UpdateDataEdge.performOperation(session, template, nodeID, dataElementID, type, dataEdge, null, dataEdgeProperties);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, int nodeID, int dataElementID, ActivityConstants.AccessType type, DataEdge dataEdge, UpdateManager updateManager, ProcessConstants.DataEdgeProperty ... dataEdgeProperties) {
        UpdateDataEdge.performOperation(session, (ChangePrimitives)template, nodeID, dataElementID, type, dataEdge, updateManager, dataEdgeProperties);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, int nodeID, int dataElementID, ActivityConstants.AccessType type, DataEdge dataEdge, ProcessConstants.DataEdgeProperty ... dataEdgeProperties) {
        UpdateDataEdge.performOperation(session, instance, nodeID, dataElementID, type, dataEdge, null, dataEdgeProperties);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, int nodeID, int dataElementID, ActivityConstants.AccessType type, DataEdge dataEdge, UpdateManager updateManager, ProcessConstants.DataEdgeProperty ... dataEdgeProperties) {
        UpdateDataEdge.performOperation(session, (ChangePrimitives)instance, nodeID, dataElementID, type, dataEdge, updateManager, dataEdgeProperties);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, int nodeID, int dataElementID, ActivityConstants.AccessType type, DataEdge dataEdge, UpdateManager updateManager, ProcessConstants.DataEdgeProperty ... dataEdgeProperties) {
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        logger.info("calling change primitive updateDataEdge");
        processGraph.updateDataEdge(nodeID, dataElementID, type, dataEdge, dataEdgeProperties);
        if (!type.equals((Object)ActivityConstants.AccessType.SYSTEM_READ) && !type.equals((Object)ActivityConstants.AccessType.SYSTEM_WRITE)) {
            boolean input = false;
            boolean output = false;
            if (nodeID == template.getStartNode().getID()) {
                input = true;
            } else if (nodeID == template.getEndNode().getID()) {
                output = true;
            }
            boolean changed = false;
            ProcessConstants.DataEdgeProperty[] dataEdgePropertyArray = dataEdgeProperties;
            int n = dataEdgeProperties.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessConstants.DataEdgeProperty property = dataEdgePropertyArray[n2];
                if (property.equals((Object)ProcessConstants.DataEdgeProperty.OPTIONAL)) {
                    changed = true;
                    break;
                }
                ++n2;
            }
            if (changed && (input || output)) {
                UpdateDataEdge.updateProcessParameters(session, processGraph, input, output, template.getDataElement(dataElementID), dataEdge.isOptional(), updateManager);
            }
        }
        if (updateManager != null && dataEdgeProperties.length > 0) {
            updateManager.firePropertyChange(template, (Object)UpdateManager.ProcessProperties.PROCESS);
        }
    }

    private static void updateProcessParameters(SessionToken session, ChangePrimitives processGraph, boolean startNode, boolean endNode, DataElement dataElement, boolean isOptional, UpdateManager updateManager) {
        Template template;
        boolean isInstance = false;
        if (processGraph instanceof ChangeableInstance) {
            template = ((ChangeableInstance)processGraph).getTemplate();
            isInstance = true;
        } else {
            template = (ChangeableTemplate)processGraph;
        }
        HashSet<ProcessModelParameter> newProcessInputParameters = null;
        if (startNode) {
            ProcessModelFactory pmf;
            Set<ProcessModelParameter> processInputParameters = template.getParameters(ActivityConstants.AccessType.READ);
            newProcessInputParameters = new HashSet<ProcessModelParameter>();
            Parameter oldParam = null;
            for (ProcessModelParameter processInputParameter : processInputParameters) {
                if (!processInputParameter.getName().equals(dataElement.getName())) {
                    newProcessInputParameters.add(processInputParameter);
                    continue;
                }
                oldParam = processInputParameter;
            }
            String newName = oldParam.getName();
            ProcessConstants.AdeptDataType newType = oldParam.getDataType();
            String newUDTName = oldParam.getUDTName();
            UUID newIdentifierID = oldParam.getIdentifierID();
            try {
                pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
            }
            catch (ServiceNotKnownException snke) {
                throw new RTServiceNotKnownException(snke);
            }
            String description = "Process output parameter to supply data element '";
            description = String.valueOf(description) + newName;
            description = String.valueOf(description) + "'";
            ProcessModelParameter newProcessInputParameter = pmf.createProcessModelParameter(newName, description, newType, newUDTName, newIdentifierID, isOptional, false, false, null, null, null, null);
            newProcessInputParameters.add(newProcessInputParameter);
        }
        HashSet<ProcessModelParameter> newProcessOutputParameters = null;
        if (endNode) {
            ProcessModelFactory pmf;
            Set<ProcessModelParameter> processOutputParameters = template.getParameters(ActivityConstants.AccessType.WRITE);
            newProcessOutputParameters = new HashSet<ProcessModelParameter>();
            Parameter oldParam = null;
            for (ProcessModelParameter processOutputParameter : processOutputParameters) {
                if (!processOutputParameter.getName().equals(dataElement.getName())) {
                    newProcessOutputParameters.add(processOutputParameter);
                    continue;
                }
                oldParam = processOutputParameter;
            }
            String newName = oldParam.getName();
            ProcessConstants.AdeptDataType newType = oldParam.getDataType();
            String newUDTName = oldParam.getUDTName();
            UUID newIdentifierID = oldParam.getIdentifierID();
            try {
                pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
            }
            catch (ServiceNotKnownException snke) {
                throw new RTServiceNotKnownException(snke);
            }
            String description = "Process output parameter to supply data element '";
            description = String.valueOf(description) + newName;
            description = String.valueOf(description) + "'";
            ProcessModelParameter newProcessOutputParameter = pmf.createProcessModelParameter(newName, description, newType, newUDTName, newIdentifierID, isOptional, false, false, null, null, null, null);
            newProcessOutputParameters.add(newProcessOutputParameter);
        }
        if (isInstance) {
            if (startNode) {
                if (endNode) {
                    UpdateInstance.performOperation((ChangeableInstance)processGraph, null, null, newProcessInputParameters, newProcessOutputParameters, updateManager, ProcessConstants.InstanceProperty.INPUT_PARAMETER, ProcessConstants.InstanceProperty.OUTPUT_PARAMETER);
                } else {
                    UpdateInstance.performOperation((ChangeableInstance)processGraph, null, null, newProcessInputParameters, null, updateManager, ProcessConstants.InstanceProperty.INPUT_PARAMETER);
                }
            } else {
                UpdateInstance.performOperation((ChangeableInstance)processGraph, null, null, null, newProcessOutputParameters, updateManager, ProcessConstants.InstanceProperty.OUTPUT_PARAMETER);
            }
        } else if (startNode) {
            if (endNode) {
                UpdateTemplate.performOperation((ChangeableTemplate)template, null, null, null, newProcessInputParameters, newProcessOutputParameters, updateManager, ProcessConstants.TemplateProperty.INPUT_PARAMETER, ProcessConstants.TemplateProperty.OUTPUT_PARAMETER);
            } else {
                UpdateTemplate.performOperation((ChangeableTemplate)template, null, null, null, newProcessInputParameters, null, updateManager, ProcessConstants.TemplateProperty.INPUT_PARAMETER);
            }
        } else {
            UpdateTemplate.performOperation((ChangeableTemplate)template, null, null, null, null, newProcessOutputParameters, updateManager, ProcessConstants.TemplateProperty.OUTPUT_PARAMETER);
        }
    }

    private static boolean enoughParameter(int nodeID, int dataElementID, ActivityConstants.AccessType type, Template template, CheckReport checkReport) {
        if (template.getNode(nodeID) == null) {
            if (checkReport != null) {
                String message = "The template/instance does not contain a node with the given id: " + nodeID;
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getDataElement(dataElementID) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain a data element with the given id: " + dataElementID;
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getDataEdge(nodeID, dataElementID, type) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain a data edge between given IDs in the given direction.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

