/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.UpdateInstance;
import de.aristaflow.adept2.core.changeoperations.UpdateTemplate;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

public class UpdateDataElement {
    protected static final Logger logger = LoggerTools.getLogger(UpdateDataElement.class);
    private static final String CHECK_ID = "Update Data Element";

    public static boolean isPossible(Template template, DataElement dataElement, ProcessConstants.DataElementProperty ... dataElementProperties) {
        return UpdateDataElement.isPossible(template, dataElement, null, dataElementProperties);
    }

    public static boolean isPossible(Template template, DataElement dataElement, CheckReport checkReport, ProcessConstants.DataElementProperty ... dataElementProperties) {
        boolean isPossible = true;
        if (!UpdateDataElement.enoughParameter(dataElement, template, checkReport)) {
            return false;
        }
        boolean onlyIrrelevantProperties = true;
        Enum[] enumArray = dataElementProperties;
        int n = dataElementProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.DataElementProperty property = enumArray[n2];
            if (property != ProcessConstants.DataElementProperty.NAME && property != ProcessConstants.DataElementProperty.DESCRIPTION && property != ProcessConstants.DataElementProperty.PUBLIC) {
                onlyIrrelevantProperties = false;
            }
            ++n2;
        }
        if (onlyIrrelevantProperties) {
            return true;
        }
        enumArray = ActivityConstants.AccessType.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            int[] nArray;
            Enum accessType = enumArray[n2];
            if (isPossible && (nArray = template.getAccessingNodeIDsForDataElement(dataElement.getID(), (ActivityConstants.AccessType)accessType)).length != 0) {
                int nodeID = nArray[0];
                String message = null;
                Node node = template.getNode(nodeID);
                if (accessType == ActivityConstants.AccessType.SYSTEM_READ || accessType == ActivityConstants.AccessType.SYSTEM_WRITE) {
                    isPossible = false;
                    message = "The data element '" + dataElement.getName() + "' is connected to the node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' via a system data edge. " + "A change of the attributes is forbidden.";
                } else if (template.getNode(nodeID).getExecutableBusinessProcess() != null) {
                    isPossible = false;
                    message = "The data element '" + dataElement.getName() + "' is connected to the node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' which already has an EBP assigned to it. " + "A change of the attributes is forbidden.";
                }
                if (!isPossible && checkReport != null) {
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getDataElementIdentifier(checkReport.getBase(), dataElement), ProcessElementIdentifierTools.getDataEdgeIdentifier(checkReport.getBase(), node, dataElement, (ActivityConstants.AccessType)accessType)};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
            }
            ++n2;
        }
        return isPossible;
    }

    public static boolean isPossible(ChangeableInstance instance, DataElement dataElement, ProcessConstants.DataElementProperty ... dataElementProperties) {
        return UpdateDataElement.isPossible(instance, dataElement, null, dataElementProperties);
    }

    public static boolean isPossible(ChangeableInstance instance, DataElement dataElement, CheckReport checkReport, ProcessConstants.DataElementProperty ... dataElementProperties) {
        Template template = instance.getTemplate();
        if (!UpdateDataElement.enoughParameter(dataElement, template, checkReport)) {
            return false;
        }
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.dataFlowWriteAccess();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            int[] writingNodes;
            ActivityConstants.AccessType writingAccessType = accessTypeArray[n2];
            int[] nArray = writingNodes = template.getAccessingNodeIDsForDataElement(dataElement.getID(), writingAccessType);
            int n3 = writingNodes.length;
            int n4 = 0;
            while (n4 < n3) {
                int writingNodeID = nArray[n4];
                if (instance.getNodeState(writingNodeID) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(writingNodeID) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
                    if (checkReport != null) {
                        String message = String.format("The node '%s' which writes the data element which should be updated must be ACTIVATED or NOT_ACTIVATED, but it is in state: %s.", ChangeOperationTools.getHumanReadableNodeName(template.getNode(writingNodeID)), instance.getNodeState(writingNodeID).toString());
                        Node writingNode = template.getNode(writingNodeID);
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), writingNode, "NodeState")};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                    }
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return UpdateDataElement.isPossible(template, dataElement, checkReport, dataElementProperties);
    }

    public static DataElement performOperation(SessionToken session, ChangeableTemplate template, DataElement dataElement, ProcessConstants.DataElementProperty ... dataElementProperties) {
        return UpdateDataElement.performOperation(session, template, dataElement, null, dataElementProperties);
    }

    public static DataElement performOperation(SessionToken session, ChangeableTemplate template, DataElement dataElement, UpdateManager updateManager, ProcessConstants.DataElementProperty ... dataElementProperties) {
        return UpdateDataElement.performOperation(session, (ChangePrimitives)template, dataElement, updateManager, dataElementProperties);
    }

    public static DataElement performOperation(SessionToken session, ChangeableInstance instance, DataElement dataElement, ProcessConstants.DataElementProperty ... dataElementProperties) {
        return UpdateDataElement.performOperation(session, instance, dataElement, null, dataElementProperties);
    }

    public static DataElement performOperation(SessionToken session, ChangeableInstance instance, DataElement dataElement, UpdateManager updateManager, ProcessConstants.DataElementProperty ... dataElementProperties) {
        return UpdateDataElement.performOperation(session, (ChangePrimitives)instance, dataElement, updateManager, dataElementProperties);
    }

    protected static DataElement performOperation(SessionToken session, ChangePrimitives processGraph, DataElement dataElement, UpdateManager updateManager, ProcessConstants.DataElementProperty ... dataElementProperties) {
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        DataElement oldDataElement = template.getDataElement(dataElement.getID());
        logger.info("calling change primitive updateDataElement");
        if (updateManager != null) {
            UpdateManager.DataElementProperties[] umDataElementProperties;
            UpdateManager.DataElementProperties[] dataElementPropertiesArray = umDataElementProperties = ChangeOperationTools.getCorrespondingDataElementProperties(dataElementProperties);
            int n = umDataElementProperties.length;
            int n2 = 0;
            while (n2 < n) {
                UpdateManager.DataElementProperties dataElementProperty = dataElementPropertiesArray[n2];
                updateManager.firePropertyChange(template.getDataElement(dataElement.getID()), (Object)dataElementProperty);
                ++n2;
            }
        }
        if (dataElement.getName() != null && !dataElement.getName().equals(oldDataElement.getName()) || dataElement.getDataType() != null && !dataElement.getDataType().equals((Object)oldDataElement.getDataType()) || dataElement.getIdentifierID() != null && !dataElement.getIdentifierID().equals(oldDataElement.getIdentifierID()) || dataElement.getUDTName() != null && !dataElement.getUDTName().equals(oldDataElement.getUDTName()) || oldDataElement.isVirtual() != dataElement.isVirtual()) {
            int[] readerNodeIDs = template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.READ);
            int[] writerNodeIDs = template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.WRITE);
            boolean input = false;
            boolean output = false;
            int[] nArray = writerNodeIDs;
            int n = writerNodeIDs.length;
            int n3 = 0;
            while (n3 < n) {
                int writer = nArray[n3];
                if (writer == template.getStartNode().getID()) {
                    input = true;
                    break;
                }
                ++n3;
            }
            nArray = readerNodeIDs;
            n = readerNodeIDs.length;
            n3 = 0;
            while (n3 < n) {
                int reader = nArray[n3];
                if (reader == template.getEndNode().getID()) {
                    output = true;
                    break;
                }
                ++n3;
            }
            if (input || output) {
                UpdateDataElement.updateProcessParameters(session, processGraph, input, output, oldDataElement, dataElement, updateManager, dataElementProperties);
            }
        }
        return processGraph.updateDataElement(dataElement, dataElementProperties);
    }

    private static void updateProcessParameters(SessionToken session, ChangePrimitives processGraph, boolean startNode, boolean endNode, DataElement oldDataElement, DataElement newDataElement, UpdateManager updateManager, ProcessConstants.DataElementProperty ... dataElementProperties) {
        ProcessModelParameter newProcessParameter;
        Template template;
        boolean isInstance = false;
        if (processGraph instanceof ChangeableInstance) {
            template = ((ChangeableInstance)processGraph).getTemplate();
            isInstance = true;
        } else {
            template = (ChangeableTemplate)processGraph;
        }
        HashSet<ProcessModelParameter> processInputParameters = null;
        HashSet<ProcessModelParameter> processOutputParameters = null;
        if (startNode) {
            processInputParameters = new HashSet<ProcessModelParameter>(template.getParameters(ActivityConstants.AccessType.READ));
            newProcessParameter = UpdateDataElement.createNewParameter(session, true, oldDataElement, newDataElement, processInputParameters, dataElementProperties);
            processInputParameters.add(newProcessParameter);
        }
        if (endNode) {
            processOutputParameters = new HashSet<ProcessModelParameter>(template.getParameters(ActivityConstants.AccessType.WRITE));
            newProcessParameter = UpdateDataElement.createNewParameter(session, false, oldDataElement, newDataElement, processOutputParameters, dataElementProperties);
            processOutputParameters.add(newProcessParameter);
        }
        if (isInstance) {
            if (startNode) {
                if (endNode) {
                    UpdateInstance.performOperation((ChangeableInstance)processGraph, null, null, processInputParameters, processOutputParameters, updateManager, ProcessConstants.InstanceProperty.INPUT_PARAMETER, ProcessConstants.InstanceProperty.OUTPUT_PARAMETER);
                } else {
                    UpdateInstance.performOperation((ChangeableInstance)processGraph, null, null, processInputParameters, null, updateManager, ProcessConstants.InstanceProperty.INPUT_PARAMETER);
                }
            } else {
                UpdateInstance.performOperation((ChangeableInstance)processGraph, null, null, null, processOutputParameters, updateManager, ProcessConstants.InstanceProperty.OUTPUT_PARAMETER);
            }
        } else if (startNode) {
            if (endNode) {
                UpdateTemplate.performOperation((ChangeableTemplate)template, null, null, null, processInputParameters, processOutputParameters, updateManager, ProcessConstants.TemplateProperty.INPUT_PARAMETER, ProcessConstants.TemplateProperty.OUTPUT_PARAMETER);
            } else {
                UpdateTemplate.performOperation((ChangeableTemplate)template, null, null, null, processInputParameters, null, updateManager, ProcessConstants.TemplateProperty.INPUT_PARAMETER);
            }
        } else {
            UpdateTemplate.performOperation((ChangeableTemplate)template, null, null, null, null, processOutputParameters, updateManager, ProcessConstants.TemplateProperty.OUTPUT_PARAMETER);
        }
    }

    private static ProcessModelParameter createNewParameter(SessionToken session, boolean inputParameter, DataElement oldDataElement, DataElement newDataElement, Set<ProcessModelParameter> processParameters, ProcessConstants.DataElementProperty ... dataElementProperties) {
        ProcessModelFactory pmf;
        ProcessModelParameter oldProcParam = null;
        String newName = "FIXME! Programming error in UpdateDataElement";
        ProcessConstants.AdeptDataType newType = ProcessConstants.AdeptDataType.USERDEFINED;
        String newUDTName = "FIXME! Programming error in UpdateDataElement";
        boolean isVirtual = false;
        UUID newIdentifierID = ProcessConstants.IDENTIFIER_NOT_SET;
        Iterator<ProcessModelParameter> iterator = processParameters.iterator();
        while (iterator.hasNext()) {
            oldProcParam = iterator.next();
            if (!oldProcParam.getName().equals(oldDataElement.getName())) continue;
            iterator.remove();
            newName = oldProcParam.getName();
            newType = oldProcParam.getDataType();
            newUDTName = oldProcParam.getUDTName();
            isVirtual = oldProcParam.isVirtual();
            newIdentifierID = oldProcParam.getIdentifierID();
            break;
        }
        ProcessConstants.DataElementProperty[] dataElementPropertyArray = dataElementProperties;
        int n = dataElementProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.DataElementProperty property = dataElementPropertyArray[n2];
            switch (property) {
                case NAME: {
                    newName = newDataElement.getName();
                    break;
                }
                case TYPE: {
                    newType = newDataElement.getDataType();
                    break;
                }
                case IDENTIFIER: {
                    newIdentifierID = newDataElement.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET) ? ProcessConstants.UNIVERSAL_IDENTIFIER_ID : newDataElement.getIdentifierID();
                    break;
                }
                case USER_DEFINED_TYPE: {
                    newUDTName = newDataElement.getUDTName();
                    break;
                }
                case VIRTUAL: {
                    isVirtual = newDataElement.isVirtual();
                    break;
                }
                default: {
                    String msg = String.format("Unsupported data element property %s!", new Object[]{property});
                    logger.finest(msg);
                }
            }
            ++n2;
        }
        try {
            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory("UpdateDataElement");
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        return pmf.createProcessModelParameter(newName, oldProcParam.getDescription(), newType, newUDTName, newIdentifierID, oldProcParam.isOptional(), isVirtual, oldProcParam.isFailure(), oldProcParam.getDefaultValue(), oldProcParam.getConfiguration(), oldProcParam, oldProcParam.getUserAttributes());
    }

    private static boolean enoughParameter(DataElement dataElement, Template template, CheckReport checkReport) {
        if (dataElement == null) {
            if (checkReport != null) {
                String message = "Not enough selected elements for this operation. A single data element is needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getDataElement(dataElement.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain the data element: " + dataElement;
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

