/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.DeleteDataEdge;
import de.aristaflow.adept2.core.changeoperations.InsertDataEdge;
import de.aristaflow.adept2.core.changeoperations.InsertDataElement;
import de.aristaflow.adept2.core.changeoperations.ReconnectDataEdge;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class UpdateDataElementParameterMapping {
    private static final String MY_INSTANCE_NAME = "UpdateDataElementParameterMapping";

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node node, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>> paramsWithExistingDataElements) {
        UpdateDataElementParameterMapping.performOperation(session, template, node, paramsWithoutExistingDataElements, paramsWithExistingDataElements, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node node, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>> paramsWithExistingDataElements, UpdateManager updateManager) {
        UpdateDataElementParameterMapping.performOperation(session, (ChangePrimitives)template, node, paramsWithoutExistingDataElements, paramsWithExistingDataElements, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node node, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>> paramsWithExistingDataElements) {
        UpdateDataElementParameterMapping.performOperation(session, instance, node, paramsWithoutExistingDataElements, paramsWithExistingDataElements, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node node, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>> paramsWithExistingDataElements, UpdateManager updateManager) {
        UpdateDataElementParameterMapping.performOperation(session, (ChangePrimitives)instance, node, paramsWithoutExistingDataElements, paramsWithExistingDataElements, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, Node node, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, ProcessConstants.DataMappingType>> paramsWithoutExistingDataElements, Map<ActivityConstants.AccessType, Map<ProcessModelParameter, Integer>> paramsWithExistingDataElements, UpdateManager updateManager) {
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.AccessType accessType = accessTypeArray[n2];
            Map<ProcessModelParameter, Integer> dataExistMapping = paramsWithExistingDataElements.get((Object)accessType);
            Map<ProcessModelParameter, ProcessConstants.DataMappingType> dataNotExistMapping = paramsWithoutExistingDataElements.get((Object)accessType);
            UpdateDataElementParameterMapping.updateOuterMapping(session, processGraph, node, dataExistMapping, dataNotExistMapping, accessType, updateManager);
            ++n2;
        }
    }

    private static void updateOuterMapping(SessionToken session, ChangePrimitives processGraph, Node node, Map<ProcessModelParameter, Integer> dataExistMapping, Map<ProcessModelParameter, ProcessConstants.DataMappingType> dataNotExistMapping, ActivityConstants.AccessType type, UpdateManager updateManager) {
        int connectorID;
        ProcessModelParameter param;
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        for (Map.Entry<ProcessModelParameter, Integer> entry : dataExistMapping.entrySet()) {
            DataElement oldDataElement;
            param = entry.getKey();
            connectorID = node.getConnector(param.getName(), type);
            DataElement dataElement = template.getDataElement(entry.getValue());
            DataEdge dataEdge = template.getDataEdge(node.getID(), dataElement.getID(), type);
            if (template.getDataElement(node.getID(), connectorID) != null && !dataExistMapping.containsValue((oldDataElement = template.getDataElement(node.getID(), connectorID)).getID())) {
                DeleteDataEdge.performOperation(session, processGraph, node, oldDataElement, type, updateManager);
            }
            if (dataEdge != null) {
                ReconnectDataEdge.performOperation(session, processGraph, node.getID(), dataElement.getID(), dataEdge, param, updateManager);
                continue;
            }
            InsertDataEdge.performOperation(session, processGraph, node, dataElement, param, connectorID, type, updateManager);
        }
        for (Map.Entry<ProcessModelParameter, Object> entry : dataNotExistMapping.entrySet()) {
            param = entry.getKey();
            connectorID = node.getConnector(param.getName(), type);
            if (template.getDataElement(node.getID(), connectorID) != null) {
                DataElement oldDataElement = template.getDataElement(node.getID(), connectorID);
                if (!dataExistMapping.containsValue(oldDataElement.getID())) {
                    DeleteDataEdge.performOperation(session, processGraph, node, oldDataElement, type, updateManager);
                }
            } else {
                int[] nArray = template.getDisabledConnectors(node.getID(), type);
                int oldDataElement = nArray.length;
                int dataEdge = 0;
                while (dataEdge < oldDataElement) {
                    int disabledConnectorID = nArray[dataEdge];
                    if (connectorID == disabledConnectorID) {
                        processGraph.removeDisabledConnector(node.getID(), connectorID);
                        break;
                    }
                    ++dataEdge;
                }
            }
            switch ((ProcessConstants.DataMappingType)((Object)entry.getValue())) {
                case CONNECT_LATER: {
                    break;
                }
                case DISABLE: {
                    processGraph.addDisabledConnector(node.getID(), connectorID);
                    break;
                }
                case NEW_DATAELEMENT: {
                    ProcessModelFactory pmf;
                    try {
                        pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory(MY_INSTANCE_NAME);
                    }
                    catch (ServiceNotKnownException snke) {
                        throw new RTServiceNotKnownException(snke);
                    }
                    DataElement newData = pmf.createDataElement(Integer.MIN_VALUE, param.getName(), param.getDataType(), param.getDescription(), param.getUDTName(), null, param.getIdentifierID(), false, param.isVirtual(), new HashMap<String, Set<String>>(), new HashMap<String, PluginData>(), new HashMap<String, String>());
                    DataElement dataWithID = InsertDataElement.performOperation(session, processGraph, newData, updateManager);
                    InsertDataEdge.performOperation(session, processGraph, node, dataWithID, param, connectorID, type, updateManager);
                    break;
                }
                default: {
                    throw new RuntimeException("DataMappingType not supported");
                }
            }
        }
    }
}

