/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class UpdateExecutableBusinessProcess {
    protected static final Logger logger = LoggerTools.getLogger(UpdateExecutableBusinessProcess.class);
    private static final String CHECK_ID = "Update Executable Business Process";

    public static boolean isPossible(Template template, int nodeID, ExecutableBusinessProcess ebp, ProcessConstants.ExecutableBusinessProcessProperty ... ebpProperties) {
        return UpdateExecutableBusinessProcess.isPossible(template, nodeID, ebp, null, ebpProperties);
    }

    public static boolean isPossible(Template template, int nodeID, ExecutableBusinessProcess ebp, CheckReport checkReport, ProcessConstants.ExecutableBusinessProcessProperty ... ebpProperties) {
        return UpdateExecutableBusinessProcess.enoughParameter(nodeID, ebp, template, checkReport);
    }

    public static boolean isPossible(ChangeableInstance instance, int nodeID, ExecutableBusinessProcess ebp, ProcessConstants.ExecutableBusinessProcessProperty ... ebpProperties) {
        return UpdateExecutableBusinessProcess.isPossible(instance, nodeID, ebp, null, ebpProperties);
    }

    public static boolean isPossible(ChangeableInstance instance, int nodeID, ExecutableBusinessProcess ebp, CheckReport checkReport, ProcessConstants.ExecutableBusinessProcessProperty ... ebpProperties) {
        Template template = instance.getTemplate();
        if (!UpdateExecutableBusinessProcess.enoughParameter(nodeID, ebp, template, checkReport)) {
            return false;
        }
        if (instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(template.getNode(nodeID)) + "' whose assigned EBP properties should be changed must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(nodeID).toString() + ".";
                Node node = template.getNode(nodeID);
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node, "NodeState"));
            }
            return false;
        }
        return UpdateExecutableBusinessProcess.isPossible(template, nodeID, ebp, checkReport, ebpProperties);
    }

    public static void performOperation(ChangeableTemplate template, int nodeID, ExecutableBusinessProcess ebp, ProcessConstants.ExecutableBusinessProcessProperty ... ebpProperties) {
        UpdateExecutableBusinessProcess.performOperation(template, nodeID, ebp, null, ebpProperties);
    }

    public static void performOperation(ChangeableTemplate template, int nodeID, ExecutableBusinessProcess ebp, UpdateManager updateManager, ProcessConstants.ExecutableBusinessProcessProperty ... ebpProperties) {
        UpdateExecutableBusinessProcess.performOperation((ChangePrimitives)template, nodeID, ebp, updateManager, ebpProperties);
    }

    public static void performOperation(ChangeableInstance instance, int nodeID, ExecutableBusinessProcess ebp, ProcessConstants.ExecutableBusinessProcessProperty ... ebpProperties) {
        UpdateExecutableBusinessProcess.performOperation(instance, nodeID, ebp, null, ebpProperties);
    }

    public static void performOperation(ChangeableInstance instance, int nodeID, ExecutableBusinessProcess ebp, UpdateManager updateManager, ProcessConstants.ExecutableBusinessProcessProperty ... ebpProperties) {
        UpdateExecutableBusinessProcess.performOperation((ChangePrimitives)instance, nodeID, ebp, updateManager, ebpProperties);
    }

    protected static void performOperation(ChangePrimitives processGraph, int nodeID, ExecutableBusinessProcess ebp, UpdateManager updateManager, ProcessConstants.ExecutableBusinessProcessProperty ... ebpProperties) {
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        logger.info("calling change primitive updateExecutableBusinessProcess");
        processGraph.updateExecutableBusinessProcess(nodeID, ebp, ebpProperties);
        if (updateManager != null) {
            UpdateManager.ActivityProperties[] umActivityProperties;
            UpdateManager.ActivityProperties[] activityPropertiesArray = umActivityProperties = ChangeOperationTools.getCorrespondingActivityProperties(ebpProperties);
            int n = umActivityProperties.length;
            int n2 = 0;
            while (n2 < n) {
                UpdateManager.ActivityProperties activityProperty = activityPropertiesArray[n2];
                updateManager.firePropertyChange(ebp, (Object)activityProperty);
                ++n2;
            }
            if (umActivityProperties.length > 0) {
                updateManager.firePropertyChange(template, (Object)UpdateManager.ProcessProperties.PROCESS);
            }
        }
    }

    private static boolean enoughParameter(int nodeID, ExecutableBusinessProcess ebp, Template template, CheckReport checkReport) {
        if (ebp == null) {
            if (checkReport != null) {
                String message = "Not enough selected elements for this operation. An EBP which is assigned to a node is needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(nodeID) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain the given node: " + ChangeOperationTools.getHumanReadableNodeName(template.getNode(nodeID));
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

