/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.Set;
import java.util.logging.Logger;

public class UpdateInstance {
    protected static final Logger logger = LoggerTools.getLogger(UpdateInstance.class);
    private static final String CHECK_ID = "Update Instance";

    public static boolean isPossible(Instance instance, ProcessConstants.InstanceProperty ... instanceProperties) {
        return UpdateInstance.isPossible(instance, null, instanceProperties);
    }

    public static boolean isPossible(Instance instance, CheckReport checkReport, ProcessConstants.InstanceProperty ... instanceProperties) {
        ProcessConstants.InstanceProperty[] instancePropertyArray = instanceProperties;
        int n = instanceProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.InstanceProperty instanceProperty = instancePropertyArray[n2];
            if (instanceProperty == ProcessConstants.InstanceProperty.INPUT_PARAMETER) {
                ProcessConstants.NodeState nodeState = instance.getNodeState(instance.getTemplate().getStartNode().getID());
                if (nodeState == ProcessConstants.NodeState.NS_NOT_ACTIVATED || nodeState == ProcessConstants.NodeState.NS_ACTIVATED) break;
                if (checkReport != null) {
                    String message = "The start node of the given instance whose input parameters should be changed is already in state: " + (Object)((Object)nodeState) + " but it must be ACTIVATED or NOT_ACTIVATED";
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
                }
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void performOperation(ChangeableInstance instance, String newName, QualifiedAgent newSupervisorAgent, Set<ProcessModelParameter> newInputParameters, Set<ProcessModelParameter> newOutputParameters, ProcessConstants.InstanceProperty ... instanceProperties) {
        UpdateInstance.performOperation(instance, newName, newSupervisorAgent, newInputParameters, newOutputParameters, null, instanceProperties);
    }

    public static void performOperation(ChangeableInstance instance, String newName, QualifiedAgent newSupervisorAgent, Set<ProcessModelParameter> newInputParameters, Set<ProcessModelParameter> newOutputParameters, UpdateManager updateManager, ProcessConstants.InstanceProperty ... instanceProperties) {
        ProcessConstants.InstanceProperty property;
        ProcessConstants.InstanceProperty[] instancePropertyArray = instanceProperties;
        int n = instanceProperties.length;
        int n2 = 0;
        while (n2 < n) {
            property = instancePropertyArray[n2];
            switch (property) {
                case NAME: {
                    if (newName != null) break;
                    throw new IllegalArgumentException("Invalid instance property: Name is null!");
                }
                case SUPERVISOR_AGENT: {
                    if (newSupervisorAgent != null) break;
                    throw new IllegalArgumentException("Invalid instance property: SupervisorAgent is null!");
                }
                case INPUT_PARAMETER: {
                    if (newInputParameters != null) break;
                    throw new IllegalArgumentException("Invalid instance property: InputParameter is null!");
                }
                case OUTPUT_PARAMETER: {
                    if (newOutputParameters != null) break;
                    throw new IllegalArgumentException("Invalid instance property: OutputParameter is null!");
                }
                default: {
                    throw new IllegalArgumentException("Instance property " + (Object)((Object)property) + " is unknown!");
                }
            }
            ++n2;
        }
        instancePropertyArray = instanceProperties;
        n = instanceProperties.length;
        n2 = 0;
        while (n2 < n) {
            property = instancePropertyArray[n2];
            switch (property) {
                case NAME: {
                    logger.info("calling change primitive setName");
                    instance.setName(newName);
                    break;
                }
                case SUPERVISOR_AGENT: {
                    logger.info("calling change primitive setSupervisorAgent");
                    instance.setSupervisorAgent(newSupervisorAgent);
                    break;
                }
                case INPUT_PARAMETER: {
                    logger.info("calling change primitive setInputParameter");
                    instance.setInputParameters(newInputParameters);
                    break;
                }
                case OUTPUT_PARAMETER: {
                    logger.info("calling change primitive setOutputParameter");
                    instance.setOutputParameters(newOutputParameters);
                    break;
                }
                default: {
                    throw new RuntimeException("Programming error: update method for " + (Object)((Object)property) + " is not implemented.");
                }
            }
            ++n2;
        }
        if (updateManager != null && instanceProperties.length > 0) {
            updateManager.firePropertyChange(instance, (Object)UpdateManager.ProcessProperties.PROCESS);
        }
    }
}

