/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.NodeDependencyProvider;
import de.aristaflow.adept2.core.orgmodelmanager.parser.AtomicEntityExpression;
import de.aristaflow.adept2.core.orgmodelmanager.parser.AtomicSelection;
import de.aristaflow.adept2.core.orgmodelmanager.parser.EntityExpression;
import de.aristaflow.adept2.core.orgmodelmanager.parser.OrgPolicyParser;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.systemdata.Dependency;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.orgmodel.CmpOperator;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.OrgPolicyReport;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.systemdata.SystemDataProducer;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class UpdateNode {
    protected static final Logger logger = LoggerTools.getLogger(UpdateNode.class);
    private static final String CHECK_ID = "Update Node";

    public static boolean isPossible(Template template, Node node, ProcessConstants.NodeProperty ... nodeProperties) {
        ProcessConstants.NodeProperty[] nodePropertyArray = nodeProperties;
        int n = nodeProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.NodeProperty nodeProperty = nodePropertyArray[n2];
            if (nodeProperty == ProcessConstants.NodeProperty.CONNECTOR_PARAMETER_MAPPING || nodeProperty == ProcessConstants.NodeProperty.EXECUTABLE_BUSINESS_PROCESS || nodeProperty == ProcessConstants.NodeProperty.ID) {
                throw new IllegalArgumentException("The given property/properties can't be changed with this operation.");
            }
            ++n2;
        }
        return UpdateNode.isPossible(template, node, null, nodeProperties);
    }

    public static boolean isPossible(Template template, Node node, CheckReport checkReport, ProcessConstants.NodeProperty ... nodeProperties) {
        if (!UpdateNode.enoughParameter(node, template, checkReport)) {
            return false;
        }
        ProcessConstants.NodeType nodeType = template.getNodeType(node.getID());
        if (nodeType == ProcessConstants.NodeType.NT_STARTFLOW || nodeType == ProcessConstants.NodeType.NT_ENDFLOW) {
            if (checkReport != null) {
                String message = "Properties of the process start and end node cannot be changed.";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        ProcessConstants.NodeProperty[] nodePropertyArray = nodeProperties;
        int n = nodeProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterRef[] refs;
            ProcessConstants.NodeProperty property = nodePropertyArray[n2];
            switch (property) {
                case ID: {
                    if (checkReport != null) {
                        String message = "It is forbidden to change the id of a node. IDs are given automatically and remain stable when nodes are created.";
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node, property.toString())};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                    }
                    return false;
                }
                case EXECUTABLE_BUSINESS_PROCESS: 
                case CONNECTOR_PARAMETER_MAPPING: {
                    if (checkReport != null) {
                        String message = "Use assign/removeExecutableBusinessProcess to update the ExecutableBusinessProcess/ConnectorParameterMapping property of a node.";
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node, property.toString())};
                        checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                    }
                    return false;
                }
                case NAME: {
                    refs = SystemDataTools.findParameterReferences(node.getName());
                    break;
                }
                case DESCRIPTION: {
                    refs = SystemDataTools.findParameterReferences(node.getDescription());
                    break;
                }
                case STAFF_ASSIGNMENT_RULE: {
                    refs = SystemDataTools.findParameterReferences(node.getStaffAssignmentRule());
                    break;
                }
                case AUTO_START: {
                    return UpdateNode.autoStartEnabled(template, node);
                }
                case USER_ATTRIBUTE: {
                    refs = new ParameterRef[]{};
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Handling for the node property '" + property.name() + "' is not implemented");
                }
            }
            if (refs.length != 0) {
                if (checkReport != null) {
                    String message = "The property '" + (Object)((Object)property) + "' contains parameter" + " references. Use change operation UpdateNodeSystemDependency!";
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node, property.toString())};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isPossible(ChangeableInstance instance, Node node, ProcessConstants.NodeProperty ... nodeProperties) {
        return UpdateNode.isPossible(instance, node, null, nodeProperties);
    }

    public static boolean isPossible(ChangeableInstance instance, Node node, CheckReport checkReport, ProcessConstants.NodeProperty ... nodeProperties) {
        Template template = instance.getTemplate();
        if (!UpdateNode.enoughParameter(node, template, checkReport)) {
            return false;
        }
        if (instance.getNodeState(node.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(node.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(node) + "' whose properties should be updated must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(node.getID()).toString() + ".";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node, "NodeState")};
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        return UpdateNode.isPossible(template, node, checkReport, nodeProperties);
    }

    public static void performOperation(ChangeableTemplate template, Node node, ProcessConstants.NodeProperty ... nodeProperties) {
        UpdateNode.performOperation(template, node, null, nodeProperties);
    }

    public static void performOperation(ChangeableTemplate template, Node node, UpdateManager updateManager, ProcessConstants.NodeProperty ... nodeProperties) {
        ProcessConstants.NodeProperty[] nodePropertyArray = nodeProperties;
        int n = nodeProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.NodeProperty property = nodePropertyArray[n2];
            if (property == ProcessConstants.NodeProperty.EXECUTABLE_BUSINESS_PROCESS || property == ProcessConstants.NodeProperty.CONNECTOR_PARAMETER_MAPPING || property == ProcessConstants.NodeProperty.ID) {
                throw new IllegalArgumentException("Invalid node property");
            }
            ++n2;
        }
        UpdateNode.performOperation((ChangePrimitives)template, node, updateManager, nodeProperties);
    }

    public static void performOperation(ChangeableInstance instance, Node node, ProcessConstants.NodeProperty ... nodeProperties) {
        UpdateNode.performOperation(instance, node, null, nodeProperties);
    }

    public static void performOperation(ChangeableInstance instance, Node node, UpdateManager updateManager, ProcessConstants.NodeProperty ... nodeProperties) {
        UpdateNode.performOperation((ChangePrimitives)instance, node, updateManager, nodeProperties);
    }

    protected static void performOperation(ChangePrimitives processGraph, Node node, UpdateManager updateManager, ProcessConstants.NodeProperty ... nodeProperties) {
        Template template = processGraph instanceof ChangeableInstance ? ((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        logger.info("calling change primitive updateNode");
        processGraph.updateNode(node, nodeProperties);
        if (updateManager != null) {
            UpdateManager.NodeProperties[] umNodeProperties;
            UpdateManager.NodeProperties[] nodePropertiesArray = umNodeProperties = ChangeOperationTools.getCorrespondingNodeProperties(nodeProperties);
            int n = umNodeProperties.length;
            int n2 = 0;
            while (n2 < n) {
                UpdateManager.NodeProperties nodeProperty = nodePropertiesArray[n2];
                updateManager.firePropertyChange(template.getNode(node.getID()), (Object)nodeProperty);
                ++n2;
            }
            if (umNodeProperties.length > 0) {
                updateManager.firePropertyChange(template, (Object)UpdateManager.ProcessProperties.PROCESS);
            }
        }
    }

    private static boolean enoughParameter(Node node, Template template, CheckReport checkReport) {
        if (node == null) {
            if (checkReport != null) {
                String message = "Not enough selected elements for this operation. A single node is needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(node.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain the node: " + node;
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }

    public static boolean autoStartEnabled(Template template, Node node) {
        HashMap<String, Dependency> dependencies = new HashMap<String, Dependency>();
        NodeDependencyProvider dependencyProvider = new NodeDependencyProvider(template, node.getID());
        ParameterRef[] parameterRefArray = dependencyProvider.getParameters();
        int n = parameterRefArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterRef param = parameterRefArray[n2];
            Dependency dependency = dependencyProvider.getDependencyOf(param.getName());
            dependencies.put(param.getName(), dependency);
            ++n2;
        }
        return UpdateNode.btnAutoStartEnabled(template, node, node.getStaffAssignmentRule(), dependencies);
    }

    public static boolean btnAutoStartEnabled(Template template, Node node, String nodeSAR, Map<String, Dependency> dependencies) {
        Object type;
        Dependency dependency;
        AtomicSelection atomicSel;
        AtomicEntityExpression atomicExp;
        boolean enable = false;
        OrgPolicyParser parser = OrgPolicyParser.getInstance();
        EntityExpression expression = parser.parse(nodeSAR, new OrgPolicyReport(), null);
        if (expression instanceof AtomicEntityExpression && (atomicExp = (AtomicEntityExpression)expression).getEntityTypeAt(0).equals((Object)EntityType.AGENT) && atomicExp.getFunctionCount() == 0 && atomicExp.getSelectionAt(0) instanceof AtomicSelection && (atomicSel = (AtomicSelection)atomicExp.getSelectionAt(0)).getAttriubteName().equals("id") && atomicSel.getCmpOperator().equals((Object)CmpOperator.EQUAL) && atomicSel.getValue() instanceof ParameterRef && (dependency = dependencies.get(((ParameterRef)atomicSel.getValue()).getName())) != null && (type = dependency.getType()) instanceof SystemDataProducer && (type.equals((Object)SystemDataProducer.INSTANCE_INITIATOR_AGENT_ID) || type.equals((Object)SystemDataProducer.NODE_PERFORMING_AGENT_ID)) && dependency.getArgument() instanceof Node) {
            enable = true;
        }
        return enable;
    }
}

