/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.AddNodeSystemParameter;
import de.aristaflow.adept2.core.changeoperations.AddSystemDataFlow;
import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.changeoperations.InsertDataEdge;
import de.aristaflow.adept2.core.changeoperations.NodeDependencyProvider;
import de.aristaflow.adept2.core.changeoperations.RemoveNodeSystemParameter;
import de.aristaflow.adept2.core.changeoperations.RemoveSystemDataFlow;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.ModelFactoryRegistry;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.systemdata.Dependency;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.systemdata.SystemDataProducer;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;

public class UpdateNodeSystemDependency {
    protected static final Logger logger = LoggerTools.getLogger(UpdateNodeSystemDependency.class);
    private static final String CHECK_ID = "Update Node System Parameters";
    private static final String MY_INSTANCE_NAME = "Update Node System Parameters";

    public static boolean isPossible(Template template, Node tempNode, Map<String, Dependency> paramBindings, ProcessConstants.NodeProperty nodeProperty) {
        if (nodeProperty == ProcessConstants.NodeProperty.CONNECTOR_PARAMETER_MAPPING || nodeProperty == ProcessConstants.NodeProperty.EXECUTABLE_BUSINESS_PROCESS || nodeProperty == ProcessConstants.NodeProperty.ID || nodeProperty == ProcessConstants.NodeProperty.SYSTEM_READ_PARAMS || nodeProperty == ProcessConstants.NodeProperty.SYSTEM_WRITE_PARAMS || nodeProperty == ProcessConstants.NodeProperty.USER_ATTRIBUTE) {
            throw new IllegalArgumentException("The given property/properties can't be changed with this operation.");
        }
        return UpdateNodeSystemDependency.isPossible(template, tempNode, paramBindings, nodeProperty, null);
    }

    public static boolean isPossible(Template template, Node tempNode, Map<String, Dependency> paramBindings, ProcessConstants.NodeProperty nodeProperty, CheckReport checkReport) {
        ParameterRef[] refs;
        String consumerString;
        if (!UpdateNodeSystemDependency.enoughParameter(tempNode, template, paramBindings, checkReport)) {
            return false;
        }
        switch (nodeProperty) {
            case ID: 
            case EXECUTABLE_BUSINESS_PROCESS: 
            case CONNECTOR_PARAMETER_MAPPING: 
            case SYSTEM_READ_PARAMS: 
            case SYSTEM_WRITE_PARAMS: 
            case USER_ATTRIBUTE: {
                if (checkReport != null) {
                    String message = "The given property/properties can't be changed with this operation.";
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(tempNode.getID()), nodeProperty.toString())};
                    checkReport.addReportEntry("Update Node System Parameters", CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                return false;
            }
            case NAME: {
                consumerString = tempNode.getName();
                break;
            }
            case DESCRIPTION: {
                consumerString = tempNode.getDescription();
                break;
            }
            case STAFF_ASSIGNMENT_RULE: {
                if (template.getNodeType(tempNode.getID()).equals((Object)ProcessConstants.NodeType.NT_STARTFLOW) || template.getNodeType(tempNode.getID()).equals((Object)ProcessConstants.NodeType.NT_ENDFLOW)) {
                    if (checkReport != null) {
                        String message = "The staff assignment rule of the process start and end node can't be changed.";
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), tempNode, nodeProperty.toString())};
                        checkReport.addReportEntry("Update Node System Parameters", CheckReport.ResultType.FAILURE, message, affectedElements);
                    }
                    return false;
                }
                consumerString = tempNode.getStaffAssignmentRule();
                break;
            }
            default: {
                throw new IllegalArgumentException("Handling for the node property '" + nodeProperty.toString() + "' is not implemented");
            }
        }
        ParameterRef[] parameterRefArray = refs = SystemDataTools.findParameterReferences(consumerString);
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterRef ref = parameterRefArray[n2];
            if (!paramBindings.containsKey(ref.getName())) {
                if (checkReport != null) {
                    String message = "The parameter '" + ref.getName() + "' contained in the value of the given property " + "is not contained in the parameter binding map.";
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(tempNode.getID()), nodeProperty.toString())};
                    checkReport.addReportEntry("Update Node System Parameters", CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                return false;
            }
            Dependency dependency = paramBindings.get(ref.getName());
            if (dependency != null) {
                Object depType = dependency.getType();
                ProcessConstants.AdeptDataType dataType = null;
                if (depType.equals(Dependency.DEPENDENCY_TYPE_DATA_ELEMENT)) {
                    DataElement dataElement = (DataElement)dependency.getArgument();
                    if (dataElement != null) {
                        dataType = dataElement.getDataType();
                    }
                } else if (depType instanceof SystemDataProducer) {
                    ProcessModelParameter param = ((SystemDataProducer)((Object)depType)).getParameterProperties();
                    dataType = param.getDataType();
                    Node node = (Node)dependency.getArgument();
                    if (node != null && !AddSystemDataFlow.isPossible(template, node.getID(), (SystemDataProducer)((Object)depType), tempNode.getID(), checkReport)) {
                        return false;
                    }
                } else {
                    throw new IllegalArgumentException("Handling for the binding type '" + depType.getClass().getName() + "' is not implemented");
                }
                if (ref.getDataType() != dataType) {
                    if (checkReport != null) {
                        String message = "The data type of the parameter '" + ref.getName() + "' contained in the value of the given property " + "does not match the data type of the parameter in the parameter binding map.";
                        URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(tempNode.getID()), nodeProperty.toString())};
                        checkReport.addReportEntry("Update Node System Parameters", CheckReport.ResultType.FAILURE, message, affectedElements);
                    }
                    return false;
                }
                ProcessModelParameter systemParameter = template.getNode(tempNode.getID()).getSystemParameter(ref.getName(), ActivityConstants.AccessType.SYSTEM_READ);
                if (systemParameter != null) {
                    Node bindingNode;
                    if (systemParameter.getDataType() != dataType) {
                        if (checkReport != null) {
                            String message = "The data type and/or the identifier ID of the parameter '" + ref.getName() + "' contained in the value of the given property " + "does not match the data type and/or identifier ID of the " + "parameter in the parameter binding map.";
                            URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(tempNode.getID()), nodeProperty.toString())};
                            checkReport.addReportEntry("Update Node System Parameters", CheckReport.ResultType.FAILURE, message, affectedElements);
                        }
                        return false;
                    }
                    if (depType instanceof SystemDataProducer && (bindingNode = (Node)dependency.getArgument()) != null) {
                        int bindingNodeID = bindingNode.getID();
                        int connectorID = template.getNode(tempNode.getID()).getConnector(systemParameter.getName(), ActivityConstants.AccessType.SYSTEM_READ);
                        DataElement dataElement = template.getDataElement(tempNode.getID(), connectorID);
                        int[] nodeIDs = template.getAccessingNodeIDsForDataElement(dataElement.getID(), ActivityConstants.AccessType.SYSTEM_WRITE);
                        assert (nodeIDs.length <= 1);
                        if (nodeIDs.length != 0 && bindingNodeID != nodeIDs[0]) {
                            if (checkReport != null) {
                                String message = "The node already contains a parameter with the name '" + ref.getName() + "', but the parameter is connected (via a data element) " + "to another node as the node specified in the parameter " + "binding. Use another name for the parameter!";
                                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(tempNode.getID()), nodeProperty.toString())};
                                checkReport.addReportEntry("Update Node System Parameters", CheckReport.ResultType.FAILURE, message, affectedElements);
                            }
                            return false;
                        }
                    }
                }
            }
            ++n2;
        }
        return true;
    }

    public static boolean isPossible(ChangeableInstance instance, Node tempNode, Map<String, Dependency> paramBindings, ProcessConstants.NodeProperty nodeProperty) {
        return UpdateNodeSystemDependency.isPossible(instance, tempNode, paramBindings, nodeProperty, null);
    }

    public static boolean isPossible(ChangeableInstance instance, Node tempNode, Map<String, Dependency> paramBindings, ProcessConstants.NodeProperty nodeProperty, CheckReport checkReport) {
        Template template = instance.getTemplate();
        if (!UpdateNodeSystemDependency.enoughParameter(tempNode, template, paramBindings, checkReport)) {
            return false;
        }
        if (instance.getNodeState(tempNode.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(tempNode.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(tempNode) + "' whose properties should be updated must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(tempNode.getID()).toString() + ".";
                URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), tempNode, "NodeState")};
                checkReport.addReportEntry("Update Node System Parameters", CheckReport.ResultType.FAILURE, message, affectedElements);
            }
            return false;
        }
        for (Dependency dependency : paramBindings.values()) {
            Node node;
            Object depType;
            if (dependency == null || !((depType = dependency.getType()) instanceof SystemDataProducer) || AddSystemDataFlow.isPossible((Instance)instance, (node = (Node)dependency.getArgument()).getID(), (SystemDataProducer)((Object)depType), tempNode.getID(), checkReport)) continue;
            return false;
        }
        return UpdateNodeSystemDependency.isPossible(template, tempNode, paramBindings, nodeProperty);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node node, Map<String, Dependency> paramBindings, ProcessConstants.NodeProperty nodeProperty) {
        UpdateNodeSystemDependency.performOperation(session, template, node, paramBindings, nodeProperty, null);
    }

    public static void performOperation(SessionToken session, ChangeableTemplate template, Node node, Map<String, Dependency> paramBindings, ProcessConstants.NodeProperty nodeProperty, UpdateManager updateManager) {
        if (nodeProperty == ProcessConstants.NodeProperty.CONNECTOR_PARAMETER_MAPPING || nodeProperty == ProcessConstants.NodeProperty.EXECUTABLE_BUSINESS_PROCESS || nodeProperty == ProcessConstants.NodeProperty.ID || nodeProperty == ProcessConstants.NodeProperty.SYSTEM_READ_PARAMS || nodeProperty == ProcessConstants.NodeProperty.SYSTEM_WRITE_PARAMS || nodeProperty == ProcessConstants.NodeProperty.USER_ATTRIBUTE) {
            throw new IllegalArgumentException("The given property/properties can't be changed with this operation.");
        }
        UpdateNodeSystemDependency.performOperation(session, (ChangePrimitives)template, node, paramBindings, nodeProperty, updateManager);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node node, Map<String, Dependency> paramBindings, ProcessConstants.NodeProperty nodeProperty) {
        UpdateNodeSystemDependency.performOperation(session, instance, node, paramBindings, nodeProperty, null);
    }

    public static void performOperation(SessionToken session, ChangeableInstance instance, Node node, Map<String, Dependency> paramBindings, ProcessConstants.NodeProperty nodeProperty, UpdateManager updateManager) {
        UpdateNodeSystemDependency.performOperation(session, (ChangePrimitives)instance, node, paramBindings, nodeProperty, updateManager);
    }

    protected static void performOperation(SessionToken session, ChangePrimitives processGraph, Node node, Map<String, Dependency> paramBindings, ProcessConstants.NodeProperty nodeProperty, UpdateManager updateManager) {
        String oldConsumerString;
        String newConsumerString;
        ChangeableTemplate template = processGraph instanceof ChangeableInstance ? (ChangeableTemplate)((ChangeableInstance)processGraph).getTemplate() : (ChangeableTemplate)processGraph;
        switch (nodeProperty) {
            case NAME: {
                newConsumerString = node.getName();
                oldConsumerString = template.getNode(node.getID()).getName();
                break;
            }
            case DESCRIPTION: {
                newConsumerString = node.getDescription();
                oldConsumerString = template.getNode(node.getID()).getDescription();
                break;
            }
            case STAFF_ASSIGNMENT_RULE: {
                newConsumerString = node.getStaffAssignmentRule();
                oldConsumerString = template.getNode(node.getID()).getStaffAssignmentRule();
                break;
            }
            default: {
                throw new IllegalArgumentException("Handling for the node property '" + nodeProperty.toString() + "' is not implemented");
            }
        }
        logger.info("calling change primitive updateNode");
        processGraph.updateNode(node, nodeProperty);
        UpdateNodeSystemDependency.handleConsumerUpdate(session, node, template, oldConsumerString, newConsumerString, paramBindings, updateManager);
        if (updateManager != null) {
            UpdateManager.NodeProperties[] umNodeProperties = ChangeOperationTools.getCorrespondingNodeProperties(nodeProperty);
            updateManager.firePropertyChange(template.getNode(node.getID()), (Object)umNodeProperties[0]);
        }
    }

    private static void handleConsumerUpdate(SessionToken session, Node node, ChangeableTemplate template, String oldConsumerString, String newConsumerString, Map<String, Dependency> paramBindings, UpdateManager updateManager) {
        int n;
        int n2;
        ParameterRef[] parameterRefArray;
        boolean found;
        ParameterRef[] newRefs = SystemDataTools.findParameterReferences(newConsumerString);
        ParameterRef[] oldRefs = SystemDataTools.findParameterReferences(oldConsumerString);
        LinkedList<ParameterRef> newParams = new LinkedList<ParameterRef>();
        LinkedList<ParameterRef> delParams = new LinkedList<ParameterRef>();
        NodeDependencyProvider dependencyProvider = new NodeDependencyProvider(template, node.getID());
        ParameterRef[] parameterRefArray2 = oldRefs;
        int n3 = oldRefs.length;
        int n4 = 0;
        while (n4 < n3) {
            ParameterRef oldRef = parameterRefArray2[n4];
            found = false;
            parameterRefArray = newRefs;
            n2 = newRefs.length;
            n = 0;
            while (n < n2) {
                ParameterRef newRef = parameterRefArray[n];
                if (UpdateNodeSystemDependency.refsEquals(paramBindings, dependencyProvider, oldRef, newRef)) {
                    found = true;
                    break;
                }
                ++n;
            }
            if (!found) {
                delParams.add(oldRef);
            }
            ++n4;
        }
        parameterRefArray2 = newRefs;
        n3 = newRefs.length;
        n4 = 0;
        while (n4 < n3) {
            ParameterRef newRef = parameterRefArray2[n4];
            found = false;
            parameterRefArray = oldRefs;
            n2 = oldRefs.length;
            n = 0;
            while (n < n2) {
                ParameterRef oldRef = parameterRefArray[n];
                if (UpdateNodeSystemDependency.refsEquals(paramBindings, dependencyProvider, oldRef, newRef)) {
                    found = true;
                    break;
                }
                ++n;
            }
            if (!found) {
                newParams.add(newRef);
            }
            ++n4;
        }
        for (ParameterRef delParam : delParams) {
            if (!RemoveNodeSystemParameter.isPossible(template, node.getID(), ActivityConstants.AccessType.SYSTEM_READ, delParam.getName())) continue;
            if (RemoveSystemDataFlow.isPossible(template, node.getID(), delParam.getName())) {
                RemoveSystemDataFlow.performOperation(session, (ChangePrimitives)template, node.getID(), delParam.getName(), updateManager);
            }
            RemoveNodeSystemParameter.performOperation(session, (ChangePrimitives)template, node.getID(), ActivityConstants.AccessType.SYSTEM_READ, delParam.getName(), updateManager);
        }
        for (ParameterRef newParamRef : newParams) {
            ProcessModelParameter existentParam = node.getSystemParameter(newParamRef.getName(), ActivityConstants.AccessType.SYSTEM_READ);
            Dependency dependency = paramBindings.get(newParamRef.getName());
            if (dependency != null) {
                Object depType = dependency.getType();
                if (depType.equals(Dependency.DEPENDENCY_TYPE_DATA_ELEMENT)) {
                    DataElement dataElement = (DataElement)dependency.getArgument();
                    if (existentParam == null) {
                        if (dataElement != null) {
                            ProcessModelFactory pmf;
                            try {
                                pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory("Update Node System Parameters");
                            }
                            catch (ServiceNotKnownException snke) {
                                throw new RTServiceNotKnownException(snke);
                            }
                            existentParam = pmf.createProcessModelParameter(newParamRef.getName(), dataElement.getDescription(), newParamRef.getDataType(), dataElement.getUDTName(), dataElement.getIdentifierID(), false, dataElement.isVirtual(), false, null, null, null, null);
                        } else {
                            existentParam = ChangeOperationTools.createSimpleProcessParameterObject(session, newParamRef.getName(), newParamRef.getDataType(), "", false, ProcessConstants.IDENTIFIER_NOT_SET, true);
                        }
                        assert (AddNodeSystemParameter.isPossible(template, node.getID(), ActivityConstants.AccessType.SYSTEM_READ, existentParam));
                        AddNodeSystemParameter.performOperation(session, (ChangePrimitives)template, node.getID(), ActivityConstants.AccessType.SYSTEM_READ, existentParam, updateManager);
                    }
                    if (dataElement == null || template.getDataEdge(node.getID(), dataElement.getID(), ActivityConstants.AccessType.SYSTEM_READ) != null) continue;
                    logger.info("call change operation insert data edge");
                    InsertDataEdge.performOperation(session, (ChangePrimitives)template, template.getNode(node.getID()), dataElement, existentParam, ActivityConstants.AccessType.SYSTEM_READ, updateManager);
                    continue;
                }
                if (depType instanceof SystemDataProducer) {
                    Node producerNode;
                    if (existentParam == null) {
                        ProcessModelFactory pmf;
                        ProcessModelParameter param = ((SystemDataProducer)((Object)depType)).getParameterProperties();
                        try {
                            pmf = ModelFactoryRegistry.getModelFactoryRegistry().getProcessModelFactory("Update Node System Parameters");
                        }
                        catch (ServiceNotKnownException snke) {
                            throw new RTServiceNotKnownException(snke);
                        }
                        ProcessModelParameter newParam = pmf.createProcessModelParameter(newParamRef.getName(), param.getDescription(), newParamRef.getDataType(), param.getUDTName(), param.getIdentifierID(), param.isOptional(), param.isVirtual(), param.isFailure(), param.getDefaultValue(), param.getConfiguration(), param, param.getUserAttributes());
                        assert (AddNodeSystemParameter.isPossible(template, node.getID(), ActivityConstants.AccessType.SYSTEM_READ, newParam));
                        AddNodeSystemParameter.performOperation(session, (ChangePrimitives)template, node.getID(), ActivityConstants.AccessType.SYSTEM_READ, newParam, updateManager);
                    }
                    if ((producerNode = (Node)dependency.getArgument()) == null) continue;
                    assert (AddSystemDataFlow.isPossible((Template)template, producerNode.getID(), (SystemDataProducer)((Object)depType), node.getID(), newParamRef.getName()));
                    AddSystemDataFlow.performOperation(session, template, producerNode.getID(), (SystemDataProducer)((Object)depType), node.getID(), newParamRef.getName(), updateManager);
                    continue;
                }
                throw new IllegalArgumentException("Handling for the binding type '" + depType.getClass().getName() + "' is not implemented");
            }
            ProcessModelParameter newParam = ChangeOperationTools.createSimpleProcessParameterObject(session, newParamRef.getName(), newParamRef.getDataType(), "", false, ProcessConstants.IDENTIFIER_NOT_SET, true);
            assert (AddNodeSystemParameter.isPossible(template, node.getID(), ActivityConstants.AccessType.SYSTEM_READ, newParam));
            AddNodeSystemParameter.performOperation(session, (ChangePrimitives)template, node.getID(), ActivityConstants.AccessType.SYSTEM_READ, newParam, updateManager);
        }
    }

    private static boolean enoughParameter(Node node, Template template, Map<String, Dependency> paramBindings, CheckReport checkReport) {
        if (node == null) {
            if (checkReport != null) {
                String message = "Not enough selected elements for this operation. A single node is needed.";
                checkReport.addReportEntry("Update Node System Parameters", CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (template.getNode(node.getID()) == null) {
            if (checkReport != null) {
                String message = "The given template/instance does not contain the node: " + node;
                checkReport.addReportEntry("Update Node System Parameters", CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (paramBindings == null) {
            if (checkReport != null) {
                String message = "The parameter binding is null! Use an empty map to show that there is no parameter binding.";
                checkReport.addReportEntry("Update Node System Parameters", CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }

    private static boolean refsEquals(Map<String, Dependency> paramBindings, NodeDependencyProvider dependencyProvider, ParameterRef oldRef, ParameterRef newRef) {
        Dependency oldDependency;
        boolean equals = false;
        if (oldRef.getName().equals(newRef.getName()) && oldRef.getDataType().equals((Object)newRef.getDataType()) && (oldDependency = dependencyProvider.getDependencyOf(oldRef.getName())) != null) {
            if (oldDependency.getType().equals(Dependency.DEPENDENCY_TYPE_DATA_ELEMENT) && paramBindings.get(newRef.getName()).getType().equals(Dependency.DEPENDENCY_TYPE_DATA_ELEMENT)) {
                DataElement oldDataElement = (DataElement)oldDependency.getArgument();
                DataElement newDataElement = (DataElement)paramBindings.get(newRef.getName()).getArgument();
                if (oldDataElement.getID() == newDataElement.getID()) {
                    equals = true;
                }
            } else if (oldDependency.getType() instanceof SystemDataProducer && paramBindings.get(newRef.getName()).getType() instanceof SystemDataProducer) {
                equals = true;
            }
        }
        return equals;
    }
}

