/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class UpdatePluginDataContainer {
    protected static final Logger logger = LoggerTools.getLogger(UpdatePluginDataContainer.class);
    private static final String CHECK_ID = "Update Plugin Data Container";

    public static boolean isPossible(Template template, PluginDataContainer pluginContainer, String extensionPointID, String pluginDataID, PluginData pluginData) {
        return UpdatePluginDataContainer.isPossible(template, pluginContainer, extensionPointID, pluginDataID, pluginData, null);
    }

    public static boolean isPossible(Template template, PluginDataContainer pluginContainer, String extensionPointID, String pluginDataID, PluginData pluginData, CheckReport checkReport) {
        return UpdatePluginDataContainer.enoughParameter(pluginContainer, extensionPointID, pluginDataID, pluginData, checkReport);
    }

    public static boolean isPossible(ChangeableInstance instance, PluginDataContainer pluginContainer, String extensionPointID, String pluginDataID, PluginData pluginData) {
        return UpdatePluginDataContainer.isPossible(instance, pluginContainer, extensionPointID, pluginDataID, pluginData, null);
    }

    public static boolean isPossible(ChangeableInstance instance, PluginDataContainer pluginContainer, String extensionPointID, String pluginDataID, PluginData pluginData, CheckReport checkReport) {
        int nodeID;
        if (pluginContainer instanceof Node && instance.getNodeState(nodeID = ((Node)pluginContainer).getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(instance.getTemplate().getNode(nodeID)) + "' whose plug in data container should be changed must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(nodeID).toString() + ".";
                Node node = instance.getTemplate().getNode(nodeID);
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node, "NodeState"));
            }
            return false;
        }
        return UpdatePluginDataContainer.isPossible(instance.getTemplate(), pluginContainer, extensionPointID, pluginDataID, pluginData, checkReport);
    }

    public static void performOperation(ChangeableTemplate template, PluginDataContainer pluginContainer, String extensionPointID, String pluginDataID, PluginData pluginData) {
        UpdatePluginDataContainer.performOperation(template, pluginContainer, extensionPointID, pluginDataID, pluginData, null);
    }

    public static void performOperation(ChangeableTemplate template, PluginDataContainer pluginContainer, String extensionPointID, String pluginDataID, PluginData pluginData, UpdateManager updateManager) {
        UpdatePluginDataContainer.performOperation((ChangePrimitives)template, pluginContainer, extensionPointID, pluginDataID, pluginData, updateManager);
    }

    public static void performOperation(ChangeableInstance instance, PluginDataContainer pluginContainer, String extensionPointID, String pluginDataID, PluginData pluginData) {
        UpdatePluginDataContainer.performOperation(instance, pluginContainer, extensionPointID, pluginDataID, pluginData, null);
    }

    public static void performOperation(ChangeableInstance instance, PluginDataContainer pluginContainer, String extensionPointID, String pluginDataID, PluginData pluginData, UpdateManager updateManager) {
        UpdatePluginDataContainer.performOperation((ChangePrimitives)instance, pluginContainer, extensionPointID, pluginDataID, pluginData, updateManager);
    }

    protected static void performOperation(ChangePrimitives processGraph, PluginDataContainer pluginContainer, String extensionPointID, String pluginDataID, PluginData pluginData, UpdateManager updateManager) {
        logger.info("calling change primitive updatePluginDataContainer");
        processGraph.updatePluginDataContainer(pluginContainer, extensionPointID, pluginDataID, pluginData);
        if (updateManager != null) {
            Enum changedProperty;
            if (pluginContainer instanceof Node) {
                changedProperty = UpdateManager.NodeProperties.NODE_PLUG_IN_DATA;
            } else if (pluginContainer instanceof Template || pluginContainer instanceof Instance) {
                changedProperty = UpdateManager.ProcessProperties.PROCESS_PLUG_IN_DATA;
            } else if (pluginContainer instanceof DataElement) {
                changedProperty = UpdateManager.DataElementProperties.DE_PLUG_IN_DATA;
            } else if (pluginContainer instanceof ConstraintEdge) {
                changedProperty = UpdateManager.ProcessProperties.PROCESS_PLUG_IN_DATA;
            } else {
                throw new IllegalArgumentException("not implemented yet for " + pluginContainer.getClass());
            }
            updateManager.firePropertyChange(pluginContainer, changedProperty);
            updateManager.firePropertyChange(processGraph, (Object)UpdateManager.ProcessProperties.PROCESS);
        }
    }

    private static boolean enoughParameter(PluginDataContainer pluginContainer, String extensionPointID, String pluginDataID, PluginData pluginData, CheckReport checkReport) {
        if (pluginContainer == null || extensionPointID == null || extensionPointID.equals("") || pluginDataID == null || pluginDataID.equals("")) {
            if (checkReport != null) {
                String message = "Not enough elements for this operation. A plug in container, an extension point ID and a plug in data ID and an attribute are needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        if (pluginData == null && pluginContainer.getPluginData(pluginDataID) == null) {
            if (checkReport != null) {
                String message = "Incorrect element combination for this operation. If the plug in data object is null, the plugin data ID must exist for the plug in data container.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

