/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

public class UpdateTemplate {
    protected static final Logger logger = LoggerTools.getLogger(UpdateTemplate.class);

    public static boolean isPossible(UUID templateID, ProcessConstants.TemplateProperty ... templateProperties) {
        return UpdateTemplate.isPossible(templateID, null, templateProperties);
    }

    public static boolean isPossible(UUID templateID, CheckReport checkReport, ProcessConstants.TemplateProperty ... templateProperties) {
        return UpdateTemplate.templateExists(templateID, checkReport);
    }

    public static void performOperation(ChangeableTemplate template, String newName, String newInstanceNameTemplate, QualifiedAgent newSupervisorAgent, Set<ProcessModelParameter> newInputParameters, Set<ProcessModelParameter> newOutputParameters, ProcessConstants.TemplateProperty ... templateProperties) {
        UpdateTemplate.performOperation(template, newName, newInstanceNameTemplate, newSupervisorAgent, newInputParameters, newOutputParameters, null, templateProperties);
    }

    public static void performOperation(ChangeableTemplate template, String newName, String newInstanceNameTemplate, QualifiedAgent newSupervisorAgent, Set<ProcessModelParameter> newInputParameters, Set<ProcessModelParameter> newOutputParameters, UpdateManager updateManager, ProcessConstants.TemplateProperty ... templateProperties) {
        ProcessConstants.TemplateProperty property;
        ProcessConstants.TemplateProperty[] templatePropertyArray = templateProperties;
        int n = templateProperties.length;
        int n2 = 0;
        while (n2 < n) {
            property = templatePropertyArray[n2];
            switch (property) {
                case NAME: {
                    if (newName != null) break;
                    throw new IllegalArgumentException("Invalid template property: Name is null!");
                }
                case INSTANCE_NAME_TEMPLATE: {
                    if (newInstanceNameTemplate != null) break;
                    throw new IllegalArgumentException("Invalid template property: InstanceNameTemplate is null!");
                }
                case SUPERVISOR_AGENT: {
                    if (newSupervisorAgent != null) break;
                    throw new IllegalArgumentException("Invalid template property: SupervisorAgent is null!");
                }
                case INPUT_PARAMETER: {
                    if (newInputParameters != null) break;
                    throw new IllegalArgumentException("Invalid template property: InputParameter is null!");
                }
                case OUTPUT_PARAMETER: {
                    if (newOutputParameters != null) break;
                    throw new IllegalArgumentException("Invalid template property: OutputParameter is null!");
                }
                default: {
                    throw new IllegalArgumentException("Template property " + (Object)((Object)property) + " is unknown!");
                }
            }
            ++n2;
        }
        templatePropertyArray = templateProperties;
        n = templateProperties.length;
        n2 = 0;
        while (n2 < n) {
            property = templatePropertyArray[n2];
            switch (property) {
                case NAME: {
                    logger.info("calling change primitive setName");
                    template.setName(newName);
                    break;
                }
                case INSTANCE_NAME_TEMPLATE: {
                    logger.info("calling change primitive setInstanceNameTemplate");
                    template.setInstanceNameTemplate(newInstanceNameTemplate);
                    break;
                }
                case SUPERVISOR_AGENT: {
                    logger.info("calling change primitive setSupervisorAgent");
                    template.setSupervisorAgent(newSupervisorAgent);
                    break;
                }
                case INPUT_PARAMETER: {
                    logger.info("calling change primitive setInputParameter");
                    template.setInputParameters(newInputParameters);
                    break;
                }
                case OUTPUT_PARAMETER: {
                    logger.info("calling change primitive setOutputParameter");
                    template.setOutputParameters(newOutputParameters);
                    break;
                }
                default: {
                    throw new RuntimeException("Programming error: update method for " + (Object)((Object)property) + " is not implemented.");
                }
            }
            ++n2;
        }
        if (updateManager != null && templateProperties.length > 0) {
            updateManager.firePropertyChange(template, (Object)UpdateManager.ProcessProperties.PROCESS);
        }
    }

    private static boolean templateExists(UUID templateID, CheckReport checkReport) {
        return true;
    }
}

