/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.changeoperations;

import de.aristaflow.adept2.core.changeoperations.ChangeOperationTools;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.UserAttributeContainer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class UpdateUserAttribute {
    protected static final Logger logger = LoggerTools.getLogger(UpdateUserAttribute.class);
    private static final String CHECK_ID = "Update User Attribute";

    public static boolean isPossible(Template template, UserAttributeContainer attributeContainer, String name, String value) {
        return UpdateUserAttribute.isPossible(template, attributeContainer, name, value, null);
    }

    public static boolean isPossible(Template template, UserAttributeContainer attributeContainer, String name, String value, CheckReport checkReport) {
        return UpdateUserAttribute.enoughParameter(attributeContainer, name, checkReport);
    }

    public static boolean isPossible(ChangeableInstance instance, UserAttributeContainer attributeContainer, String name, String value) {
        return UpdateUserAttribute.isPossible(instance, attributeContainer, name, value, null);
    }

    public static boolean isPossible(ChangeableInstance instance, UserAttributeContainer attributeContainer, String name, String value, CheckReport checkReport) {
        int nodeID;
        if (!UpdateUserAttribute.enoughParameter(attributeContainer, name, checkReport)) {
            return false;
        }
        if (attributeContainer instanceof Node && instance.getNodeState(nodeID = ((Node)attributeContainer).getID()) != ProcessConstants.NodeState.NS_ACTIVATED && instance.getNodeState(nodeID) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
            if (checkReport != null) {
                String message = "The node '" + ChangeOperationTools.getHumanReadableNodeName(instance.getTemplate().getNode(nodeID)) + "' whose user attribute container should be changed must be ACTIVATED or NOT_ACTIVATED, but it is in state: " + instance.getNodeState(nodeID).toString() + ".";
                Node node = instance.getTemplate().getNode(nodeID);
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node, "NodeState"));
            }
            return false;
        }
        return UpdateUserAttribute.isPossible(instance.getTemplate(), attributeContainer, name, value, checkReport);
    }

    public static void performOperation(ChangeableTemplate template, UserAttributeContainer attributeContainer, String name, String value) {
        UpdateUserAttribute.performOperation(template, attributeContainer, name, value, null);
    }

    public static void performOperation(ChangeableTemplate template, UserAttributeContainer attributeContainer, String name, String value, UpdateManager updateManager) {
        UpdateUserAttribute.performOperation((ChangePrimitives)template, attributeContainer, name, value, updateManager);
    }

    public static void performOperation(ChangeableInstance instance, UserAttributeContainer attributeContainer, String name, String value) {
        UpdateUserAttribute.performOperation(instance, attributeContainer, name, value, null);
    }

    public static void performOperation(ChangeableInstance instance, UserAttributeContainer attributeContainer, String name, String value, UpdateManager updateManager) {
        UpdateUserAttribute.performOperation((ChangePrimitives)instance, attributeContainer, name, value, updateManager);
    }

    protected static void performOperation(ChangePrimitives processGraph, UserAttributeContainer attributeContainer, String name, String value, UpdateManager updateManager) {
        logger.info("calling change primitive updateUserAttribute");
        if (value == null) {
            processGraph.removeUserAttribute(attributeContainer, name);
        } else {
            processGraph.updateUserAttribute(attributeContainer, name, value);
        }
        if (updateManager != null) {
            Enum changedProperty = null;
            if (attributeContainer instanceof Node) {
                changedProperty = UpdateManager.NodeProperties.NODE_USER_ATTRIB;
            } else if (attributeContainer instanceof Process) {
                changedProperty = UpdateManager.ProcessProperties.PROCESS_USER_ATTRIB;
            } else if (attributeContainer instanceof DataElement) {
                changedProperty = UpdateManager.DataElementProperties.DE_USER_ATTRIB;
            } else if (attributeContainer instanceof Activity) {
                changedProperty = UpdateManager.ActivityProperties.ACTIVITY_USER_ATTRIB;
            }
            updateManager.firePropertyChange(attributeContainer, changedProperty);
            updateManager.firePropertyChange(processGraph, (Object)UpdateManager.ProcessProperties.PROCESS);
        }
    }

    private static boolean enoughParameter(UserAttributeContainer attributeContainer, String name, CheckReport checkReport) {
        if (attributeContainer == null || name == null) {
            if (checkReport != null) {
                String message = "Not enough elements for this operation. A userAttributeContainer and an attribute given by its name are needed.";
                checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, new URI[0]);
            }
            return false;
        }
        return true;
    }
}

