/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public abstract class AbstractProcessTemplateCheck
implements ProcessTemplateCheck {
    protected final Logger logger = LoggerTools.getLogger(this);
    private final ThreadLocal<CheckReport.ResultType> result = new ThreadLocal();
    private final ThreadLocal<CheckReport> checkReport = new ThreadLocal();
    private final String id;

    protected AbstractProcessTemplateCheck(String id) {
        this.id = id;
    }

    @Override
    public final boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        ArgChecks.checkForNull(template, "template");
        ArgChecks.checkForNull(checkReport, "checkReport");
        try {
            this.result.set(CheckReport.ResultType.OK);
            this.checkReport.set(checkReport);
            this.performCheckSpi(template, relations, checkReport);
            boolean bl = this.result.get().ordinal() < CheckReport.ResultType.WARNING.ordinal();
            return bl;
        }
        finally {
            this.checkReport.remove();
            this.result.remove();
        }
    }

    protected abstract void performCheckSpi(Template var1, NodeRelations var2, CheckReport var3);

    protected final void addReportEntry(CheckReport.ResultType resultType, String message, Object ... elements) {
        this.logger.info(message);
        CheckReport checkReport = this.checkReport.get();
        if (checkReport != null) {
            URI[] uris = this.getURIsForElement(checkReport.getBase(), elements);
            checkReport.addReportEntry(this.id, resultType, message, uris);
        }
        if (this.result.get().ordinal() < resultType.ordinal()) {
            this.result.set(resultType);
        }
    }

    private URI[] getURIsForElement(URI base, Object[] element) {
        URI[] res = new URI[element.length];
        int i = 0;
        while (i < res.length) {
            if (element[i] instanceof DataElement) {
                res[i] = ProcessElementIdentifierTools.getDataElementIdentifier(base, (DataElement)element[i]);
            } else if (element[i] instanceof Node) {
                res[i] = ProcessElementIdentifierTools.getNodeIdentifier(base, (Node)element[i]);
            }
            ++i;
        }
        return res;
    }
}

