/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.core.checks.processmodel.CompositeProcessTemplateCheck;
import de.aristaflow.adept2.core.checks.processmodel.ProcessCheckService;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.util.DataSourceException;
import java.net.URI;
import java.util.List;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="BasicModellingChecks")})
public class DefaultProcessCheckService
extends AbstractADEPT2Service
implements ProcessCheckService {
    public static final String CHECKS_CONSISTENCY = "AllConsistencyChecks";
    public static final String CHECKS_STRUCTURE = "AllStructureChecks";
    public static final String CHECKS_BASIC_MODELLING = "BasicModellingChecks";
    public static final String CHECKS_EXECUTION_PRODUCTION = "ProductionExecutionChecks";
    public static final String CHECKS_EXECUTION_TEST_CLIENT = "TestClientExecutionChecks";
    private final Configuration configuration;
    private SessionFactory sessionFactory;
    private ProcessTemplateCheck checksBasicModelling;
    private ProcessTemplateCheck checksExecutionTestClient;
    private ProcessTemplateCheck checksExecutionProduction;

    public DefaultProcessCheckService(Configuration configuration, Registry registry) {
        super(configuration, registry);
        this.configuration = configuration;
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        try {
            this.sessionFactory = this.registry.getSecurityManager().authenticatePrivileged(-2L, -2L, "password");
        }
        catch (AuthenticationException ae) {
            throw new InternalServiceException("Failed to authenticate at the security manager due to wrongauthentication data. Check the configuration of this SubprocessManager.", ae);
        }
        catch (DataSourceException dse) {
            throw new InternalServiceException("Failed to authenticate at the security manager due to unavailability of the data.", dse);
        }
        this.checksBasicModelling = this.getCheckRunnerForCheckSet(CHECKS_BASIC_MODELLING);
        this.checksExecutionTestClient = this.getCheckRunnerForCheckSet(CHECKS_EXECUTION_TEST_CLIENT);
        this.checksExecutionProduction = this.getCheckRunnerForCheckSet(CHECKS_EXECUTION_PRODUCTION);
    }

    private ProcessTemplateCheck getCheckRunnerForCheckSet(String checkSet) {
        List checkIDs = this.configuration.getList(checkSet);
        ProcessTemplateCheck[] checks = new ProcessTemplateCheck[checkIDs.size()];
        int i = 0;
        while (i < checkIDs.size()) {
            checks[i] = this.getProcessTemplateCheck((String)checkIDs.get(i));
            ++i;
        }
        return new CompositeProcessTemplateCheck(checks);
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
    }

    @Override
    public ProcessTemplateCheck getProcessTemplateCheck(String checkID) {
        try {
            return this.registry.getConfiguredPlugin(this.sessionFactory.getSessionToken(this.getURIs()), this, "ProcessTemplateCheck", ProcessTemplateCheck.class, checkID);
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
    }

    @Override
    public ProcessTemplateCheck getBasicModellingChecks() {
        return this.checksBasicModelling;
    }

    @Override
    public ProcessTemplateCheck getConsistencyChecks() {
        return this.getProcessTemplateCheck(CHECKS_CONSISTENCY);
    }

    @Override
    public ProcessTemplateCheck getStructureChecks() {
        return this.getProcessTemplateCheck(CHECKS_STRUCTURE);
    }

    @Override
    public ProcessTemplateCheck getExecutionProductionChecks() {
        return this.checksExecutionProduction;
    }

    @Override
    public ProcessTemplateCheck getExecutionTestClientChecks() {
        return this.checksExecutionTestClient;
    }
}

