/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessTemplateCheckRunner {
    private final ProcessTemplateCheck[] checks;
    protected final Logger logger;
    private final boolean stopOnError;
    public static final String RECURSIVE_CHECK_ID = "Recursive check";

    public ProcessTemplateCheckRunner(boolean stopOnError, ProcessTemplateCheck[] checks) {
        this.stopOnError = stopOnError;
        this.checks = checks != null ? (ProcessTemplateCheck[])checks.clone() : null;
        this.logger = LoggerTools.getLogger(this);
    }

    public ProcessTemplateCheckRunner(ProcessTemplateCheck ... checks) {
        this(true, checks);
    }

    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        HashMap<Template, Node> embeddedTemplates = new HashMap<Template, Node>();
        ProcessTemplateCheck[] processTemplateCheckArray = this.checks;
        int n = this.checks.length;
        int n2 = 0;
        while (n2 < n) {
            boolean checkOK;
            ProcessTemplateCheck check = processTemplateCheckArray[n2];
            this.logger.fine(String.format("Running check: %s", check.getClass().getSimpleName()));
            try {
                checkOK = check.performCheck(template, relations, checkReport);
            }
            catch (RuntimeException e) {
                allOK = false;
                String message = String.format("An exception occurred performing the check '%1$s', failing and skipping subsequent checks!", check.getClass().getSimpleName());
                this.logger.log(Level.SEVERE, message, e);
                if (checkReport == null) break;
                checkReport.addReportEntry(message, CheckReport.ResultType.FAILURE, message, new URI[0]);
                break;
            }
            if (!checkOK) {
                allOK = false;
                this.logger.info("Check '" + check.getClass().getSimpleName() + "' failed, skipping following checks.");
                if (this.stopOnError) {
                    return false;
                }
            }
            ++n2;
        }
        for (Node node : template.getNodes()) {
            ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
            if (ebp instanceof VariableParallelismEBP) {
                ebp = ((VariableParallelismEBP)ebp).getLightWeightProcess();
            }
            if (!(ebp instanceof EmbeddedProcess)) continue;
            EmbeddedProcess embedded = (EmbeddedProcess)ebp;
            embeddedTemplates.put(embedded.getTemplate(), node);
        }
        HashSet<CheckReport.ResultType> resultTypesToProcess = new HashSet<CheckReport.ResultType>(Arrays.asList(CheckReport.ResultType.values()));
        resultTypesToProcess.remove((Object)CheckReport.ResultType.OK);
        block4: while (!embeddedTemplates.isEmpty()) {
            Template embeddedTemplate = (Template)embeddedTemplates.keySet().iterator().next();
            Node containingNode = (Node)embeddedTemplates.remove(embeddedTemplate);
            CheckReport embeddedReport = null;
            if (checkReport != null) {
                embeddedReport = new CheckReport(checkReport.getBase());
            }
            ProcessTemplateCheck[] processTemplateCheckArray2 = this.checks;
            int message = this.checks.length;
            int n3 = 0;
            while (n3 < message) {
                ProcessTemplateCheck check = processTemplateCheckArray2[n3];
                boolean checkOK = check.performCheck(embeddedTemplate, new NodeRelations(embeddedTemplate), embeddedReport);
                if (checkReport != null && embeddedReport != null) {
                    for (CheckReport.ReportEntry entry : embeddedReport.getReportEntries()) {
                        if (!resultTypesToProcess.contains((Object)entry.getReportEntryType())) continue;
                        resultTypesToProcess.remove((Object)entry.getReportEntryType());
                        URI nodeURI = ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), containingNode);
                        String message2 = String.format("An embedded template contains %s messages.", entry.getReportEntryType().toString());
                        checkReport.addReportEntry(RECURSIVE_CHECK_ID, entry.getReportEntryType(), message2, nodeURI);
                        if (resultTypesToProcess.size() == 0) break block4;
                    }
                }
                if (!checkOK) {
                    allOK = false;
                    break;
                }
                ++n3;
            }
            for (Node node : embeddedTemplate.getNodes()) {
                ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
                if (ebp instanceof VariableParallelismEBP) {
                    ebp = ((VariableParallelismEBP)ebp).getLightWeightProcess();
                }
                if (!(ebp instanceof EmbeddedProcess)) continue;
                EmbeddedProcess embedded = (EmbeddedProcess)ebp;
                embeddedTemplates.put(embedded.getTemplate(), containingNode);
            }
        }
        return allOK;
    }
}

