/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.activity;

import de.aristaflow.adept2.core.checks.processmodel.activity.ExecutableComponentCheck;
import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.StringTools;
import java.net.URI;
import java.util.Arrays;
import java.util.logging.Logger;

public abstract class AbstractExecutableComponentCheck
implements ExecutableComponentCheck {
    protected final Logger logger;
    private final String ecName;
    private final String checkID;
    private final ThreadLocal<CheckReport.ResultType> result = new ThreadLocal();
    private final ThreadLocal<CheckReport> checkReport = new ThreadLocal();
    private final ThreadLocal<URI> affectedNode = new ThreadLocal();

    public AbstractExecutableComponentCheck(String ecName, String checkID) {
        this.logger = LoggerTools.getLogger(this);
        this.ecName = ecName;
        this.checkID = checkID;
    }

    public String getCheckID() {
        return this.checkID;
    }

    public String getExecutableComponentName() {
        return this.ecName;
    }

    @Override
    public final boolean performCheck(AbstractActivity activity, CheckReport checkReport, URI affectedNode) {
        ArgChecks.checkForNull(activity, "activity");
        ArgChecks.checkForNull(checkReport, "checkReport");
        ArgChecks.checkForNull(affectedNode, "affectedNode");
        try {
            this.result.set(CheckReport.ResultType.OK);
            this.checkReport.set(checkReport);
            this.affectedNode.set(affectedNode);
            this.performCheckSpi(activity);
            boolean bl = this.result.get() != CheckReport.ResultType.FAILURE;
            return bl;
        }
        finally {
            this.affectedNode.remove();
            this.checkReport.remove();
            this.result.remove();
        }
    }

    protected abstract void performCheckSpi(AbstractActivity var1);

    protected final boolean checkParameterPresent(AbstractActivity activity, String parameterName, ActivityConstants.AccessType accessType) {
        Parameter param = activity.getParameter(parameterName, accessType);
        if (param == null) {
            String msg = "The %s parameter '%s' is missing!";
            msg = String.format(msg, this.toText(accessType), parameterName);
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            return false;
        }
        return true;
    }

    protected final boolean checkParameter(AbstractActivity activity, String parameterName, ActivityConstants.AccessType accessType, boolean isPresenceOptional, Boolean isAccessOptional, ProcessConstants.AdeptDataType ... allowedDataTypes) {
        String msg;
        Parameter param = activity.getParameter(parameterName, accessType);
        if (param == null) {
            if (!isPresenceOptional) {
                String msg2 = "The %s parameter '%s' is missing!";
                msg2 = String.format(msg2, this.toText(accessType), parameterName);
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg2);
            }
            return false;
        }
        if (isAccessOptional != null && param.isOptional() != isAccessOptional.booleanValue()) {
            msg = param.isOptional() ? "The %s parameter '%s' is optional but should not be!" : "The %s parameter '%s' is not optional but should be!";
            msg = String.format(msg, this.toText(accessType), parameterName);
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        }
        if (!Arrays.asList(allowedDataTypes).contains((Object)param.getDataType())) {
            msg = "The %s parameter '%s' must have one of the following data types: %s";
            msg = String.format(msg, this.toText(accessType), parameterName, StringTools.join(", ", (Object[])allowedDataTypes));
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        }
        return true;
    }

    protected final boolean checkParameter(Parameter param, ActivityConstants.AccessType accessType, ProcessConstants.AdeptDataType ... allowedDataTypes) {
        if (!Arrays.asList(allowedDataTypes).contains((Object)param.getDataType())) {
            String msg = "The %s parameter '%s' must have one of the following data types: %s";
            msg = String.format(msg, this.toText(accessType), param.getName(), StringTools.join(", ", (Object[])allowedDataTypes));
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            return false;
        }
        return true;
    }

    protected final boolean checkDualStringInputParameter(AbstractActivity activity, String parameterName) {
        Parameter param = activity.getParameter(parameterName, ActivityConstants.AccessType.READ);
        String fieldValue = activity.getConfiguration().getString(parameterName);
        if (param == null) {
            if (fieldValue == null) {
                String msg = "The input parameter and configuration entry both with the name '%s' are missing!";
                msg = String.format(msg, parameterName);
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                return false;
            }
        } else {
            String msg;
            if (param.getDataType() != ProcessConstants.AdeptDataType.STRING) {
                msg = "The input parameter '%s' must have the data type %s!";
                msg = String.format(msg, new Object[]{parameterName, ProcessConstants.AdeptDataType.STRING});
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
            if (param.isOptional()) {
                msg = "The configuration entry '%s' must be set since the input parameter '%s' is only optional!";
                msg = String.format(msg, parameterName, parameterName);
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            } else if (fieldValue != null) {
                msg = "The configuration field '%s' is not required since a value is always provided by the input parameter '%s'!";
                msg = String.format(msg, parameterName, parameterName);
                this.addReportEntry(CheckReport.ResultType.WARNING, msg);
            }
        }
        return true;
    }

    protected final boolean checkDualIntegerInputParameter(AbstractActivity activity, String parameterName) {
        return this.checkDualIntegerInputParameter(activity, parameterName, parameterName);
    }

    protected final boolean checkDualIntegerInputParameter(AbstractActivity activity, String parameterName, String confEntryName) {
        String msg;
        Parameter param = activity.getParameter(parameterName, ActivityConstants.AccessType.READ);
        String fieldValue = activity.getConfiguration().getString(confEntryName);
        if (fieldValue != null) {
            try {
                Long.parseLong(fieldValue);
            }
            catch (NumberFormatException numberFormatException) {
                msg = "The configuration entry '%s' cannot be parsed to a valid INTEGER!";
                msg = String.format(msg, confEntryName);
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
        }
        if (param == null) {
            if (fieldValue == null) {
                msg = "The input parameter '%s' and configuration entry '%s' are both missing!";
                msg = String.format(msg, parameterName, confEntryName);
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                return false;
            }
        } else {
            if (param.getDataType() != ProcessConstants.AdeptDataType.INTEGER) {
                msg = "The input parameter '%s' must have the data type %s!";
                msg = String.format(msg, new Object[]{parameterName, ProcessConstants.AdeptDataType.INTEGER});
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            }
            if (param.isOptional()) {
                msg = "The configuration entry '%s' must be set since the input parameter '%s' is only optional!";
                msg = String.format(msg, confEntryName, parameterName);
                this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            } else if (fieldValue != null) {
                msg = "The configuration entry '%s' is not required since a value is always provided by the input parameter '%s'!";
                msg = String.format(msg, confEntryName, parameterName);
                this.addReportEntry(CheckReport.ResultType.WARNING, msg);
            }
        }
        return true;
    }

    private String toText(ActivityConstants.AccessType accessType) {
        return accessType == ActivityConstants.AccessType.READ ? "input" : "output";
    }

    protected final boolean checkOneOfATCFieldsPresent(AbstractActivity activity, String ... fieldNames) {
        boolean onePresent = false;
        String[] stringArray = fieldNames;
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            ArgChecks.checkForNull(activity, "activity");
            ArgChecks.checkForNull(fieldName, "fieldName");
            String value = activity.getConfiguration().getString(fieldName);
            if (value != null) {
                if (onePresent) {
                    String msg = "Only one of the configuration entries %s may be present!";
                    msg = String.format(msg, AbstractExecutableComponentCheck.createFieldList(fieldNames));
                    this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
                    return false;
                }
                onePresent = true;
            }
            ++n2;
        }
        if (!onePresent) {
            String msg = "One of the configuration entries %s must be present!";
            msg = String.format(msg, AbstractExecutableComponentCheck.createFieldList(fieldNames));
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            return false;
        }
        return true;
    }

    private static final String createFieldList(String ... fieldNames) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        String[] stringArray = fieldNames;
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("'").append(fieldName).append("'");
            ++n2;
        }
        return sb.toString();
    }

    protected final boolean checkATPCFieldPresent(Parameter param, ActivityConstants.AccessType accessType, String fieldName) {
        ArgChecks.checkForNull(param, "param");
        ArgChecks.checkForNull(fieldName, "fieldName");
        String value = param.getConfiguration().getString(fieldName);
        if (value == null) {
            String temp = accessType == ActivityConstants.AccessType.READ ? "input" : "output";
            String msg = "The configuration entry '%s' for %s parameter '%s' is missing or has no value!";
            msg = String.format(msg, fieldName, temp, param.getName());
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
            return false;
        }
        return true;
    }

    protected final void addReportEntry(CheckReport.ResultType resultType, String message) {
        this.logger.info(message);
        CheckReport checkReport = this.checkReport.get();
        if (checkReport != null) {
            checkReport.addReportEntry(this.getCheckID(), resultType, message, this.affectedNode.get());
        }
        if (this.result.get().ordinal() < resultType.ordinal()) {
            this.result.set(resultType);
        }
    }

    protected boolean checkConfEntrySet(ActivityConfiguration conf, String entryName) {
        return this.checkConfEntrySet(conf, entryName, null, null);
    }

    protected boolean checkConfEntrySet(ActivityConfiguration conf, String entryName, ActivityConstants.AccessType accessType, String paramName) {
        if (this.isConfEntrySet(conf, entryName)) {
            return true;
        }
        if (conf.getString(entryName) == null && conf.fromInputParameter(entryName) == null && conf.fromProcessConfiguration(entryName) == null) {
            String msg = accessType == null ? "The configuration entry '%s' is missing from the activity!" : "The configuration entry '%s' of %s parameter '%s' is missing!";
            msg = String.format(msg, new Object[]{entryName, accessType, paramName});
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        }
        return false;
    }

    protected boolean isConfEntrySet(ActivityConfiguration conf, String entryName) {
        ArgChecks.checkForNull(conf, "conf");
        ArgChecks.checkForNull(entryName, "entryName");
        return conf.getString(entryName) != null || conf.fromInputParameter(entryName) != null || conf.fromProcessConfiguration(entryName) != null;
    }

    protected boolean checkConfValueAvailable(ActivityConfiguration conf, String entryName) {
        return this.checkConfValueAvailable(conf, entryName, null, null);
    }

    protected boolean checkConfValueAvailable(ActivityConfiguration conf, String entryName, ActivityConstants.AccessType accessType, String paramName) {
        ArgChecks.checkForNull(conf, "conf");
        ArgChecks.checkForNull(entryName, "entryName");
        if (!this.isConfEntrySet(conf, entryName)) {
            return false;
        }
        if (this.isConfValueAvailable(conf, entryName)) {
            return true;
        }
        String msg = accessType == null ? "The configuration entry '%s' of the activity is set but the value is not available and therefore could not be checked." : "The configuration entry '%s' of %s parameter '%s' is set but the value is not available and therefore could not be checked.";
        msg = String.format(msg, entryName, this.toText(accessType), paramName);
        this.addReportEntry(CheckReport.ResultType.INFO, msg);
        return false;
    }

    private boolean isConfValueAvailable(ActivityConfiguration conf, String entryName) {
        ArgChecks.checkForNull(conf, "conf");
        ArgChecks.checkForNull(entryName, "entryName");
        return conf.getString(entryName) != null;
    }

    protected boolean checkConfValueAvailable(ActivityConfiguration conf, String entryName, ProcessConstants.AdeptDataType dataType) {
        return this.checkConfValueAvailable(conf, entryName, dataType, null, null);
    }

    protected boolean checkConfValueAvailable(ActivityConfiguration conf, String entryName, ProcessConstants.AdeptDataType dataType, ActivityConstants.AccessType accessType, String paramName) {
        boolean matchesType;
        if (!this.checkConfValueAvailable(conf, entryName, accessType, paramName)) {
            return false;
        }
        switch (dataType) {
            case BOOLEAN: {
                matchesType = conf.getBoolean(entryName) != null;
                break;
            }
            case INTEGER: {
                matchesType = conf.getInteger(entryName) != null;
                break;
            }
            case FLOAT: {
                matchesType = conf.getFloat(entryName) != null;
                break;
            }
            case STRING: {
                matchesType = conf.getString(entryName) != null;
                break;
            }
            case URI: {
                matchesType = conf.getURI(entryName) != null;
                break;
            }
            case DATE: {
                matchesType = conf.getDate(entryName) != null;
                break;
            }
            case USERDEFINED: {
                matchesType = conf.getUDT(entryName) != null;
                break;
            }
            default: {
                String msg = "%s not yet supported in this method";
                msg = String.format(msg, new Object[]{dataType});
                throw new AssertionError((Object)msg);
            }
        }
        if (!matchesType) {
            String msg = accessType == null ? "The configuration entry '%s' of the activity does not have the expected data type %s!" : "The configuration entry '%1$s' of %3$s parameter '%4$s' does not have the expected data type %2$s!";
            msg = String.format(msg, new Object[]{entryName, dataType, this.toText(accessType), paramName});
            this.addReportEntry(CheckReport.ResultType.FAILURE, msg);
        }
        return matchesType;
    }
}

