/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.activity;

import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.core.checks.processmodel.DefaultProcessCheckService;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.checks.processmodel.activity.ExecutableComponentCheck;
import de.aristaflow.adept2.core.checks.processmodel.activity.SubprocessCheck;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;

public class AllExecutableComponentChecks
implements ProcessTemplateCheck {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final Registry registry;
    protected final SessionFactory sessionFactory;
    protected final URI[] uris;

    public AllExecutableComponentChecks(Configuration configuration, DefaultProcessCheckService checkService, Registry registry) {
        this.registry = registry;
        this.uris = checkService.getURIs();
        try {
            this.sessionFactory = registry.getSecurityManager().authenticatePrivileged(-2L, -2L, "password");
        }
        catch (AuthenticationException ae) {
            throw new InternalServiceException("Failed to authenticate at the security manager due to wrongauthentication data. Check the configuration of this SubprocessManager.", ae);
        }
        catch (DataSourceException dse) {
            throw new InternalServiceException("Failed to authenticate at the security manager due to unavailability of the data.", dse);
        }
    }

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        for (Node node : template.getNodes()) {
            ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
            if (ebp != null && ebp instanceof Activity) {
                Activity activity = (Activity)ebp;
                String ecName = activity.getExecutableComponentName();
                ExecutableComponentCheck check = this.getExecutableComponentCheck(ecName);
                if (check != null) {
                    URI affectedNode = ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node);
                    allOK = allOK && check.performCheck(activity, checkReport, affectedNode);
                    continue;
                }
                String message = String.format("No check for executable component '%s'", ecName);
                this.logger.info(message);
                continue;
            }
            if (ebp == null || !(ebp instanceof VariableParallelismEBP)) continue;
            allOK = new SubprocessCheck().performCheck(node, checkReport);
        }
        return allOK;
    }

    protected ExecutableComponentCheck getExecutableComponentCheck(String ecName) {
        ExecutableComponentCheck plugin;
        try {
            plugin = this.registry.getConfiguredPlugin(this.sessionFactory.getSessionToken(this.uris), this, "ActivityTypeCheck", ExecutableComponentCheck.class, ecName);
        }
        catch (ServiceNotKnownException snke) {
            this.logger.log(Level.INFO, String.format("QA Warning: There is no check registered for activity type '%s':", ecName), snke);
            plugin = null;
        }
        return plugin;
    }
}

