/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.activity;

import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;

public class SubprocessCheck {
    private static final String SUB_PROCESS_CHECK = "SubProcess Check";
    protected final Logger logger = LoggerTools.getLogger(this);

    public boolean performCheck(Node node, CheckReport checkReport) {
        boolean allOK = true;
        ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
        if (ebp != null && ebp instanceof VariableParallelismEBP) {
            VariableParallelismEBP varPar = (VariableParallelismEBP)ebp;
            for (ProcessModelParameter param : varPar.getParameters(ActivityConstants.AccessType.WRITE)) {
                if (param.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED && param.getUDTName().startsWith("java.util.List")) continue;
                String msg = String.format("The subprocess template on node %s is used in variable parallelism mode but there are output parameters which are not USERDEFINED with UDTName java.util.List", node.getName());
                if (checkReport != null) {
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                    checkReport.addReportEntry(SUB_PROCESS_CHECK, CheckReport.ResultType.FAILURE, msg, affectedElements);
                }
                this.logger.severe(msg);
                allOK = false;
            }
            if (varPar.getIndexedInputParameters().isEmpty()) {
                String msg = String.format("The subprocess template on node %s is used in variable parallelism mode but there is no input parameter which is declared to be used as index for the var par.", node.getName());
                if (checkReport != null) {
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), node)};
                    checkReport.addReportEntry(SUB_PROCESS_CHECK, CheckReport.ResultType.FAILURE, msg, affectedElements);
                }
                this.logger.severe(msg);
                allOK = false;
            }
        }
        return allOK;
    }
}

