/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.checks.processmodel.consistency;

import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.tools.ProcessGraphPredicates;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.HashSet;
import java.util.Stack;
import java.util.logging.Logger;

public class BranchIDCheck
implements ProcessTemplateCheck {
    private static final String CHECK_ID = "Branch ID consistency check.";
    protected final Logger logger = LoggerTools.getLogger(this);

    @Override
    public boolean performCheck(Template template, NodeRelations relations, CheckReport checkReport) {
        boolean allOK = true;
        Stack<Integer> splitStack = new Stack<Integer>();
        HashSet<Integer> usedBranchIDs = new HashSet<Integer>();
        if (!this.checkSequence(template, splitStack, template.getStartNode().getID(), checkReport)) {
            allOK = false;
        }
        while (!splitStack.isEmpty()) {
            int splitID = splitStack.pop();
            int[] succs = template.getSuccByEdgeType(splitID, ProcessConstants.EdgeType.ET_CONTROL);
            int joinID = ProcessGraphPredicates.join(template, splitID);
            int[] nArray = succs;
            int n = succs.length;
            int n2 = 0;
            while (n2 < n) {
                int succ = nArray[n2];
                if (succ != joinID) {
                    int succBranchID = template.getNodeBranchID(succ);
                    if (usedBranchIDs.contains(succBranchID)) {
                        String message = "The branch ID of node '" + succ + "' is already used (branchID: '" + succBranchID + "').";
                        if (checkReport != null) {
                            URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(succ), "branchID")};
                            checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                        }
                        this.logger.severe(message);
                        allOK = false;
                    }
                    usedBranchIDs.add(succBranchID);
                    if (!this.checkSequence(template, splitStack, succ, checkReport)) {
                        allOK = false;
                    }
                }
                ++n2;
            }
        }
        if (allOK) {
            this.logger.info("Branch ID consistency check. ok.");
        } else {
            this.logger.info("Branch ID consistency check. not ok.");
        }
        return allOK;
    }

    private boolean checkSequence(Template template, Stack<Integer> splitStack, int nodeID, CheckReport checkReport) {
        boolean allOK = true;
        int branchID = template.getNodeBranchID(nodeID);
        int nextNode = nodeID;
        while (true) {
            if (template.getNodeBranchID(nextNode) != branchID) {
                String message = "The branch ID of node '" + nextNode + "' does not match the expected branch ID: '" + branchID + "').";
                if (checkReport != null) {
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(nextNode), "branchID")};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
                allOK = false;
            }
            if (ProcessGraphPredicates.isBlockStart(template, nextNode)) {
                this.logger.info("Found split node '" + nextNode + "'.");
                splitStack.push(nextNode);
                int oldNext = nextNode;
                if ((nextNode = ProcessGraphPredicates.join(template, nextNode)) != Integer.MIN_VALUE) continue;
                String message = "Could not find the join node for '" + oldNext + "' => structural problems, giving up the current sequence.";
                if (checkReport != null) {
                    URI[] affectedElements = new URI[]{ProcessElementIdentifierTools.getNodeIdentifier(checkReport.getBase(), template.getNode(oldNext))};
                    checkReport.addReportEntry(CHECK_ID, CheckReport.ResultType.FAILURE, message, affectedElements);
                }
                this.logger.severe(message);
                allOK = false;
                break;
            }
            int[] succs = template.getSuccByEdgeType(nextNode, ProcessConstants.EdgeType.ET_CONTROL);
            if (succs.length == 0 || ProcessGraphPredicates.isBlockEnd(template, succs[0])) break;
            nextNode = succs[0];
            this.logger.info("Sequence - next node '" + nextNode + "' (length: " + succs.length + ").");
        }
        return allOK;
    }
}

